/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.REPORT;

import COM.hugin.REPORT.Report;
import COM.hugin.REPORT.ReportElement;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import sun.awt.VariableGridLayout;

public class DynamicLine
extends ReportElement {
    public static final int HEADER_HIDE = 0;
    public static final int HEADER_SHOW_ONCE = 1;
    public static final int HEADER_SHOW_EACH_PAGE = 2;
    protected ArrayList<Field> columns = new ArrayList();
    protected ArrayList<String> header = new ArrayList();
    protected int headerSettings = 1;
    protected ArrayList<Float> columnWidths = new ArrayList();
    protected int numberOfColumns = 0;
    protected InclusionRule rule = new EverythingRule();
    protected int font = 2;
    protected int fontSize = 12;
    public String sortBeliefNodeName = null;
    public int sortBeliefState = -1;
    public String sortColumn = null;
    public boolean sortAscending = true;
    protected int maxLines = 0;
    private JPanel fieldPanel;
    private JPanel statsPanel;

    public DynamicLine() {
        this.setLayout(new GridLayout(2, 1));
        this.fieldPanel = new JPanel();
        this.fieldPanel.setOpaque(false);
        this.statsPanel = new JPanel();
        this.statsPanel.setOpaque(false);
        this.add(this.fieldPanel);
        this.add(this.statsPanel);
        this.updateStats();
        this.setBackground(Color.WHITE);
    }

    private void updateStats() {
        this.fieldPanel.removeAll();
        if (this.numberOfColumns > 0) {
            VariableGridLayout variableGridLayout = new VariableGridLayout(2, this.numberOfColumns);
            float f = 0.0f;
            for (Float f2 : this.columnWidths) {
                f += f2.floatValue();
            }
            for (int i = 0; i < this.numberOfColumns; ++i) {
                variableGridLayout.setColFraction(i, 1.0 / (double)f * (double)this.columnWidths.get(i).floatValue());
            }
            this.fieldPanel.setLayout((LayoutManager)variableGridLayout);
        }
        for (String string : this.header) {
            JPanel jPanel = new JPanel(new GridLayout(1, 1));
            jPanel.setOpaque(false);
            jPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            jPanel.add(new JLabel(string));
            this.fieldPanel.add(jPanel);
        }
        for (Field field : this.columns) {
            JPanel jPanel = new JPanel(new GridLayout(1, 1));
            jPanel.setOpaque(false);
            jPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            jPanel.add(new JLabel("" + field));
            this.fieldPanel.add(jPanel);
        }
        this.statsPanel.removeAll();
        this.statsPanel.add(new JLabel("Include when: " + this.rule.toString()));
        this.validate();
    }

    public void setLineFont(int n, int n2) {
        this.font = n;
        this.fontSize = n2;
    }

    public int getLineFont() {
        return this.font;
    }

    public int getLineFontSize() {
        return this.fontSize;
    }

    public void setSortBeliefNode(String string, int n, boolean bl) {
        this.sortBeliefNodeName = string;
        this.sortBeliefState = n;
        this.sortColumn = null;
        this.sortAscending = bl;
    }

    public void setSortColumn(String string, boolean bl) {
        this.sortBeliefNodeName = null;
        this.sortBeliefState = -1;
        this.sortColumn = string;
        this.sortAscending = bl;
    }

    public boolean sortingHasBeenSpecified() {
        return this.sortBeliefNodeName != null || this.sortColumn != null;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int n) {
        this.maxLines = n;
    }

    public Element render(Report report, Document document, PdfWriter pdfWriter) {
        return null;
    }

    public InclusionRule getRule() {
        return this.rule;
    }

    public void setRule(InclusionRule inclusionRule) {
        this.rule = inclusionRule;
        this.updateStats();
    }

    public void setNumberOfColumns(int n) {
        while (this.numberOfColumns > n) {
            this.columns.remove(--this.numberOfColumns);
            this.header.remove(this.numberOfColumns);
            this.columnWidths.remove(this.numberOfColumns);
        }
        while (n > this.numberOfColumns) {
            ++this.numberOfColumns;
            this.columns.add(null);
            this.header.add("");
            this.columnWidths.add(new Float(1.0f));
        }
        this.updateStats();
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public void setHeaderSettings(int n) {
        this.headerSettings = n;
    }

    public int getHeaderSettings() {
        return this.headerSettings;
    }

    public void setField(int n, Field field) {
        this.columns.remove(n);
        this.columns.add(n, field);
        this.updateStats();
    }

    public Field getField(int n) {
        return this.columns.get(n);
    }

    public void setColWidth(int n, float f) {
        this.columnWidths.remove(n);
        this.columnWidths.add(n, new Float(f));
        this.updateStats();
    }

    public float getColWidth(int n) {
        return this.columnWidths.get(n).floatValue();
    }

    public void setHeaderString(int n, String string) {
        this.header.remove(n);
        this.header.add(n, string);
        this.updateStats();
    }

    public String getHeaderString(int n) {
        return this.header.get(n);
    }

    public SingleStateBeliefField createSingleStateBeliefField(String string, int n) {
        return new SingleStateBeliefField(string, n);
    }

    public HighestBeliefState createHighestBeliefState(String string) {
        return new HighestBeliefState(string);
    }

    public CaseState createCaseState(String string) {
        return new CaseState(string);
    }

    public DataFileValue createDataFileValue(String string) {
        return new DataFileValue(string);
    }

    public UserInputValue createUserInputValue(String string) {
        return new UserInputValue(string);
    }

    public EverythingRule createEverythingRule() {
        return new EverythingRule();
    }

    public BeliefRule createBeliefRule(String string, int n, double d) {
        return new BeliefRule(string, n, d);
    }

    public DataFileValueEquals createDataFileValueEquals(String string, String string2) {
        return new DataFileValueEquals(string, string2);
    }

    public DataFileValueGreaterThan createDataFileValueGreaterThan(String string, String string2) {
        return new DataFileValueGreaterThan(string, string2);
    }

    public DataFileValueLessThan createDataFileValueLessThan(String string, String string2) {
        return new DataFileValueLessThan(string, string2);
    }

    public AndRule createAndRule(InclusionRule inclusionRule, InclusionRule inclusionRule2) {
        return new AndRule(inclusionRule, inclusionRule2);
    }

    public OrRule createOrRule(InclusionRule inclusionRule, InclusionRule inclusionRule2) {
        return new OrRule(inclusionRule, inclusionRule2);
    }

    public NegateRule createNegateRule(InclusionRule inclusionRule) {
        return new NegateRule(inclusionRule);
    }

    public class NegateRule
    extends InclusionRule {
        public InclusionRule rule;

        public NegateRule(InclusionRule inclusionRule) {
            this.rule = inclusionRule;
        }

        public boolean evaluate(String[] stringArray, double[][] dArray, String[] stringArray2, String[] stringArray3) {
            return !this.rule.evaluate(stringArray, dArray, stringArray2, stringArray3);
        }

        public String toString() {
            return "NOT (" + this.rule.toString() + ")";
        }
    }

    public class OrRule
    extends InclusionRule {
        public InclusionRule first;
        public InclusionRule second;

        public OrRule(InclusionRule inclusionRule, InclusionRule inclusionRule2) {
            this.first = inclusionRule;
            this.second = inclusionRule2;
        }

        public boolean evaluate(String[] stringArray, double[][] dArray, String[] stringArray2, String[] stringArray3) {
            return this.first.evaluate(stringArray, dArray, stringArray2, stringArray3) || this.second.evaluate(stringArray, dArray, stringArray2, stringArray3);
        }

        public String toString() {
            return "(" + this.first.toString() + " OR " + this.second.toString() + ")";
        }
    }

    public class AndRule
    extends InclusionRule {
        public InclusionRule first;
        public InclusionRule second;

        public AndRule(InclusionRule inclusionRule, InclusionRule inclusionRule2) {
            this.first = inclusionRule;
            this.second = inclusionRule2;
        }

        public boolean evaluate(String[] stringArray, double[][] dArray, String[] stringArray2, String[] stringArray3) {
            return this.first.evaluate(stringArray, dArray, stringArray2, stringArray3) && this.second.evaluate(stringArray, dArray, stringArray2, stringArray3);
        }

        public String toString() {
            return "(" + this.first.toString() + " AND " + this.second.toString() + ")";
        }
    }

    public class DataFileValueLessThan
    extends InclusionRule {
        public String dataColumnName;
        public String value;

        public DataFileValueLessThan(String string, String string2) {
            this.dataColumnName = string;
            this.value = string2;
        }

        public String toString() {
            try {
                Double.parseDouble(this.value);
                return "COL(" + this.dataColumnName + ") < " + this.value;
            }
            catch (Exception exception) {
                return "COL(" + this.dataColumnName + ") < '" + this.value + "'";
            }
        }

        public boolean evaluate(String[] stringArray, double[][] dArray, String[] stringArray2, String[] stringArray3) {
            int n = -1;
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!stringArray2[i].equals(this.dataColumnName)) continue;
                n = i;
                break;
            }
            if (n == -1) {
                return false;
            }
            double d = 0.0;
            boolean bl = false;
            double d2 = 0.0;
            try {
                d = Double.parseDouble(this.value);
                bl = true;
                d2 = Double.parseDouble(stringArray3[n]);
                return d2 < d;
            }
            catch (Exception exception) {
                if (bl) {
                    return false;
                }
                int n2 = this.value.compareTo(stringArray3[n]);
                return n2 > 0;
            }
        }
    }

    public class DataFileValueGreaterThan
    extends InclusionRule {
        public String dataColumnName;
        public String value;

        public DataFileValueGreaterThan(String string, String string2) {
            this.dataColumnName = string;
            this.value = string2;
        }

        public String toString() {
            try {
                Double.parseDouble(this.value);
                return "COL(" + this.dataColumnName + ") > " + this.value;
            }
            catch (Exception exception) {
                return "COL(" + this.dataColumnName + ") > '" + this.value + "'";
            }
        }

        public boolean evaluate(String[] stringArray, double[][] dArray, String[] stringArray2, String[] stringArray3) {
            int n = -1;
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!stringArray2[i].equals(this.dataColumnName)) continue;
                n = i;
                break;
            }
            if (n == -1) {
                return false;
            }
            double d = 0.0;
            boolean bl = false;
            double d2 = 0.0;
            try {
                d = Double.parseDouble(this.value);
                bl = true;
                d2 = Double.parseDouble(stringArray3[n]);
                return d2 > d;
            }
            catch (Exception exception) {
                if (bl) {
                    return false;
                }
                int n2 = this.value.compareTo(stringArray3[n]);
                return n2 < 0;
            }
        }
    }

    public class DataFileValueEquals
    extends InclusionRule {
        public String dataColumnName;
        public String equals;

        public DataFileValueEquals(String string, String string2) {
            this.dataColumnName = string;
            this.equals = string2;
        }

        public boolean evaluate(String[] stringArray, double[][] dArray, String[] stringArray2, String[] stringArray3) {
            int n = -1;
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!stringArray2[i].equals(this.dataColumnName)) continue;
                n = i;
                break;
            }
            if (n == -1) {
                return false;
            }
            return stringArray3[n].equals(this.equals);
        }

        public String toString() {
            return "COL(" + this.dataColumnName + ") == '" + this.equals + "'";
        }
    }

    public class BeliefRule
    extends InclusionRule {
        public String nodeName;
        public int stateNumber;
        public double beliefThreshold;

        public BeliefRule(String string, int n, double d) {
            this.nodeName = string;
            this.stateNumber = n;
            this.beliefThreshold = d;
        }

        public boolean evaluate(String[] stringArray, double[][] dArray, String[] stringArray2, String[] stringArray3) {
            int n = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(this.nodeName)) continue;
                n = i;
                break;
            }
            if (n == -1) {
                return false;
            }
            double[] dArray2 = dArray[n];
            return dArray2[this.stateNumber] > this.beliefThreshold;
        }

        public String toString() {
            return "P(" + this.nodeName + "=#" + this.stateNumber + ") > " + this.beliefThreshold;
        }
    }

    public class EverythingRule
    extends InclusionRule {
        public boolean evaluate(String[] stringArray, double[][] dArray, String[] stringArray2, String[] stringArray3) {
            return true;
        }

        public String toString() {
            return "TRUE";
        }
    }

    public abstract class InclusionRule {
        public abstract boolean evaluate(String[] var1, double[][] var2, String[] var3, String[] var4);

        public abstract String toString();
    }

    public class UserInputValue
    extends Field {
        public String userFieldName;

        public UserInputValue(String string) {
            this.userFieldName = string;
        }

        public Element render(int n) {
            return null;
        }

        public String toString() {
            return "input [" + this.userFieldName + "]";
        }
    }

    public class DataFileValue
    extends Field {
        public String dataColumnName;

        public DataFileValue(String string) {
            this.dataColumnName = string;
        }

        public Element render(int n) {
            return null;
        }

        public String toString() {
            return "value [" + this.dataColumnName + "]";
        }
    }

    public class CaseState
    extends Field {
        public String nodeName;

        public CaseState(String string) {
            this.nodeName = string;
        }

        public Element render(int n) {
            return null;
        }

        public String toString() {
            return "CASE(" + this.nodeName + ")";
        }
    }

    public class HighestBeliefState
    extends Field {
        public String nodeName;

        public HighestBeliefState(String string) {
            this.nodeName = string;
        }

        public Element render(int n) {
            return null;
        }

        public String toString() {
            return "arg max P(" + this.nodeName + ")";
        }
    }

    public class SingleStateBeliefField
    extends Field {
        public String nodeName;
        public int state;

        public SingleStateBeliefField(String string, int n) {
            this.nodeName = string;
            this.state = n;
        }

        public Element render(int n) {
            return null;
        }

        public String toString() {
            return "P(" + this.nodeName + "=#" + this.state + ")";
        }
    }

    public abstract class Field {
        public abstract Element render(int var1);

        public abstract String toString();
    }
}

