/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.REPORT;

import COM.hugin.MODEL.Batch;
import COM.hugin.MODEL.Case;
import COM.hugin.MODEL.CaseSet;
import COM.hugin.MODEL.ContinuousChanceNode;
import COM.hugin.MODEL.DiscreteNode;
import COM.hugin.MODEL.Network;
import COM.hugin.MODEL.Node;
import COM.hugin.REPORT.DynamicLine;
import COM.hugin.REPORT.Report;
import COM.hugin.REPORT.ReportElement;
import COM.hugin.REPORT.ReportStuff;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Section
extends ReportElement {
    private static DecimalFormat numberFormat = new DecimalFormat("##0.00");
    protected ReportElement description = null;
    protected DynamicLine dynLine = null;
    private CaseSet cases = null;
    private Batch beliefs = null;
    private JPanel descriptionPanel = new JPanel(new GridLayout(1, 1));
    private JPanel dynLinePanel = new JPanel(new GridLayout(1, 1));

    public Section() {
        this.setLayout(new GridLayout(2, 1));
        this.descriptionPanel.add(new JLabel("<Description>"));
        this.dynLinePanel.add(new JLabel("<Line Generating Template>"));
        this.add(this.descriptionPanel);
        this.add(this.dynLinePanel);
        this.setBackground(Color.BLACK);
    }

    public void setDescription(ReportElement reportElement) {
        this.description = reportElement;
        this.descriptionPanel.removeAll();
        if (this.description != null) {
            this.description.setReportParent(this);
            this.descriptionPanel.add(this.description);
        } else {
            this.descriptionPanel.add(new JLabel("<Description>"));
        }
        this.validate();
    }

    public ReportElement getDescription() {
        return this.description;
    }

    public void setLine(DynamicLine dynamicLine) {
        this.dynLine = dynamicLine;
        this.dynLinePanel.removeAll();
        if (this.dynLine != null) {
            dynamicLine.setReportParent(this);
            this.dynLinePanel.add(this.dynLine);
        } else {
            this.dynLinePanel.add(new JLabel("<Line Generating Template>"));
        }
        this.validate();
    }

    public DynamicLine getLine() {
        return this.dynLine;
    }

    public void setBackingData(CaseSet caseSet, Batch batch) {
        this.cases = caseSet;
        this.beliefs = batch;
    }

    public Element render(Report report, Document document, PdfWriter pdfWriter) {
        try {
            String[] stringArray;
            int n;
            int n2;
            int n3;
            Object object;
            Object object2;
            PdfPTable pdfPTable = new PdfPTable(1);
            pdfPTable.setWidthPercentage(100.0f);
            pdfPTable.setSplitLate(false);
            if (this.description != null) {
                object2 = new PdfPCell();
                ((PdfPCell)object2).addElement(this.description.render(report, document, pdfWriter));
                ((Rectangle)object2).setBorder(0);
                pdfPTable.addCell((PdfPCell)object2);
            }
            object2 = new float[this.dynLine.getNumberOfColumns()];
            for (int i = 0; i < this.dynLine.getNumberOfColumns(); ++i) {
                object2[i] = this.dynLine.getColWidth(i);
            }
            if (((Object)object2).length == 0) {
                object2 = new float[1];
            }
            PdfPTable pdfPTable2 = new PdfPTable((float[])object2);
            pdfPTable2.setWidthPercentage(100.0f);
            Font font = ReportStuff.getFont(this.dynLine.getLineFont(), this.dynLine.getLineFontSize(), Color.BLACK);
            if (this.dynLine.getHeaderSettings() == 2) {
                pdfPTable2.setHeaderRows(1);
            }
            if (this.dynLine.getHeaderSettings() != 0) {
                for (int i = 0; i < this.dynLine.getNumberOfColumns(); ++i) {
                    object = new PdfPCell(new Phrase(this.dynLine.getHeaderString(i), font));
                    ((Rectangle)object).setBorder(0);
                    ((Rectangle)object).enableBorderSide(1);
                    ((Rectangle)object).enableBorderSide(2);
                    ((Rectangle)object).setBackgroundColor(Color.LIGHT_GRAY);
                    pdfPTable2.addCell((PdfPCell)object);
                }
            }
            DiscreteNode[] discreteNodeArray = this.beliefs.getResultNodes();
            object = this.cases.getCaseNodes();
            String[] stringArray2 = this.cases.getOtherLabels();
            ArrayList<double[][]> arrayList = this.beliefs.getResults(0, this.cases.getNumberOfCases() - 1);
            int[] nArray = new int[this.cases.getNumberOfCases()];
            for (n3 = 0; n3 < this.cases.getNumberOfCases(); ++n3) {
                nArray[n3] = n3;
            }
            if (this.dynLine.sortingHasBeenSpecified()) {
                if (this.dynLine.sortBeliefNodeName != null) {
                    String[] stringArray3 = null;
                    DiscreteNode[] discreteNodeArray2 = discreteNodeArray;
                    n2 = discreteNodeArray2.length;
                    for (n = 0; n < n2; ++n) {
                        stringArray = discreteNodeArray2[n];
                        if (!stringArray.getName().equals(this.dynLine.sortBeliefNodeName)) continue;
                        stringArray3 = stringArray;
                    }
                    if (stringArray3 != null) {
                        nArray = Section.orderByBeliefState((DiscreteNode)stringArray3, this.dynLine.sortBeliefState, this.cases, this.beliefs, this.dynLine.sortAscending);
                    }
                } else if (this.dynLine.sortColumn != null) {
                    nArray = Section.orderByDataValue(this.dynLine.sortColumn, this.cases, this.dynLine.sortAscending);
                }
            }
            if ((n3 = this.dynLine.getMaxLines()) < 1) {
                n3 = nArray.length;
            }
            int n4 = 0;
            for (n2 = 0; n2 < nArray.length && n4 < n3; ++n2) {
                n = nArray[n2];
                stringArray = new String[discreteNodeArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = discreteNodeArray[i].getName();
                }
                double[][] dArray = arrayList.get(n);
                String[] stringArray4 = this.cases.getOtherLabels();
                String[] stringArray5 = this.cases.getOther(n);
                if (dArray == null || !this.dynLine.getRule().evaluate(stringArray, dArray, stringArray4, stringArray5)) continue;
                ++n4;
                for (int i = 0; i < this.dynLine.getNumberOfColumns(); ++i) {
                    Object object3;
                    String string = "";
                    DynamicLine.Field field = this.dynLine.getField(i);
                    if (field instanceof DynamicLine.SingleStateBeliefField) {
                        int n5;
                        object3 = (DynamicLine.SingleStateBeliefField)field;
                        for (n5 = 0; n5 < discreteNodeArray.length && !discreteNodeArray[n5].getName().equals(((DynamicLine.SingleStateBeliefField)object3).nodeName); ++n5) {
                        }
                        double d = arrayList.get(n)[n5][((DynamicLine.SingleStateBeliefField)object3).state];
                        string = "" + numberFormat.format(d);
                    } else if (field instanceof DynamicLine.HighestBeliefState) {
                        int n6;
                        object3 = (DynamicLine.HighestBeliefState)field;
                        for (n6 = 0; n6 < discreteNodeArray.length && !discreteNodeArray[n6].getName().equals(((DynamicLine.HighestBeliefState)object3).nodeName); ++n6) {
                        }
                        int n7 = 0;
                        double d = 0.0;
                        for (int j = 0; j < discreteNodeArray[n6].getNumberOfStates(); ++j) {
                            double d2 = arrayList.get(n)[n6][j];
                            if (!(d2 > d)) continue;
                            d = d2;
                            n7 = j;
                        }
                        string = discreteNodeArray[n6].getStateLabel(n7);
                    } else if (field instanceof DynamicLine.CaseState) {
                        int n8;
                        object3 = (DynamicLine.CaseState)field;
                        for (n8 = 0; n8 < ((Object)object).length && !((Node)object[n8]).getName().equals(((DynamicLine.CaseState)object3).nodeName); ++n8) {
                        }
                        Case case_ = this.cases.getCase(n);
                        if (object[n8] instanceof DiscreteNode) {
                            int n9 = case_.disc_states[n8];
                            if (n9 > -1) {
                                string = ((DiscreteNode)object[n8]).getStateLabel(n9);
                            }
                        } else {
                            string = object[n8] instanceof ContinuousChanceNode && case_.cont_flags[n8] ? "" + case_.cont_values[n8] : "n/a";
                        }
                    } else if (field instanceof DynamicLine.DataFileValue) {
                        object3 = (DynamicLine.DataFileValue)field;
                        String string2 = "";
                        String[] stringArray6 = this.cases.getOther(n);
                        for (int j = 0; j < stringArray2.length; ++j) {
                            if (!stringArray2[j].equals(((DynamicLine.DataFileValue)object3).dataColumnName)) continue;
                            string2 = stringArray6[j];
                            break;
                        }
                        string = string2;
                    } else if (field instanceof DynamicLine.UserInputValue) {
                        String string3;
                        object3 = (DynamicLine.UserInputValue)field;
                        if (report.userInput != null && report.userInput.get(((DynamicLine.UserInputValue)object3).userFieldName) != null && (string3 = report.userInput.get(((DynamicLine.UserInputValue)object3).userFieldName)) != null) {
                            string = string3;
                        }
                    }
                    object3 = new PdfPCell(new Paragraph(string, font));
                    ((Rectangle)object3).setBorder(0);
                    ((Rectangle)object3).enableBorderSide(1);
                    ((Rectangle)object3).enableBorderSide(2);
                    pdfPTable2.addCell((PdfPCell)object3);
                }
            }
            PdfPCell pdfPCell = new PdfPCell(pdfPTable2);
            pdfPCell.setBorder(0);
            pdfPTable.addCell(pdfPCell);
            return pdfPTable;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static int[] orderByBeliefState(DiscreteNode discreteNode, int n, CaseSet caseSet, Batch batch, boolean bl) throws Exception {
        int n2 = caseSet.getNumberOfCases();
        DiscreteNode[] discreteNodeArray = batch.getResultNodes();
        int n3 = -1;
        for (int i = 0; i < discreteNodeArray.length; ++i) {
            if (discreteNodeArray[i] != discreteNode) continue;
            n3 = i;
            break;
        }
        if (n3 == -1) {
            return null;
        }
        ArrayList<double[][]> arrayList = batch.getResults(0, n2 - 1);
        Object[] objectArray = new ValueSorting[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = new ValueSorting(i, arrayList.get(i)[n3][n]);
        }
        Arrays.sort(objectArray);
        if (!bl) {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = ((ValueSorting)objectArray[n2 - 1 - i]).index;
            }
            return nArray;
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = ((ValueSorting)objectArray[i]).index;
        }
        return nArray;
    }

    private static int[] orderByDataValue(String string, CaseSet caseSet, boolean bl) {
        int n = caseSet.getNumberOfCases();
        int n2 = -1;
        String[] stringArray = caseSet.getOtherLabels();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n2 = i;
        }
        if (n2 == -1) {
            return null;
        }
        Object[] objectArray = new ValueSorting[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = new ValueSorting(i, caseSet.getOther(i)[n2]);
        }
        Arrays.sort(objectArray);
        if (!bl) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = ((ValueSorting)objectArray[n - 1 - i]).index;
            }
            return nArray;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = ((ValueSorting)objectArray[i]).index;
        }
        return nArray;
    }

    public DiscreteNode[] getResultNodesForBatch(Network network) {
        HashSet<DiscreteNode> hashSet = new HashSet<DiscreteNode>();
        for (int i = 0; i < this.dynLine.getNumberOfColumns(); ++i) {
            DynamicLine.Field field = this.dynLine.getField(i);
            String string = null;
            if (field instanceof DynamicLine.SingleStateBeliefField) {
                string = ((DynamicLine.SingleStateBeliefField)field).nodeName;
            } else if (field instanceof DynamicLine.HighestBeliefState) {
                string = ((DynamicLine.HighestBeliefState)field).nodeName;
            }
            if (string == null) continue;
            try {
                DiscreteNode discreteNode = (DiscreteNode)network.getNodeByName(string);
                hashSet.add(discreteNode);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.dynLine.sortingHasBeenSpecified() && this.dynLine.sortBeliefNodeName != null) {
            DiscreteNode discreteNode = (DiscreteNode)network.getNodeByName(this.dynLine.sortBeliefNodeName);
            hashSet.add(discreteNode);
        }
        return hashSet.toArray(new DiscreteNode[1]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueSorting
    implements Comparable<ValueSorting> {
        public int index;
        public String value;
        private boolean isText;
        private double numericValue;

        public ValueSorting(int n, String string) {
            this.index = n;
            this.value = string;
            this.isText = true;
            try {
                this.numericValue = Double.parseDouble(this.value);
                this.isText = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public ValueSorting(int n, double d) {
            this.index = n;
            this.value = null;
            this.isText = false;
            this.numericValue = d;
        }

        @Override
        public int compareTo(ValueSorting valueSorting) {
            if (!this.isText && !valueSorting.isText) {
                if (this.numericValue == valueSorting.numericValue) {
                    return 0;
                }
                if (this.numericValue < valueSorting.numericValue) {
                    return -1;
                }
                return 1;
            }
            if (this.isText && valueSorting.isText) {
                return this.value.compareTo(valueSorting.value);
            }
            if (!this.isText && valueSorting.isText) {
                return -1;
            }
            return 1;
        }
    }
}

