/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.REPORT;

import COM.hugin.REPORT.Report;
import COM.hugin.REPORT.ReportElement;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
extends ReportElement {
    protected int rows;
    protected int cols;
    protected ArrayList<ReportElement> contents = new ArrayList();
    protected Table thisTable = this;

    public Table(int n, int n2) {
        this.setRowsColumns(n, n2);
        this.setBackground(Color.BLACK);
    }

    public void setRowsColumns(int n, int n2) {
        this.rows = n;
        this.cols = n2;
        int n3 = this.contents.size();
        while (n3 > this.rows * this.cols) {
            this.contents.remove(--n3);
        }
        int n4 = this.rows * this.cols;
        if (n3 < n4) {
            for (int i = n3; i < n4; ++i) {
                this.contents.add(this.createEmptyCell());
            }
        }
        this.removeAll();
        this.setLayout(new GridLayout(this.rows, this.cols, 1, 1));
        for (ReportElement reportElement : this.contents) {
            reportElement.setReportParent(this);
            this.add(reportElement);
        }
    }

    public int getNumberOfRows() {
        return this.rows;
    }

    public int getNumberOfColumns() {
        return this.cols;
    }

    public void addReportElement(ReportElement reportElement, int n) {
        reportElement.setReportParent(this);
        this.contents.add(n, reportElement);
        this.setRowsColumns(this.rows, this.cols);
    }

    public void setReportElement(ReportElement reportElement, int n) {
        reportElement.setReportParent(this);
        this.contents.remove(n);
        this.contents.add(n, reportElement);
        this.setRowsColumns(this.rows, this.cols);
    }

    public void removeReportElement(ReportElement reportElement) {
        int n = this.contents.indexOf(reportElement);
        this.contents.remove(reportElement);
        this.contents.add(n, this.createEmptyCell());
        this.setRowsColumns(this.rows, this.cols);
    }

    public int getIndex(ReportElement reportElement) {
        return this.contents.indexOf(reportElement);
    }

    public ArrayList<ReportElement> getContents() {
        return this.contents;
    }

    @Override
    public Element render(Report report, Document document, PdfWriter pdfWriter) {
        PdfPTable pdfPTable = new PdfPTable(this.cols);
        pdfPTable.setWidthPercentage(100.0f);
        for (int i = 0; i < this.contents.size(); ++i) {
            ReportElement reportElement = this.contents.get(i);
            PdfPCell pdfPCell = new PdfPCell();
            if (!(reportElement instanceof EmptyCell)) {
                int n = 1;
                switch (reportElement.getAlignment()) {
                    case 0: {
                        n = 0;
                        break;
                    }
                    case 1: {
                        n = 1;
                        break;
                    }
                    case 2: {
                        n = 2;
                    }
                }
                pdfPCell.setHorizontalAlignment(n);
                pdfPCell.addElement(reportElement.render(report, document, pdfWriter));
            }
            pdfPCell.setBorder(0);
            pdfPTable.addCell(pdfPCell);
        }
        return pdfPTable;
    }

    public EmptyCell createEmptyCell() {
        return new EmptyCell();
    }

    public class EmptyCell
    extends ReportElement {
        private EmptyCell() {
            this.setReportParent(this);
            this.setBackground(Color.WHITE);
            JLabel jLabel = new JLabel("[empty]");
            jLabel.setOpaque(false);
            this.add(jLabel);
        }

        public Element render(Report report, Document document, PdfWriter pdfWriter) {
            return null;
        }
    }
}

