/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.REPORT;

import COM.hugin.REPORT.Report;
import COM.hugin.REPORT.ReportElement;
import COM.hugin.REPORT.ReportStuff;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class TextLabel
extends ReportElement {
    protected int font;
    protected int size;
    protected String text;
    private JPanel renderPanel;

    public TextLabel(String string, int n, int n2) {
        this.font = n;
        this.size = n2;
        this.text = string;
        this.configure();
    }

    private void configure() {
        this.removeAll();
        this.renderPanel = new JPanel();
        this.renderPanel.setLayout(new BoxLayout(this.renderPanel, 1));
        this.renderPanel.setOpaque(false);
        JTextArea jTextArea = new JTextArea(this.text);
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setPreferredSize(null);
        this.renderPanel.add(jTextArea);
        com.lowagie.text.Font font = ReportStuff.getFont(this.font, this.size, Color.BLACK);
        String string = font.getFamilyname() + " " + font.getSize();
        JLabel jLabel = new JLabel(string);
        jLabel.setOpaque(false);
        jLabel.setFont(new Font("Times Roman", 2, 9));
        this.renderPanel.add(jLabel);
        this.add(this.renderPanel);
        this.setBackground(Color.WHITE);
    }

    public Element render(Report report, Document document, PdfWriter pdfWriter) {
        Paragraph paragraph = new Paragraph(this.text, ReportStuff.getFont(this.font, this.size, Color.BLACK));
        switch (this.alignment) {
            case 0: {
                paragraph.setAlignment(0);
                break;
            }
            case 1: {
                paragraph.setAlignment(1);
                break;
            }
            case 2: {
                paragraph.setAlignment(2);
            }
        }
        return paragraph;
    }

    public String getTextLabelText() {
        return this.text;
    }

    public int getTextLabelSize() {
        return this.size;
    }

    public int getTextLabelFont() {
        return this.font;
    }

    public void setProperties(String string, int n, int n2) {
        this.font = n;
        this.size = n2;
        this.text = string;
        this.configure();
    }
}

