/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HAPI;

import COM.hugin.HAPI.Attribute;
import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.BooleanDDNode;
import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionArgumentNotAlive;
import COM.hugin.HAPI.ExceptionError;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.FunctionNode;
import COM.hugin.HAPI.InstanceNode;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.IntervalDDNode;
import COM.hugin.HAPI.JunctionTree;
import COM.hugin.HAPI.LabelledDCNode;
import COM.hugin.HAPI.LabelledDDNode;
import COM.hugin.HAPI.Model;
import COM.hugin.HAPI.Native.HAPI;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.NumberedDDNode;
import COM.hugin.HAPI.Table;
import COM.hugin.HAPI.UtilityNode;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.ListIterator;

public abstract class Node
implements Cloneable {
    private Object userData = null;
    protected int nodePeer = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Node(NetworkModel networkModel, NetworkModel.Category category, NetworkModel.Kind kind, int n) throws ExceptionHugin {
        if (!($assertionsDisabled || category != null && kind != null)) {
            throw new AssertionError();
        }
        if (networkModel == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        if (!networkModel.isAlive()) {
            throw new ExceptionArgumentNotAlive();
        }
        this.nodePeer = HAPI.nativeHAPI.hDomainNewNode(this, networkModel.modelPeer, category.value, kind.value, n);
        if (this.nodePeer == 0) {
            ExceptionHugin.throwException();
        }
        if (!$assertionsDisabled && this.nodePeer == 0) {
            throw new AssertionError();
        }
    }

    protected Node(NetworkModel networkModel, NetworkModel.Category category, NetworkModel.Kind kind) throws ExceptionHugin {
        this(networkModel, category, kind, 30);
    }

    protected Node(int n) throws ExceptionHugin {
        this.nodePeer = n;
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeSetBackpointer(this.nodePeer, this));
    }

    protected Node() {
    }

    protected static Node convert(int n) throws ExceptionHugin {
        if (n == 0) {
            ExceptionHugin.throwException();
            return null;
        }
        Node node = (Node)HAPI.nativeHAPI.hNodeGetBackpointer(n);
        if (node != null) {
            return node;
        }
        switch (HAPI.nativeHAPI.hNodeGetCategory(n)) {
            case 7: {
                switch (HAPI.nativeHAPI.hNodeGetKind(n)) {
                    case 0: {
                        switch (HAPI.nativeHAPI.hNodeGetSubtype(n)) {
                            case 30: {
                                return new LabelledDCNode(n);
                            }
                            case 31: {
                                return new BooleanDCNode(n);
                            }
                            case 32: {
                                return new NumberedDCNode(n);
                            }
                            case 33: {
                                return new IntervalDCNode(n);
                            }
                        }
                        ExceptionHugin.throwException();
                        throw new ExceptionError();
                    }
                    case 1: {
                        return new ContinuousChanceNode(n);
                    }
                }
                ExceptionHugin.throwException();
                throw new ExceptionError();
            }
            case 8: {
                switch (HAPI.nativeHAPI.hNodeGetKind(n)) {
                    case 0: {
                        switch (HAPI.nativeHAPI.hNodeGetSubtype(n)) {
                            case 30: {
                                return new LabelledDDNode(n);
                            }
                            case 31: {
                                return new BooleanDDNode(n);
                            }
                            case 32: {
                                return new NumberedDDNode(n);
                            }
                            case 33: {
                                return new IntervalDDNode(n);
                            }
                        }
                        ExceptionHugin.throwException();
                        throw new ExceptionError();
                    }
                }
                ExceptionHugin.throwException();
                throw new ExceptionError();
            }
            case 9: {
                return new UtilityNode(n);
            }
            case 6: {
                return new InstanceNode(n);
            }
            case 5: {
                return new FunctionNode(n);
            }
        }
        ExceptionHugin.throwException();
        throw new ExceptionError();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            int n = this.thisPeer();
            Node node = (Node)super.clone();
            node.userData = null;
            node.nodePeer = HAPI.nativeHAPI.hNodeClone(node, n);
            if (node.nodePeer == 0) {
                ExceptionHugin.throwException();
            }
            if (!$assertionsDisabled && node.nodePeer == 0) {
                throw new AssertionError();
            }
            return node;
        }
        catch (ExceptionHugin exceptionHugin) {
            throw new CloneNotSupportedException(exceptionHugin.toString());
        }
    }

    public void addParent(Node node) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeAddParent(this.thisPeer(), Node.getNodePeer(node)));
    }

    public void reverseEdge(Node node) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeReverseEdge(this.thisPeer(), Node.getNodePeer(node)));
    }

    public void removeParent(Node node) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeRemoveParent(this.thisPeer(), Node.getNodePeer(node)));
    }

    public void switchParent(Node node, Node node2) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeSwitchParent(this.thisPeer(), Node.getNodePeer(node), Node.getNodePeer(node2)));
    }

    public abstract NetworkModel.Category getCategory();

    public abstract NetworkModel.Kind getKind();

    public String getLabel() throws ExceptionHugin {
        String string = HAPI.nativeHAPI.hNodeGetLabel(this.thisPeer());
        if (string == null) {
            ExceptionHugin.throwException();
        }
        return string;
    }

    public String getName() throws ExceptionHugin {
        String string = HAPI.nativeHAPI.hNodeGetName(this.thisPeer());
        if (string == null) {
            ExceptionHugin.throwException();
        }
        return string;
    }

    public JunctionTree getJunctionTree() throws ExceptionHugin {
        return JunctionTree.convert(HAPI.nativeHAPI.hNodeGetJunctionTree(this.thisPeer()));
    }

    public NodeList getParents() throws ExceptionHugin {
        return new NodeList(HAPI.nativeHAPI.hNodeGetParents(this.thisPeer()));
    }

    public NodeList getChildren() throws ExceptionHugin {
        return new NodeList(HAPI.nativeHAPI.hNodeGetChildren(this.thisPeer()));
    }

    public Point2D getPosition() throws ExceptionHugin {
        int n = 0;
        int n2 = HAPI.nativeHAPI.hNodeGetXCoordinate(this.thisPeer());
        if (n2 == -1 || (n = HAPI.nativeHAPI.hNodeGetYCoordinate(this.nodePeer)) == -1) {
            ExceptionHugin.throwException();
        }
        return new Point2D.Double(n2, n);
    }

    public Object getUserData() {
        return this.userData;
    }

    public boolean evidenceIsEntered() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hNodeEvidenceIsEntered(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public boolean evidenceIsPropagated() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hNodeEvidenceIsPropagated(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public boolean likelihoodIsEntered() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hNodeLikelihoodIsEntered(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public boolean likelihoodIsPropagated() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hNodeLikelihoodIsPropagated(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public boolean evidenceToPropagate() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hNodeEvidenceToPropagate(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public String getAttribute(String string) throws ExceptionHugin {
        String string2 = HAPI.nativeHAPI.hNodeGetAttribute(this.thisPeer(), string);
        if (string2 == null) {
            ExceptionHugin.throwException();
        }
        return string2;
    }

    public void setAttribute(String string, String string2) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeSetAttribute(this.thisPeer(), string, string2));
    }

    public LinkedList getAttributes() throws ExceptionHugin {
        return Attribute.createAttributeList(HAPI.nativeHAPI.hNodeGetFirstAttribute(this.thisPeer()));
    }

    public void setAttributes(LinkedList linkedList) throws ExceptionHugin {
        int n = this.thisPeer();
        if (linkedList == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            Attribute attribute = (Attribute)listIterator.next();
            ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeSetAttribute(n, attribute.getKey(), attribute.getValue()));
        }
    }

    public void delete() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeDelete(this.thisPeer()));
        if (!$assertionsDisabled && this.isAlive()) {
            throw new AssertionError();
        }
    }

    public boolean isAlive() {
        return this.nodePeer != 0;
    }

    protected final int thisPeer() throws ExceptionObjectNotAlive {
        if (this.nodePeer == 0) {
            throw new ExceptionObjectNotAlive();
        }
        return this.nodePeer;
    }

    protected static final int getNodePeer(Node node) throws ExceptionHugin {
        if (node == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        if (node.nodePeer == 0) {
            throw new ExceptionArgumentNotAlive();
        }
        return node.nodePeer;
    }

    public void setLabel(String string) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeSetLabel(this.thisPeer(), string));
    }

    public void setName(String string) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeSetName(this.thisPeer(), string));
    }

    public void setPosition(Point2D point2D) throws ExceptionHugin {
        if (point2D == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeSetPosition(this.thisPeer(), (int)point2D.getX(), (int)point2D.getY()));
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Table getTable() throws ExceptionHugin {
        return Table.convert(HAPI.nativeHAPI.hNodeGetTable(this.thisPeer()));
    }

    public Model getModel() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hNodeGetModel(this.thisPeer());
        if (n == 0) {
            ExceptionHugin.throwException();
            return null;
        }
        Model model = (Model)HAPI.nativeHAPI.hModelGetBackpointer(n);
        if (model != null) {
            return model;
        }
        return new Model(n);
    }

    public NetworkModel getHome() throws ExceptionHugin {
        int n = this.thisPeer();
        NetworkModel networkModel = (NetworkModel)HAPI.nativeHAPI.hNodeGetHomeBackpointer(n);
        if (networkModel != null) {
            return networkModel;
        }
        int n2 = HAPI.nativeHAPI.hNodeGetHomeDomain(n);
        if (n2 != 0) {
            return new Domain(n2);
        }
        int n3 = HAPI.nativeHAPI.hNodeGetHomeClass(n);
        if (n3 != 0) {
            return new Class(n3);
        }
        throw new ExceptionError();
    }

    public Class getHomeClass() throws ExceptionHugin {
        NetworkModel networkModel = this.getHome();
        if (networkModel instanceof Class) {
            return (Class)networkModel;
        }
        return null;
    }

    public Domain getHomeDomain() throws ExceptionHugin {
        NetworkModel networkModel = this.getHome();
        if (networkModel instanceof Domain) {
            return (Domain)networkModel;
        }
        return null;
    }

    public Domain getDomain() throws ExceptionHugin {
        return this.getHomeDomain();
    }

    public void setEdgeConstraint(Node node, NetworkModel.Constraint constraint) throws ExceptionHugin {
        if (constraint == null) {
            throw new ExceptionUsage("Argument 'constraint' is 'null'");
        }
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeSetEdgeConstraint(this.thisPeer(), Node.getNodePeer(node), constraint.value));
    }

    public NetworkModel.Constraint getEdgeConstraint(Node node) throws ExceptionHugin {
        switch (HAPI.nativeHAPI.hNodeGetEdgeConstraint(this.thisPeer(), Node.getNodePeer(node))) {
            case 100: {
                return NetworkModel.H_CONSTRAINT_NONE;
            }
            case 101: {
                return NetworkModel.H_CONSTRAINT_EDGE_REQUIRED;
            }
            case 102: {
                return NetworkModel.H_CONSTRAINT_FORWARD_EDGE_REQUIRED;
            }
            case 103: {
                return NetworkModel.H_CONSTRAINT_BACKWARD_EDGE_REQUIRED;
            }
            case 104: {
                return NetworkModel.H_CONSTRAINT_EDGE_FORBIDDEN;
            }
            case 105: {
                return NetworkModel.H_CONSTRAINT_FORWARD_EDGE_FORBIDDEN;
            }
            case 106: {
                return NetworkModel.H_CONSTRAINT_BACKWARD_EDGE_FORBIDDEN;
            }
        }
        ExceptionHugin.throwException();
        throw new ExceptionError();
    }

    public Node getMaster() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hNodeGetMaster(this.thisPeer());
        if (n == 0) {
            return null;
        }
        return Node.convert(n);
    }

    public Node getInstance() throws ExceptionHugin {
        return Node.convert(HAPI.nativeHAPI.hNodeGetInstance(this.thisPeer()));
    }

    public void addToOutputs() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeAddToOutputs(this.thisPeer()));
    }

    public void removeFromOutputs() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeRemoveFromOutputs(this.thisPeer()));
    }

    public void addToInputs() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeAddToInputs(this.thisPeer()));
    }

    public void removeFromInputs() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeRemoveFromInputs(this.thisPeer()));
    }

    public NodeList getSource() throws ExceptionHugin {
        return new NodeList(HAPI.nativeHAPI.hNodeGetSource(this.thisPeer()));
    }

    static {
        $assertionsDisabled = !Node.class.desiredAssertionStatus();
    }
}

