/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HAPI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.ExceptionHugeArray;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.Native.HAPI;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import java.util.ListIterator;

public class Table {
    private int tablePeer = 0;
    private NodeList tableNodes = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Table(int n) throws ExceptionHugin {
        this.tablePeer = n;
        ExceptionHugin.throwException(HAPI.nativeHAPI.hTableSetBackpointer(this.tablePeer, this));
    }

    protected static Table convert(int n) throws ExceptionHugin {
        if (n == 0) {
            ExceptionHugin.throwException();
        }
        if (!$assertionsDisabled && n == 0) {
            throw new AssertionError();
        }
        Table table = (Table)HAPI.nativeHAPI.hTableGetBackpointer(n);
        if (table != null) {
            return table;
        }
        return new Table(n);
    }

    private Table(int n, NodeList nodeList) throws ExceptionHugin {
        if (!$assertionsDisabled && n == 0) {
            throw new AssertionError();
        }
        this.tablePeer = n;
        this.tableNodes = nodeList == null ? new NodeList(HAPI.nativeHAPI.hTableGetNodes(this.tablePeer)) : (NodeList)nodeList.clone();
    }

    protected static Table convertUserTable(int n, NodeList nodeList) throws ExceptionHugin {
        if (n == 0) {
            ExceptionHugin.throwException();
        }
        if (!$assertionsDisabled && n == 0) {
            throw new AssertionError();
        }
        try {
            return new Table(n, nodeList);
        }
        catch (ExceptionHugin exceptionHugin) {
            ExceptionHugin.throwException(HAPI.nativeHAPI.hTableDelete(n));
            throw exceptionHugin;
        }
    }

    public void getConfiguration(int[] nArray, int n) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hTableGetConfigurationFromIndex(this.thisPeer(), nArray, n));
    }

    public int getIndex(int[] nArray) throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hTableGetIndexFromConfiguration(this.thisPeer(), nArray);
        if (n < 0) {
            ExceptionHugin.throwException();
        }
        return n;
    }

    public double[] getData() throws ExceptionHugin {
        int n = this.getSize();
        if (n < 0 || n > Integer.MAX_VALUE) {
            throw new ExceptionHugeArray();
        }
        double[] dArray = new double[n];
        ExceptionHugin.throwException(HAPI.nativeHAPI.hTableGetData(this.tablePeer, dArray, 0, n));
        return dArray;
    }

    public void getData(double[] dArray, int n, int n2) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hTableGetData(this.thisPeer(), dArray, n, n2));
    }

    public double getDataItem(int n) throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hTableGetDataItem(this.thisPeer(), n);
        ExceptionHugin.throwException();
        return d;
    }

    public NodeList getNodes() throws ExceptionHugin {
        if (this.tableNodes != null) {
            return (NodeList)this.tableNodes.clone();
        }
        return new NodeList(HAPI.nativeHAPI.hTableGetNodes(this.thisPeer()));
    }

    public int getSize() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hTableGetSize(this.thisPeer());
        ExceptionHugin.throwException();
        return n;
    }

    public int getCGSize() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hTableGetCGSize(this.thisPeer());
        ExceptionHugin.throwException();
        return n;
    }

    public void setData(double[] dArray) throws ExceptionHugin {
        if (dArray == null || this.getSize() != dArray.length) {
            throw new ExceptionUsage();
        }
        this.setData(dArray, 0, dArray.length);
    }

    public void setData(double[] dArray, int n, int n2) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hTableSetData(this.thisPeer(), dArray, n, n2));
    }

    public void setDataItem(int n, double d) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hTableSetDataItem(this.thisPeer(), n, d));
    }

    public double getVariance(int n, ContinuousChanceNode continuousChanceNode) throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hTableGetVariance(this.thisPeer(), n, Node.getNodePeer(continuousChanceNode));
        if (d < 0.0) {
            ExceptionHugin.throwException();
        }
        return d;
    }

    public double getMean(int n, ContinuousChanceNode continuousChanceNode) throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hTableGetMean(this.thisPeer(), n, Node.getNodePeer(continuousChanceNode));
        ExceptionHugin.throwException();
        return d;
    }

    public double getCovariance(int n, ContinuousChanceNode continuousChanceNode, ContinuousChanceNode continuousChanceNode2) throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hTableGetCovariance(this.thisPeer(), n, Node.getNodePeer(continuousChanceNode), Node.getNodePeer(continuousChanceNode2));
        ExceptionHugin.throwException();
        return d;
    }

    public void reorderNodes(NodeList nodeList) throws ExceptionHugin {
        int n = this.thisPeer();
        int n2 = NetworkModel.convertNodeList(nodeList);
        int n3 = HAPI.nativeHAPI.hTableReorderNodes(n, n2);
        HAPI.nativeHAPI.hListDelete(n2);
        ExceptionHugin.throwException(n3);
    }

    public void delete() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hTableDelete(this.thisPeer()));
        this.tablePeer = 0;
    }

    public boolean isAlive() {
        if (this.tablePeer == 0) {
            return false;
        }
        if (this.tableNodes != null) {
            ListIterator listIterator = this.tableNodes.listIterator();
            while (listIterator.hasNext()) {
                if (((Node)listIterator.next()).isAlive()) continue;
                return false;
            }
        }
        return true;
    }

    private int thisPeer() throws ExceptionObjectNotAlive {
        if (!this.isAlive()) {
            throw new ExceptionObjectNotAlive();
        }
        return this.tablePeer;
    }

    static {
        $assertionsDisabled = !Table.class.desiredAssertionStatus();
    }
}

