# include "hugin"

# include <vector>
# include <iostream>

using namespace HAPI;
using namespace std;

class BAP {
public:
  BAP ();
protected:
  void printNodeMarginals (Domain *d);

  NumberedDCNode* constructNDC (const char *label, const char *name, size_t n);

  void buildStructure
     (NumberedDCNode *A, NumberedDCNode *B, NumberedDCNode *C);

  void buildExpressionForC
     (NumberedDCNode *A, NumberedDCNode *B, NumberedDCNode *C);

  void specifyDistributions (NumberedDCNode *A, NumberedDCNode *B);

  void buildNetwork ();

  Domain *domain;

  ~BAP () { delete domain; }
};


/** Build a Bayesian network and print node marginals. */

BAP::BAP ()
{
  domain = new Domain ();

  buildNetwork ();

  domain->saveAsNet ("builddomain.net");
  domain->compile ();

  printNodeMarginals (domain);
}


/** Print node marginals. */

void BAP::printNodeMarginals (Domain *d)
{
  NodeList nlist = domain->getNodes ();

  for (NodeList::const_iterator nit = nlist.begin ();
       nit != nlist.end (); ++nit)
  {
    DiscreteChanceNode *node = dynamic_cast<DiscreteChanceNode*> (*nit);

    if (node != 0) {
      size_t nStates = node->getNumberOfStates ();

      cout << node->getLabel () << endl;

      for (size_t i = 0; i < nStates; i++)
	cout << "-" << node->getStateLabel (i)
	     << " " << node->getBelief (i) << endl;
    }
  }
}


/** Construct numbered discrete chance node. */
NumberedDCNode* BAP::constructNDC
 (const char *label, const char *name, size_t n)
{
  NumberedDCNode *node = new NumberedDCNode (domain);

  node->setNumberOfStates (n);

  for (size_t i = 0; i < n; i++)
    node->setStateValue (i, i);

  node->setLabel (label);
  node->setName (name);

  return node;
}


/** Build the structure.  */

void BAP::buildStructure
   (NumberedDCNode *A, NumberedDCNode *B, NumberedDCNode *C)
{
  C->addParent (A);
  C->addParent (B);

  A->setPosition (100, 200);
  B->setPosition (200, 200);
  C->setPosition (150, 50);
}


/** Expression for C */

void BAP::buildExpressionForC
   (NumberedDCNode *A, NumberedDCNode *B, NumberedDCNode *C)
{
  NodeList modelNodes;

  Model *model = new Model (C, modelNodes);

  NodeExpression *exprA = new NodeExpression (A);
  NodeExpression *exprB = new NodeExpression (B);

  AddExpression *exprC = new AddExpression (exprA, exprB);

  model->setExpression (0, exprC);
}


/** Specify the prior distribution of A and B. */

void BAP::specifyDistributions (NumberedDCNode *A, NumberedDCNode *B)
{
  Table *table = A->getTable ();
  NumberList data = table->getData ();

  data[0] = 0.1;
  data[1] = 0.2;
  data[2] = 0.7;
  table->setData (data);

  table = B->getTable ();
  data = table->getData ();
  data[0] = 0.2;
  data[1] = 0.2;
  data[2] = 0.6;
  table->setData (data);
}


/** Build the Bayesian network. */

void BAP::buildNetwork ()
{
  domain->setNodeSize (50,30);

  NumberedDCNode *A = constructNDC ("A1234567890123", "A", 3);
  NumberedDCNode *B = constructNDC ("B", "B", 3);
  NumberedDCNode *C = constructNDC ("C", "C", 5);

  buildStructure (A,B,C);

  buildExpressionForC (A,B,C);

  specifyDistributions (A, B);
}


/**
 * Build a Bayesian network, and compute and print the initial node marginals.
 */
int main (int argc, char *argv[])
{
  new BAP ();
  return 0;
}
