# include "hugin"

# include <cstdio>
# include <iostream>

using namespace HAPI;
using namespace std;

class ClassBuildInstance {
public:
  void test ();
};

/* Build the first network. This will contain an
   instance of the second network
*/
void buildFirst (Class* cls)
{
  LabelledDCNode *node1 = new LabelledDCNode (cls);
  node1->setName ("c1_n1");
  node1->setNumberOfStates (3);

  LabelledDCNode *node2 = new LabelledDCNode (cls);
  node2->setName ("c1_n2");
  node2->setNumberOfStates (2);

  LabelledDCNode *node3 = new LabelledDCNode (cls);
  node3->setName ("c1_n3");
  node3->setNumberOfStates (3);

  node2->addParent (node1);
  node3->addParent (node2);
}

/* Build the second network to be instantiated in
   the first network
*/
void buildSecond (Class* cls)
{
  LabelledDCNode *node1 = new LabelledDCNode (cls);
  node1->setName ("c2_n1");
  node1->setNumberOfStates (3);

  LabelledDCNode *node2 = new LabelledDCNode (cls);
  node2->setName ("c2_n2");
  node2->setNumberOfStates (2);

  LabelledDCNode *node3 = new LabelledDCNode (cls);
  node3->setName ("c2_n3");
  node3->setNumberOfStates (3);

  node3->addParent (node1);
  node3->addParent (node2);

  // make node3 output node
  node3->addToOutputs ();
  // make node2 input node
  // note that only nodes with no parents can be input node
  node2->addToInputs ();
}


void ClassBuildInstance::test ()
{
  // create the class collection to contain the classes
  ClassCollection coll;

  // create the first class in the collection
  Class *cls1 = new Class (&coll);
  cls1->setName ("c1");
  buildFirst (cls1);

  // create the second class in the collection
  Class *cls2 = new Class (&coll);
  cls2->setName ("c2");
  buildSecond (cls2);

  cout << "----------------------------------------\n";
  cout << "Testing instances\n";
  cout << "----------------------------------------\n";
  // create an instance of cls2 in cls1
  InstanceNode *instance = new InstanceNode (cls1, cls2);
  cout << "Instance " << instance->getName () << " derived from "
       << instance->getClass ()->getName () << endl;

  {
    cout << "\n----------------------------------------\n";
    cout << "Testing outputs and clones\n";
    cout << "----------------------------------------\n";
    // get the output node from cls2
    Node *node = cls2->getNodeByName ("c2_n3");

    // we will add the clone of the output as parent to c1_n2
    DiscreteChanceNode *node2
      = dynamic_cast<DiscreteChanceNode*>(cls1->getNodeByName ("c1_n2"));
    // instance->getOutput retrieves the output clone for the given node
    node2->addParent (dynamic_cast<DiscreteChanceNode*>
		      (instance->getOutput (node)));

    cout << "Removing output \n";
    // removing the c2_n3 from the output list. This will
    // delete the output clone, so that c1_n2 no longer has that as parent.
    node->removeFromOutputs ();
    cout << "Done \n";
  }

  {
    cout << "\n----------------------------------------\n";
    cout << "Testing inputs and bindings\n";
    cout << "----------------------------------------\n";
    // get the first (and only) input node from cls2
    Node *node = cls2->getInputs ().front ();
    Node *node2 = cls1->getNodeByName ("c1_n2");
    // bind c1_n2 to the input node. This effectively replaces
    // the table of the input node with that of the bound node.
    instance->setInput (node, node2);
    cout << "Bound " << node->getName () << " to "
	 << instance->getInput (node)->getName () << endl;
  }

  { // create a domain to perform propagation
    cout << "\n----------------------------------------\n";
    cout << "Testing domain creation\n";
    cout << "----------------------------------------\n";
    Domain *dom = cls1->createDomain ();
    dom->saveAsNet ("cbap.net");
  }

  coll.saveAsNet ("cbColl.net");
}

int main ()
{
  ClassBuildInstance *cbi = new ClassBuildInstance ();

  cbi->test ();

  return 0;
}
