/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HAPI;

import COM.hugin.HAPI.AmbiguousRegion;
import COM.hugin.HAPI.AmbiguousRegionList;
import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.ExceptionArgumentNotAlive;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.JunctionTree;
import COM.hugin.HAPI.JunctionTreeList;
import COM.hugin.HAPI.Native.HAPI;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.ParseListener;
import COM.hugin.HAPI.Table;

public class Domain
extends NetworkModel
implements Cloneable {
    public static final Equilibrium H_EQUILIBRIUM_SUM = new Equilibrium(11);
    public static final Equilibrium H_EQUILIBRIUM_MAX = new Equilibrium(12);
    public static final EvidenceMode H_EVIDENCE_MODE_NORMAL = new EvidenceMode(20);
    public static final EvidenceMode H_EVIDENCE_MODE_FAST_RETRACTION = new EvidenceMode(21);
    public static final TriangulationMethod H_TM_CLIQUE_SIZE = new TriangulationMethod(15);
    public static final TriangulationMethod H_TM_CLIQUE_WEIGHT = new TriangulationMethod(16);
    public static final TriangulationMethod H_TM_FILL_IN_SIZE = new TriangulationMethod(17);
    public static final TriangulationMethod H_TM_FILL_IN_WEIGHT = new TriangulationMethod(18);
    public static final TriangulationMethod H_TM_BEST_GREEDY = new TriangulationMethod(20);
    public static final TriangulationMethod H_TM_TOTAL_WEIGHT = new TriangulationMethod(19);
    private AmbiguousRegionList ambiguousRegions = null;

    public Domain() throws ExceptionHugin {
        this.modelPeer = HAPI.nativeHAPI.hNewDomain(this);
        if (this.modelPeer == 0) {
            ExceptionHugin.throwException();
        }
        assert (this.modelPeer != 0);
    }

    public Domain(String string, String string2) throws ExceptionHugin {
        if (string == null) {
            throw new ExceptionUsage("Argument 'hkbFileName' is 'null'");
        }
        this.modelPeer = HAPI.nativeHAPI.hKBLoadDomain(this, string, string2);
        if (this.modelPeer == 0) {
            ExceptionHugin.throwException();
        }
        assert (this.modelPeer != 0);
    }

    public Domain(String string) throws ExceptionHugin {
        this(string, (String)null);
    }

    public Domain(String string, ParseListener parseListener) throws ExceptionHugin {
        if (string == null) {
            throw new ExceptionUsage("Argument 'netFileName' is 'null'");
        }
        this.modelPeer = HAPI.nativeHAPI.hNetParseDomain(this, string, parseListener);
        if (this.modelPeer == 0) {
            ExceptionHugin.throwException();
        }
        assert (this.modelPeer != 0);
    }

    public Domain(String string, ParseListener parseListener, int n) throws ExceptionHugin {
        if (string == null) {
            throw new ExceptionUsage("Argument 'domainDescription' is 'null'");
        }
        this.modelPeer = HAPI.nativeHAPI.hNetParseDomainFromString(this, string, parseListener);
        if (this.modelPeer == 0) {
            ExceptionHugin.throwException();
        }
        assert (this.modelPeer != 0);
    }

    public Domain(Class clazz) throws ExceptionHugin {
        if (clazz == null || !clazz.isAlive()) {
            throw new ExceptionArgumentNotAlive();
        }
        this.modelPeer = HAPI.nativeHAPI.hClassCreateDomain(this, clazz.modelPeer);
        if (this.modelPeer == 0) {
            ExceptionHugin.throwException();
        }
        assert (this.modelPeer != 0);
    }

    protected Domain(int n) throws ExceptionHugin {
        assert (n != 0);
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSetBackpointer(this.modelPeer, this));
    }

    protected static Domain convert(int n) throws ExceptionHugin {
        if (n == 0) {
            ExceptionHugin.throwException();
            return null;
        }
        Domain domain = (Domain)HAPI.nativeHAPI.hDomainGetBackpointer(n);
        if (domain != null) {
            return domain;
        }
        return new Domain(n);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            int n = this.thisPeer();
            Domain domain = (Domain)super.clone();
            domain.modelPeer = HAPI.nativeHAPI.hDomainClone(domain, n);
            if (domain.modelPeer == 0) {
                ExceptionHugin.throwException();
            }
            assert (domain.modelPeer != 0);
            return domain;
        }
        catch (ExceptionHugin exceptionHugin) {
            throw new CloneNotSupportedException(exceptionHugin.toString());
        }
    }

    public void delete() throws ExceptionHugin {
        int n = this.thisPeer();
        this.deleteAmbiguousRegions();
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainDelete(n));
        assert (!this.isAlive());
    }

    public double approximate(double d) throws ExceptionHugin {
        double d2 = HAPI.nativeHAPI.hDomainApproximate(this.thisPeer(), d);
        if (d2 < 0.0) {
            ExceptionHugin.throwException();
        }
        return d2;
    }

    public boolean cgEvidenceIsPropagated() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hDomainCGEvidenceIsPropagated(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public synchronized void compile() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainCompile(this.thisPeer()));
    }

    public synchronized void compile(NodeList nodeList) throws ExceptionHugin {
        this.triangulate(nodeList);
        try {
            this.compile();
        }
        catch (ExceptionHugin exceptionHugin) {
            this.uncompile();
            throw exceptionHugin;
        }
    }

    public synchronized void compile(TriangulationMethod triangulationMethod) throws ExceptionHugin {
        this.triangulate(triangulationMethod);
        try {
            this.compile();
        }
        catch (ExceptionHugin exceptionHugin) {
            this.uncompile();
            throw exceptionHugin;
        }
    }

    public double compress() throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hDomainCompress(this.thisPeer());
        if (d < 0.0) {
            ExceptionHugin.throwException();
        }
        return d;
    }

    public boolean equilibriumIs(Equilibrium equilibrium) throws ExceptionHugin {
        if (equilibrium == null) {
            throw new ExceptionUsage("Argument 'equilibrium' is 'null'");
        }
        boolean bl = HAPI.nativeHAPI.hDomainEquilibriumIs(this.thisPeer(), equilibrium.value);
        ExceptionHugin.throwException();
        return bl;
    }

    public boolean evidenceIsPropagated() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hDomainEvidenceIsPropagated(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public boolean evidenceModeIs(EvidenceMode evidenceMode) throws ExceptionHugin {
        if (evidenceMode == null) {
            throw new ExceptionUsage("Argument 'evidenceMode' is 'null'");
        }
        boolean bl = HAPI.nativeHAPI.hDomainEvidenceModeIs(this.thisPeer(), evidenceMode.value);
        ExceptionHugin.throwException();
        return bl;
    }

    public boolean evidenceToPropagate() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hDomainEvidenceToPropagate(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public double getApproximationConstant() throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hDomainGetApproximationConstant(this.thisPeer());
        if (d < 0.0) {
            ExceptionHugin.throwException();
        }
        return d;
    }

    public synchronized double getConflict() throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hDomainGetConflict(this.thisPeer());
        if (d < 0.0) {
            ExceptionHugin.throwException();
        }
        return d;
    }

    public NodeList getEliminationOrder() throws ExceptionHugin {
        return new NodeList(HAPI.nativeHAPI.hDomainGetEliminationOrder(this.thisPeer()));
    }

    public JunctionTreeList getJunctionTrees() throws ExceptionHugin {
        JunctionTreeList junctionTreeList = new JunctionTreeList();
        int n = HAPI.nativeHAPI.hDomainGetFirstJunctionTree(this.thisPeer());
        while (n != 0) {
            junctionTreeList.add(JunctionTree.convert(n));
            n = HAPI.nativeHAPI.hJTGetNext(n);
        }
        ExceptionHugin.throwException();
        return junctionTreeList;
    }

    public Table getMarginal(NodeList nodeList) throws ExceptionHugin {
        int n = this.thisPeer();
        int n2 = Domain.convertNodeList(nodeList);
        int n3 = HAPI.nativeHAPI.hDomainGetMarginal(n, n2);
        HAPI.nativeHAPI.hListDelete(n2);
        return Table.convertUserTable(n3, nodeList);
    }

    public void findMAPConfigurations(NodeList nodeList, double d) throws ExceptionHugin {
        int n = this.thisPeer();
        int n2 = Domain.convertNodeList(nodeList);
        int n3 = HAPI.nativeHAPI.hDomainFindMAPConfigurations(n, n2, d);
        HAPI.nativeHAPI.hListDelete(n2);
        ExceptionHugin.throwException(n3);
    }

    public int getNumberOfMAPConfigurations() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hDomainGetNumberOfMAPConfigurations(this.thisPeer());
        if (n < 0) {
            ExceptionHugin.throwException();
        }
        return n;
    }

    public int[] getMAPConfiguration(int n) throws ExceptionHugin {
        int[] nArray = HAPI.nativeHAPI.hDomainGetMAPConfiguration(this.thisPeer(), n);
        if (nArray == null) {
            ExceptionHugin.throwException();
        }
        return nArray;
    }

    public double getProbabilityOfMAPConfiguration(int n) throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hDomainGetProbabilityOfMAPConfiguration(this.thisPeer(), n);
        if (d < 0.0) {
            ExceptionHugin.throwException();
        }
        return d;
    }

    public synchronized double getNormalizationConstant() throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hDomainGetNormalizationConstant(this.thisPeer());
        if (d < 0.0) {
            ExceptionHugin.throwException();
        }
        return d;
    }

    public double getExpectedUtility() throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hDomainGetExpectedUtility(this.thisPeer());
        if (d < 0.0) {
            ExceptionHugin.throwException();
        }
        return d;
    }

    public synchronized void initialize() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainInitialize(this.thisPeer()));
    }

    public boolean isTriangulated() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hDomainIsTriangulated(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public boolean isCompiled() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hDomainIsCompiled(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public boolean isCompressed() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hDomainIsCompressed(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public boolean likelihoodIsPropagated() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hDomainLikelihoodIsPropagated(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public synchronized void propagate(Equilibrium equilibrium, EvidenceMode evidenceMode) throws ExceptionHugin {
        if (equilibrium == null || evidenceMode == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainPropagate(this.thisPeer(), equilibrium.value, evidenceMode.value));
    }

    public synchronized void resetInferenceEngine() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainResetInferenceEngine(this.thisPeer()));
    }

    public void retractFindings() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainRetractFindings(this.thisPeer()));
    }

    public void saveAsKB(String string, String string2) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSaveAsKB(this.thisPeer(), string, string2));
    }

    public void saveAsKB(String string) throws ExceptionHugin {
        this.saveAsKB(string, null);
    }

    public void saveToMemory() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSaveToMemory(this.thisPeer()));
    }

    public void simulate() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSimulate(this.thisPeer()));
    }

    public void seedRandom(int n) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSeedRandom(this.thisPeer(), n));
    }

    public double getUniformDeviate() throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hDomainGetUniformDeviate(this.thisPeer());
        if (d < 0.0) {
            ExceptionHugin.throwException();
        }
        assert (d >= 0.0 && d < 1.0);
        return d;
    }

    public double getNormalDeviate(double d, double d2) throws ExceptionHugin {
        double d3 = HAPI.nativeHAPI.hDomainGetNormalDeviate(this.thisPeer(), d, d2);
        if (d3 < 0.0) {
            ExceptionHugin.throwException();
        }
        return d3;
    }

    public boolean tablesToPropagate() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hDomainTablesToPropagate(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public synchronized void triangulate(TriangulationMethod triangulationMethod) throws ExceptionHugin {
        if (triangulationMethod == null) {
            throw new ExceptionUsage("Argument 'tm' is 'null'");
        }
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainTriangulate(this.thisPeer(), triangulationMethod.value));
    }

    public synchronized void triangulate() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainTriangulateDefault(this.thisPeer()));
    }

    public synchronized void triangulate(NodeList nodeList) throws ExceptionHugin {
        int n = this.thisPeer();
        int n2 = Domain.convertNodeList(nodeList);
        int n3 = HAPI.nativeHAPI.hDomainTriangulateWithOrder(n, n2);
        HAPI.nativeHAPI.hListDelete(n2);
        ExceptionHugin.throwException(n3);
    }

    public synchronized void uncompile() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainUncompile(this.thisPeer()));
    }

    public void setConcurrencyLevel(int n) throws ExceptionHugin {
        if (n <= 0) {
            throw new ExceptionUsage("Concurrency level must be positive");
        }
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSetConcurrencyLevel(this.thisPeer(), n));
    }

    public void setGrainSize(int n) throws ExceptionHugin {
        if (n <= 0) {
            throw new ExceptionUsage("Grain size must be positive");
        }
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSetGrainSize(this.thisPeer(), n));
    }

    public int getConcurrencyLevel() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hDomainGetConcurrencyLevel(this.thisPeer());
        if (n < 0) {
            ExceptionHugin.throwException();
        }
        return n;
    }

    public int getGrainSize() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hDomainGetGrainSize(this.thisPeer());
        if (n < 0) {
            ExceptionHugin.throwException();
        }
        return n;
    }

    public double getLogNormalizationConstant() throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hDomainGetLogNormalizationConstant(this.thisPeer());
        ExceptionHugin.throwException();
        return d;
    }

    public void setNumberOfCases(int n) throws ExceptionHugin {
        if (n < 0) {
            throw new ExceptionUsage("Number of cases must be nonnegative");
        }
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSetNumberOfCases(this.thisPeer(), n));
    }

    public int newCase() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hDomainNewCase(this.thisPeer());
        if (n < 0) {
            ExceptionHugin.throwException();
        }
        return n;
    }

    public int getNumberOfCases() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hDomainGetNumberOfCases(this.thisPeer());
        if (n < 0) {
            ExceptionHugin.throwException();
        }
        return n;
    }

    public void setCaseCount(int n, double d) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSetCaseCount(this.thisPeer(), n, d));
    }

    public double getCaseCount(int n) throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hDomainGetCaseCount(this.thisPeer(), n);
        if (d < 0.0) {
            ExceptionHugin.throwException();
        }
        return d;
    }

    public void enterCase(int n) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainEnterCase(this.thisPeer(), n));
    }

    public void learnTables() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainLearnTables(this.thisPeer()));
    }

    public void learnClassTables() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainLearnClassTables(this.thisPeer()));
    }

    public void setLogLikelihoodTolerance(double d) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSetLogLikelihoodTolerance(this.thisPeer(), d));
    }

    public double getLogLikelihoodTolerance() throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hDomainGetLogLikelihoodTolerance(this.thisPeer());
        if (d < 0.0) {
            ExceptionHugin.throwException();
        }
        return d;
    }

    public void setMaxNumberOfEMIterations(int n) throws ExceptionHugin {
        if (n < 0) {
            throw new ExceptionUsage("Number of EM iterations must be nonnegative");
        }
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSetMaxNumberOfEMIterations(this.thisPeer(), n));
    }

    public int getMaxNumberOfEMIterations() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hDomainGetMaxNumberOfEMIterations(this.thisPeer());
        if (n < 0) {
            ExceptionHugin.throwException();
        }
        return n;
    }

    public double getLogLikelihood() throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hDomainGetLogLikelihood(this.thisPeer());
        ExceptionHugin.throwException();
        return d;
    }

    public double getAIC() throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hDomainGetAIC(this.thisPeer());
        ExceptionHugin.throwException();
        return d;
    }

    public double getBIC() throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hDomainGetBIC(this.thisPeer());
        ExceptionHugin.throwException();
        return d;
    }

    public void adapt() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainAdapt(this.thisPeer()));
    }

    public void learnStructure() throws ExceptionHugin {
        int n = this.thisPeer();
        this.deleteAmbiguousRegions();
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainLearnStructure(n));
    }

    public void setSignificanceLevel(double d) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSetSignificanceLevel(this.thisPeer(), d));
    }

    public double getSignificanceLevel() throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hDomainGetSignificanceLevel(this.thisPeer());
        if (d < 0.0) {
            ExceptionHugin.throwException();
        }
        return d;
    }

    public void setMaxNumberOfSeparators(int n) throws ExceptionHugin {
        if (n < 0) {
            throw new ExceptionUsage("Number of separators must be nonnegative");
        }
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSetMaxNumberOfSeparators(this.thisPeer(), n));
    }

    public int getMaxNumberOfSeparators() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hDomainGetMaxNumberOfSeparators(this.thisPeer());
        if (n < 0) {
            ExceptionHugin.throwException();
        }
        return n;
    }

    public void parseCase(String string, ParseListener parseListener) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainParseCase(this.thisPeer(), string, parseListener));
    }

    public void saveCase(String string) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSaveCase(this.thisPeer(), string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCases(String string, NodeList nodeList, int[] nArray, boolean bl, String string2, String string3) throws ExceptionHugin {
        int n = this.thisPeer();
        int n2 = Domain.convertNodeList(nodeList);
        int n3 = 0;
        try {
            if (nArray != null) {
                n3 = HAPI.nativeHAPI.hNewList(nArray.length + 1);
                if (n3 == 0) {
                    ExceptionHugin.throwException();
                }
                assert (n3 != 0);
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] < 0) {
                        throw new ExceptionUsage("Invalid case index");
                    }
                    HAPI.nativeHAPI.hListSetItem(n3, i, nArray[i]);
                }
                HAPI.nativeHAPI.hListSetItem(n3, nArray.length, -1);
            }
            ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSaveCases(n, string, n2, n3, bl, string2, string3));
        }
        finally {
            HAPI.nativeHAPI.hListDelete(n2);
            HAPI.nativeHAPI.hListDelete(n3);
        }
    }

    public void parseCases(String string, ParseListener parseListener) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainParseCases(this.thisPeer(), string, parseListener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeList getDConnectedNodes(NodeList nodeList, NodeList nodeList2, NodeList nodeList3) throws ExceptionHugin {
        int n = this.thisPeer();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            n2 = Domain.convertNodeList(nodeList);
            n3 = Domain.convertNodeList(nodeList2);
            n4 = Domain.convertNodeList(nodeList3);
            NodeList nodeList4 = new NodeList(HAPI.nativeHAPI.hDomainGetDConnectedNodes(n, n2, n3, n4));
            return nodeList4;
        }
        finally {
            HAPI.nativeHAPI.hListDelete(n2);
            HAPI.nativeHAPI.hListDelete(n3);
            HAPI.nativeHAPI.hListDelete(n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeList getDConnectedNodes(NodeList nodeList, NodeList nodeList2) throws ExceptionHugin {
        int n = this.thisPeer();
        int n2 = 0;
        int n3 = 0;
        try {
            n2 = Domain.convertNodeList(nodeList);
            n3 = Domain.convertNodeList(nodeList2);
            NodeList nodeList3 = new NodeList(HAPI.nativeHAPI.hDomainGetDConnectedNodes(n, n2, n3, 0));
            return nodeList3;
        }
        finally {
            HAPI.nativeHAPI.hListDelete(n2);
            HAPI.nativeHAPI.hListDelete(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeList getDSeparatedNodes(NodeList nodeList, NodeList nodeList2, NodeList nodeList3) throws ExceptionHugin {
        int n = this.thisPeer();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            n2 = Domain.convertNodeList(nodeList);
            n3 = Domain.convertNodeList(nodeList2);
            n4 = Domain.convertNodeList(nodeList3);
            NodeList nodeList4 = new NodeList(HAPI.nativeHAPI.hDomainGetDSeparatedNodes(n, n2, n3, n4));
            return nodeList4;
        }
        finally {
            HAPI.nativeHAPI.hListDelete(n2);
            HAPI.nativeHAPI.hListDelete(n3);
            HAPI.nativeHAPI.hListDelete(n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeList getDSeparatedNodes(NodeList nodeList, NodeList nodeList2) throws ExceptionHugin {
        int n = this.thisPeer();
        int n2 = 0;
        int n3 = 0;
        try {
            n2 = Domain.convertNodeList(nodeList);
            n3 = Domain.convertNodeList(nodeList2);
            NodeList nodeList3 = new NodeList(HAPI.nativeHAPI.hDomainGetDSeparatedNodes(n, n2, n3, 0));
            return nodeList3;
        }
        finally {
            HAPI.nativeHAPI.hListDelete(n2);
            HAPI.nativeHAPI.hListDelete(n3);
        }
    }

    public void computeSensitivityData(NodeList nodeList, int[] nArray) throws ExceptionHugin {
        int n = this.thisPeer();
        if (nodeList == null || nArray == null || nodeList.size() != nArray.length) {
            throw new ExceptionUsage();
        }
        int n2 = Domain.convertNodeList(nodeList);
        int n3 = HAPI.nativeHAPI.hDomainComputeSensitivityData(n, n2, nArray);
        HAPI.nativeHAPI.hListDelete(n2);
        ExceptionHugin.throwException(n3);
    }

    public NodeList getSensitivitySet() throws ExceptionHugin {
        return new NodeList(HAPI.nativeHAPI.hDomainGetSensitivitySet(this.thisPeer(), 0));
    }

    public NodeList getSensitivitySet(int n) throws ExceptionHugin {
        return new NodeList(HAPI.nativeHAPI.hDomainGetSensitivitySet(this.thisPeer(), n));
    }

    public void updatePolicies() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainUpdatePolicies(this.thisPeer()));
    }

    public void reportBeliefs(Domain domain) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainReportBeliefs(this.thisPeer()));
    }

    public void learnStructureNPC() throws ExceptionHugin {
        int n = this.thisPeer();
        this.deleteAmbiguousRegions();
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainLearnStructureNPC(n));
    }

    public void learnChowLiuTree(Node node, Node node2) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainLearnChowLiuTree(this.thisPeer(), Node.getNodePeer(node), node2 != null ? Node.getNodePeer(node2) : 0));
    }

    public AmbiguousRegionList getAmbiguousRegions() throws ExceptionHugin {
        int n = this.thisPeer();
        if (this.ambiguousRegions == null) {
            this.ambiguousRegions = new AmbiguousRegionList();
        }
        if (this.ambiguousRegions.size() == 0) {
            int n2 = HAPI.nativeHAPI.hDomainGetFirstAmbiguousRegion(n);
            while (n2 != 0) {
                this.ambiguousRegions.add(new AmbiguousRegion(this, n2));
                n2 = HAPI.nativeHAPI.hAmbiguousRegionGetNext(n2);
            }
            ExceptionHugin.throwException();
        }
        return this.ambiguousRegions;
    }

    public void undoManualDecisions() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainUndoManualDecisions(this.thisPeer()));
        this.deleteAmbiguousRegions();
    }

    public void decideAutomatically() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainDecideAutomatically(this.thisPeer()));
        this.deleteAmbiguousRegions();
    }

    private void deleteAmbiguousRegions() throws ExceptionHugin {
        if (this.ambiguousRegions != null) {
            for (AmbiguousRegion ambiguousRegion : this.ambiguousRegions) {
                ambiguousRegion.delete();
            }
            this.ambiguousRegions.clear();
            this.ambiguousRegions = null;
        }
    }

    public double[] getConvolution(Node node, BooleanDCNode booleanDCNode, Node node2, int n) throws ExceptionHugin {
        if (n <= 0 || n > Integer.MAX_VALUE) {
            throw new ExceptionUsage("Invalid numberOfSamples");
        }
        double[] dArray = new double[n];
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainGetConvolution(this.thisPeer(), Node.getNodePeer(node), Node.getNodePeer(booleanDCNode), Node.getNodePeer(node2), dArray));
        return dArray;
    }

    public boolean areNodesSeparated(Node node, Node node2, NodeList nodeList) throws ExceptionHugin {
        int n = this.thisPeer();
        int n2 = Node.getNodePeer(node);
        int n3 = Node.getNodePeer(node2);
        int n4 = 0;
        if (nodeList != null) {
            n4 = Domain.convertNodeList(nodeList);
        }
        boolean bl = HAPI.nativeHAPI.hDomainNodesAreDSeparated(n, n2, n3, n4);
        HAPI.nativeHAPI.hListDelete(n4);
        ExceptionHugin.throwException();
        return bl;
    }

    public boolean areNodesSeparated(Node node, Node node2) throws ExceptionHugin {
        return this.areNodesSeparated(node, node2, null);
    }

    public Table countCases(NodeList nodeList) throws ExceptionHugin {
        int n = this.thisPeer();
        int n2 = Domain.convertNodeList(nodeList);
        int n3 = HAPI.nativeHAPI.hDomainCountCases(n, n2);
        HAPI.nativeHAPI.hListDelete(n2);
        return Table.convertUserTable(n3, nodeList);
    }

    public NodeList getDecisionOrder() throws ExceptionHugin {
        return new NodeList(HAPI.nativeHAPI.hDomainGetDecisionOrder(this.thisPeer()));
    }

    public static class TriangulationMethod {
        protected final int value;

        protected TriangulationMethod(int n) {
            this.value = n;
        }
    }

    public static class EvidenceMode {
        protected final int value;

        protected EvidenceMode(int n) {
            this.value = n;
        }
    }

    public static class Equilibrium {
        protected final int value;

        protected Equilibrium(int n) {
            this.value = n;
        }
    }
}

