/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.BeliefBarNode;
import COM.hugin.HGUI.BeliefBarTree;
import COM.hugin.HGUI.HuginGUIUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JViewport;

public abstract class BeliefBarNodePainter
extends JPanel {
    static boolean forceScientific = false;
    static int width;
    int height;
    int totalWidth = 0;
    int initialSpace;
    int numberWidth;
    int expandedWidth = 0;
    static int space;
    static int toExp;
    static final int nodeWidth = 16;
    static final int nodeHeight = 14;
    Color color;
    Color back;
    Color fore;
    boolean selected;
    BeliefBarTree theTree;
    JViewport theView;
    static final int BELIEF_BAR = 0;
    static final int FINDING_BAR = 1;
    static final int INCONSISTENT_BAR = 2;
    static final int LIKELIHOOD_BAR = 3;
    static final int LOCKED_EVIDENCE_BAR = 4;
    static final int UTILITY_BAR = 5;
    static final int FUNCTION_BAR = 6;

    public BeliefBarNodePainter() {
        width = 50;
        space = this.initialSpace = 50;
        this.numberWidth = 7;
        this.height = 16;
        this.back = Color.white;
        this.fore = Color.black;
        this.setOpaque(true);
        this.selected = false;
        Dimension dimension = new Dimension(width, this.height);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
    }

    public int getWidth() {
        Graphics graphics = this.getGraphics();
        if (graphics == null && this.totalWidth == 0) {
            this.totalWidth = 1;
        }
        return this.getWidth(graphics);
    }

    public abstract int getWidth(Graphics var1);

    public abstract BeliefBarNode getOwner();

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.back = this.selected ? new Color(0, 0, 150) : Color.white;
        this.fore = this.selected ? Color.white : Color.black;
    }

    public static String convertValue(double d) {
        return HuginGUIUtils.printDouble(d, 2, true, true);
    }

    public static String convertValue(double d, int n, int n2) {
        if (n < 0 || n2 < 0) {
            return "";
        }
        if (forceScientific) {
            return HuginGUIUtils.printDoubleScientific(d);
        }
        return HuginGUIUtils.printDouble(d, n2, true, true);
    }

    void setClip(Graphics graphics) {
        if (this.theView == null) {
            this.theView = (JViewport)this.theTree.getParent();
        }
        Rectangle rectangle = this.theView.getViewRect();
        int n = this.getHeight();
        int n2 = 0;
        if ((double)this.getY() < rectangle.getY()) {
            n2 = (int)(rectangle.getY() - (double)this.getY());
        }
        if ((double)(n + this.getY()) > rectangle.getHeight() + rectangle.getY()) {
            n = (int)rectangle.getHeight() + (int)rectangle.getY() - this.getY();
        }
        graphics.setClip((int)rectangle.getX() - this.getX(), n2, (int)rectangle.getWidth(), n -= n2);
    }

    static String fixed_format(double d, int n, int n2) {
        String string = " ";
        if (d < 0.0) {
            d = -d;
            string = "-";
        }
        long l = (long)d;
        double d2 = d - (double)l;
        double d3 = 1.0;
        String string2 = "";
        for (int i = 1; i <= n2 && d3 <= 9.223372036854776E18; d3 *= 10.0, ++i) {
            string2 = string2 + "0";
        }
        long l2 = (long)(d3 * d2 + 0.5);
        if ((double)l2 >= d3) {
            l2 = 0L;
            ++l;
        }
        String string3 = string2 + l2;
        string3 = n2 == 0 ? string3.substring(string3.length() - n2, string3.length()) : "." + string3.substring(string3.length() - n2, string3.length());
        String string4 = string + l + string3;
        int n3 = string4.length();
        for (int i = 0; i < n - n3; ++i) {
            string4 = " " + string4;
        }
        return string4;
    }

    static String exp_format(double d, int n, int n2) {
        String string = "";
        int n3 = 0;
        double d2 = d;
        double d3 = 1.0;
        if (d != 0.0) {
            while (Math.abs(d2) > 10.0) {
                ++n3;
                d3 /= 10.0;
                d2 /= 10.0;
            }
            while (Math.abs(d2) < 1.0) {
                --n3;
                d3 *= 10.0;
                d2 *= 10.0;
            }
        }
        string = string + BeliefBarNodePainter.fixed_format(d *= d3, n, n2);
        string = string + "e";
        String string2 = "00";
        if (n3 >= 0) {
            string = string + "+";
            string2 = string2 + n3;
        } else {
            string = string + "-";
            string2 = string2 + -n3;
        }
        int n4 = string2.length() - 2;
        for (int i = 0; i < string2.length() - 2; ++i) {
            if (string2.charAt(i) == '0') continue;
            n4 = i;
            break;
        }
        return string + string2.substring(n4, string2.length());
    }

    static {
        toExp = 100000;
    }
}

