/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Node;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class CaseFileViewer
extends JOptionPane {
    JDialog owner;
    CaseFileViewer self;
    JLabel title;
    JButton next;
    JButton previous;
    JButton reset;
    JButton close;
    JTable theTable;
    Domain domain;
    int numSamples = 100;

    public CaseFileViewer(JDialog jDialog, Domain domain) {
        boolean bl = false;
        int n = 0;
        this.self = this;
        this.owner = jDialog;
        this.domain = domain;
        try {
            if (this.numSamples > domain.getNumberOfCases()) {
                this.numSamples = domain.getNumberOfCases();
            }
            this.setLayout(new BorderLayout(5, 5));
            this.theTable = new JTable(new CaseModel(domain, this.numSamples)){

                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this.theTable.setAutoResizeMode(0);
            JScrollPane jScrollPane = new JScrollPane(this.theTable);
            jScrollPane.setPreferredSize(new Dimension(200, 200));
            JPanel jPanel = new JPanel(new FlowLayout());
            JPanel jPanel2 = new JPanel(new FlowLayout());
            this.close = new JButton(HuginGUIConstants.get("MENU_FILE_Close"));
            this.close.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CaseFileViewer.this.self.owner.dispose();
                }
            });
            this.previous = new JButton(HuginGUIConstants.get("str_previous"));
            this.previous.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((CaseModel)CaseFileViewer.this.theTable.getModel()).setIndex(((CaseModel)CaseFileViewer.this.theTable.getModel()).getIndex() - CaseFileViewer.this.numSamples);
                    CaseFileViewer.this.next.setEnabled(true);
                    int n = ((CaseModel)CaseFileViewer.this.theTable.getModel()).getIndex();
                    CaseFileViewer.this.previous.setEnabled(n > 0);
                    CaseFileViewer.this.reset.setEnabled(n > 0);
                    try {
                        CaseFileViewer.this.title.setText(HuginGUIConstants.get("str_showing_ARG0_ARG1_of_ARG2_cases", new String[]{"" + n, "" + (n + CaseFileViewer.this.theTable.getRowCount() - 1), "" + CaseFileViewer.this.domain.getNumberOfCases()}));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.previous.setEnabled(false);
            this.reset = new JButton(HuginGUIConstants.get("str_reset"));
            this.reset.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((CaseModel)CaseFileViewer.this.theTable.getModel()).setIndex(0);
                    CaseFileViewer.this.reset.setEnabled(false);
                    CaseFileViewer.this.previous.setEnabled(false);
                    try {
                        CaseFileViewer.this.next.setEnabled(CaseFileViewer.this.numSamples < CaseFileViewer.this.domain.getNumberOfCases());
                        CaseFileViewer.this.title.setText(HuginGUIConstants.get("str_showing_ARG0_ARG1_of_ARG2_cases", new String[]{"0", "" + CaseFileViewer.this.theTable.getRowCount(), "" + CaseFileViewer.this.domain.getNumberOfCases()}));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.reset.setEnabled(false);
            this.next = new JButton(HuginGUIConstants.get("str_next"));
            this.next.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((CaseModel)CaseFileViewer.this.theTable.getModel()).setIndex(((CaseModel)CaseFileViewer.this.theTable.getModel()).getIndex() + CaseFileViewer.this.numSamples);
                    CaseFileViewer.this.previous.setEnabled(true);
                    try {
                        CaseFileViewer.this.next.setEnabled(((CaseModel)CaseFileViewer.this.theTable.getModel()).getIndex() + CaseFileViewer.this.numSamples < CaseFileViewer.this.domain.getNumberOfCases());
                    }
                    catch (Exception exception) {
                        CaseFileViewer.this.next.setEnabled(false);
                    }
                    CaseFileViewer.this.reset.setEnabled(true);
                    try {
                        int n = ((CaseModel)CaseFileViewer.this.theTable.getModel()).getIndex();
                        CaseFileViewer.this.title.setText(HuginGUIConstants.get("str_showing_ARG0_ARG1_of_ARG2_cases", new String[]{"" + n, "" + (n + CaseFileViewer.this.theTable.getRowCount()), "" + CaseFileViewer.this.domain.getNumberOfCases()}));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.next.setEnabled(this.theTable.getRowCount() < domain.getNumberOfCases());
            jPanel.add(this.previous);
            jPanel.add(this.reset);
            jPanel.add(this.next);
            JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
            jPanel2.add(this.close);
            jPanel3.add(jPanel);
            jPanel3.add(jPanel2);
            this.title = new JLabel(HuginGUIConstants.get("str_showing_ARG0_ARG1_of_ARG2_cases", new String[]{"" + n, "" + (n + this.theTable.getRowCount()), "" + domain.getNumberOfCases()}));
            this.add((Component)jScrollPane, "Center");
            this.add((Component)jPanel3, "South");
            this.add((Component)this.title, "North");
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        if (System.getProperty("os.name").equals("Linux")) {
            this.setSize((int)this.getPreferredSize().getWidth() + 10, (int)this.getPreferredSize().getHeight() + 30);
        }
    }

    private class CaseModel
    extends DefaultTableModel {
        Domain domain;
        Node[] nodes;
        int index = 0;
        int numRows;
        int maxIndex;

        public CaseModel(Domain domain, int n) throws ExceptionHugin {
            this.domain = domain;
            this.numRows = n;
            this.nodes = domain.getNodes().toArray(new Node[0]);
            this.maxIndex = domain.getNumberOfCases();
        }

        public void setIndex(int n) {
            if (n < 0) {
                n = 0;
            }
            if (n > this.maxIndex) {
                n = this.maxIndex - 1;
            }
            this.index = n;
            this.fireTableDataChanged();
        }

        public int getIndex() {
            return this.index;
        }

        public Object getValueAt(int n, int n2) {
            try {
                if (this.nodes[n2] instanceof DiscreteChanceNode) {
                    if (((DiscreteChanceNode)this.nodes[n2]).caseIsSet(n + this.index)) {
                        return ((DiscreteChanceNode)this.nodes[n2]).getStateLabel(((DiscreteChanceNode)this.nodes[n2]).getCaseState(n + this.index));
                    }
                    return HuginGUIConstants.get("str_NA");
                }
                if (this.nodes[n2] instanceof ContinuousChanceNode) {
                    if (((ContinuousChanceNode)this.nodes[n2]).caseIsSet(n + this.index)) {
                        return new Double(((ContinuousChanceNode)this.nodes[n2]).getCaseValue(n + this.index)).toString();
                    }
                    return HuginGUIConstants.get("str_NA");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "-";
        }

        public String getColumnName(int n) {
            String string = HuginGUIConstants.get("str_error_detected");
            try {
                string = this.nodes[n].getLabel();
                if (string == null || string.length() == 0) {
                    string = this.nodes[n].getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }

        public int getColumnCount() {
            return this.nodes.length;
        }

        public int getRowCount() {
            if (this.index + this.numRows > this.maxIndex) {
                return this.maxIndex - this.index;
            }
            return this.numRows;
        }
    }
}

