/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.Node;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public abstract class ColorChart
extends JPanel {
    private static final int RULER_WIDTH = 40;
    private static final int RULER_Y_OFFSET = 5;
    private static final int RULER_X_OFFSET = 3;
    public Node guiNode = null;
    public Color baseColor = Color.WHITE;
    public float fillColorPosR = 0.0f;
    public float fillColorPosG = 0.0f;
    public float fillColorPosB = 1.0f;
    public float fillColorNegR = 1.0f;
    public float fillColorNegG = 0.0f;
    public float fillColorNegB = 0.0f;
    public Color errorColor = Color.RED;
    private ArrayList<ClickListener> clickListeners = new ArrayList();
    protected int graphWidth;
    private float forcedMaxValue = 0.0f;
    protected Stroke thinStroke = new BasicStroke(0.0f);

    public ColorChart(Node node) {
        this.guiNode = node;
        super.setMinimumSize(new Dimension(0, 0));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    if (mouseEvent.getX() < ColorChart.this.graphWidth) {
                        COM.hugin.HAPI.Node node = ColorChart.this.guiNode.getAPINode();
                        int n = 1;
                        if (node instanceof DiscreteNode) {
                            n = ((DiscreteNode)node).getNumberOfStates();
                        }
                        int n2 = node.getTable().getSize() / n;
                        int n3 = mouseEvent.getX();
                        int n4 = mouseEvent.getY();
                        double d = (double)n2 / (double)ColorChart.this.graphWidth;
                        double d2 = (double)n / (double)ColorChart.this.getHeight();
                        int n5 = (int)((double)n3 * d);
                        int n6 = (int)((double)n4 * d2);
                        for (ClickListener clickListener : ColorChart.this.clickListeners) {
                            clickListener.clicked(n6, n5);
                        }
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void addClickListener(ClickListener clickListener) {
        this.clickListeners.add(clickListener);
    }

    public void paint(Graphics graphics) {
        try {
            Color color;
            int n;
            int n2;
            int n3;
            super.paint(graphics);
            int n4 = this.computeHeight();
            int n5 = this.computeWidth();
            if (n4 < 0 || n5 < 0) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (!this.shouldPaint()) {
                graphics2D.setColor(this.errorColor);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                return;
            }
            float f = 0.0f;
            boolean bl = false;
            for (n3 = 0; n3 < n4; ++n3) {
                float f2 = 0.0f;
                for (n2 = 0; n2 < n5; ++n2) {
                    f2 = this.getValue(n2, n3);
                    if (Math.abs(f2) > f) {
                        f = Math.abs(f2);
                    }
                    if (!(f2 < 0.0f)) continue;
                    bl = true;
                }
            }
            if (f < this.forcedMaxValue) {
                f = this.forcedMaxValue;
            }
            if (f <= 0.0f) {
                f = 1.0f;
            }
            this.graphWidth = this.getWidth() - 40;
            n3 = HuginGUIUtils.printDouble((float)(bl ? -1 : 1) * f, 2, false, true).length() - 3;
            if (n3 > 0) {
                this.graphWidth -= n3 * 5;
            }
            if (this.graphWidth > 0) {
                this.paintChart(graphics2D, n5, n4, f);
            } else {
                this.graphWidth = 0;
            }
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(this.graphWidth, 0, this.getWidth() - this.graphWidth, this.getHeight());
            int n6 = this.graphWidth + 3;
            n2 = this.getHeight() - 10;
            int n7 = 13;
            graphics2D.setColor(this.baseColor);
            graphics2D.fillRect(n6, 5, n7, n2);
            for (n = 0; n < n2 / (bl ? 2 : 1); ++n) {
                color = new Color(this.fillColorPosR, this.fillColorPosG, this.fillColorPosB, 1.0f - (float)n / (float)(n2 / (bl ? 2 : 1)));
                graphics2D.setColor(color);
                graphics2D.fillRect(n6, n + 5, n7, 1);
            }
            if (bl) {
                for (n = 0; n < n2 / 2; ++n) {
                    color = new Color(this.fillColorNegR, this.fillColorNegG, this.fillColorNegB, (float)n / (float)(n2 / 2));
                    graphics2D.setColor(color);
                    graphics2D.fillRect(n6, n + 5 + n2 / 2, n7, 1);
                }
            }
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawRect(n6, 5, n7, n2 - 1);
            Font font = new Font("Courier", 1, 10);
            graphics2D.setFont(font);
            for (int i = 0; i < 4; ++i) {
                graphics2D.drawLine(n6 + n7 - 2, i * (n2 / 4) + 5, n6 + n7 + 2, i * (n2 / 4) + 5);
                String string = i == 0 ? HuginGUIUtils.printDouble(f, 2, false, true) : HuginGUIUtils.printDouble(f - (float)i * (f / (float)(bl ? 2 : 4)), 2, false, true);
                graphics2D.drawString(string, n6 + n7 + 3, i * (n2 / 4) + 4 + 5);
            }
            graphics2D.drawLine(n6 + n7 - 2, n2 - 1 + 5, n6 + n7 + 2, n2 - 1 + 5);
            String string = bl ? HuginGUIUtils.printDouble(-f, 2, false, true) : "0";
            graphics2D.drawString(string, n6 + n7 + 3, n2 + 3 + 5);
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public void setForcedMaxValue(float f) {
        this.forcedMaxValue = f;
    }

    public float getForcedMaxValue() {
        return this.forcedMaxValue;
    }

    public int computeHeight() throws ExceptionHugin {
        int n = -1;
        if (this.guiNode.getAPINode() instanceof UtilityNode) {
            UtilityNode utilityNode = (UtilityNode)this.guiNode.getAPINode();
            n = 1;
            if (utilityNode == null) {
                return -1;
            }
        } else {
            DiscreteNode discreteNode = (DiscreteNode)this.guiNode.getAPINode();
            n = discreteNode.getNumberOfStates();
            if (discreteNode == null) {
                return -1;
            }
        }
        return n;
    }

    public int computeWidth() throws ExceptionHugin {
        COM.hugin.HAPI.Node node = this.guiNode.getAPINode();
        int n = 1;
        if (node instanceof DiscreteNode) {
            n = ((DiscreteNode)node).getNumberOfStates();
        }
        return node.getTable().getSize() / n;
    }

    public void paintChart(Graphics2D graphics2D, int n, int n2, float f) {
        int n3;
        double d = (double)this.graphWidth / (double)n;
        double d2 = (double)this.getHeight() / (double)n2;
        graphics2D.scale(d, d2);
        graphics2D.setColor(this.baseColor);
        graphics2D.fillRect(0, 0, n, n2);
        Color color = this.errorColor;
        for (int i = 0; i < n2; ++i) {
            for (n3 = 0; n3 < n; ++n3) {
                float f2 = 0.0f;
                f2 = this.getValue(n3, i);
                color = f2 >= 0.0f ? ((f2 /= f) <= 1.0f ? new Color(this.fillColorPosR, this.fillColorPosG, this.fillColorPosB, f2) : this.errorColor) : ((f2 = Math.abs(f2 / f)) <= 1.0f ? new Color(this.fillColorNegR, this.fillColorNegG, this.fillColorNegB, f2) : this.errorColor);
                graphics2D.setColor(color);
                graphics2D.fillRect(n3, i, 1, 1);
            }
        }
        Stroke stroke = graphics2D.getStroke();
        if (this.canPaintGrid(n)) {
            int n4;
            graphics2D.setStroke(this.thinStroke);
            graphics2D.setColor(Color.BLACK);
            n3 = 0;
            for (n4 = 1; n4 < n; ++n4) {
                graphics2D.drawLine(++n3, 0, n3, n2);
            }
            n4 = 0;
            for (int i = 1; i < n2; ++i) {
                graphics2D.drawLine(0, ++n4, n, n4);
            }
            graphics2D.setStroke(stroke);
        }
        d = (double)n / (double)this.graphWidth;
        d2 = (double)n2 / (double)this.getHeight();
        graphics2D.scale(d, d2);
    }

    private boolean canPaintGrid(int n) {
        return n * 2 <= this.graphWidth;
    }

    public abstract float getValue(int var1, int var2);

    public abstract boolean shouldPaint();

    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent.getX() >= this.graphWidth) {
            return null;
        }
        try {
            int n = this.computeWidth();
            int n2 = this.computeHeight();
            double d = (double)n / (double)this.graphWidth;
            double d2 = (double)n2 / (double)this.getHeight();
            int n3 = (int)((double)mouseEvent.getX() * d);
            int n4 = (int)((double)mouseEvent.getY() * d2);
            int n5 = n3;
            int n6 = n4;
            return "" + this.getValue(n5, n6);
        }
        catch (Exception exception) {
            return "error";
        }
    }

    public static interface ClickListener {
        public void clicked(int var1, int var2);
    }
}

