/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.CasePreprocess;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginFileLoader;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.PreProcessingException;
import COM.hugin.HGUI.Preferences;
import COM.hugin.HGUI.SampleCasesProcess;
import COM.hugin.HGUI.TitledPanel;
import COM.hugin.HGUI.URLComboBox;
import COM.hugin.HGUI.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.SortedMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DataAcquisitionPanel
extends WizardPanel {
    public static final int TEXTFILE = 0;
    public static final int DATABASE = 1;
    public static final int EXISTING = 2;
    public static final int ORACLE = 0;
    public static final int ODBC = 1;
    public static final int JDBC = 2;
    private String[] databases = new String[]{"Oracle", "ODBC", "JDBC"};
    private int nextButtonIndex;
    private JPanel[] connectionInfo = new JPanel[this.databases.length];
    private boolean allowExisting = false;
    JRadioButton textFile;
    JRadioButton database;
    JRadioButton existing;
    TitledPanel textFilePanel;
    TitledPanel databasePanel;
    JButton chooseFile;
    JTextField fileName;
    JCheckBox readNamesFromFile;
    JCheckBox useSeparator;
    JTextField separator;
    JPanel databaseInformationPanel;
    JPanel databaseTypePanel;
    JComboBox databaseType;
    JComboBox driverComboBox;
    JLabel urlLabel;
    JLabel driverLabel;
    JLabel usernameLabel;
    JLabel passLabel;
    JTextField driverField;
    JTextField usernameField;
    URLComboBox urlField;
    JButton driverButton;
    JButton oracleDriverButton;
    JPasswordField passwordField;
    Preferences prefs;
    String filename;
    JLabel hostLabel;
    JLabel portLabel;
    JLabel sidLabel;
    JLabel userLabel;
    JLabel passwordLabel;
    JLabel databaseTypeLabel;
    JTextField host;
    JTextField port;
    JTextField sid;
    JTextField user;
    JPasswordField password;
    JLabel databaseNameLabel;
    JTextField databaseName;
    JCheckBox timeStamped;
    JPanel sampleMethods;
    JCheckBox doSample;
    JRadioButton useSubset;
    JRadioButton pickCases;
    JComboBox subsetMethod;
    JComboBox pickMethod;
    JComboBox pickFrequency;
    JTextField casesFrom;
    JTextField casesTo;
    JTextField pickFrom;
    JLabel casesFromLabel;
    JLabel casesToLabel;
    JLabel everyLabel;
    JLabel pickCasesLabel;
    JLabel pickFromLabel;
    SortedMap<String, Charset> charsets;
    JComboBox encodingBox;
    JLabel encodingLabel;
    JButton defaultButton;

    public DataAcquisitionPanel(JButton[] jButtonArray, int n) {
        this(jButtonArray, n, false);
    }

    public DataAcquisitionPanel(JButton[] jButtonArray, int n, boolean bl) {
        super("Data Acquisition");
        this.buttons = jButtonArray;
        this.nextButtonIndex = n;
        this.allowExisting = bl;
        this.setImage(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("images/data_acquisition.jpg")));
        this.connectionInfo[0] = this.createOracleConnectionInfo();
        this.connectionInfo[1] = this.createODBCConnectionInfo();
        this.connectionInfo[2] = this.createJDBCConnectionInfo();
        this.interior = this.createInterior();
        this.addComponents();
        this.filename = "";
    }

    private Component createInterior() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        if (this.allowExisting) {
            jTextArea.setText("Please specify the source of the data used for testing the model.");
        } else {
            jTextArea.setText("Please specify the source of the data used for learning.");
        }
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBackground(this.getBackground());
        jPanel.add((Component)jTextArea, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.textFile = new JRadioButton("Text File");
        this.textFile.addActionListener(new ChooseTextFileListener());
        this.database = new JRadioButton("Database");
        this.database.addActionListener(new ChooseDatabaseListener());
        this.existing = new JRadioButton("Use inserted data");
        this.existing.addActionListener(new ChooseExistingListener());
        buttonGroup.add(this.textFile);
        buttonGroup.add(this.database);
        buttonGroup.add(this.existing);
        this.textFile.setSelected(true);
        EnableNextListener enableNextListener = new EnableNextListener();
        this.textFilePanel = new TitledPanel("File");
        this.fileName = new JTextField();
        this.fileName.addCaretListener(enableNextListener);
        this.chooseFile = new JButton("Browse");
        this.chooseFile.addActionListener(new BrowseFileListener());
        this.readNamesFromFile = new JCheckBox("Read node names from file");
        this.readNamesFromFile.setSelected(true);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        this.useSeparator = new JCheckBox("Specify Separator");
        this.useSeparator.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DataAcquisitionPanel.this.buttons[DataAcquisitionPanel.this.nextButtonIndex].setEnabled(DataAcquisitionPanel.this.allTextFileFieldsReady());
            }
        });
        this.separator = new JTextField(8);
        this.separator.addCaretListener(enableNextListener);
        this.separator.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                DataAcquisitionPanel.this.useSeparator.setSelected(DataAcquisitionPanel.this.separator.getText().length() > 0);
                DataAcquisitionPanel.this.buttons[DataAcquisitionPanel.this.nextButtonIndex].setEnabled(DataAcquisitionPanel.this.allTextFileFieldsReady());
            }
        });
        jPanel3.add(this.useSeparator);
        jPanel3.add(this.separator);
        JPanel jPanel4 = new JPanel(new BorderLayout(5, 5));
        this.charsets = Charset.availableCharsets();
        Collection<Charset> collection = this.charsets.values();
        this.encodingBox = new JComboBox<Object>(collection.toArray());
        if (this.charsets.containsKey("UTF-8")) {
            this.encodingBox.setSelectedItem(this.charsets.get("UTF-8"));
        }
        this.encodingLabel = new JLabel(HuginGUIConstants.get("LW_encoding"));
        this.defaultButton = new JButton(HuginGUIConstants.get("LW_set_to_default"));
        this.defaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataAcquisitionPanel.this.charsets.containsKey("UTF-8")) {
                    DataAcquisitionPanel.this.encodingBox.setSelectedItem(DataAcquisitionPanel.this.charsets.get("UTF-8"));
                }
            }
        });
        jPanel4.add((Component)new JSeparator(), "North");
        jPanel4.add((Component)this.encodingLabel, "West");
        jPanel4.add((Component)this.encodingBox, "Center");
        jPanel4.add((Component)this.defaultButton, "East");
        JPanel jPanel5 = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)this.readNamesFromFile, "North");
        jPanel6.add((Component)jPanel3, "South");
        jPanel5.add((Component)jPanel6, "North");
        jPanel5.add((Component)jPanel4, "South");
        this.textFilePanel.setLayout(new BorderLayout(5, 5));
        this.textFilePanel.add(this.fileName);
        this.textFilePanel.add((Component)this.chooseFile, "East");
        this.textFilePanel.add((Component)jPanel5, "South");
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.add((Component)this.textFile, "North");
        jPanel7.add(this.textFilePanel);
        this.databasePanel = new TitledPanel("Database Connection");
        this.databasePanel.setLayout(new BorderLayout());
        this.databaseTypePanel = new JPanel(new FlowLayout(0));
        this.databaseType = new JComboBox<String>(this.databases);
        this.databaseType.setSelectedIndex(1);
        this.databaseType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DataAcquisitionPanel.this.databaseInformationPanel.removeAll();
                DataAcquisitionPanel.this.databaseInformationPanel.add((Component)DataAcquisitionPanel.this.databaseTypePanel, "North");
                DataAcquisitionPanel.this.databaseInformationPanel.add(DataAcquisitionPanel.this.connectionInfo[DataAcquisitionPanel.this.databaseType.getSelectedIndex()]);
                DataAcquisitionPanel.this.validate();
            }
        });
        this.databaseTypeLabel = new JLabel("Database Type");
        this.databaseTypePanel.add(this.databaseType);
        this.databaseTypePanel.add(this.databaseTypeLabel);
        this.databaseInformationPanel = new JPanel(new BorderLayout());
        JPanel jPanel8 = this.connectionInfo[this.databaseType.getSelectedIndex()];
        this.databaseInformationPanel.add((Component)this.databaseTypePanel, "North");
        this.databaseInformationPanel.add(jPanel8);
        this.databasePanel.add(this.databaseInformationPanel);
        JPanel jPanel9 = new JPanel(new BorderLayout());
        jPanel9.add((Component)this.database, "North");
        JPanel jPanel10 = new JPanel(new BorderLayout());
        jPanel10.add((Component)this.databasePanel, "North");
        jPanel9.add(jPanel10);
        jPanel2.add((Component)jPanel7, "North");
        jPanel2.add(jPanel9);
        this.enableTextFile(this.textFile.isSelected());
        this.enableDatabase(this.database.isSelected());
        this.host.setText("");
        this.port.setText("");
        this.sid.setText("");
        this.user.setText("");
        this.password.setText("");
        JPanel jPanel11 = new JPanel(new BorderLayout());
        jPanel11.add((Component)this.existing, "North");
        JPanel jPanel12 = new JPanel(new BorderLayout());
        jPanel12.add((Component)jPanel2, "North");
        if (this.allowExisting) {
            jPanel12.add(jPanel11);
        }
        jPanel.add(jPanel12);
        JPanel jPanel13 = new JPanel(new BorderLayout());
        this.doSample = new JCheckBox("Sample data");
        this.doSample.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataAcquisitionPanel.this.enableSampling(DataAcquisitionPanel.this.doSample.isSelected());
            }
        });
        this.sampleMethods = new TitledPanel("Method");
        this.sampleMethods.setLayout(new GridLayout(3, 1));
        JPanel jPanel14 = new JPanel(new FlowLayout(0));
        this.useSubset = new JRadioButton("");
        this.subsetMethod = new JComboBox<String>(new String[]{HuginGUIConstants.get("str_use"), HuginGUIConstants.get("str_exclude")});
        this.casesFrom = new JTextField(5);
        this.casesTo = new JTextField(5);
        this.casesFromLabel = new JLabel(HuginGUIConstants.get("str_cases_from"));
        this.casesToLabel = new JLabel(HuginGUIConstants.get("str_to"));
        jPanel14.add(this.useSubset);
        jPanel14.add(this.subsetMethod);
        jPanel14.add(this.casesFromLabel);
        jPanel14.add(this.casesFrom);
        jPanel14.add(this.casesToLabel);
        jPanel14.add(this.casesTo);
        JPanel jPanel15 = new JPanel(new FlowLayout(0));
        this.pickCases = new JRadioButton("");
        this.pickCases.setSelected(true);
        this.pickMethod = new JComboBox<String>(new String[]{HuginGUIConstants.get("str_use"), HuginGUIConstants.get("str_exclude")});
        this.pickFrequency = new JComboBox<String>(new String[]{"2", "3", "4", "5", "10"});
        this.pickFrequency.setEditable(true);
        this.everyLabel = new JLabel(HuginGUIConstants.get("str_every"));
        this.pickCasesLabel = new JLabel(HuginGUIConstants.get("str_cases"));
        jPanel15.add(this.pickCases);
        jPanel15.add(this.pickMethod);
        jPanel15.add(this.everyLabel);
        jPanel15.add(this.pickFrequency);
        jPanel15.add(this.pickCasesLabel);
        JPanel jPanel16 = new JPanel(new FlowLayout(2));
        this.pickFrom = new JTextField(5);
        this.pickFrom.setText("0");
        this.pickFromLabel = new JLabel(HuginGUIConstants.get("str_starting_from_"));
        jPanel16.add(this.pickFromLabel);
        jPanel16.add(this.pickFrom);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.useSubset);
        buttonGroup2.add(this.pickCases);
        this.useSubset.setEnabled(true);
        this.sampleMethods.add(jPanel14);
        this.sampleMethods.add(jPanel15);
        this.sampleMethods.add(jPanel16);
        jPanel13.add((Component)this.doSample, "North");
        jPanel13.add(this.sampleMethods);
        this.enableSampling(false);
        return jPanel;
    }

    public String getEncoding() {
        return this.encodingBox.getSelectedItem().toString();
    }

    public void setEnableComponents(boolean bl) {
        try {
            for (int i = 0; i < this.buttons.length - 1; ++i) {
                this.buttons[i].setEnabled(bl);
            }
            this.buttons[this.buttons.length - 1].setCursor(Cursor.getPredefinedCursor(0));
            if (this.textFile.isSelected()) {
                this.enableTextFile(bl);
            }
            if (this.database.isSelected()) {
                this.enableDatabase(bl);
            }
            this.textFile.setEnabled(bl);
            this.database.setEnabled(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void enableSampling(boolean bl) {
        this.sampleMethods.setEnabled(bl);
        this.useSubset.setEnabled(bl);
        this.pickCases.setEnabled(bl);
        this.subsetMethod.setEnabled(bl);
        this.pickMethod.setEnabled(bl);
        this.pickFrequency.setEnabled(bl);
        this.casesFrom.setEnabled(bl);
        this.casesTo.setEnabled(bl);
        this.casesFromLabel.setEnabled(bl);
        this.casesToLabel.setEnabled(bl);
        this.everyLabel.setEnabled(bl);
        this.pickCasesLabel.setEnabled(bl);
        this.pickFrom.setEnabled(bl);
        this.pickFromLabel.setEnabled(bl);
    }

    public CasePreprocess getSampleProcess() throws PreProcessingException {
        int n;
        int n2;
        if (!this.doSample.isEnabled() || !this.doSample.isSelected()) {
            return null;
        }
        int n3 = this.useSubset.isSelected() ? (this.subsetMethod.getSelectedIndex() == 0 ? 1 : 2) : (this.pickMethod.getSelectedIndex() == 0 ? 3 : 4);
        boolean bl = false;
        if (this.useSubset.isSelected()) {
            int n4;
            int n5;
            try {
                n5 = Integer.parseInt(this.casesTo.getText());
                n4 = Integer.parseInt(this.casesFrom.getText());
                if (n4 >= n5) {
                    throw new PreProcessingException(HuginGUIConstants.get("str_invalid_interval_from_must_be_smaller"));
                }
                if (n5 < 1 || n4 < 1) {
                    throw new PreProcessingException(HuginGUIConstants.get("str_invalid_interval_all_values_must_be_larger"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new PreProcessingException(HuginGUIConstants.get("str_invalid_interval_specified_not_a_valid_number"));
            }
            return new SampleCasesProcess(n3, n4, n5);
        }
        try {
            n2 = Integer.parseInt(this.pickFrequency.getSelectedItem().toString());
            if (n2 < 2) {
                throw new PreProcessingException(HuginGUIConstants.get("str_invalid_sample_value_specified_value_must_be_larger"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PreProcessingException(HuginGUIConstants.get("str_invalid_sample_value_specified_not_a_valid_number"));
        }
        try {
            n = Integer.parseInt(this.pickFrom.getText());
        }
        catch (Exception exception) {
            throw new PreProcessingException(HuginGUIConstants.get("str_ARG0_is_not_a_valid_number", new String[]{this.pickFrom.getText()}));
        }
        if (n < 0) {
            throw new PreProcessingException(HuginGUIConstants.get("str_invalid_start_value_must_be_larger"));
        }
        return new SampleCasesProcess(n3, n2, n);
    }

    protected boolean timeStamped() {
        return this.timeStamped.isSelected();
    }

    protected int getAcquisitionMethod() {
        return this.textFile.isSelected() ? 0 : (this.database.isSelected() ? 1 : 2);
    }

    protected String getFileName() {
        if (!this.textFile.isSelected()) {
            return null;
        }
        this.filename = this.fileName.getText().trim();
        return this.fileName.getText().trim();
    }

    public String getFileOrDatabaseName() {
        String[] stringArray = this.filename.split("/");
        this.filename = stringArray[stringArray.length - 1];
        return this.filename;
    }

    protected boolean useSeparator() {
        return this.useSeparator.isSelected() && this.separator.getText().length() > 0;
    }

    protected String getSeparator() {
        return this.separator.getText();
    }

    protected boolean getReadNames() {
        return this.readNamesFromFile.isSelected();
    }

    protected int getDatabaseType() {
        if (!this.database.isSelected()) {
            return -1;
        }
        return this.databaseType.getSelectedIndex();
    }

    protected String getHost() {
        if (!this.database.isSelected()) {
            return null;
        }
        this.filename = this.host.getText().trim();
        return this.host.getText().trim();
    }

    protected String getUrl() {
        if (!this.database.isSelected()) {
            return null;
        }
        this.filename = (String)this.urlField.getSelectedItem();
        this.urlField.addToList();
        return (String)this.urlField.getSelectedItem();
    }

    protected String getDriver() {
        if (!this.database.isSelected()) {
            return null;
        }
        return ((String)this.driverComboBox.getSelectedItem()).trim();
    }

    protected String getJDBCUsername() {
        if (!this.database.isSelected()) {
            return null;
        }
        return this.usernameField.getText().trim();
    }

    protected String getJDBCPassword() {
        if (!this.database.isSelected()) {
            return null;
        }
        String string = new String(this.passwordField.getPassword());
        return string.trim();
    }

    protected String getPort() {
        if (!this.database.isSelected()) {
            return null;
        }
        return this.port.getText().trim();
    }

    protected String getSID() {
        if (!this.database.isSelected()) {
            return null;
        }
        return this.sid.getText().trim();
    }

    protected String getUser() {
        if (!this.database.isSelected()) {
            return null;
        }
        return this.user.getText().trim();
    }

    protected String getPassword() {
        if (!this.database.isSelected()) {
            return null;
        }
        return new String(this.password.getPassword());
    }

    protected String getDatabaseName() {
        if (!this.database.isSelected()) {
            return null;
        }
        this.filename = this.databaseName.getText().trim();
        return this.databaseName.getText();
    }

    private boolean allDatabaseFieldsReady() {
        String string = (String)this.databaseType.getSelectedItem();
        if (string == null) {
            return false;
        }
        if (string.equals(this.databases[0])) {
            return this.host.getText().trim().length() > 0 && this.port.getText().trim().length() > 0 && this.sid.getText().trim().length() > 0 && this.user.getText().trim().length() > 0 && this.password.getPassword().length > 0;
        }
        if (string.equals(this.databases[1])) {
            return this.databaseName.getText().trim().length() > 0;
        }
        String string2 = new String(this.passwordField.getPassword());
        if (string.equals(this.databases[2])) {
            return ((String)this.urlField.getSelectedItem()).length() > 0 && this.usernameField.getText().trim().length() > 0 && string2.trim().length() > 0;
        }
        return false;
    }

    private boolean allTextFileFieldsReady() {
        return this.fileName.getText().trim().length() > 0 && (!this.useSeparator.isSelected() || this.separator.getText().length() > 0);
    }

    private void enableTextFile(boolean bl) {
        this.textFilePanel.setEnabled(bl);
        this.fileName.setEnabled(bl);
        this.chooseFile.setEnabled(bl);
        this.readNamesFromFile.setEnabled(bl);
        this.useSeparator.setEnabled(bl);
        this.separator.setEnabled(bl);
        this.encodingBox.setEnabled(bl);
        this.encodingLabel.setEnabled(bl);
        this.defaultButton.setEnabled(bl);
    }

    private void enableDatabase(boolean bl) {
        this.databasePanel.setEnabled(bl);
        this.databaseType.setEnabled(bl);
        this.databaseTypeLabel.setEnabled(bl);
        this.hostLabel.setEnabled(bl);
        this.portLabel.setEnabled(bl);
        this.sidLabel.setEnabled(bl);
        this.userLabel.setEnabled(bl);
        this.passwordLabel.setEnabled(bl);
        this.host.setEnabled(bl);
        this.port.setEnabled(bl);
        this.sid.setEnabled(bl);
        this.user.setEnabled(bl);
        this.password.setEnabled(bl);
        this.databaseNameLabel.setEnabled(bl);
        this.databaseName.setEnabled(bl);
        this.urlLabel.setEnabled(bl);
        this.urlField.setEnabled(bl);
        this.passwordField.setEnabled(bl);
        this.passLabel.setEnabled(bl);
        this.usernameLabel.setEnabled(bl);
        this.usernameField.setEnabled(bl);
        this.driverButton.setEnabled(bl);
        this.oracleDriverButton.setEnabled(bl);
    }

    private JPanel createOracleConnectionInfo() {
        EnableNextListener enableNextListener = new EnableNextListener();
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.hostLabel = new JLabel("Host");
        this.host = new JTextField();
        this.host.addCaretListener(enableNextListener);
        jPanel2.add((Component)this.hostLabel, "North");
        jPanel2.add(this.host);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new GridLayout(2, 2));
        jPanel2 = new JPanel(new BorderLayout());
        this.portLabel = new JLabel("Port");
        this.port = new JTextField();
        this.port.addCaretListener(enableNextListener);
        jPanel2.add((Component)this.portLabel, "North");
        jPanel2.add(this.port);
        jPanel3.add(jPanel2);
        jPanel2 = new JPanel(new BorderLayout());
        this.sidLabel = new JLabel("SID");
        this.sid = new JTextField();
        this.sid.addCaretListener(enableNextListener);
        jPanel2.add((Component)this.sidLabel, "North");
        jPanel2.add(this.sid);
        jPanel3.add(jPanel2);
        jPanel2 = new JPanel(new BorderLayout());
        this.userLabel = new JLabel("User");
        this.user = new JTextField();
        this.user.addCaretListener(enableNextListener);
        jPanel2.add((Component)this.userLabel, "North");
        jPanel2.add(this.user);
        jPanel3.add(jPanel2);
        jPanel2 = new JPanel(new BorderLayout());
        this.passwordLabel = new JLabel("Password");
        this.password = new JPasswordField();
        this.password.addCaretListener(enableNextListener);
        jPanel2.add((Component)this.passwordLabel, "North");
        jPanel2.add(this.password);
        jPanel3.add(jPanel2);
        jPanel2 = new JPanel(new BorderLayout());
        this.oracleDriverButton = new JButton(HuginGUIConstants.get("DCP_Set_Driver"));
        this.oracleDriverButton.addActionListener(new DriverListener());
        jPanel2.add((Component)new JSeparator(), "North");
        jPanel2.add((Component)this.oracleDriverButton, "East");
        jPanel.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    public void setPreferences(Preferences preferences) {
        this.prefs = preferences;
        this.urlField.setPreferences(this.prefs);
    }

    private JPanel createJDBCConnectionInfo() {
        EnableNextListener enableNextListener = new EnableNextListener();
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.urlLabel = new JLabel("URL");
        this.urlField = this.prefs != null ? new URLComboBox(this.prefs) : new URLComboBox();
        jPanel3.add((Component)this.urlLabel, "North");
        jPanel3.add(this.urlField);
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2));
        jPanel3 = new JPanel(new BorderLayout());
        this.usernameLabel = new JLabel("User");
        this.usernameField = new JTextField();
        this.usernameField.addCaretListener(enableNextListener);
        jPanel3.add((Component)this.usernameLabel, "North");
        jPanel3.add(this.usernameField);
        jPanel4.add(jPanel3);
        jPanel3 = new JPanel(new BorderLayout());
        this.passLabel = new JLabel("Password");
        this.passwordField = new JPasswordField();
        this.passwordField.addCaretListener(enableNextListener);
        jPanel3.add((Component)this.passLabel, "North");
        jPanel3.add(this.passwordField);
        jPanel4.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel4 = new JPanel(new BorderLayout());
        jPanel3 = new JPanel(new BorderLayout());
        this.driverButton = new JButton(HuginGUIConstants.get("DCP_Set_Driver"));
        this.driverButton.addActionListener(new DriverListener());
        jPanel3.add((Component)new JSeparator(), "North");
        jPanel3.add((Component)this.driverButton, "East");
        jPanel4.add((Component)jPanel3, "North");
        jPanel2.add((Component)jPanel4, "South");
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel createODBCConnectionInfo() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.databaseName = new JTextField();
        this.databaseName.addCaretListener(new EnableNextListener());
        this.databaseNameLabel = new JLabel("Database Name");
        jPanel.add((Component)this.databaseNameLabel, "North");
        jPanel.add(this.databaseName);
        return jPanel;
    }

    class DriverListener
    implements ActionListener {
        String driverpath = "";
        File driverFile = new File("");

        DriverListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HuginFileLoader huginFileLoader;
            int n;
            if (DataAcquisitionPanel.this.prefs.driverdir.length() != 0) {
                this.driverpath = DataAcquisitionPanel.this.prefs.driverdir;
                this.driverFile = new File(this.driverpath);
            }
            if ((n = (huginFileLoader = new HuginFileLoader(15, this.driverFile, 0)).showDialog(DataAcquisitionPanel.this)) == 0) {
                File file = null;
                file = huginFileLoader.getSelectedFile();
                if (file != null) {
                    DataAcquisitionPanel.this.prefs.driverdir = file.getPath();
                }
            }
        }
    }

    private class BrowseFileListener
    implements ActionListener {
        private BrowseFileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HuginFileLoader huginFileLoader = null;
            File file = DataAcquisitionPanel.this.fileName.getText().length() > 0 ? new File(DataAcquisitionPanel.this.fileName.getText()) : Hugin.mainFrame.getMostRecentDataFile();
            huginFileLoader = file == null ? new HuginFileLoader(1, 0) : new HuginFileLoader(1, file, 0);
            if (huginFileLoader != null && huginFileLoader.showDialog(DataAcquisitionPanel.this) == 0) {
                Hugin.mainFrame.setMostRecentDataFile(huginFileLoader.getSelectedFile());
                try {
                    DataAcquisitionPanel.this.fileName.setText(huginFileLoader.getSelectedFile().getCanonicalPath());
                }
                catch (Exception exception) {
                    DataAcquisitionPanel.this.fileName.setText(huginFileLoader.getSelectedFile().toString());
                }
            }
        }
    }

    private class ChooseExistingListener
    implements ActionListener {
        private ChooseExistingListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataAcquisitionPanel.this.enableTextFile(false);
            DataAcquisitionPanel.this.enableDatabase(false);
            DataAcquisitionPanel.this.doSample.setEnabled(false);
            DataAcquisitionPanel.this.buttons[DataAcquisitionPanel.this.nextButtonIndex].setEnabled(true);
        }
    }

    private class ChooseDatabaseListener
    implements ActionListener {
        private ChooseDatabaseListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataAcquisitionPanel.this.enableTextFile(false);
            DataAcquisitionPanel.this.enableDatabase(true);
            DataAcquisitionPanel.this.doSample.setEnabled(true);
            DataAcquisitionPanel.this.buttons[DataAcquisitionPanel.this.nextButtonIndex].setEnabled(DataAcquisitionPanel.this.allDatabaseFieldsReady());
        }
    }

    private class ChooseTextFileListener
    implements ActionListener {
        private ChooseTextFileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataAcquisitionPanel.this.enableTextFile(true);
            DataAcquisitionPanel.this.enableDatabase(false);
            DataAcquisitionPanel.this.doSample.setEnabled(true);
            DataAcquisitionPanel.this.buttons[DataAcquisitionPanel.this.nextButtonIndex].setEnabled(DataAcquisitionPanel.this.allTextFileFieldsReady());
        }
    }

    private class EnableNextListener
    implements CaretListener {
        private EnableNextListener() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            if (DataAcquisitionPanel.this.textFile.isSelected()) {
                DataAcquisitionPanel.this.buttons[DataAcquisitionPanel.this.nextButtonIndex].setEnabled(DataAcquisitionPanel.this.allTextFileFieldsReady());
            } else if (DataAcquisitionPanel.this.database.isSelected()) {
                DataAcquisitionPanel.this.buttons[DataAcquisitionPanel.this.nextButtonIndex].setEnabled(DataAcquisitionPanel.this.allDatabaseFieldsReady());
            }
        }
    }
}

