/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.DatabaseDataSource;
import COM.hugin.HGUI.DatabaseException;
import COM.hugin.HGUI.DatabaseJoin;
import COM.hugin.HGUI.DatabaseTable;
import COM.hugin.HGUI.DatabaseVariable;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.TitledPanel;
import COM.hugin.HGUI.UsefullList;
import COM.hugin.HGUI.WarningDialog;
import COM.hugin.HGUI.WizardError;
import COM.hugin.HGUI.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class DatabaseConfigurationPanel
extends WizardPanel {
    Connection database;
    DatabaseDataSource databaseSource;
    int nextButtonIndex;
    JDialog parent;
    Vector<DatabaseTable> databaseTables;
    UsefullList tableList;
    JComboBox newTableName;
    JButton addTable;
    JButton removeTable;
    JTable joins;
    TableTableModel tableModel;
    JTextField joinText;
    JButton addJoin;
    JButton editJoin;
    JButton removeJoin;

    public DatabaseConfigurationPanel(JButton[] jButtonArray, int n, JDialog jDialog) {
        super("Database Configuration");
        this.buttons = jButtonArray;
        this.nextButtonIndex = n;
        this.parent = jDialog;
        this.setImage(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("images/database_configuration.jpg")));
        this.interior = this.createInterior();
        this.addComponents();
    }

    private Component createInterior() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 10));
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        TitledPanel titledPanel = new TitledPanel("Tables");
        titledPanel.setLayout(new BorderLayout(5, 5));
        this.tableList = new UsefullList();
        this.tableList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DatabaseConfigurationPanel.this.removeTable.setEnabled(DatabaseConfigurationPanel.this.tableList.getSelectedIndex() >= 0 && !DatabaseConfigurationPanel.this.tableModel.contains((DatabaseTable)DatabaseConfigurationPanel.this.tableList.getSelectedValue()));
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tableList);
        jScrollPane.setPreferredSize(new Dimension(140, 50));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.addTable = new JButton("Add");
        this.addTable.addActionListener(new AddTableListener());
        this.addTable.setEnabled(false);
        this.removeTable = new JButton("Remove");
        this.removeTable.addActionListener(new RemoveTableListener());
        this.removeTable.setEnabled(false);
        jPanel3.add((Component)this.addTable, "North");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)this.removeTable, "North");
        jPanel3.add(jPanel4);
        String[] stringArray = new String[]{HuginGUIConstants.get("LEARNING_MSG_Select_Table_To_Add")};
        this.newTableName = new JComboBox<String>(stringArray);
        this.newTableName.setEnabled(false);
        this.newTableName.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DatabaseConfigurationPanel.this.addTable.setEnabled(DatabaseConfigurationPanel.this.newTableName.getSelectedIndex() != -1 && DatabaseConfigurationPanel.this.newTableName.getSelectedIndex() != 0);
            }
        });
        titledPanel.add(jScrollPane);
        titledPanel.add((Component)jPanel3, "East");
        titledPanel.add((Component)this.newTableName, "South");
        TitledPanel titledPanel2 = new TitledPanel("Joins");
        titledPanel2.setLayout(new BorderLayout(5, 5));
        this.tableModel = new TableTableModel();
        this.joins = new JTable(this.tableModel){

            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                super.changeSelection(n, n2, bl, bl2);
                DatabaseConfigurationPanel.this.joinText.setText(DatabaseConfigurationPanel.this.tableModel.getJoin(n).toString());
                DatabaseConfigurationPanel.this.editJoin.setEnabled(n >= 0);
                DatabaseConfigurationPanel.this.removeJoin.setEnabled(n >= 0);
            }
        };
        this.joins.setSelectionMode(0);
        JPanel jPanel5 = new JPanel(new FlowLayout(1, 0, 0));
        this.addJoin = new JButton("Define");
        this.addJoin.addActionListener(new DefineJoinListener(this.tableModel));
        this.editJoin = new JButton("Edit");
        this.editJoin.addActionListener(new DefineJoinListener(this.joins));
        this.editJoin.setEnabled(false);
        this.removeJoin = new JButton("Remove");
        this.removeJoin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseConfigurationPanel.this.tableModel.removeJoin(DatabaseConfigurationPanel.this.joins.getSelectedRow());
                DatabaseConfigurationPanel.this.joinText.setText("");
                DatabaseConfigurationPanel.this.buttons[DatabaseConfigurationPanel.this.nextButtonIndex].setEnabled(DatabaseConfigurationPanel.this.allTablesJoined());
            }
        });
        this.removeJoin.setEnabled(false);
        jPanel5.add(this.addJoin);
        jPanel5.add(this.editJoin);
        jPanel5.add(this.removeJoin);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        this.joinText = new JTextField();
        this.joinText.setEditable(false);
        jPanel6.add((Component)new JLabel("Join Definition"), "North");
        jPanel6.add(this.joinText);
        jPanel6.add((Component)jPanel5, "South");
        JScrollPane jScrollPane2 = new JScrollPane(this.joins);
        jScrollPane2.setPreferredSize(new Dimension(240, 60));
        titledPanel2.add(jScrollPane2);
        titledPanel2.add((Component)jPanel6, "South");
        jPanel2.add(titledPanel);
        jPanel2.add((Component)titledPanel2, "South");
        JTextArea jTextArea = new JTextArea("Select which tables to use for learning, and specify the necessary joins between the tables.");
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBackground(this.getBackground());
        jPanel.add((Component)jTextArea, "North");
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.add((Component)jPanel2, "North");
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void setEnableComponents(boolean bl) {
        for (int i = 0; i < this.buttons.length - 1; ++i) {
            this.buttons[i].setEnabled(bl);
        }
        this.buttons[this.buttons.length - 1].setCursor(Cursor.getPredefinedCursor(0));
        this.addJoin.setEnabled(bl);
        this.newTableName.setEnabled(bl);
    }

    protected void setDatabase(DatabaseDataSource databaseDataSource) throws DatabaseException {
        try {
            this.databaseSource = databaseDataSource;
            this.database = databaseDataSource.getConnection();
            this.databaseTables = databaseDataSource.getTables();
            this.tableList.setListData(this.databaseTables);
            this.buttons[this.nextButtonIndex].setEnabled(this.allTablesJoined());
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = new DatabaseException(HuginGUIConstants.get("str_unable_to_retrieve_tb_from_db_lb_ARG0", new String[]{sQLException.getMessage()}));
            databaseException.fillInStackTrace();
            throw databaseException;
        }
    }

    protected DatabaseJoin getJoin() {
        DatabaseJoin databaseJoin = new DatabaseJoin();
        if (this.joins.getRowCount() == 0) {
            return null;
        }
        for (int i = 0; i < this.joins.getRowCount() - 1; ++i) {
            databaseJoin.addJoin(this.tableModel.getJoin(i));
            databaseJoin.addOperator("and");
        }
        databaseJoin.addJoin(this.tableModel.getJoin(this.joins.getRowCount() - 1));
        return databaseJoin;
    }

    protected String[] getTables() {
        String[] stringArray = new String[this.tableList.length()];
        ListModel listModel = this.tableList.getModel();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((DatabaseTable)listModel.getElementAt(i)).getName();
        }
        return stringArray;
    }

    private boolean allTablesJoined() {
        int n;
        if (this.tableList.length() == 0) {
            return false;
        }
        if (this.tableList.length() == 1) {
            return true;
        }
        boolean[][] blArray = new boolean[this.tableList.length()][this.tableList.length()];
        for (n = 0; n < blArray[0].length; ++n) {
            for (int i = 0; i < blArray[0].length; ++i) {
                blArray[n][i] = n == i;
            }
        }
        for (n = 0; n < this.tableModel.getRowCount(); ++n) {
            DatabaseJoin databaseJoin = this.tableModel.getJoin(n);
            int n2 = this.tableList.getObjectIndex(databaseJoin.getFrom());
            int n3 = this.tableList.getObjectIndex(databaseJoin.getTo());
            blArray[n2][n3] = true;
            blArray[n3][n2] = true;
        }
        this.recursiveCheck(blArray, 0);
        n = blArray.length > 0 ? 1 : 0;
        for (int i = 0; i < blArray[0].length; ++i) {
            n = n != 0 && blArray[0][i] ? 1 : 0;
        }
        return n != 0;
    }

    private void recursiveCheck(boolean[][] blArray, int n) {
        for (int i = n + 1; i < blArray[n].length; ++i) {
            if (!blArray[n][i] || blArray[0][i] && n != 0) continue;
            blArray[0][i] = true;
            this.recursiveCheck(blArray, i);
        }
    }

    public void back() {
        this.getPrevious().reInitialize();
    }

    public String getHelpText() {
        return "No help available";
    }

    protected void showJoinWarning() {
        if (!Hugin.mainFrame.showJoinWarning()) {
            return;
        }
        WarningDialog warningDialog = new WarningDialog(HuginGUIConstants.get("str_notice"), HuginGUIConstants.get("MISCELLANEOUS_join_warning"), this.parent);
        warningDialog.pack();
        warningDialog.setLocation(Hugin.mainFrame.getX() + this.getX() + (this.getWidth() - warningDialog.getWidth()) / 2, Hugin.mainFrame.getY() + this.getY() + (this.getHeight() - warningDialog.getHeight()) / 2);
        warningDialog.setVisible(true);
        Hugin.mainFrame.showJoinWarning(warningDialog.showWarning());
    }

    private DatabaseTable getFromSavedTables(String string) {
        if (this.databaseTables != null) {
            for (DatabaseTable databaseTable : this.databaseTables) {
                if (!databaseTable.getName().replace("\"", "").equals(string)) continue;
                return databaseTable;
            }
        }
        return null;
    }

    private class DefineJoinListener
    implements ActionListener {
        TableTableModel tableModel;
        JTable table;
        boolean editing;

        public DefineJoinListener(TableTableModel tableTableModel) {
            this.tableModel = tableTableModel;
            this.editing = false;
        }

        public DefineJoinListener(JTable jTable) {
            this.tableModel = (TableTableModel)jTable.getModel();
            this.table = jTable;
            this.editing = true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CreateJoin createJoin = this.editing ? new CreateJoin(this.tableModel.getJoin(this.table.getSelectedRow())) : new CreateJoin();
            createJoin.pack();
            createJoin.setVisible(true);
            DatabaseJoin databaseJoin = createJoin.getResult();
            if (databaseJoin == null) {
                return;
            }
            if (this.editing) {
                if (databaseJoin.isEmpty()) {
                    this.tableModel.removeJoin(DatabaseConfigurationPanel.this.joins.getSelectedRow());
                    DatabaseConfigurationPanel.this.joinText.setText("");
                    DatabaseConfigurationPanel.this.buttons[DatabaseConfigurationPanel.this.nextButtonIndex].setEnabled(DatabaseConfigurationPanel.this.allTablesJoined());
                } else {
                    this.tableModel.setJoin(databaseJoin, this.table.getSelectedRow());
                    DatabaseConfigurationPanel.this.joins.setRowSelectionInterval(DatabaseConfigurationPanel.this.joins.getRowCount() - 1, DatabaseConfigurationPanel.this.joins.getRowCount() - 1);
                }
            } else if (!databaseJoin.isEmpty()) {
                this.tableModel.addJoin(databaseJoin);
                DatabaseConfigurationPanel.this.joins.setRowSelectionInterval(DatabaseConfigurationPanel.this.joins.getRowCount() - 1, DatabaseConfigurationPanel.this.joins.getRowCount() - 1);
            }
            DatabaseConfigurationPanel.this.joinText.setText(databaseJoin.toString());
            DatabaseConfigurationPanel.this.editJoin.setEnabled(true);
            DatabaseConfigurationPanel.this.removeJoin.setEnabled(true);
            DatabaseConfigurationPanel.this.buttons[DatabaseConfigurationPanel.this.nextButtonIndex].setEnabled(DatabaseConfigurationPanel.this.allTablesJoined());
            DatabaseConfigurationPanel.this.showJoinWarning();
        }

        private class CreateJoin
        extends JDialog {
            DatabaseJoin result;
            JList from;
            JList to;
            JList fromVariables;
            JList toVariables;
            JTextField joinDefinition;
            JButton add;
            JButton and;
            JButton or;
            JButton delete;

            public CreateJoin() {
                super((JDialog)DatabaseConfigurationPanel.this.getTopLevelAncestor(), "", true);
                this.result = new DatabaseJoin();
                this.createPanel(null);
            }

            public CreateJoin(DatabaseJoin databaseJoin) {
                super((JDialog)DatabaseConfigurationPanel.this.getTopLevelAncestor(), "", true);
                this.result = databaseJoin;
                this.createPanel(this.result);
            }

            private void createPanel(DatabaseJoin databaseJoin) {
                JDialog jDialog = (JDialog)DatabaseConfigurationPanel.this.getTopLevelAncestor();
                JLabel jLabel = new JLabel("Define Join");
                jLabel.setAlignmentX(0.0f);
                TitledPanel titledPanel = new TitledPanel("From");
                titledPanel.setLayout(new GridLayout(1, 2, 10, 0));
                this.from = new JList(DatabaseConfigurationPanel.this.tableList.getModel());
                this.from.setSelectionMode(0);
                this.from.addListSelectionListener(new FromListener());
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)new JLabel("Table"), "North");
                JScrollPane jScrollPane = new JScrollPane(this.from);
                jScrollPane.setPreferredSize(new Dimension(120, 80));
                jPanel.add(jScrollPane);
                titledPanel.add(jPanel);
                this.fromVariables = new JList();
                this.fromVariables.setSelectionMode(0);
                this.fromVariables.addListSelectionListener(new VariablesSelectedListener());
                jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)new JLabel("Variable"), "North");
                jScrollPane = new JScrollPane(this.fromVariables);
                jScrollPane.setPreferredSize(new Dimension(120, 80));
                jPanel.add(jScrollPane);
                titledPanel.add(jPanel);
                TitledPanel titledPanel2 = new TitledPanel("To");
                titledPanel2.setLayout(new GridLayout(1, 2, 10, 0));
                this.to = new JList(DatabaseConfigurationPanel.this.tableList.getModel());
                this.to.setSelectionMode(0);
                this.to.addListSelectionListener(new ToListener());
                jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)new JLabel("Table"), "North");
                jScrollPane = new JScrollPane(this.to);
                jScrollPane.setPreferredSize(new Dimension(120, 80));
                jPanel.add(jScrollPane);
                titledPanel2.add(jPanel);
                this.toVariables = new JList();
                this.toVariables.setSelectionMode(0);
                this.toVariables.addListSelectionListener(new VariablesSelectedListener());
                jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)new JLabel("Variable"), "North");
                jScrollPane = new JScrollPane(this.toVariables);
                jScrollPane.setPreferredSize(new Dimension(120, 80));
                jPanel.add(jScrollPane);
                titledPanel2.add(jPanel);
                JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
                jPanel2.add(titledPanel);
                jPanel2.add(titledPanel2);
                JPanel jPanel3 = new JPanel(new BorderLayout());
                JPanel jPanel4 = new JPanel(new FlowLayout());
                this.add = new JButton("Add");
                this.add.addActionListener(new AddJoinListener());
                this.add.setEnabled(false);
                this.delete = new JButton("Delete");
                this.delete.addActionListener(new DeleteJoinListener());
                this.delete.setEnabled(this.result.toString().length() > 0);
                this.and = new JButton("And");
                this.and.addActionListener(new AddAndListener());
                this.and.setEnabled(this.result.toString().length() > 0);
                this.or = new JButton("Or");
                this.or.setEnabled(this.result.toString().length() > 0);
                jPanel4.add(this.add);
                jPanel4.add(this.delete);
                jPanel4.add(Box.createRigidArea(new Dimension(30, 10)));
                jPanel4.add(this.and);
                JPanel jPanel5 = new JPanel(new FlowLayout());
                JButton jButton = new JButton("Cancel");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        CreateJoin.this.result = null;
                        CreateJoin.this.dispose();
                    }
                });
                JButton jButton2 = new JButton("OK");
                jButton2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (CreateJoin.this.joinDefinition.getText().trim().length() == 0) {
                            CreateJoin.this.result = null;
                        }
                        CreateJoin.this.dispose();
                    }
                });
                jPanel5.add(jButton2);
                jPanel5.add(jButton);
                this.joinDefinition = new JTextField(this.result.toString());
                this.joinDefinition.setEditable(false);
                jScrollPane = new JScrollPane(this.joinDefinition);
                jScrollPane.setHorizontalScrollBarPolicy(32);
                jPanel3.add((Component)jPanel4, "North");
                jPanel3.add(jScrollPane);
                jPanel3.add((Component)jPanel5, "South");
                this.getContentPane().setLayout(new BorderLayout(5, 5));
                this.getContentPane().add((Component)jLabel, "North");
                this.getContentPane().add(jPanel2);
                this.getContentPane().add((Component)jPanel3, "South");
                if (databaseJoin != null) {
                    this.from.setSelectedValue(databaseJoin.getFrom(), true);
                    this.to.setSelectedValue(databaseJoin.getTo(), true);
                    this.from.setEnabled(databaseJoin.getFrom() == null);
                    this.to.setEnabled(databaseJoin.getTo() == null);
                    this.joinDefinition.setText(databaseJoin.toString());
                }
                this.setLocation(jDialog.getX(), jDialog.getY());
            }

            protected DatabaseJoin getResult() {
                return this.result;
            }

            private class DeleteJoinListener
            implements ActionListener {
                private DeleteJoinListener() {
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (CreateJoin.this.result.deleteElement() == 0) {
                        CreateJoin.this.to.setEnabled(true);
                        CreateJoin.this.from.setEnabled(true);
                    }
                    CreateJoin.this.joinDefinition.setText(CreateJoin.this.result.toString());
                    CreateJoin.this.and.setEnabled(!CreateJoin.this.result.addedOperatorLast());
                    CreateJoin.this.add.setEnabled(CreateJoin.this.result.addedOperatorLast());
                }
            }

            private class AddAndListener
            implements ActionListener {
                private AddAndListener() {
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    CreateJoin.this.result.addOperator("and");
                    CreateJoin.this.joinDefinition.setText(CreateJoin.this.result.toString());
                    CreateJoin.this.and.setEnabled(!CreateJoin.this.result.addedOperatorLast());
                    CreateJoin.this.add.setEnabled(CreateJoin.this.result.addedOperatorLast());
                }
            }

            private class AddJoinListener
            implements ActionListener {
                private AddJoinListener() {
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        DatabaseJoin databaseJoin = new DatabaseJoin((DatabaseTable)CreateJoin.this.from.getSelectedValue(), (DatabaseTable)CreateJoin.this.to.getSelectedValue(), (DatabaseVariable)CreateJoin.this.fromVariables.getSelectedValue(), (DatabaseVariable)CreateJoin.this.toVariables.getSelectedValue());
                        if (CreateJoin.this.result.addJoin(databaseJoin)) {
                            CreateJoin.this.from.setEnabled(false);
                            CreateJoin.this.to.setEnabled(false);
                        }
                        CreateJoin.this.joinDefinition.setText(CreateJoin.this.result.toString());
                        CreateJoin.this.and.setEnabled(!CreateJoin.this.result.addedOperatorLast());
                        CreateJoin.this.add.setEnabled(CreateJoin.this.result.addedOperatorLast());
                    }
                    catch (DatabaseJoin.InvalidJoinException invalidJoinException) {
                        new HuginGUIError(invalidJoinException.getMessage());
                    }
                }
            }

            private class VariablesSelectedListener
            implements ListSelectionListener {
                private VariablesSelectedListener() {
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    CreateJoin.this.add.setEnabled(CreateJoin.this.toVariables.getSelectedIndex() >= 0 && CreateJoin.this.fromVariables.getSelectedIndex() >= 0 && !CreateJoin.this.to.getSelectedValue().equals(CreateJoin.this.from.getSelectedValue()) && CreateJoin.this.result.addedOperatorLast());
                }
            }

            private class ToListener
            implements ListSelectionListener {
                private ToListener() {
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    JList jList = (JList)listSelectionEvent.getSource();
                    if (!jList.isSelectionEmpty()) {
                        Vector<DatabaseVariable> vector = ((DatabaseTable)CreateJoin.this.to.getSelectedValue()).getVariables();
                        CreateJoin.this.toVariables.setListData(vector);
                    }
                }
            }

            private class FromListener
            implements ListSelectionListener {
                private FromListener() {
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    JList jList = (JList)listSelectionEvent.getSource();
                    if (!jList.isSelectionEmpty()) {
                        Vector<DatabaseVariable> vector = ((DatabaseTable)CreateJoin.this.from.getSelectedValue()).getVariables();
                        CreateJoin.this.fromVariables.setListData(vector);
                    }
                }
            }
        }
    }

    private class RemoveTableListener
    implements ActionListener {
        private RemoveTableListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DatabaseTable databaseTable = (DatabaseTable)DatabaseConfigurationPanel.this.tableList.getSelectedValue();
            while (databaseTable != null) {
                DatabaseConfigurationPanel.this.tableList.removeElementAt(DatabaseConfigurationPanel.this.tableList.getSelectedIndex());
                DatabaseConfigurationPanel.this.newTableName.addItem(databaseTable.getName().replace("\"", ""));
                DatabaseConfigurationPanel.this.newTableName.setEnabled(DatabaseConfigurationPanel.this.newTableName.getItemCount() > 1);
                for (int i = 0; i < DatabaseConfigurationPanel.this.tableModel.getRowCount(); ++i) {
                    DatabaseJoin databaseJoin = DatabaseConfigurationPanel.this.tableModel.getJoin(i);
                    if (databaseJoin == null || !databaseJoin.containsTable(databaseTable)) continue;
                    if (DatabaseConfigurationPanel.this.joins.getSelectedRow() == i) {
                        DatabaseConfigurationPanel.this.editJoin.setEnabled(false);
                        DatabaseConfigurationPanel.this.removeJoin.setEnabled(false);
                        DatabaseConfigurationPanel.this.joinText.setText("");
                    }
                    DatabaseConfigurationPanel.this.tableModel.removeJoin(i);
                }
                databaseTable = (DatabaseTable)DatabaseConfigurationPanel.this.tableList.getSelectedValue();
            }
            DatabaseConfigurationPanel.this.removeTable.setEnabled(false);
            DatabaseConfigurationPanel.this.buttons[DatabaseConfigurationPanel.this.nextButtonIndex].setEnabled(DatabaseConfigurationPanel.this.allTablesJoined());
        }
    }

    private class AddTableListener
    implements ActionListener {
        private AddTableListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)DatabaseConfigurationPanel.this.newTableName.getSelectedItem();
            DatabaseTable databaseTable = DatabaseConfigurationPanel.this.getFromSavedTables(string);
            if (databaseTable != null) {
                DatabaseConfigurationPanel.this.tableList.add(databaseTable);
                DatabaseConfigurationPanel.this.newTableName.removeItem(string);
                DatabaseConfigurationPanel.this.newTableName.setSelectedIndex(0);
                DatabaseConfigurationPanel.this.newTableName.setEnabled(DatabaseConfigurationPanel.this.newTableName.getItemCount() > 1);
                DatabaseConfigurationPanel.this.addTable.setEnabled(false);
                DatabaseConfigurationPanel.this.buttons[DatabaseConfigurationPanel.this.nextButtonIndex].setEnabled(DatabaseConfigurationPanel.this.allTablesJoined());
                return;
            }
            try {
                ResultSet resultSet = null;
                DatabaseMetaData databaseMetaData = DatabaseConfigurationPanel.this.database.getMetaData();
                resultSet = databaseMetaData.getColumns(null, null, string, null);
                Vector<DatabaseVariable> vector = new Vector<DatabaseVariable>();
                while (resultSet.next()) {
                    vector.add(new DatabaseVariable(resultSet.getString("COLUMN_NAME")));
                }
                resultSet.close();
                DatabaseConfigurationPanel.this.tableList.add(new DatabaseTable(string, vector));
                DatabaseConfigurationPanel.this.newTableName.removeItem(string);
                DatabaseConfigurationPanel.this.newTableName.setSelectedIndex(0);
                DatabaseConfigurationPanel.this.newTableName.setEnabled(DatabaseConfigurationPanel.this.newTableName.getItemCount() > 1);
                DatabaseConfigurationPanel.this.addTable.setEnabled(false);
                DatabaseConfigurationPanel.this.buttons[DatabaseConfigurationPanel.this.nextButtonIndex].setEnabled(DatabaseConfigurationPanel.this.allTablesJoined());
            }
            catch (Exception exception) {
                WizardError.showError(HuginGUIConstants.get("str_error"), exception.getMessage(), DatabaseConfigurationPanel.this);
            }
        }
    }

    private class TableTableModel
    extends DefaultTableModel {
        String[] names = new String[]{"From", "To"};
        Vector<DatabaseJoin> data = new Vector();

        public int getColumnCount() {
            return this.names.length;
        }

        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public DatabaseTable getValueAt(int n, int n2) {
            if (this.data.size() > n && n2 < this.names.length) {
                switch (n2) {
                    case 0: {
                        return this.data.get(n).getFrom();
                    }
                    case 1: {
                        return this.data.get(n).getTo();
                    }
                }
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public String getColumnName(int n) {
            return this.names[n];
        }

        public DatabaseJoin getJoin(int n) {
            if (n >= this.data.size() || n < 0) {
                return null;
            }
            return this.data.get(n);
        }

        public void setJoin(DatabaseJoin databaseJoin, int n) {
            this.data.setElementAt(databaseJoin, n);
            this.fireTableCellUpdated(n, 0);
            this.fireTableCellUpdated(n, 1);
        }

        public void removeJoin(int n) {
            this.data.remove(n);
            this.fireTableRowsDeleted(0, 0);
        }

        public void addJoin(DatabaseJoin databaseJoin) {
            String[] stringArray = new String[]{"", ""};
            this.fireTableRowsInserted(0, 0);
            this.data.add(databaseJoin);
        }

        public boolean contains(DatabaseTable databaseTable) {
            for (int i = 0; i < this.data.size(); ++i) {
                DatabaseJoin databaseJoin = this.data.get(i);
                if (databaseJoin.getTo() != databaseTable && databaseJoin.getFrom() != databaseTable) continue;
                return true;
            }
            return false;
        }
    }
}

