/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionInconsistencyOrUnderflow;
import COM.hugin.HAPI.ExceptionInvalidExpression;
import COM.hugin.HAPI.ExceptionInvalidProbabilityPotential;
import COM.hugin.HAPI.ExceptionLowDensity;
import COM.hugin.HAPI.ExceptionMemory;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.Node;
import COM.hugin.HGUI.DataAcquisitionPanel;
import COM.hugin.HGUI.DataPreprocessingPanel;
import COM.hugin.HGUI.DataSource;
import COM.hugin.HGUI.DataSourceException;
import COM.hugin.HGUI.DataStream;
import COM.hugin.HGUI.DatabaseConfigurationPanel;
import COM.hugin.HGUI.DatabaseDataSource;
import COM.hugin.HGUI.DatabaseException;
import COM.hugin.HGUI.DatabaseJoin;
import COM.hugin.HGUI.EMLearningPanel;
import COM.hugin.HGUI.HelpPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.JDBCDataSource;
import COM.hugin.HGUI.NetworkNamingPane;
import COM.hugin.HGUI.ODBCDataSource;
import COM.hugin.HGUI.OracleDataSource;
import COM.hugin.HGUI.PreProcessingException;
import COM.hugin.HGUI.Preferences;
import COM.hugin.HGUI.PriorDistributionsPanel;
import COM.hugin.HGUI.TextfileDataSource;
import COM.hugin.HGUI.WizardPanel;
import COM.hugin.HGUI.WizardStatus;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.FileNotFoundException;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class EMLearningWizard
extends JDialog {
    String networkName = "wizard";
    DataAcquisitionPanel page1 = null;
    DatabaseConfigurationPanel page2 = null;
    DataPreprocessingPanel page3 = null;
    PriorDistributionsPanel page4 = null;
    EMLearningPanel page5 = null;
    private WizardPanel currentPanel = null;
    final int NEXT_BUTTON = 2;
    DataSource dataSource = null;
    DataStream dataStream = null;
    HelpPanel helpPanel;
    Preferences prefs;
    boolean finished = false;
    HuginProjectFrame project;
    boolean wasDomain = false;
    WizardStatus status;
    int activeStep = 0;

    public EMLearningWizard(JFrame jFrame, Preferences preferences) {
        super((Frame)jFrame, true);
        this.prefs = preferences;
        WizardPanel.setWizardSize(new Dimension(620, 550));
        this.status = new WizardStatus(new String[]{"Data Acquisition", "Data Preprocessing", "Prior Distribution Knowledge", "EM-Learning"}, Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("images/emWizard.png")));
        this.project = Hugin.mainFrame.getSelectedProjectFrame();
        this.page1 = this.getAcquisitionPanel();
        this.currentPanel = this.page1;
        this.page1.setStatus(this.status);
        this.status.setActiveStep(0);
        this.helpPanel = new HelpPanel(this);
        this.getContentPane().add(this.page1);
        this.pack();
        if (System.getProperty("os.name").equals("Linux")) {
            this.setSize((int)this.getPreferredSize().getWidth() + 10, (int)this.getPreferredSize().getHeight() + 30);
        }
        this.addKeyListener(new WizardKeyListener());
        this.setResizable(true);
        this.addComponentListener(new ResizedListener(this));
    }

    public String getTitle() {
        return "Learning Wizard";
    }

    public Dimension getPreferredSize() {
        return new Dimension(620, 550);
    }

    protected Domain getResult() throws ExceptionObjectNotAlive, ExceptionHugin {
        if (!this.finished) {
            return null;
        }
        Domain domain = this.page5.getDomain();
        return domain;
    }

    private DataAcquisitionPanel getAcquisitionPanel() {
        JButton[] jButtonArray = new JButton[4];
        jButtonArray[0] = new JButton("Help");
        jButtonArray[0].addActionListener(new HelpListener("help/dataAcquisitionHelp.html"));
        jButtonArray[0].setEnabled(true);
        jButtonArray[1] = new JButton("< Back");
        jButtonArray[1].setEnabled(false);
        jButtonArray[2] = new JButton("Next >");
        jButtonArray[2].setEnabled(false);
        jButtonArray[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Domain domain;
                    NetworkModel networkModel = EMLearningWizard.this.project.getNetworkPanel().getHome();
                    if (networkModel instanceof Class) {
                        domain = HuginGUIUtils.createDomain((Class)networkModel);
                        domain.openLogFile(EMLearningWizard.this.project.getClassInfo().getLogFile().getCanonicalPath(), true);
                        domain.setUserData(networkModel);
                    } else {
                        EMLearningWizard.this.wasDomain = true;
                        domain = (Domain)networkModel;
                    }
                    int n = EMLearningWizard.this.page1.getAcquisitionMethod();
                    WizardPanel wizardPanel = null;
                    switch (n) {
                        case 0: {
                            EMLearningWizard.this.dataSource = new TextfileDataSource(EMLearningWizard.this.page1.getFileName(), null, EMLearningWizard.this.page1.getEncoding());
                            ((TextfileDataSource)EMLearningWizard.this.dataSource).readNamesFromFile(EMLearningWizard.this.page1.getReadNames());
                            if (EMLearningWizard.this.page1.useSeparator()) {
                                ((TextfileDataSource)EMLearningWizard.this.dataSource).setSeparators(EMLearningWizard.this.page1.getSeparator());
                            }
                            EMLearningWizard.this.dataStream = new DataStream(EMLearningWizard.this.dataSource, domain, false);
                            EMLearningWizard.this.page3 = EMLearningWizard.this.getDataPreprocessingPanel();
                            EMLearningWizard.this.page3.setPrevious(EMLearningWizard.this.page1);
                            EMLearningWizard.this.page3.setDataStream(EMLearningWizard.this.dataStream);
                            EMLearningWizard.this.page3.setStatus(EMLearningWizard.this.status);
                            EMLearningWizard.this.status.setActiveStep(++EMLearningWizard.this.activeStep);
                            wizardPanel = EMLearningWizard.this.page3;
                            break;
                        }
                        case 1: {
                            switch (EMLearningWizard.this.page1.getDatabaseType()) {
                                case 0: {
                                    EMLearningWizard.this.dataSource = new OracleDataSource(EMLearningWizard.this.prefs.driverdir, EMLearningWizard.this.page1.getHost(), EMLearningWizard.this.page1.getPort(), EMLearningWizard.this.page1.getSID(), EMLearningWizard.this.page1.getUser(), EMLearningWizard.this.page1.getPassword());
                                    break;
                                }
                                case 1: {
                                    EMLearningWizard.this.dataSource = new ODBCDataSource(EMLearningWizard.this.page1.getDatabaseName());
                                    break;
                                }
                                case 2: {
                                    EMLearningWizard.this.dataSource = new JDBCDataSource(EMLearningWizard.this.prefs.driverdir, EMLearningWizard.this.page1.getUrl(), EMLearningWizard.this.page1.getJDBCUsername(), EMLearningWizard.this.page1.getJDBCPassword());
                                }
                            }
                            EMLearningWizard.this.dataStream = new DataStream(EMLearningWizard.this.dataSource, domain, false);
                            EMLearningWizard.this.page2 = EMLearningWizard.this.getDatabaseConfigPanel();
                            EMLearningWizard.this.page2.setDatabase((DatabaseDataSource)EMLearningWizard.this.dataSource);
                            EMLearningWizard.this.page2.setStatus(EMLearningWizard.this.status);
                            EMLearningWizard.this.page2.setPrevious(EMLearningWizard.this.page1);
                            EMLearningWizard.this.status.insertItemAt("Database Configuration", 1);
                            EMLearningWizard.this.status.setActiveStep(++EMLearningWizard.this.activeStep);
                            wizardPanel = EMLearningWizard.this.page2;
                        }
                    }
                    EMLearningWizard.this.currentPanel = EMLearningWizard.this.page2;
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(wizardPanel);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
                catch (NullPointerException nullPointerException) {
                    new HuginGUIError(HuginGUIConstants.get("MENU_WIZARDS_EMLearning_Error"));
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page1);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
                catch (DatabaseException databaseException) {
                    new HuginGUIError(databaseException.getMessage());
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page1);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
                catch (DataSourceException dataSourceException) {
                    new HuginGUIError(dataSourceException.getMessage());
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page1);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    new HuginGUIError(fileNotFoundException.getMessage());
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page1);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
                catch (ExceptionMemory exceptionMemory) {
                    new HuginGUIError(exceptionMemory.getMessage());
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page1);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page1);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
            }
        });
        jButtonArray[3] = new JButton("Cancel");
        jButtonArray[3].addActionListener(new CancelListener());
        DataAcquisitionPanel dataAcquisitionPanel = new DataAcquisitionPanel(jButtonArray, 2);
        dataAcquisitionPanel.setPreferences(this.prefs);
        return dataAcquisitionPanel;
    }

    private DatabaseConfigurationPanel getDatabaseConfigPanel() {
        JButton[] jButtonArray = new JButton[4];
        jButtonArray[0] = new JButton("Help");
        jButtonArray[0].addActionListener(new HelpListener("help/databaseConfigurationHelp.html"));
        jButtonArray[0].setEnabled(true);
        jButtonArray[1] = new JButton("< Back");
        jButtonArray[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EMLearningWizard.this.page2.back();
                EMLearningWizard.this.status.removeItemAt(1);
                EMLearningWizard.this.currentPanel = EMLearningWizard.this.page1;
                EMLearningWizard.this.activeStep = 0;
                EMLearningWizard.this.currentPanel.setStatus(EMLearningWizard.this.status);
                EMLearningWizard.this.status.setActiveStep(EMLearningWizard.this.activeStep);
                EMLearningWizard.this.getContentPane().invalidate();
                EMLearningWizard.this.getContentPane().removeAll();
                EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page1);
                EMLearningWizard.this.validate();
                EMLearningWizard.this.repaint();
            }
        });
        jButtonArray[2] = new JButton("Next >");
        jButtonArray[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseJoin databaseJoin = EMLearningWizard.this.page2.getJoin();
                String[] stringArray = EMLearningWizard.this.page2.getTables();
                if (databaseJoin == null && stringArray.length > 1) {
                    new HuginGUIError(HuginGUIConstants.get("str_unable_to_proceed_with_specified_joins"));
                    return;
                }
                ((DatabaseDataSource)EMLearningWizard.this.dataSource).setJoin(databaseJoin);
                ((DatabaseDataSource)EMLearningWizard.this.dataSource).setTables(stringArray);
                EMLearningWizard.this.getContentPane().invalidate();
                try {
                    EMLearningWizard.this.dataStream.initialize();
                    for (int i = 0; i < stringArray.length - 1; ++i) {
                        EMLearningWizard.this.networkName = EMLearningWizard.this.networkName + stringArray[i] + "_";
                    }
                    EMLearningWizard.this.networkName = EMLearningWizard.this.networkName + stringArray[stringArray.length - 1];
                    EMLearningWizard.this.networkName = NetworkNamingPane.legalize(EMLearningWizard.this.networkName);
                    EMLearningWizard.this.page3 = EMLearningWizard.this.getDataPreprocessingPanel();
                    EMLearningWizard.this.page3.setPrevious(EMLearningWizard.this.page2);
                    EMLearningWizard.this.page3.setDataStream(EMLearningWizard.this.dataStream);
                    EMLearningWizard.this.page3.setStatus(EMLearningWizard.this.status);
                    EMLearningWizard.this.status.setActiveStep(++EMLearningWizard.this.activeStep);
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page3);
                    EMLearningWizard.this.currentPanel = EMLearningWizard.this.page3;
                }
                catch (DataSourceException dataSourceException) {
                    new HuginGUIError(dataSourceException.getMessage());
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page2);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page2);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
                EMLearningWizard.this.validate();
                EMLearningWizard.this.repaint();
            }
        });
        jButtonArray[3] = new JButton("Cancel");
        jButtonArray[3].addActionListener(new CancelListener());
        return new DatabaseConfigurationPanel(jButtonArray, 2, this);
    }

    private DataPreprocessingPanel getDataPreprocessingPanel() {
        JButton[] jButtonArray = new JButton[4];
        jButtonArray[0] = new JButton("Help");
        jButtonArray[0].addActionListener(new HelpListener("help/dataPreprocessingHelp.html"));
        jButtonArray[0].setEnabled(true);
        jButtonArray[1] = new JButton("< Back");
        jButtonArray[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EMLearningWizard.this.page3.back(false);
                EMLearningWizard.this.currentPanel = EMLearningWizard.this.page3.getPrevious();
                EMLearningWizard.this.activeStep = EMLearningWizard.this.currentPanel == EMLearningWizard.this.page2 ? 1 : 0;
                EMLearningWizard.this.status.setActiveStep(EMLearningWizard.this.activeStep);
                EMLearningWizard.this.currentPanel.setStatus(EMLearningWizard.this.status);
                EMLearningWizard.this.getContentPane().invalidate();
                EMLearningWizard.this.getContentPane().removeAll();
                EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page3.getPrevious());
                EMLearningWizard.this.validate();
                EMLearningWizard.this.repaint();
            }
        });
        jButtonArray[2] = new JButton("Next >");
        jButtonArray[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Domain domain = EMLearningWizard.this.dataStream.getCaseTemplate().getDomain();
                    EMLearningWizard.this.page3.insertCases();
                    EMLearningWizard.this.page4 = EMLearningWizard.this.getPriorDistributionsPanel(domain);
                    EMLearningWizard.this.currentPanel = EMLearningWizard.this.page4;
                    EMLearningWizard.this.page4.setPrevious(EMLearningWizard.this.page3);
                    EMLearningWizard.this.page4.setStatus(EMLearningWizard.this.status);
                    EMLearningWizard.this.status.setActiveStep(++EMLearningWizard.this.activeStep);
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page4);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
                catch (ExceptionMemory exceptionMemory) {
                    new HuginGUIError(exceptionMemory.getMessage());
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page3);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
                catch (DataSourceException dataSourceException) {
                    new HuginGUIError(dataSourceException.getMessage());
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page3);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
                catch (PreProcessingException preProcessingException) {
                    new HuginGUIError(preProcessingException.getMessage());
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page3);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page3);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
            }
        });
        jButtonArray[3] = new JButton("Cancel");
        jButtonArray[3].addActionListener(new CancelListener());
        return new DataPreprocessingPanel(jButtonArray, 2, false);
    }

    private PriorDistributionsPanel getPriorDistributionsPanel(final Domain domain) {
        JButton[] jButtonArray = new JButton[4];
        jButtonArray[0] = new JButton("Help");
        jButtonArray[0].addActionListener(new HelpListener("help/priorDistributionsHelp.html"));
        jButtonArray[0].setEnabled(true);
        jButtonArray[1] = new JButton("< Back");
        jButtonArray[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EMLearningWizard.this.page4.back();
                EMLearningWizard.this.currentPanel = EMLearningWizard.this.page4.getPrevious();
                --EMLearningWizard.this.activeStep;
                EMLearningWizard.this.status.setActiveStep(EMLearningWizard.this.activeStep);
                EMLearningWizard.this.currentPanel.setStatus(EMLearningWizard.this.status);
                EMLearningWizard.this.getContentPane().invalidate();
                EMLearningWizard.this.getContentPane().removeAll();
                EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page4.getPrevious());
                PriorDistributionsPanel.updateGuiAndDomainTables(domain);
                EMLearningWizard.this.validate();
                EMLearningWizard.this.repaint();
            }
        });
        jButtonArray[2] = new JButton("Next >");
        jButtonArray[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EMLearningWizard.this.page5 = EMLearningWizard.this.getEMLearningPanel(EMLearningWizard.this.page4.getDomain());
                EMLearningWizard.this.currentPanel = EMLearningWizard.this.page5;
                EMLearningWizard.this.page5.setPrevious(EMLearningWizard.this.page4);
                EMLearningWizard.this.page5.setStatus(EMLearningWizard.this.status);
                EMLearningWizard.this.status.setActiveStep(++EMLearningWizard.this.activeStep);
                EMLearningWizard.this.getContentPane().removeAll();
                EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page5);
                PriorDistributionsPanel.updateGuiAndDomainTables(domain);
                EMLearningWizard.this.validate();
                EMLearningWizard.this.repaint();
            }
        });
        jButtonArray[3] = new JButton("Cancel");
        jButtonArray[3].addActionListener(new CancelListener());
        jButtonArray[3].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PriorDistributionsPanel.updateGuiAndDomainTables(domain);
            }
        });
        return new PriorDistributionsPanel(domain, jButtonArray);
    }

    private EMLearningPanel getEMLearningPanel(Domain domain) {
        JButton[] jButtonArray = new JButton[4];
        jButtonArray[0] = new JButton("Help");
        jButtonArray[0].setEnabled(true);
        jButtonArray[0].addActionListener(new HelpListener("help/emLearningHelp.html"));
        jButtonArray[1] = new JButton("< Back");
        jButtonArray[1].setEnabled(false);
        jButtonArray[2] = new JButton(HuginGUIConstants.get("str_perform_em_learning"));
        jButtonArray[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    EMLearningWizard.this.page5.learnTables();
                    EMLearningWizard.this.wasDomain = true;
                    EMLearningWizard.this.finished = true;
                    ((JButton)actionEvent.getSource()).setEnabled(false);
                }
                catch (ExceptionUsage exceptionUsage) {
                    exceptionUsage.printStackTrace();
                    EMLearningWizard.this.finished = true;
                    EMLearningWizard.this.dispose();
                }
                catch (ExceptionInconsistencyOrUnderflow exceptionInconsistencyOrUnderflow) {
                    new HuginGUIError(exceptionInconsistencyOrUnderflow.getMessage());
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page5);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
                catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page5);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
                catch (ExceptionInvalidProbabilityPotential exceptionInvalidProbabilityPotential) {
                    new HuginGUIError(exceptionInvalidProbabilityPotential.getMessage());
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page5);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
                catch (ExceptionLowDensity exceptionLowDensity) {
                    new HuginGUIError(exceptionLowDensity.getMessage());
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page5);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
                catch (ExceptionMemory exceptionMemory) {
                    new HuginGUIError(exceptionMemory.getMessage());
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page5);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                    EMLearningWizard.this.getContentPane().invalidate();
                    EMLearningWizard.this.getContentPane().removeAll();
                    EMLearningWizard.this.getContentPane().add(EMLearningWizard.this.page5);
                    EMLearningWizard.this.validate();
                    EMLearningWizard.this.repaint();
                }
            }
        });
        jButtonArray[3] = new JButton(HuginGUIConstants.get("str_done"));
        jButtonArray[3].addActionListener(new CancelListener());
        return new EMLearningPanel(domain, jButtonArray, 2, this.dataStream.getMissingValuesCount());
    }

    protected static boolean unresolvedLinks(Domain domain) throws ExceptionUsage {
        try {
            ListIterator listIterator = domain.getNodes().listIterator();
            while (listIterator.hasNext()) {
                Node node = (Node)listIterator.next();
                if (node.getPdagNeighbors().size() <= 0 && domain.getAmbiguousRegions().size() <= 0) continue;
                return true;
            }
        }
        catch (ExceptionUsage exceptionUsage) {
            throw exceptionUsage;
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return false;
        }
        return false;
    }

    private boolean dontProceed(long l) {
        int n = JOptionPane.showConfirmDialog(this, "This model is very large (sum of sizes of CPTs will be " + l + ").\nMemory will be allocated for all CPTs if you proceed to the next stage.\n\nDo you really wish to proceed?", "Confirm CPT Creation", 0);
        return n == 1;
    }

    private class WizardKeyListener
    extends KeyAdapter {
        private int pressedEvent = 0;

        private WizardKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.pressedEvent = keyEvent.getKeyCode();
            if (EMLearningWizard.this.currentPanel != null) {
                EMLearningWizard.this.currentPanel.receiveKeyEvent(keyEvent);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() != this.pressedEvent && EMLearningWizard.this.currentPanel != null) {
                EMLearningWizard.this.currentPanel.receiveKeyEvent(keyEvent);
            }
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (EMLearningWizard.this.dataStream != null && EMLearningWizard.this.dataStream.getCaseTemplate() != null && !EMLearningWizard.this.wasDomain) {
                    EMLearningWizard.this.dataStream.getCaseTemplate().getDomain().delete();
                }
            }
            catch (ExceptionObjectNotAlive exceptionObjectNotAlive) {
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(exceptionHugin);
            }
            EMLearningWizard.this.dispose();
        }
    }

    private class HelpListener
    implements ActionListener {
        String helpPage;

        public HelpListener(String string) {
            this.helpPage = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EMLearningWizard.this.helpPanel.setHelpPage(this.helpPage);
            if (!EMLearningWizard.this.helpPanel.isVisible()) {
                int n = EMLearningWizard.this.getX() - EMLearningWizard.this.helpPanel.getWidth();
                if (n < 5 && (n = EMLearningWizard.this.getX() + EMLearningWizard.this.getWidth()) + EMLearningWizard.this.helpPanel.getWidth() > Toolkit.getDefaultToolkit().getScreenSize().width - 5) {
                    n = 5;
                }
                EMLearningWizard.this.helpPanel.setLocation(n, EMLearningWizard.this.getY());
                EMLearningWizard.this.helpPanel.setVisible(true);
            }
        }
    }

    private class ResizedListener
    extends ComponentAdapter {
        EMLearningWizard frame;

        public ResizedListener(EMLearningWizard eMLearningWizard2) {
            this.frame = eMLearningWizard2;
        }

        public void componentResized(ComponentEvent componentEvent) {
            int n = this.frame.getWidth();
            int n2 = this.frame.getHeight();
            boolean bl = false;
            if (n < 620) {
                n = 620;
                bl = true;
            }
            if (n2 < 550) {
                n2 = 550;
                bl = true;
            }
            if (bl) {
                this.frame.setSize(n, n2);
            }
        }
    }
}

