/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.ExceptionComputationFailed;
import COM.hugin.HAPI.ExceptionDivisionByZero;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionInappropriateArguments;
import COM.hugin.HAPI.ExceptionInsufficientStateRange;
import COM.hugin.HAPI.ExceptionInvalidExpression;
import COM.hugin.HAPI.ExceptionInvalidStateValues;
import COM.hugin.HAPI.ExceptionSyntax;
import COM.hugin.HAPI.Expression;
import COM.hugin.HAPI.Model;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.DiscreteChanceNodeTableModel;
import COM.hugin.HGUI.ExpressionBuilderPanel;
import COM.hugin.HGUI.ExpressionTable;
import COM.hugin.HGUI.ExpressionTableColumnModel;
import COM.hugin.HGUI.ExpressionTableModel;
import COM.hugin.HGUI.GenericTable;
import COM.hugin.HGUI.GraphicTable;
import COM.hugin.HGUI.HelpPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginComboBox;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginInsets;
import COM.hugin.HGUI.ModeGraphicTable;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NodeTable;
import COM.hugin.HGUI.NodeTableFrameInterface;
import COM.hugin.HGUI.ParentInserterField;
import COM.hugin.HGUI.TableWrapper;
import COM.hugin.HGUI.TitledPanel;
import COM.hugin.HGUI.UtilityNode;
import COM.hugin.HGUI.UtilityNodeTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExpressionBuilderWizard
extends JDialog {
    public static final int BLANK_MODE = -2;
    public static final int FROM_NODE_MODE = -1;
    private LinkedList<ExpressionBuilderPanel> steps;
    private int editingRow;
    private int editingColumn;
    private JPanel mainPanel;
    private JPanel tablePanel;
    private JPanel choisePanel;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JPanel expressionFieldPanel;
    private HelpPanel helpPanel;
    private JPanel expressionPanel;
    private JSplitPane splitPanel;
    private JScrollPane tableScrollPane;
    private JButton backButton;
    private JButton manualButton;
    private JButton buildButton;
    private JButton cancelButton;
    private JButton helpButton;
    private JButton showAsTableButton;
    private JButton transferButton;
    private JButton expandButton;
    private JComboBox typeCombo;
    private JComboBox barModeCombo;
    private HuginComboBox addNodeCombo;
    private HuginComboBox removeNodeCombo;
    private JLabel addNodeLabel;
    private JLabel removeNodeLabel;
    private JLabel typeLabe;
    private JLabel expressionLabel;
    private JLabel samplesLabel;
    private JLabel barModeLabel;
    private ParentInserterField expressionField;
    private JSpinner samplesSpinner;
    private Container contentPane;
    protected Cursor selectCursor;
    protected Cursor defaultCursor;
    private String selectText = HuginGUIConstants.get("EBW_Select_To_Build");
    private NodeTable table;
    private NodeTable originalTable;
    private GraphicTable graphicTable;
    private NodeList parents;
    private ExpressionTable expressionTable;
    private ExpressionTable et;
    private NodeTableFrameInterface frameTable;
    private Node node;
    private Node originalNode;
    private COM.hugin.HAPI.Node apiNode;
    private Expression expression;
    private HuginGUIFrame guiFrame;
    private ExpressionBuilderPanel builder;
    private ExpressionBuilderWizard ebw;
    private ExpressionViewer expandedField;
    private int apiColumn;

    public ExpressionBuilderWizard(HuginGUIFrame huginGUIFrame, NodeTableFrameInterface nodeTableFrameInterface, Node node, Expression expression) throws ExceptionHugin {
        super(Hugin.mainFrame, HuginGUIUtils.getNodeTitle(node.getAPINode()), true);
        this.guiFrame = huginGUIFrame;
        this.node = node;
        this.ebw = this;
        this.apiNode = node.getAPINode();
        try {
            this.parents = this.apiNode.getParents();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.createCursors();
        this.contentPane = this.getContentPane();
        this.expression = expression;
        if (this.apiNode instanceof DiscreteChanceNode) {
            this.graphicTable = new GraphicTable(node);
        }
        this.table = new NodeTable(node);
        this.table.setEditable(false);
        this.frameTable = nodeTableFrameInterface;
        this.expressionTable = this.frameTable.getTable().getExpressionTable();
        this.et = this.table.getExpressionTable();
        CellSelectionListener cellSelectionListener = new CellSelectionListener(this.et);
        ListSelectionModel listSelectionModel = this.et.getSelectionModel();
        this.et.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(cellSelectionListener);
        this.et.addMouseListener(new PointingListener());
        this.et.addMouseMotionListener(new ExpressionMotionListener());
        this.et.setToolTipText(this.selectText);
        this.expressionFieldPanel = new JPanel(new BorderLayout());
        this.expressionField = new ParentInserterField(40);
        this.expressionField.setToolTipText(this.expressionField.getText());
        this.expressionField.setEditable(false);
        this.expressionField.setBackground(Color.YELLOW);
        this.expandButton = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/plus.gif")));
        this.expandButton.setMargin(new HuginInsets());
        this.expandButton.setToolTipText(HuginGUIConstants.get("EBW_Open_Expression_Viewer"));
        this.expandButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionBuilderWizard.this.expandedField = new ExpressionViewer(ExpressionBuilderWizard.this.ebw, HuginGUIConstants.get("EBW_Expression_Viewer"), false, ExpressionBuilderWizard.this.expressionField);
                ExpressionBuilderWizard.this.expandButton.setEnabled(false);
            }
        });
        this.expressionLabel = new JLabel(HuginGUIConstants.get("EBW_BUTTON_Fx"));
        this.expressionFieldPanel.add((Component)this.expressionField, "Center");
        this.expressionFieldPanel.add((Component)this.expandButton, "East");
        this.helpPanel = new HelpPanel(this);
        this.mainPanel = new JPanel(new GridLayout(1, 1));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        this.splitPanel = new JSplitPane(1);
        this.createChoisePanel();
        this.createExpressionPanel(-2, null);
        this.createTablePanel();
        this.createButtonPanel();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        TitledPanel titledPanel = new TitledPanel(HuginGUIConstants.get("EBW_TITLE_Options"));
        titledPanel.add(this.choisePanel);
        jPanel2.add((Component)titledPanel, "West");
        jPanel2.add((Component)this.expressionPanel, "Center");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
        jPanel3.add(this.buttonPanel);
        this.bottomPanel = new JPanel(new BorderLayout());
        this.bottomPanel.setBorder(BorderFactory.createEtchedBorder());
        this.bottomPanel.add((Component)this.tablePanel, "Center");
        this.bottomPanel.add((Component)jPanel3, "South");
        jPanel.add((Component)this.bottomPanel, "Center");
        this.mainPanel.add(jPanel);
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(this.mainPanel);
        this.pack();
        HuginGUIUtils.centerComponent(Hugin.mainFrame, (Window)this);
        this.setDefaultCloseOperation(2);
        this.addComponentListener(new ResizedListener(this));
        this.setVisible(true);
        this.setResizable(true);
    }

    private void createCursors() {
        Toolkit toolkit = this.getToolkit();
        Point point = HuginGUIConstants.SELECT_CURSOR_HOTSPOT;
        Image image = HuginGUIConstants.SELECT_CURSOR_IMAGE;
        this.selectCursor = toolkit.createCustomCursor(image, point, "SELECT Cursor");
        this.defaultCursor = Cursor.getDefaultCursor();
    }

    private void createChoisePanel() {
        String[] stringArray;
        this.choisePanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.addNodeLabel = new JLabel(HuginGUIConstants.get("EBW_LABEL_Add_Model_Node"));
        this.addNodeLabel.setAlignmentX(1.0f);
        this.addNodeCombo = new HuginComboBox();
        this.addNodeCombo.setBackground(Color.WHITE);
        this.addNodeCombo.addActionListener(new AddListener(this.table, this.frameTable, this.node.getAPINode()));
        this.removeNodeLabel = new JLabel(HuginGUIConstants.get("EBW_LABEL_Remove_Model_Node"));
        this.removeNodeLabel.setAlignmentX(1.0f);
        this.removeNodeCombo = new HuginComboBox();
        this.removeNodeCombo.setBackground(Color.WHITE);
        this.removeNodeCombo.addActionListener(new RemoveListener(this.table, this.frameTable, this.node.getAPINode()));
        try {
            this.populateAddNodeCombo();
            this.populateRemoveNodeCombo();
            this.addNodeCombo.setPreferredSize(new Dimension(100, this.addNodeCombo.getPreferredSize().height));
            this.removeNodeCombo.setPreferredSize(new Dimension(100, this.removeNodeCombo.getPreferredSize().height));
            stringArray = this.table.getNode().getModel();
            this.samplesLabel = new JLabel(HuginGUIConstants.get("EBW_LABEL_Samples_Interval"));
            this.samplesSpinner = new JSpinner(new SpinnerNumberModel(stringArray.getNumberOfSamplesPerInterval(), 1, Integer.MAX_VALUE, 1));
            this.samplesSpinner.addChangeListener(new SamplesPerIntervalListener());
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.showAsTableButton = new JButton(HuginGUIConstants.get("EBW_LABEL_Show_As_Table"));
        this.showAsTableButton.addActionListener(new ShowAsTableListener());
        this.transferButton = new JButton(HuginGUIConstants.get("EBW_LABEL_Transfer_To_Table"));
        this.transferButton.addActionListener(new TransferToTableListener());
        this.barModeLabel = new JLabel(HuginGUIConstants.get("VIEW"));
        this.barModeLabel.setAlignmentX(1.0f);
        stringArray = new String[]{HuginGUIConstants.get("EBW_BUTTON_Normal_Mode"), HuginGUIConstants.get("EBW_BUTTON_Bar_Mode"), HuginGUIConstants.get("EBW_BUTTON_Pure_Bar_Mode")};
        this.barModeCombo = new JComboBox<String>(stringArray);
        this.barModeCombo.setBackground(Color.WHITE);
        this.barModeCombo.addActionListener(new BarModeListener());
        if (this.apiNode instanceof DiscreteChanceNode) {
            this.barModeCombo.setEnabled(true);
        } else {
            this.barModeCombo.setEnabled(false);
        }
        jPanel2.add(this.addNodeLabel);
        jPanel2.add(this.addNodeCombo);
        jPanel.add(Box.createRigidArea(new Dimension(1, 5)));
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.add(this.removeNodeLabel);
        jPanel2.add(this.removeNodeCombo);
        jPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.add(this.barModeLabel);
        jPanel2.add(this.barModeCombo);
        jPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.add(this.samplesLabel);
        jPanel2.add(this.samplesSpinner);
        jPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new GridLayout(1, 1));
        jPanel2.add(this.showAsTableButton);
        jPanel.add(Box.createRigidArea(new Dimension(1, 15)));
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new GridLayout(1, 1));
        jPanel2.add(this.transferButton);
        jPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel.add(jPanel2);
        this.choisePanel.add((Component)jPanel, "West");
    }

    private void createExpressionPanel(int n, Expression expression) {
        int n2 = n;
        Expression expression2 = expression;
        if (n2 == -2) {
            this.createBlankPanel();
            return;
        }
        if (this.builder == null) {
            this.steps = new LinkedList();
        } else {
            Expression expression3 = this.builder.getExpression();
            this.steps.add(this.builder);
        }
        this.builder = new ExpressionBuilderPanel(this.guiFrame, this.node, expression2, n2, HuginGUIConstants.get("EBW_TITLE_Function") + ": " + (this.steps.size() + 1));
        this.builder.addFunctionListener(new FunctionListener());
        this.builder.addBackListener(new BackListener());
        this.builder.addOkListener(new OkListener());
        this.builder.addExpressionListener(new ExpressionChangeListener());
        this.builder.addApplyListener(new ApplyListener());
        this.updateExpressionPanel(this.builder);
    }

    private void createBlankPanel() {
        if (this.expressionPanel == null) {
            this.expressionPanel = new JPanel(new GridLayout(1, 1));
        } else {
            this.expressionPanel.removeAll();
        }
        this.builder = null;
        this.expressionField.setText("");
        this.expressionField.setToolTipText("");
        this.expressionPanel.add(this.getBlankPanel());
        this.expressionPanel.setVisible(true);
        this.expressionPanel.repaint();
        this.expressionPanel.validate();
        this.validate();
    }

    private JPanel getBlankPanel() {
        Object object;
        JLabel jLabel = new JLabel("", 0);
        try {
            object = this.getEmptyPanelContent(HuginGUIConstants.get("EBW_TITLE_EBP"), HuginGUIUtils.getNodeTitle(this.apiNode), HuginGUIConstants.get("EBW_MSG_Click"));
            jLabel = new JLabel((String)object, 0);
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
        object = new JPanel(new BorderLayout());
        ((JComponent)object).setPreferredSize(new Dimension(500, 470));
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("EBW_TITLE_EBP")));
        ((Container)object).add((Component)jLabel, "Center");
        return object;
    }

    private void updateExpressionPanel(ExpressionBuilderPanel expressionBuilderPanel) {
        this.expressionPanel.removeAll();
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)expressionBuilderPanel, "North");
        jPanel.add((Component)jPanel2, "North");
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.expressionFieldPanel, "North");
        jPanel.add((Component)jPanel2, "Center");
        this.expressionPanel.add(jPanel);
        if (this.builder != null) {
            this.builder.notifyExpressionListener();
        }
        this.expressionPanel.setVisible(true);
        this.expressionPanel.repaint();
        this.expressionPanel.validate();
        this.validate();
    }

    private void createTablePanel() {
        try {
            if (this.apiNode instanceof DiscreteChanceNode && !((DiscreteChanceNodeTableModel)this.frameTable.getTable().getTable().getModel()).getInvalidTable()) {
                this.table.generateTable();
            }
            if (this.apiNode instanceof COM.hugin.HAPI.UtilityNode && !((UtilityNodeTableModel)this.frameTable.getTable().getTable().getModel()).getInvalidTable()) {
                this.table.generateTable();
            }
            this.tablePanel = new JPanel(new GridLayout(1, 1));
            JPanel jPanel = new JPanel(new BorderLayout());
            Border border = BorderFactory.createEtchedBorder(Color.BLACK, Color.GRAY);
            ModeGraphicTable modeGraphicTable = new ModeGraphicTable(this.node, 1, (GenericTable)this.table.getTable());
            TableWrapper tableWrapper = new TableWrapper(this.table, this.table, modeGraphicTable);
            tableWrapper.wrapInScrollPane();
            tableWrapper.setPreferredSize(new Dimension(500, 150));
            jPanel.add(tableWrapper);
            this.tableScrollPane = new JScrollPane(jPanel);
            this.tableScrollPane.setPreferredSize(new Dimension(450, 100));
            try {
                tableWrapper.contents.setDividerLocation(150);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tablePanel.add(jPanel);
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel(new BorderLayout(5, 5));
        this.helpButton = new JButton(HuginGUIConstants.get("EBW_BUTTON_Help"));
        this.helpButton.addActionListener(new HelpListener("help/ExpressionBuilderWizard.html"));
        this.cancelButton = new JButton(HuginGUIConstants.get("EBW_BUTTON_Close"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ExpressionBuilderWizard.this.dispose();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createRigidArea(new Dimension(10, 5)));
        jPanel.add(this.helpButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.cancelButton);
        jPanel2.add(Box.createRigidArea(new Dimension(10, 5)));
        this.buttonPanel.add((Component)jPanel, "West");
        this.buttonPanel.add((Component)jPanel2, "East");
    }

    private void setEnableLeftBottom(boolean bl) {
        this.transferButton.setEnabled(bl);
        this.addNodeCombo.setEnabled(bl);
        this.removeNodeCombo.setEnabled(bl);
        this.samplesSpinner.setEnabled(bl);
        this.et.setEnabled(bl);
        this.table.setEnabled(bl);
        if (!this.et.isEnabled()) {
            this.setCursor(this.defaultCursor);
            this.et.setToolTipText(null);
        } else {
            this.et.setToolTipText(this.selectText);
        }
    }

    private void populateAddNodeCombo() throws ExceptionHugin {
        if (this.addNodeCombo == null) {
            return;
        }
        NodeList nodeList = this.node.getAPINode().getParents();
        Model model = null;
        if (this.table.canShowExpressions()) {
            model = this.node.getAPINode().getModel();
        }
        if (model == null) {
            return;
        }
        NodeList nodeList2 = model.getNodes();
        boolean bl = false;
        this.addNodeCombo.removeAllItems();
        this.addNodeCombo.addItem(HuginGUIConstants.get("EBW_ITEM_Select"));
        ListIterator listIterator = nodeList.listIterator();
        while (listIterator.hasNext()) {
            COM.hugin.HAPI.Node node = (COM.hugin.HAPI.Node)listIterator.next();
            if (!(node instanceof DiscreteChanceNode) && !(node instanceof DiscreteDecisionNode) || nodeList2.contains(node)) continue;
            this.addNodeCombo.addItem(HuginGUIUtils.getNodeTitle(node));
            bl = true;
        }
        if (!bl) {
            this.addNodeCombo.removeAllItems();
            this.addNodeCombo.addItem(HuginGUIConstants.get("EBW_ITEM_Not_Available"));
        }
        this.addNodeCombo.validatePopupWidth();
        this.validate();
    }

    private void populateRemoveNodeCombo() throws ExceptionHugin {
        if (this.removeNodeCombo == null) {
            return;
        }
        Model model = null;
        if (this.table.canShowExpressions()) {
            model = this.node.getAPINode().getModel();
        }
        if (model == null) {
            return;
        }
        NodeList nodeList = model.getNodes();
        boolean bl = false;
        this.removeNodeCombo.removeAllItems();
        this.removeNodeCombo.addItem(HuginGUIConstants.get("EBW_ITEM_Select"));
        ListIterator listIterator = nodeList.listIterator();
        while (listIterator.hasNext()) {
            COM.hugin.HAPI.Node node = (COM.hugin.HAPI.Node)listIterator.next();
            this.removeNodeCombo.addItem(HuginGUIUtils.getNodeTitle(node));
            bl = true;
        }
        if (!bl) {
            this.removeNodeCombo.removeAllItems();
            this.removeNodeCombo.addItem(HuginGUIConstants.get("EBW_ITEM_Not_Available"));
        }
        this.removeNodeCombo.validatePopupWidth();
        this.validate();
    }

    public Expression getExpression() throws ExceptionHugin {
        Expression expression = null;
        try {
            expression = this.apiNode.getModel().getExpression(this.apiColumn);
        }
        catch (ExceptionSyntax exceptionSyntax) {
            // empty catch block
        }
        return expression;
    }

    private void setExpression(Expression expression) throws ExceptionHugin {
        Expression expression2 = expression;
        this.apiNode.getModel().setExpression(this.apiColumn, expression);
    }

    private void setExpression(String string) {
        try {
            this.apiNode.getModel().setExpression(this.apiColumn, string, null);
        }
        catch (Exception exception) {
            System.out.println("Exception in setExpression " + exception.getMessage());
        }
    }

    private String getEmptyPanelContent(String string, String string2, String string3) {
        return "<html><head><title>" + string + "</title>" + "<style type=\"text/css\">" + ".style1" + "{" + "text-align: center;" + "font-family: \"Dialog\";" + "}" + ".style2" + "    {" + " text-align: center;" + "font-family: \"Dialog\";" + "font-size: x-large;" + "}" + "</style>" + "     </head>" + "    <body>" + "" + "  <p class=\"style2\">" + string + "</p>" + "<p class=\"style1\">" + "&nbsp;</p>" + "\t  <p class=\"style1\">" + string2 + "<br>" + string3 + "</p>" + " " + "</body>" + "</html>";
    }

    public class ExpressionMotionListener
    implements MouseMotionListener {
        public void mouseMoved(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof GenericTable) {
                GenericTable genericTable = (GenericTable)object;
                if (genericTable.columnAtPoint(mouseEvent.getPoint()) != -1 && genericTable.isEnabled()) {
                    ExpressionBuilderWizard.this.setCursor(ExpressionBuilderWizard.this.selectCursor);
                } else {
                    ExpressionBuilderWizard.this.setCursor(ExpressionBuilderWizard.this.defaultCursor);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }

    public class PointingListener
    implements MouseListener {
        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            GenericTable genericTable;
            Object object = mouseEvent.getSource();
            if (object instanceof GenericTable && (genericTable = (GenericTable)object).columnAtPoint(mouseEvent.getPoint()) != -1 && genericTable.isEnabled()) {
                ExpressionBuilderWizard.this.setCursor(ExpressionBuilderWizard.this.selectCursor);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            GenericTable genericTable;
            Object object = mouseEvent.getSource();
            if (object instanceof GenericTable && (genericTable = (GenericTable)object).columnAtPoint(mouseEvent.getPoint()) != -1) {
                ExpressionBuilderWizard.this.setCursor(ExpressionBuilderWizard.this.defaultCursor);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }
    }

    public class ExpressionViewer
    extends JDialog {
        private JDialog parentDialog;
        private ParentInserterField field;
        private JEditorPane textArea;
        int fontSize;
        private JScrollPane scrollPane;
        private JButton closeButton;
        private JButton largerButton;
        private JButton smallerButton;

        public ExpressionViewer(JDialog jDialog, String string, boolean bl, ParentInserterField parentInserterField) {
            super(jDialog, string, bl);
            this.fontSize = 12;
            this.parentDialog = jDialog;
            this.field = parentInserterField;
            this.setResizable(true);
            Point point = parentInserterField.getLocationOnScreen();
            this.setLocation(point.x, point.y + parentInserterField.getHeight());
            this.setContentPane(this.createContent());
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new CloseListener());
            this.pack();
            this.setVisible(true);
        }

        private JPanel createContent() {
            JPanel jPanel = new JPanel(new GridLayout(1, 1));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            EmptyBorder emptyBorder = new EmptyBorder(new Insets(5, 5, 5, 5));
            jPanel2.setBorder(emptyBorder);
            JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
            jPanel3.setBorder(BorderFactory.createEtchedBorder());
            jPanel.setPreferredSize(new Dimension(500, 100));
            this.textArea = new JEditorPane("text/html", "");
            this.textArea.setEditable(false);
            this.scrollPane = new JScrollPane(this.textArea);
            Dimension dimension = this.scrollPane.getViewport().getSize();
            jPanel3.add(this.scrollPane);
            jPanel2.add((Component)jPanel3, "Center");
            if (this.field.hasToolTipSelection()) {
                this.refresh(this.field.getText(), this.field.getToolTipSelectionStart(), this.field.getToolTipSelectionEnd());
            } else {
                this.refresh(this.field.getText(), 0, 0);
            }
            this.closeButton = new JButton(HuginGUIConstants.get("EBW_BUTTON_Close"));
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ExpressionBuilderWizard.this.expandButton.setEnabled(true);
                        ExpressionViewer.this.dispose();
                        ExpressionBuilderWizard.this.expandedField = null;
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                }
            });
            this.largerButton = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/plus.gif")));
            this.largerButton.setMargin(new HuginInsets());
            this.largerButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExpressionViewer.this.fontSize < 28) {
                        ++ExpressionViewer.this.fontSize;
                        ExpressionViewer.this.refresh();
                    }
                }
            });
            this.smallerButton = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/minus.gif")));
            this.smallerButton.setMargin(new HuginInsets());
            this.smallerButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExpressionViewer.this.fontSize > 8) {
                        --ExpressionViewer.this.fontSize;
                        ExpressionViewer.this.refresh();
                    }
                }
            });
            JPanel jPanel4 = new JPanel(new GridLayout(1, 2));
            jPanel4.add(this.smallerButton);
            jPanel4.add(this.largerButton);
            JPanel jPanel5 = new JPanel(new BorderLayout());
            jPanel5.add((Component)new JSeparator(), "North");
            jPanel5.add((Component)jPanel4, "West");
            jPanel5.add((Component)this.closeButton, "East");
            jPanel2.add((Component)jPanel5, "South");
            jPanel.add(jPanel2);
            return jPanel;
        }

        public void refresh(String string, int n, int n2) {
            String string2 = this.formatText(string, n, n2);
            this.textArea.setText(string2);
        }

        public void refresh() {
            if (this.field != null) {
                if (this.field.hasToolTipSelection()) {
                    this.refresh(this.field.getText(), this.field.getToolTipSelectionStart(), this.field.getToolTipSelectionEnd());
                } else {
                    this.refresh(this.field.getText(), 0, 0);
                }
            }
        }

        private String formatText(String string, int n, int n2) {
            String string2 = "";
            String string3 = this.getFont().getName();
            try {
                String string4 = string.substring(0, n);
                String string5 = string.substring(n, n2);
                String string6 = string.substring(n2, string.length());
                string2 = "<html><style type=\"text/css\">.style1{font-family: \"" + string3 + "\";" + "font-size: \"" + this.fontSize + "pt\";" + "}" + "<body class=\"style1\">" + "" + string4 + "<B><font: color = \"#1e90ff\">" + string5 + "</font></B>" + string6 + "</body></html>";
            }
            catch (Exception exception) {
                string2 = "<html><style type=\"text/css\">.style1{font-family: \"" + string3 + "\";" + "font-size: \"" + this.fontSize + "pt\";" + "}" + "<body class=\"style1\">" + "" + string + "</body></html>";
            }
            return string2;
        }

        private class CloseListener
        implements WindowListener {
            public void windowActivated(WindowEvent windowEvent) {
            }

            public void windowClosing(WindowEvent windowEvent) {
            }

            public void windowDeactivated(WindowEvent windowEvent) {
            }

            public void windowDeiconified(WindowEvent windowEvent) {
            }

            public void windowIconified(WindowEvent windowEvent) {
            }

            public void windowOpened(WindowEvent windowEvent) {
            }

            public void windowClosed(WindowEvent windowEvent) {
                ExpressionBuilderWizard.this.expandButton.setEnabled(true);
                ExpressionBuilderWizard.this.expandedField = null;
            }
        }
    }

    private class ResizedListener
    extends ComponentAdapter {
        ExpressionBuilderWizard frame;

        public ResizedListener(ExpressionBuilderWizard expressionBuilderWizard2) {
            this.frame = expressionBuilderWizard2;
        }

        public void componentResized(ComponentEvent componentEvent) {
            int n = this.frame.getWidth();
            int n2 = this.frame.getHeight();
            boolean bl = false;
            if (n < 620) {
                n = 620;
                bl = true;
            }
            if (n2 < 550) {
                n2 = 550;
                bl = true;
            }
            if (bl) {
                this.frame.setSize(n, n2);
            }
        }
    }

    private class ExpressionChangeListener
    implements ChangeListener {
        private ExpressionChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            String string = "";
            String string2 = "";
            if (ExpressionBuilderWizard.this.steps.size() >= 0 && ExpressionBuilderWizard.this.builder != null) {
                int n;
                String[] stringArray;
                int n2;
                string = ExpressionBuilderWizard.this.builder.getStringExpression();
                string = string2 = "#" + string;
                for (n2 = ExpressionBuilderWizard.this.steps.size() - 1; n2 >= 0; --n2) {
                    stringArray = (String[])ExpressionBuilderWizard.this.steps.get(n2);
                    string = n2 == ExpressionBuilderWizard.this.steps.size() - 1 ? stringArray.getStringExpression(string2) : stringArray.getStringExpression(string);
                }
                n2 = string.indexOf(string2);
                string2 = string2.substring(1);
                stringArray = string.split("#");
                string = "";
                for (n = 0; n < stringArray.length; ++n) {
                    string = string + stringArray[n];
                }
                n = string2.length();
                int n3 = n2 + n;
                ExpressionBuilderWizard.this.expressionField.setText(string);
                ExpressionBuilderWizard.this.expressionField.setToolTipSelection(n2, n3);
                ExpressionBuilderWizard.this.expressionField.setToolTipSelectionColor(new Color(30, 144, 255));
                ExpressionBuilderWizard.this.expressionField.setToolTipText(ExpressionBuilderWizard.this.expressionField.getText());
                ExpressionBuilderWizard.this.expressionField.requestFocus(true);
                ExpressionBuilderWizard.this.expressionField.setSelectionStart(n2);
                ExpressionBuilderWizard.this.expressionField.setSelectionEnd(n3);
                ExpressionBuilderWizard.this.expressionField.setSelectedTextColor(Color.RED);
                if (ExpressionBuilderWizard.this.expandedField != null) {
                    ExpressionBuilderWizard.this.expandedField.refresh();
                }
                ExpressionBuilderWizard.this.builder.setActiveTextFocus(true);
            } else if (ExpressionBuilderWizard.this.expandedField != null) {
                ExpressionBuilderWizard.this.expandedField.dispose();
                ExpressionBuilderWizard.this.expandedField = null;
            }
        }
    }

    private class SamplesPerIntervalListener
    implements ChangeListener {
        Model model;

        public void stateChanged(ChangeEvent changeEvent) {
            try {
                this.model = ExpressionBuilderWizard.this.table.getNode().getModel();
                this.model.setNumberOfSamplesPerInterval((Integer)ExpressionBuilderWizard.this.samplesSpinner.getValue());
                Hugin.mainFrame.getStatusBar().write(HuginGUIConstants.get("SAMPLES_PER_INTERVAL_Applied") + ExpressionBuilderWizard.this.samplesSpinner.getValue());
            }
            catch (Exception exception) {
                new HuginGUIError(HuginGUIConstants.get("str_unable_to_set_samples_interval_") + exception.getMessage());
            }
        }
    }

    private class HelpListener
    implements ActionListener {
        String helpPage;

        public HelpListener(String string) {
            this.helpPage = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExpressionBuilderWizard.this.helpPanel.setHelpPage(this.helpPage);
            if (!ExpressionBuilderWizard.this.helpPanel.isVisible()) {
                int n = ExpressionBuilderWizard.this.getX() - ExpressionBuilderWizard.this.helpPanel.getWidth();
                if (n < 5 && (n = ExpressionBuilderWizard.this.getX() + ExpressionBuilderWizard.this.getWidth()) + ExpressionBuilderWizard.this.helpPanel.getWidth() > Toolkit.getDefaultToolkit().getScreenSize().width - 5) {
                    n = 5;
                }
                ExpressionBuilderWizard.this.helpPanel.setLocation(n, ExpressionBuilderWizard.this.getY());
                ExpressionBuilderWizard.this.helpPanel.setVisible(true);
            }
        }
    }

    public class CellSelectionListener
    implements ListSelectionListener {
        ExpressionTable exTable;

        CellSelectionListener(ExpressionTable expressionTable) {
            this.exTable = expressionTable;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!((ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty() && !((ListSelectionModel)listSelectionEvent.getSource()).getValueIsAdjusting()) {
                try {
                    ExpressionBuilderWizard.this.editingRow = this.exTable.getSelectedRow();
                    ExpressionBuilderWizard.this.editingColumn = this.exTable.getSelectedColumn();
                    int n = ((ExpressionTableColumnModel)ExpressionBuilderWizard.this.et.getColumnModel()).getVisibleColumns();
                    int n2 = ((ExpressionTableColumnModel)ExpressionBuilderWizard.this.et.getColumnModel()).getLastVisibleColumnIndex();
                    ExpressionBuilderWizard.this.apiColumn = n2 - (n - ExpressionBuilderWizard.this.editingColumn);
                    ExpressionBuilderWizard.this.createExpressionPanel(-1, ExpressionBuilderWizard.this.getExpression());
                    ExpressionBuilderWizard.this.setEnableLeftBottom(false);
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin.getMessage());
                }
            }
            ExpressionBuilderWizard.this.mainPanel.validate();
        }
    }

    private class BackListener
    implements ChangeListener {
        private BackListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (ExpressionBuilderWizard.this.steps.size() >= 1) {
                ExpressionBuilderWizard.this.builder = (ExpressionBuilderPanel)ExpressionBuilderWizard.this.steps.getLast();
                ExpressionBuilderWizard.this.steps.removeLast();
                ExpressionBuilderWizard.this.updateExpressionPanel(ExpressionBuilderWizard.this.builder);
            } else {
                try {
                    ExpressionBuilderWizard.this.builder = null;
                    ExpressionBuilderWizard.this.createExpressionPanel(-2, null);
                    ExpressionBuilderWizard.this.table.setNode(ExpressionBuilderWizard.this.apiNode);
                    ExpressionBuilderWizard.this.setEnableLeftBottom(true);
                }
                catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                    new HuginGUIError(exceptionInvalidExpression.getMessage());
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin.getMessage());
                }
            }
        }
    }

    private class ApplyListener
    implements ChangeListener {
        private ApplyListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Expression expression;
            ExpressionBuilderPanel expressionBuilderPanel = ExpressionBuilderWizard.this.steps.size() > 0 ? (ExpressionBuilderPanel)ExpressionBuilderWizard.this.steps.getFirst() : ExpressionBuilderWizard.this.builder;
            Expression expression2 = ExpressionBuilderWizard.this.builder.getCurrentExpression();
            if (expression2 == null) {
                expression2 = ExpressionTableModel.createValidExpression(ExpressionBuilderWizard.this.builder.getStringExpression(), ExpressionBuilderWizard.this.node.getClass().equals(UtilityNode.class));
            }
            if (ExpressionBuilderWizard.this.steps.size() > 0) {
                for (int i = ExpressionBuilderWizard.this.steps.size() - 1; i >= 0; --i) {
                    ExpressionBuilderPanel expressionBuilderPanel2 = (ExpressionBuilderPanel)ExpressionBuilderWizard.this.steps.get(i);
                    expressionBuilderPanel2.setActiveFieldText(expression2);
                    expression2 = expressionBuilderPanel2.getCurrentExpression();
                    if (expression2 != null) continue;
                    expression2 = ExpressionTableModel.createValidExpression(expressionBuilderPanel2.getStringExpression(), ExpressionBuilderWizard.this.node.getClass().equals(UtilityNode.class));
                }
            }
            if ((expression = expressionBuilderPanel.getCurrentExpression()) == null) {
                expression = ExpressionTableModel.createValidExpression(ExpressionBuilderWizard.this.expressionField.getText(), ExpressionBuilderWizard.this.node.getClass().equals(UtilityNode.class));
            }
            try {
                try {
                    ExpressionBuilderWizard.this.setExpression(expression);
                }
                catch (Exception exception) {
                    expression = ExpressionTableModel.createValidExpression(ExpressionBuilderWizard.this.expressionField.getText(), ExpressionBuilderWizard.this.node.getClass().equals(UtilityNode.class));
                    ExpressionBuilderWizard.this.setExpression(expression);
                }
                ExpressionBuilderWizard.this.table.setNode(ExpressionBuilderWizard.this.apiNode);
                ExpressionBuilderWizard.this.frameTable.getTable().getGUINode().updateTable();
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(exceptionHugin.getMessage());
            }
        }
    }

    private class OkListener
    implements ChangeListener {
        private OkListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ExpressionBuilderPanel expressionBuilderPanel = ExpressionBuilderWizard.this.builder;
            Expression expression = expressionBuilderPanel.getExpression();
            if (ExpressionBuilderWizard.this.steps.size() >= 1) {
                ExpressionBuilderWizard.this.expressionPanel.removeAll();
                ExpressionBuilderWizard.this.builder = (ExpressionBuilderPanel)ExpressionBuilderWizard.this.steps.getLast();
                ExpressionBuilderWizard.this.steps.removeLast();
                if (expression != null) {
                    ExpressionBuilderWizard.this.builder.setActiveFieldText(expression);
                } else {
                    ExpressionBuilderWizard.this.builder.setActiveFieldText("");
                }
                ExpressionBuilderWizard.this.updateExpressionPanel(ExpressionBuilderWizard.this.builder);
            } else {
                try {
                    ExpressionBuilderWizard.this.setExpression(expression);
                    ExpressionBuilderWizard.this.table.setNode(ExpressionBuilderWizard.this.apiNode);
                    ExpressionBuilderWizard.this.builder = null;
                    ExpressionBuilderWizard.this.createExpressionPanel(-2, null);
                    ExpressionBuilderWizard.this.setEnableLeftBottom(true);
                    ExpressionBuilderWizard.this.frameTable.getTable().getGUINode().updateTable();
                }
                catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                    new HuginGUIError(exceptionInvalidExpression.getMessage());
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin.getMessage());
                }
            }
        }
    }

    private class FunctionListener
    implements ChangeListener {
        private FunctionListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            Expression expression = object instanceof Expression ? (Expression)object : null;
            ExpressionBuilderWizard.this.createExpressionPanel(ExpressionBuilderWizard.this.builder.getNextMode(), expression);
        }
    }

    private class BarModeListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = true;
            if (ExpressionBuilderWizard.this.apiNode instanceof DiscreteChanceNode && !(bl = ((DiscreteChanceNodeTableModel)ExpressionBuilderWizard.this.frameTable.getTable().getTable().getModel()).getInvalidTable())) {
                bl = ((DiscreteChanceNodeTableModel)ExpressionBuilderWizard.this.table.getTable().getModel()).getInvalidTable();
            }
            if (ExpressionBuilderWizard.this.apiNode instanceof COM.hugin.HAPI.UtilityNode && !(bl = ((UtilityNodeTableModel)ExpressionBuilderWizard.this.frameTable.getTable().getTable().getModel()).getInvalidTable())) {
                bl = ((UtilityNodeTableModel)ExpressionBuilderWizard.this.table.getTable().getModel()).getInvalidTable();
            }
            if (!bl) {
                if (ExpressionBuilderWizard.this.barModeCombo.getSelectedIndex() == 0) {
                    try {
                        ExpressionBuilderWizard.this.frameTable.getTable().setDisplayMode(0);
                        ExpressionBuilderWizard.this.table.setDisplayMode(0);
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                }
                if (ExpressionBuilderWizard.this.barModeCombo.getSelectedIndex() == 1) {
                    try {
                        ExpressionBuilderWizard.this.frameTable.getTable().setDisplayMode(3);
                        ExpressionBuilderWizard.this.table.setDisplayMode(3);
                        ExpressionBuilderWizard.this.frameTable.getTable().setDisplayMode(1);
                        ExpressionBuilderWizard.this.table.setDisplayMode(1);
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                }
                if (ExpressionBuilderWizard.this.barModeCombo.getSelectedIndex() == 2) {
                    try {
                        ExpressionBuilderWizard.this.frameTable.getTable().setDisplayMode(3);
                        ExpressionBuilderWizard.this.table.setDisplayMode(3);
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                }
            } else {
                ExpressionBuilderWizard.this.barModeCombo.setSelectedIndex(0);
            }
        }
    }

    private class ShowAsTableListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ExpressionBuilderWizard.this.frameTable.getTable().generateTable();
                ExpressionBuilderWizard.this.table.generateTable();
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(HuginGUIConstants.get("ERROR_Invalid_expressions"));
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(HuginGUIConstants.get("ERROR_Invalid_expressions") + "\n" + exceptionInappropriateArguments.getMessage());
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(HuginGUIConstants.get("ERROR_Invalid_expressions") + "\n" + exceptionInsufficientStateRange.getMessage());
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(HuginGUIConstants.get("ERROR_Invalid_expressions") + "\n" + exceptionSyntax.getMessage());
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(HuginGUIConstants.get("ERROR_Invalid_expressions") + "\n" + exceptionDivisionByZero.getMessage());
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(HuginGUIConstants.get("ERROR_Invalid_expressions") + "\n" + exceptionInvalidStateValues.getMessage());
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(HuginGUIConstants.get("ERROR_Invalid_expressions") + "\n" + exceptionComputationFailed.getMessage());
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }

    private class TransferToTableListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ExpressionBuilderWizard.this.frameTable.getTable().transferToCPT();
                ExpressionBuilderWizard.this.table.transferToCPT();
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(HuginGUIConstants.get("ERROR_Invalid_expressions"));
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(HuginGUIConstants.get("ERROR_Invalid_expressions") + "\n" + exceptionInappropriateArguments.getMessage());
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(HuginGUIConstants.get("ERROR_Invalid_expressions") + "\n" + exceptionInsufficientStateRange.getMessage());
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(HuginGUIConstants.get("ERROR_Invalid_expressions") + "\n" + exceptionSyntax.getMessage());
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(HuginGUIConstants.get("ERROR_Invalid_expressions") + "\n" + exceptionDivisionByZero.getMessage());
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(HuginGUIConstants.get("ERROR_Invalid_expressions") + "\n" + exceptionInvalidStateValues.getMessage());
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(HuginGUIConstants.get("ERROR_Invalid_expressions") + "\n" + exceptionComputationFailed.getMessage());
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }

    private class RemoveListener
    implements ActionListener {
        NodeTableFrameInterface table;
        NodeTable t;
        COM.hugin.HAPI.Node node;
        NodeList parents;

        public RemoveListener(NodeTable nodeTable, NodeTableFrameInterface nodeTableFrameInterface, COM.hugin.HAPI.Node node) {
            this.table = nodeTableFrameInterface;
            this.node = node;
            this.t = nodeTable;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.parents = this.node.getParents();
                ListIterator listIterator = this.parents.listIterator();
                while (listIterator.hasNext()) {
                    COM.hugin.HAPI.Node node = (COM.hugin.HAPI.Node)listIterator.next();
                    if (!(node instanceof DiscreteChanceNode) && !(node instanceof DiscreteDecisionNode) || !HuginGUIUtils.getNodeTitle(node).equals(ExpressionBuilderWizard.this.removeNodeCombo.getSelectedItem())) continue;
                    this.table.getTable().removeModelNode(node);
                    ExpressionBuilderWizard.this.expressionTable = this.table.getTable().getExpressionTable();
                    ExpressionBuilderWizard.this.populateAddNodeCombo();
                    ExpressionBuilderWizard.this.populateRemoveNodeCombo();
                    this.t.setNode(this.node);
                    ExpressionBuilderWizard.this.bottomPanel.repaint();
                    ExpressionBuilderWizard.this.validate();
                }
                if (this.table.isVisible()) {
                    this.table.checkMinimumSizeConstraint();
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }

    private class AddListener
    implements ActionListener {
        NodeTableFrameInterface table;
        NodeTable t;
        COM.hugin.HAPI.Node node;
        NodeList parents;

        public AddListener(NodeTable nodeTable, NodeTableFrameInterface nodeTableFrameInterface, COM.hugin.HAPI.Node node) {
            this.table = nodeTableFrameInterface;
            this.node = node;
            this.t = nodeTable;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.parents = this.node.getParents();
                Model model = null;
                if (this.table.getTable().canShowExpressions()) {
                    model = this.node.getModel();
                }
                if (model == null) {
                    return;
                }
                ListIterator listIterator = this.parents.listIterator();
                while (listIterator.hasNext()) {
                    COM.hugin.HAPI.Node node = (COM.hugin.HAPI.Node)listIterator.next();
                    if ((node instanceof DiscreteChanceNode || node instanceof DiscreteDecisionNode) && HuginGUIUtils.getNodeTitle(node).equals(ExpressionBuilderWizard.this.addNodeCombo.getSelectedItem())) {
                        this.table.getTable().addModelNode(node);
                        ExpressionBuilderWizard.this.expressionTable = this.table.getTable().getExpressionTable();
                        ExpressionBuilderWizard.this.populateAddNodeCombo();
                        ExpressionBuilderWizard.this.populateRemoveNodeCombo();
                        this.t.setNode(this.node);
                        ExpressionBuilderWizard.this.bottomPanel.repaint();
                        ExpressionBuilderWizard.this.validate();
                    }
                    if (!this.table.isVisible()) continue;
                    this.table.checkMinimumSizeConstraint();
                }
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(exceptionHugin.getMessage());
            }
        }
    }
}

