/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Model;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.DiscreteChanceNode;
import COM.hugin.HGUI.DiscreteNode;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NodeTable;
import COM.hugin.HGUI.NodeTableFrameEvents;
import COM.hugin.HGUI.NodeTableFrameInterface;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ExternalNodeTableFrame
extends JFrame
implements NodeTableFrameInterface {
    JMenuBar menu = null;
    NodeTable table;
    JSlider slider;
    JLabel sliderVal;
    Node node;
    private static final double MAX_VICINITY_RADIUS = 20.0;
    JMenuItem edit_copy;
    JMenuItem edit_paste;
    JMenuItem randomize;
    JMenuItem normalize;
    JMenu reset;
    JMenuItem resetCPT;
    JMenuItem resetExperience;
    JMenuItem resetFading;
    JMenuItem function_create_fading;
    JMenuItem function_create_experience;
    JMenuItem function_delete_fading;
    JMenuItem function_delete_experience;
    JMenu fadingExperienceItems;
    JMenu expressions;
    JMenuItem showExpressions;
    JMenuItem showManual;
    JMenuItem generateTable;
    JMenuItem transferTable;
    JMenuItem buildExpression;
    JMenu addModelNode;
    JMenu removeModelNode;
    JMenu convertNode;
    JMenuItem toLabelled;
    JMenuItem toBoolean;
    JMenuItem toNumbered;
    JMenuItem toInterval;
    JMenuItem view_toggle_fading;
    JMenuItem view_toggle_experience;
    JMenuItem view_bar_mode;
    JMenuItem view_normal_mode;
    JMenuItem view_pure_bar_mode;
    JMenuItem auto_normalize;
    JMenu displayMode;
    private static final char DESC_SEP_CHAR = HuginGUIConstants.get("DESC_SEP_CHAR").charAt(0);

    public ExternalNodeTableFrame(Node node, int n, int n2) throws ExceptionHugin {
        this(node);
        Dimension dimension = this.getPreferredSize();
        dimension.width = Math.min(n, dimension.width);
        dimension.height = Math.min(n2, dimension.height);
        this.setSize(dimension.width, dimension.height);
    }

    public ExternalNodeTableFrame(Node node) throws ExceptionHugin {
        super("Dummy");
        this.node = node;
        String string = node.getLabel();
        string = string == null || string.length() == 0 ? node.getName() : string + " ( " + node.getName() + " ) ";
        this.setTitle(string);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                if (ExternalNodeTableFrame.this.menu == null) {
                    try {
                        ExternalNodeTableFrame.this.menu = ExternalNodeTableFrame.this.createMenu();
                        ExternalNodeTableFrame.this.setJMenuBar(ExternalNodeTableFrame.this.menu);
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                }
                ExternalNodeTableFrame.this.checkMinimumSizeConstraint();
            }
        });
    }

    protected boolean inVicinityOf(int n, int n2) {
        double d;
        double d2 = this.getX() - n;
        return Math.sqrt(d2 * d2 + (d = (double)(this.getY() - n2)) * d) < 20.0;
    }

    protected boolean inVicinityOfX(int n) {
        return (double)Math.abs(this.getX() - n) < 20.0;
    }

    protected boolean inVicinityOfY(int n) {
        return (double)Math.abs(this.getY() - n) < 20.0;
    }

    public Node getNode() {
        return this.node;
    }

    public NodeTable getTable() {
        return this.table;
    }

    public void update() throws ExceptionHugin {
        String string = this.node.getLabel();
        string = string == null || string.length() == 0 ? this.node.getName() : string + " ( " + this.node.getName() + " ) ";
        this.setTitle(string);
        this.table.setNode(this.node.getAPINode());
        this.createAddModelNodeMenu();
        this.checkMinimumSizeConstraint();
    }

    private JMenuBar createMenu() throws ExceptionHugin {
        MouseHandler mouseHandler = new MouseHandler(Hugin.mainFrame.getStatusBar());
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(new NodeTableFrameEvents.EDIT_Action());
        jMenu.addMenuListener(new EditMenuListener());
        this.edit_copy = new JMenuItem(new NodeTableFrameEvents.EDIT_Copy_Action(this));
        this.edit_copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.edit_copy.addMouseListener(mouseHandler);
        jMenu.add(this.edit_copy);
        this.edit_paste = new JMenuItem(new NodeTableFrameEvents.EDIT_Paste_Action(this));
        this.edit_paste.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.edit_paste.addMouseListener(mouseHandler);
        jMenu.add(this.edit_paste);
        this.normalize = new JMenuItem(new NodeTableFrameEvents.EDIT_Normalize_Action(this));
        this.normalize.addMouseListener(mouseHandler);
        jMenu.add(this.normalize);
        this.reset = new JMenu(new NodeTableFrameEvents.EDIT_Reset_Action(this));
        this.resetCPT = new JMenuItem(new NodeTableFrameEvents.EDIT_Reset_CPT_Action(this));
        this.resetCPT.addMouseListener(mouseHandler);
        this.resetCPT.setEnabled(!this.table.showExpressions());
        this.reset.add(this.resetCPT);
        this.resetExperience = new JMenuItem(new NodeTableFrameEvents.EDIT_Reset_Experience_Action(this));
        this.resetExperience.addMouseListener(mouseHandler);
        this.resetExperience.setEnabled(this.table.showExperience());
        this.reset.add(this.resetExperience);
        this.resetFading = new JMenuItem(new NodeTableFrameEvents.EDIT_Reset_Fading_Action(this));
        this.resetFading.addMouseListener(mouseHandler);
        this.resetFading.setEnabled(this.table.showFading());
        this.reset.add(this.resetFading);
        jMenu.add(this.reset);
        this.randomize = new JMenuItem(new NodeTableFrameEvents.EDIT_Randomize_Action(this));
        this.randomize.addMouseListener(mouseHandler);
        jMenu.add(this.randomize);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(new NodeTableFrameEvents.FUNCTIONS_Action());
        jMenu2.addMenuListener(new FunctionMenuListener());
        this.fadingExperienceItems = new JMenu(new NodeTableFrameEvents.FUNCTIONS_Fading_Experience_Action());
        this.function_create_experience = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Create_Experience_Action(this));
        this.function_create_experience.addMouseListener(mouseHandler);
        this.fadingExperienceItems.add(this.function_create_experience);
        this.function_create_fading = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Create_Fading_Action(this));
        this.function_create_fading.addMouseListener(mouseHandler);
        this.fadingExperienceItems.add(this.function_create_fading);
        this.function_delete_experience = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Delete_Experience_Action(this));
        this.function_delete_experience.addMouseListener(mouseHandler);
        this.fadingExperienceItems.add(this.function_delete_experience);
        this.function_delete_fading = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Delete_Fading_Action(this));
        this.function_delete_fading.addMouseListener(mouseHandler);
        this.fadingExperienceItems.add(this.function_delete_fading);
        jMenu2.add(this.fadingExperienceItems);
        this.expressions = new JMenu(new NodeTableFrameEvents.FUNCTIONS_Expressions_Action());
        this.showExpressions = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Switch_To_Expression_Action(this));
        this.showExpressions.setEnabled(!this.table.showExpressions());
        this.showExpressions.addMouseListener(mouseHandler);
        this.expressions.add(this.showExpressions);
        this.showManual = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Switch_To_Manual_Action(this));
        this.showManual.setEnabled(this.table.showExpressions());
        this.showManual.addMouseListener(mouseHandler);
        this.expressions.add(this.showManual);
        this.generateTable = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Generate_Table_Action(this));
        this.generateTable.addMouseListener(mouseHandler);
        this.generateTable.setEnabled(this.table.showExpressions());
        this.expressions.add(this.generateTable);
        this.transferTable = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Transfer_Table_Action(this));
        this.transferTable.addMouseListener(mouseHandler);
        this.transferTable.setEnabled(this.table.showExpressions());
        this.expressions.add(this.transferTable);
        this.buildExpression = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Build_Expression_Action(this));
        this.buildExpression.addMouseListener(mouseHandler);
        this.buildExpression.setEnabled(this.table.showExpressions());
        this.expressions.add(this.buildExpression);
        this.addModelNode = new JMenu(new NodeTableFrameEvents.FUNCTIONS_Add_Model_Node_Item_Action());
        this.createAddModelNodeMenu();
        this.addModelNode.setEnabled(this.table.showExpressions());
        this.expressions.add(this.addModelNode);
        this.removeModelNode = new JMenu(new NodeTableFrameEvents.FUNCTIONS_Remove_Model_Node_Item_Action());
        this.createRemoveModelNodeMenu();
        this.removeModelNode.setEnabled(this.table.showExpressions());
        this.expressions.add(this.removeModelNode);
        jMenu2.add(this.expressions);
        this.convertNode = new JMenu(new NodeTableFrameEvents.FUNCTIONS_Convert_Node_Action());
        this.toLabelled = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Convert_Node_To_Labelled_Action(this));
        this.toLabelled.addMouseListener(mouseHandler);
        this.convertNode.add(this.toLabelled);
        this.toBoolean = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Convert_Node_To_Boolean_Action(this));
        this.toBoolean.addMouseListener(mouseHandler);
        this.convertNode.add(this.toBoolean);
        this.toNumbered = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Convert_Node_To_Numbered_Action(this));
        this.toNumbered.addMouseListener(mouseHandler);
        this.convertNode.add(this.toNumbered);
        this.toInterval = new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Convert_Node_To_Interval_Action(this));
        this.toInterval.addMouseListener(mouseHandler);
        this.convertNode.add(this.toInterval);
        jMenu2.add(this.convertNode);
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu(new NodeTableFrameEvents.VIEW_Action());
        jMenu3.addMenuListener(new ViewMenuListener());
        this.displayMode = new JMenu(new NodeTableFrameEvents.VIEW_Display_Mode_Action());
        this.view_normal_mode = new JMenuItem(new NodeTableFrameEvents.VIEW_Normal_Mode_Action(this));
        this.view_normal_mode.addMouseListener(mouseHandler);
        this.displayMode.add(this.view_normal_mode);
        this.view_bar_mode = new JMenuItem(new NodeTableFrameEvents.VIEW_Bar_Mode_Action(this));
        this.view_bar_mode.addMouseListener(mouseHandler);
        this.displayMode.add(this.view_bar_mode);
        this.view_pure_bar_mode = new JMenuItem(new NodeTableFrameEvents.VIEW_Pure_Bars_Mode_Action(this));
        this.view_pure_bar_mode.addMouseListener(mouseHandler);
        this.displayMode.add(this.view_pure_bar_mode);
        this.auto_normalize = new JMenuItem(new NodeTableFrameEvents.VIEW_Auto_Normalize_Action(this));
        this.auto_normalize.addMouseListener(mouseHandler);
        this.displayMode.add(this.auto_normalize);
        jMenu3.add(this.displayMode);
        this.view_toggle_experience = new JMenuItem(new NodeTableFrameEvents.VIEW_Toggle_Experience_Action(this));
        this.view_toggle_experience.addMouseListener(mouseHandler);
        jMenu3.add(this.view_toggle_experience);
        this.view_toggle_fading = new JMenuItem(new NodeTableFrameEvents.VIEW_Toggle_Fading_Action(this));
        this.view_toggle_fading.addMouseListener(mouseHandler);
        jMenu3.add(this.view_toggle_fading);
        jMenuBar.add(jMenu3);
        return jMenuBar;
    }

    public void showExpressions(boolean bl) throws ExceptionHugin {
        this.table.showExpressions(bl);
        this.checkMinimumSizeConstraint();
        this.showExpressions.setEnabled(!bl);
        this.showManual.setEnabled(bl);
        this.generateTable.setEnabled(bl);
        this.transferTable.setEnabled(bl);
        this.buildExpression.setEnabled(bl);
        this.addModelNode.setEnabled(bl);
        this.removeModelNode.setEnabled(bl);
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension dimension = this.getContentPane().getPreferredSize();
        Dimension dimension2 = new Dimension(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
        if (this.getJMenuBar() != null) {
            Dimension dimension3 = this.getJMenuBar().getPreferredSize();
            dimension2.width = Math.max(dimension2.width, dimension3.width);
            dimension2.height += dimension3.height;
        }
        return dimension2;
    }

    public Dimension getMinimumSize() {
        if (this.menu == null) {
            return null;
        }
        Dimension dimension = this.getContentPane().getMinimumSize();
        dimension.height += this.menu.getPreferredSize().height;
        dimension.width = Math.max(dimension.width, this.getJMenuBar().getPreferredSize().width);
        Insets insets = this.getInsets();
        dimension.height += insets.top + insets.bottom;
        dimension.width += insets.left + insets.right;
        return dimension;
    }

    protected Model getModel(NodeList nodeList) throws ExceptionHugin {
        return this.table.getModel(nodeList);
    }

    public void checkMinimumSizeConstraint() {
        Dimension dimension = this.getMinimumSize();
        if (dimension == null) {
            return;
        }
        Dimension dimension2 = this.getSize();
        dimension2.width = Math.max(dimension.width, dimension2.width);
        dimension2.height = Math.max(dimension.height, dimension2.height);
        this.setBounds(this.getX(), this.getY(), dimension2.width, dimension2.height);
    }

    private void createAddModelNodeMenu() throws ExceptionHugin {
        if (this.addModelNode == null) {
            return;
        }
        NodeList nodeList = this.node.getAPINode().getParents();
        Model model = this.node.getAPINode().getModel();
        if (model == null) {
            return;
        }
        NodeList nodeList2 = model.getNodes();
        boolean bl = false;
        this.addModelNode.removeAll();
        for (COM.hugin.HAPI.Node node : nodeList) {
            if (!(node instanceof COM.hugin.HAPI.DiscreteChanceNode) || nodeList2.contains(node)) continue;
            this.addModelNode.add(new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Add_Model_Node_Action(this, node)));
            bl = true;
        }
        if (!bl) {
            this.addModelNode.add(new JMenuItem(HuginGUIConstants.get("str_no_valid_parents")));
        }
    }

    private void createRemoveModelNodeMenu() throws ExceptionHugin {
        if (this.removeModelNode == null) {
            return;
        }
        Model model = this.node.getAPINode().getModel();
        if (model == null) {
            return;
        }
        NodeList nodeList = model.getNodes();
        boolean bl = false;
        this.removeModelNode.removeAll();
        for (COM.hugin.HAPI.Node node : nodeList) {
            this.removeModelNode.add(new JMenuItem(new NodeTableFrameEvents.FUNCTIONS_Remove_Model_Node_Action(this, node)));
            bl = true;
        }
        if (!bl) {
            this.removeModelNode.add(new JMenuItem(HuginGUIConstants.get("str_no_model_nodes_available")));
        }
    }

    private String getConsDesc(String string, boolean bl) {
        int n;
        String string2 = string.substring(0, string.lastIndexOf(DESC_SEP_CHAR));
        boolean bl2 = false;
        int n2 = bl ? 0 : (n = bl2 ? string2.lastIndexOf(DESC_SEP_CHAR) + 1 : string2.indexOf(DESC_SEP_CHAR) + 1);
        int n3 = bl ? string2.indexOf(DESC_SEP_CHAR) : (bl2 ? string2.length() : string2.lastIndexOf(DESC_SEP_CHAR));
        return string2.substring(n, n3);
    }

    private class MouseHandler
    extends MouseAdapter {
        private HuginGUIFrame.StatusBar status;

        public MouseHandler(HuginGUIFrame.StatusBar statusBar) {
            this.status = statusBar;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton;
            Action action;
            if (mouseEvent.getSource() instanceof AbstractButton && (action = (abstractButton = (AbstractButton)mouseEvent.getSource()).getAction()) != null) {
                String string = (String)action.getValue("LongDescription");
                String string2 = ExternalNodeTableFrame.this.getConsDesc(string, action.isEnabled());
                this.status.write(string2);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof AbstractButton && ((AbstractButton)mouseEvent.getSource()).getAction() != null) {
                this.status.clear();
            }
        }
    }

    private class ViewMenuListener
    implements MenuListener {
        ImageIcon off = new ImageIcon(ClassLoader.getSystemResource("icons/empty.gif"));
        ImageIcon on = new ImageIcon(ClassLoader.getSystemResource("icons/ok.gif"));

        private ViewMenuListener() {
        }

        public void menuSelected(MenuEvent menuEvent) {
            ExternalNodeTableFrame.this.displayMode.setEnabled(ExternalNodeTableFrame.this.node instanceof DiscreteChanceNode);
            ExternalNodeTableFrame.this.view_normal_mode.setEnabled(ExternalNodeTableFrame.this.table.getDisplayMode() != 0);
            ExternalNodeTableFrame.this.view_bar_mode.setEnabled(ExternalNodeTableFrame.this.table.getDisplayMode() != 1);
            ExternalNodeTableFrame.this.view_pure_bar_mode.setEnabled(ExternalNodeTableFrame.this.table.getDisplayMode() != 3);
            ((NodeTableFrameEvents.VIEW_Toggle_Experience_Action)ExternalNodeTableFrame.this.view_toggle_experience.getAction()).setMode(ExternalNodeTableFrame.this.table.showExperience());
            ((NodeTableFrameEvents.VIEW_Toggle_Fading_Action)ExternalNodeTableFrame.this.view_toggle_fading.getAction()).setMode(ExternalNodeTableFrame.this.table.showFading());
            ImageIcon imageIcon = ExternalNodeTableFrame.this.getTable().autoNormalize() ? this.on : this.off;
            ExternalNodeTableFrame.this.auto_normalize.getAction().putValue("SmallIcon", imageIcon);
            ExternalNodeTableFrame.this.auto_normalize.setEnabled(ExternalNodeTableFrame.this.table.getDisplayMode() != 0);
            try {
                ExternalNodeTableFrame.this.view_toggle_experience.setEnabled(ExternalNodeTableFrame.this.table.hasExperience());
                ExternalNodeTableFrame.this.view_toggle_fading.setEnabled(ExternalNodeTableFrame.this.table.hasFading());
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }
    }

    private class FunctionMenuListener
    implements MenuListener {
        private FunctionMenuListener() {
        }

        public void menuSelected(MenuEvent menuEvent) {
            try {
                ExternalNodeTableFrame.this.fadingExperienceItems.setEnabled(ExternalNodeTableFrame.this.node instanceof DiscreteChanceNode);
                ExternalNodeTableFrame.this.function_create_experience.setEnabled(!ExternalNodeTableFrame.this.table.hasExperience());
                ExternalNodeTableFrame.this.function_create_fading.setEnabled(!ExternalNodeTableFrame.this.table.hasFading());
                ExternalNodeTableFrame.this.function_delete_experience.setEnabled(ExternalNodeTableFrame.this.table.hasExperience());
                ExternalNodeTableFrame.this.function_delete_fading.setEnabled(ExternalNodeTableFrame.this.table.hasFading());
                ExternalNodeTableFrame.this.convertNode.setEnabled(ExternalNodeTableFrame.this.node.isDiscrete());
                if (ExternalNodeTableFrame.this.node.isDiscrete()) {
                    int n = ((DiscreteNode)((Object)ExternalNodeTableFrame.this.node)).getSubtype();
                    ExternalNodeTableFrame.this.toLabelled.setEnabled(n != 0);
                    ExternalNodeTableFrame.this.toBoolean.setEnabled(n != 1);
                    ExternalNodeTableFrame.this.toNumbered.setEnabled(n != 2);
                    ExternalNodeTableFrame.this.toInterval.setEnabled(n != 3);
                }
                ExternalNodeTableFrame.this.createAddModelNodeMenu();
                ExternalNodeTableFrame.this.createRemoveModelNodeMenu();
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }
    }

    private class EditMenuListener
    implements MenuListener {
        private EditMenuListener() {
        }

        public void menuSelected(MenuEvent menuEvent) {
            ExternalNodeTableFrame.this.edit_copy.setEnabled(ExternalNodeTableFrame.this.table.canCopy());
            ExternalNodeTableFrame.this.edit_paste.setEnabled(ExternalNodeTableFrame.this.table.canPaste());
            ExternalNodeTableFrame.this.resetCPT.setEnabled(!ExternalNodeTableFrame.this.table.showExpressions());
            ExternalNodeTableFrame.this.resetExperience.setEnabled(ExternalNodeTableFrame.this.table.showExperience());
            ExternalNodeTableFrame.this.resetFading.setEnabled(ExternalNodeTableFrame.this.table.showFading());
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }
    }
}

