/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.DataAnalyzerDialog;
import COM.hugin.HGUI.HuginAnalysisDialog;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.LearningWizard;
import COM.hugin.HGUI.TitledPanel;
import COM.hugin.HGUI.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HiddenNodeAnalyzer
extends DataAnalyzerDialog {
    private JPanel dataPane;
    private JPanel setupPane;
    private JPanel runPane;
    private JPanel resultsPane;
    private Domain bestCloneDomain = null;
    private DiscreteChanceNode hidden = null;
    private JComboBox hiddenNode;
    private JSpinner minStates;
    private JSpinner maxStates;
    private JCheckBox randomizeHiddenCPTCheckBox;
    HuginAnalysisDialog.NodeWrapper selected = null;
    private boolean randomizeHiddenCPT = true;
    private HuginGUIFrame guiFrame;
    JRadioButton aicRadio;
    JRadioButton bicRadio;
    JRadioButton llRadio;
    JPanel outputPanel;
    JButton run;
    JButton apply;
    JButton reset;

    public HiddenNodeAnalyzer(HuginProjectFrame huginProjectFrame, HuginGUIFrame huginGUIFrame) {
        super(huginProjectFrame, HuginGUIConstants.get("HNA_Title"));
        this.guiFrame = huginGUIFrame;
        this.streamData = null;
        this.helpPages = new String[]{"help/HNA_DataSource.htm", "help/HNA_Setup.htm", "help/HNA_Run.htm"};
        try {
            this.configureDomain();
            if (!this.domain.isCompiled()) {
                this.domain.compile();
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        this.tabbedPane = new JTabbedPane();
        this.createDataPane();
        this.createSetupPane();
        this.createRunPane();
        this.tabbedPane.addTab(HuginGUIConstants.get("AW_Tab_data_acquisition"), this.dataPane);
        this.tabbedPane.addTab(HuginGUIConstants.get("HNA_Tab_setup"), this.setupPane);
        this.tabbedPane.addTab(HuginGUIConstants.get("HNA_Tab_run"), this.runPane);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.tabbedPane, "Center");
        jPanel.add((Component)this.getBottomPanel(), "South");
        this.setContentPane(jPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                HiddenNodeAnalyzer.this.projectFrame.getNetworkPanel().updateBackpointers();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new DataAnalyzerDialog.CloseListener(this, this.domain, huginProjectFrame.getNetworkPanel()));
    }

    protected void updatePanes() {
        int n = this.tabbedPane.indexOfTab(HuginGUIConstants.get("HNA_Tab_setup"));
        this.tabbedPane.remove(n);
        this.createSetupPane();
        this.tabbedPane.insertTab(HuginGUIConstants.get("HNA_Tab_setup"), null, this.setupPane, null, n);
        n = this.tabbedPane.indexOfTab(HuginGUIConstants.get("HNA_Tab_run"));
        this.tabbedPane.remove(n);
        this.createRunPane();
        this.tabbedPane.insertTab(HuginGUIConstants.get("HNA_Tab_run"), null, this.runPane, null, n);
    }

    private void createDataPane() {
        this.dataPane = new TitledPanel(HuginGUIConstants.get("AW_Data_title"));
        this.dataFileLabel = new JLabel(HuginGUIConstants.get("AW_Data_file") + "---");
        this.dataNumberOfCasesLabel = new JLabel(HuginGUIConstants.get("AW_Data_number_of_cases") + "0", 4);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(this.dataFileLabel);
        jPanel.add(this.dataNumberOfCasesLabel);
        this.viewDataPane = new JScrollPane();
        this.viewDataPane.setPreferredSize(new Dimension(450, 300));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 4));
        JButton jButton = new JButton(HuginGUIConstants.get("AW_Data_database"));
        jButton.setToolTipText(HuginGUIConstants.get("SA_ToolTip_Load_Cases"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearningWizard learningWizard = new LearningWizard(HiddenNodeAnalyzer.this.wizardWindow, ((HiddenNodeAnalyzer)HiddenNodeAnalyzer.this).guiFrame.preferences, HiddenNodeAnalyzer.this.domain, new DataAnalyzerDialog.DomainCasesListener(HiddenNodeAnalyzer.this));
                learningWizard.setLocation(100, 100);
                learningWizard.setVisible(true);
                try {
                    HiddenNodeAnalyzer.this.run.setEnabled(HiddenNodeAnalyzer.this.domain.getNumberOfCases() > 0);
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin);
                }
            }
        });
        this.clearData = new JButton(HuginGUIConstants.get("AW_Data_clear_data"));
        this.clearData.setToolTipText(HuginGUIConstants.get("AW_ToolTip_Clear_Data"));
        this.clearData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HiddenNodeAnalyzer.this.clearData();
                HiddenNodeAnalyzer.this.run.setEnabled(false);
            }
        });
        this.clearData.setEnabled(false);
        jPanel2.add(jButton);
        jPanel2.add(this.clearData);
        this.dataPane.setLayout(new BorderLayout());
        this.dataPane.add((Component)jPanel, "North");
        this.dataPane.add((Component)this.viewDataPane, "Center");
        this.dataPane.add((Component)jPanel2, "South");
    }

    private void createSetupPane() {
        Object object2;
        JPanel jPanel = new JPanel(new GridLayout(4, 2, 10, 5));
        Vector<HuginAnalysisDialog.NodeWrapper> vector = new Vector<HuginAnalysisDialog.NodeWrapper>();
        try {
            for (Object object2 : this.domain.getNodes()) {
                if (!(object2 instanceof DiscreteChanceNode) || object2 instanceof BooleanDCNode) continue;
                vector.add(new HuginAnalysisDialog.NodeWrapper((Node)object2));
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        this.hiddenNode = new JComboBox(vector);
        this.hiddenNode.setSelectedIndex(0);
        JLabel jLabel = new JLabel(HuginGUIConstants.get("Select_hidden_node"));
        jPanel.add(jLabel);
        jPanel.add(this.hiddenNode);
        this.minStates = new JSpinner(new SpinnerNumberModel(2, 1, Integer.MAX_VALUE, 1));
        object2 = new JLabel(HuginGUIConstants.get("min_nr_of_states"));
        jPanel.add((Component)object2);
        jPanel.add(this.minStates);
        this.maxStates = new JSpinner(new SpinnerNumberModel(2, 1, Integer.MAX_VALUE, 1));
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n;
                int n2 = ((Number)HiddenNodeAnalyzer.this.minStates.getValue()).intValue();
                if (n2 > (n = ((Number)HiddenNodeAnalyzer.this.maxStates.getValue()).intValue())) {
                    HiddenNodeAnalyzer.this.maxStates.setValue(n2);
                }
            }
        };
        this.minStates.addChangeListener(changeListener);
        this.maxStates.addChangeListener(changeListener);
        JLabel jLabel2 = new JLabel(HuginGUIConstants.get("max_nr_of_states"));
        jPanel.add(jLabel2);
        jPanel.add(this.maxStates);
        this.randomizeHiddenCPTCheckBox = new JCheckBox("", this.randomizeHiddenCPT);
        this.randomizeHiddenCPTCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HiddenNodeAnalyzer.this.randomizeHiddenCPT = !HiddenNodeAnalyzer.this.randomizeHiddenCPT;
            }
        });
        JLabel jLabel3 = new JLabel(HuginGUIConstants.get("Randomize_CPT"));
        jPanel.add(jLabel3);
        jPanel.add(this.randomizeHiddenCPTCheckBox);
        this.setupPane = new TitledPanel(HuginGUIConstants.get("HNA_setup_title"));
        this.setupPane.setLayout(new FlowLayout(0));
        this.setupPane.add(jPanel);
    }

    private void createRunPane() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.aicRadio = new JRadioButton(HuginGUIConstants.get("HNA_AIC"));
        this.aicRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.bicRadio = new JRadioButton(HuginGUIConstants.get("HNA_BIC"));
        this.llRadio = new JRadioButton(HuginGUIConstants.get("HNA_ll"));
        this.aicRadio.setSelected(true);
        this.bicRadio.setSelected(false);
        this.llRadio.setSelected(false);
        buttonGroup.add(this.aicRadio);
        buttonGroup.add(this.bicRadio);
        buttonGroup.add(this.llRadio);
        JLabel jLabel = new JLabel(HuginGUIConstants.get("HNA_Select_optimisation_score"));
        JPanel jPanel = new JPanel(new GridLayout(5, 1, 10, 5));
        jPanel.add(jLabel);
        jPanel.add(this.aicRadio);
        jPanel.add(this.bicRadio);
        jPanel.add(this.llRadio);
        this.outputPanel = this.getOutputPanel();
        JScrollPane jScrollPane = new JScrollPane(this.outputPanel);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("SE_results")));
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        this.run = this.getRunButton();
        this.apply = this.getApplyButton();
        this.reset = this.getResetButton();
        this.run.setEnabled(false);
        this.apply.setEnabled(false);
        this.reset.setEnabled(false);
        jPanel2.add(this.run);
        jPanel2.add(this.apply);
        jPanel2.add(this.reset);
        this.runPane = new TitledPanel(HuginGUIConstants.get("HNA_run_title"));
        this.runPane.setLayout(new BorderLayout());
        this.runPane.add((Component)jPanel, "North");
        this.runPane.add((Component)jScrollPane, "Center");
        this.runPane.add((Component)jPanel2, "South");
    }

    protected JButton getCloseButton() {
        JButton jButton = new JButton(HuginGUIConstants.get("MISCELLANEOUS_Close"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (HiddenNodeAnalyzer.this.bestCloneDomain != null) {
                        HiddenNodeAnalyzer.this.bestCloneDomain.delete();
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception.getMessage());
                }
                HiddenNodeAnalyzer.this.dispose();
            }
        });
        return jButton;
    }

    protected JButton getResetButton() {
        this.reset = new JButton(HuginGUIConstants.get("reset_button"));
        this.reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (HiddenNodeAnalyzer.this.bestCloneDomain != null) {
                        HiddenNodeAnalyzer.this.bestCloneDomain.delete();
                        HiddenNodeAnalyzer.this.bestCloneDomain = null;
                        HiddenNodeAnalyzer.this.hidden = null;
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception.getMessage());
                }
                HiddenNodeAnalyzer.this.apply.setEnabled(false);
                HiddenNodeAnalyzer.this.reset.setEnabled(false);
                try {
                    HiddenNodeAnalyzer.this.run.setEnabled(HiddenNodeAnalyzer.this.domain.getNumberOfCases() > 0);
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin);
                }
            }
        });
        return this.reset;
    }

    protected JButton getApplyButton() {
        this.apply = new JButton(HuginGUIConstants.get("apply_button"));
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (HiddenNodeAnalyzer.this.bestCloneDomain != null) {
                        String string = HiddenNodeAnalyzer.this.hidden.getName();
                        DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)HiddenNodeAnalyzer.this.homeModel.getNodeByName(string);
                        discreteChanceNode.setNumberOfStates(HiddenNodeAnalyzer.this.hidden.getNumberOfStates());
                        HuginGUIUtils.updateFromModel(HiddenNodeAnalyzer.this.homeModel, HiddenNodeAnalyzer.this.bestCloneDomain);
                        HiddenNodeAnalyzer.this.projectFrame.networkPanel.updateAllTables();
                        String string2 = "\n" + HuginGUIConstants.get("Changes_applied_to_domain") + "\n";
                        HiddenNodeAnalyzer.this.outputPanel.add(new JLabel(string2, 2));
                        HiddenNodeAnalyzer.this.apply.setEnabled(false);
                        HiddenNodeAnalyzer.this.reset.setEnabled(false);
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception.getMessage());
                }
            }
        });
        return this.apply;
    }

    protected JButton getRunButton() {
        JButton jButton = new JButton(HuginGUIConstants.get("HNA_Tab_run"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    HiddenNodeAnalyzer.this.selected = (HuginAnalysisDialog.NodeWrapper)HiddenNodeAnalyzer.this.hiddenNode.getSelectedItem();
                    HiddenNodeAnalyzer.this.outputPanel.removeAll();
                    HiddenNodeAnalyzer.this.outputPanel.revalidate();
                    HiddenNodeAnalyzer.this.outputPanel.repaint();
                    Domain domain = null;
                    double d = 0.0;
                    double d2 = 0.0;
                    String string = ((DiscreteChanceNode)HiddenNodeAnalyzer.this.selected.node).getName();
                    for (int i = ((Number)HiddenNodeAnalyzer.this.minStates.getValue()).intValue(); i <= ((Number)HiddenNodeAnalyzer.this.maxStates.getValue()).intValue(); ++i) {
                        Object object;
                        domain = (Domain)HiddenNodeAnalyzer.this.domain.clone();
                        DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)domain.getNodeByName(string);
                        discreteChanceNode.setNumberOfStates(i);
                        if (HiddenNodeAnalyzer.this.randomizeHiddenCPT) {
                            object = discreteChanceNode.getTable();
                            int n = ((Table)object).getSize();
                            for (int j = 0; j < n; ++j) {
                                ((Table)object).setDataItem(j, Math.random() + 0.001);
                            }
                        }
                        domain.compile();
                        domain.learnTables();
                        object = HuginGUIConstants.get("HNA_State_space_size") + "= " + i + " " + HuginGUIConstants.get("HNA_ll") + ": " + HuginGUIUtils.printDouble(domain.getLogLikelihood(), HiddenNodeAnalyzer.this.projectFrame.guiFrame.preferences.precision) + " " + HuginGUIConstants.get("HNA_BIC") + ": " + HuginGUIUtils.printDouble(domain.getBIC(), HiddenNodeAnalyzer.this.projectFrame.guiFrame.preferences.precision) + " " + HuginGUIConstants.get("HNA_AIC") + ": " + HuginGUIUtils.printDouble(domain.getAIC(), HiddenNodeAnalyzer.this.projectFrame.guiFrame.preferences.precision) + "\n";
                        HiddenNodeAnalyzer.this.outputPanel.add(new JLabel((String)object, 2));
                        d = HiddenNodeAnalyzer.this.getScore(domain);
                        if (i == ((Number)HiddenNodeAnalyzer.this.minStates.getValue()).intValue() || d2 < d) {
                            d2 = d;
                            if (HiddenNodeAnalyzer.this.bestCloneDomain != null) {
                                HiddenNodeAnalyzer.this.bestCloneDomain.delete();
                            }
                            HiddenNodeAnalyzer.this.bestCloneDomain = (Domain)domain.clone();
                        }
                        domain.delete();
                    }
                    HiddenNodeAnalyzer.this.hidden = (DiscreteChanceNode)HiddenNodeAnalyzer.this.bestCloneDomain.getNodeByName(string);
                    String string2 = "\n" + HuginGUIConstants.get("HNA_Best_ARGV0_score_is_ARGV1_for_ARGV2_states", new String[]{HiddenNodeAnalyzer.this.getScoreLabel(), HuginGUIUtils.printDouble(d2, HiddenNodeAnalyzer.this.projectFrame.guiFrame.preferences.precision), "" + HiddenNodeAnalyzer.this.hidden.getNumberOfStates()}) + "\n";
                    HiddenNodeAnalyzer.this.outputPanel.add(new JLabel(string2, 2));
                    HiddenNodeAnalyzer.this.run.setEnabled(false);
                    HiddenNodeAnalyzer.this.reset.setEnabled(true);
                    HiddenNodeAnalyzer.this.apply.setEnabled(true);
                }
                catch (Exception exception) {
                    new HuginGUIError(exception.getMessage());
                }
            }
        });
        return jButton;
    }

    private double getScore(Domain domain) {
        try {
            if (this.aicRadio.isSelected()) {
                return domain.getAIC();
            }
            if (this.bicRadio.isSelected()) {
                return domain.getBIC();
            }
            if (this.llRadio.isSelected()) {
                return domain.getLogLikelihood();
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception.getMessage());
        }
        return 0.0;
    }

    private String getScoreLabel() {
        if (this.aicRadio.isSelected()) {
            return HuginGUIConstants.get("HNA_AIC");
        }
        if (this.bicRadio.isSelected()) {
            return HuginGUIConstants.get("HNA_BIC");
        }
        if (this.llRadio.isSelected()) {
            return HuginGUIConstants.get("HNA_ll");
        }
        return "";
    }

    private JPanel getOutputPanel() {
        JPanel jPanel = new JPanel(new VerticalFlowLayout(0));
        jPanel.setSize(new Dimension(300, 100));
        jPanel.setBackground(Color.white);
        return jPanel;
    }

    public void createResultsPane() {
        JLabel jLabel = new JLabel("PIS");
        JTextArea jTextArea = new JTextArea("---");
        jTextArea.setBackground(this.getBackground());
        jTextArea.setEditable(false);
        JPanel jPanel = new JPanel(new GridLayout(3, 2, 10, 5));
        jPanel.add(jLabel);
        jPanel.add(jTextArea);
        this.resultsPane = new TitledPanel(HuginGUIConstants.get("HNA_results_title"));
        this.resultsPane.setLayout(new FlowLayout(0));
        this.resultsPane.add(jPanel);
    }
}

