/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class HuginComboBox
extends JComboBox {
    private int popupWidth = 0;
    private boolean layingOut;

    public HuginComboBox() {
        this.layingOut = true;
    }

    public HuginComboBox(Object[] objectArray) {
        super(objectArray);
        this.popupWidth = this.getPopupWidth();
        this.layingOut = this.popupWidth <= super.getSize().width;
    }

    public HuginComboBox(Vector vector) {
        super(vector);
        this.popupWidth = this.getPopupWidth();
        this.layingOut = this.popupWidth <= super.getSize().width;
    }

    public HuginComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.popupWidth = this.getPopupWidth();
        this.layingOut = this.popupWidth <= super.getSize().width;
    }

    private void setPopupWidth(int n) {
        this.popupWidth = n;
        this.layingOut = this.popupWidth <= super.getSize().width;
    }

    public void validatePopupWidth() {
        this.popupWidth = this.getPopupWidth();
        this.layingOut = this.popupWidth <= super.getSize().width;
    }

    public void setPreferredSize(Dimension dimension) {
        int n = this.getPopupWidth();
        super.setPreferredSize(dimension);
        this.setPopupWidth(n);
    }

    private int getPopupWidth() {
        try {
            int n = 0;
            int n2 = this.getItemCount();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            for (int i = 0; i < n2; ++i) {
                String string = this.getItemAt(i).toString();
                int n3 = fontMetrics.stringWidth(string);
                if (n >= n3) continue;
                n = n3;
            }
            return n + 20;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLayout() {
        try {
            this.layingOut = true;
            super.doLayout();
            this.layingOut = this.popupWidth <= super.getSize().width;
        }
        catch (Throwable throwable) {
            this.layingOut = this.popupWidth <= super.getSize().width;
            throw throwable;
        }
    }

    public Dimension getSize() {
        Dimension dimension = super.getSize();
        if (!this.layingOut) {
            dimension.width = Math.max(this.popupWidth, super.getSize().width);
            dimension.width = Math.min(dimension.width, Toolkit.getDefaultToolkit().getScreenSize().width);
        }
        return dimension;
    }
}

