/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HGUI.BeliefBarPanel;
import COM.hugin.HGUI.CDVTLink;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.Link;
import COM.hugin.HGUI.PastingTextField;
import COM.hugin.HGUI.TitledPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class InsertContinuousFindingPanel
extends JDialog {
    ContinuousChanceNode node;
    HuginProjectFrame frame;
    PastingTextField enterValue;
    JButton enter;
    JButton retract;
    JScrollPane scrollPaint;
    double oldFindings;
    static final int barWidth = 150;
    static final int barHeight = 15;
    static final int margin = 8;

    public InsertContinuousFindingPanel(ContinuousChanceNode continuousChanceNode, HuginProjectFrame huginProjectFrame) {
        super(Hugin.mainFrame, HuginGUIConstants.get("MISCELLANEOUS_Insert_continuous_finding"), true);
        this.node = continuousChanceNode;
        this.frame = huginProjectFrame;
        try {
            if (continuousChanceNode.evidenceIsEntered()) {
                this.oldFindings = continuousChanceNode.getEnteredValue();
            }
            this.createPanel();
            if (System.getProperty("os.name").equals("Linux")) {
                this.setSize((int)this.getPreferredSize().getWidth() + 10, (int)this.getPreferredSize().getHeight() + 30);
            }
            this.setResizable(false);
            this.getRootPane().setDefaultButton(this.enter);
            this.pack();
            this.setLocation(huginProjectFrame.guiFrame.getX() + huginProjectFrame.getX() + 50, huginProjectFrame.guiFrame.getY() + huginProjectFrame.getY() + 50);
            this.setVisible(true);
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private void createPanel() {
        JLabel jLabel;
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        TitledPanel titledPanel = new TitledPanel(HuginGUIConstants.get("INSERTLIKELIHOOD_node"));
        titledPanel.setLayout(new BoxLayout(titledPanel, 1));
        try {
            object = this.node.getLabel();
            if (((String)object).length() == 0) {
                object = this.node.getName();
            }
            jLabel = new JLabel((String)object);
        }
        catch (Exception exception) {
            jLabel = new JLabel("-");
        }
        jLabel.setAlignmentX(0.0f);
        titledPanel.add(jLabel);
        titledPanel.add(Box.createHorizontalGlue());
        TitledPanel titledPanel2 = new TitledPanel(HuginGUIConstants.get("CONTINUOUSFINDING_evidence"));
        titledPanel2.setLayout(new BorderLayout());
        object = new JLabel(new ImageIcon(ClassLoader.getSystemResource("icons/nodeicon.gif")));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.enterValue = new PastingTextField(15);
        jPanel2.add((Component)new JPanel(), "North");
        jPanel2.add((Component)this.enterValue, "Center");
        jPanel2.add((Component)new JPanel(), "South");
        this.enterValue.addKeyListener(new ValueListener(this.node, this.enterValue));
        titledPanel2.add((Component)jPanel2, "West");
        titledPanel2.add((Component)object, "East");
        titledPanel.setAlignmentX(0.0f);
        titledPanel2.setAlignmentX(0.0f);
        jPanel.add(titledPanel);
        jPanel.add(titledPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(5, 1));
        this.enter = new JButton(HuginGUIConstants.get("CONTINUOUSFINDING_enter_evidence"));
        this.enter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = Double.parseDouble(InsertContinuousFindingPanel.this.enterValue.getText());
                    InsertContinuousFindingPanel.this.node.enterValue(d);
                    InsertContinuousFindingPanel.this.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.retract = new JButton(HuginGUIConstants.get("CONTINUOUSFINDING_retract"));
        this.retract.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    InsertContinuousFindingPanel.this.node.retractFindings();
                    BeliefBarPanel beliefBarPanel = InsertContinuousFindingPanel.this.frame.getBeliefBarPanel();
                    for (Link link : InsertContinuousFindingPanel.this.frame.getNetworkPanel().linkList) {
                        if (!(link instanceof CDVTLink) || beliefBarPanel.getDomainNodeFor(link.parent.getAPINode()) != InsertContinuousFindingPanel.this.node) continue;
                        IntervalDCNode intervalDCNode = (IntervalDCNode)beliefBarPanel.getDomainNodeFor(link.child.getAPINode());
                        intervalDCNode.retractFindings();
                        InsertContinuousFindingPanel.this.repaint();
                        ((HuginProjectFrame)InsertContinuousFindingPanel.this.frame.guiFrame.desktop.getSelectedFrame()).getNetworkPanel().repaint();
                    }
                    InsertContinuousFindingPanel.this.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JButton jButton = new JButton(HuginGUIConstants.get("cancel_button"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (InsertContinuousFindingPanel.this.node.evidenceIsEntered()) {
                        InsertContinuousFindingPanel.this.node.enterValue(InsertContinuousFindingPanel.this.oldFindings);
                    }
                    InsertContinuousFindingPanel.this.dispose();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        jPanel3.add(this.enter);
        jPanel3.add(this.retract);
        jPanel3.add(jButton);
        jPanel3.add(new JLabel(""));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel, "North");
        jPanel3.setAlignmentY(0.0f);
        jPanel4.setAlignmentY(0.0f);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        this.getContentPane().add(jPanel4);
        this.getContentPane().add(jPanel3);
        try {
            if (this.node.evidenceIsEntered()) {
                this.enterValue.setText("" + this.node.getEnteredValue());
                this.retract.setEnabled(true);
            } else {
                this.enterValue.setText(HuginGUIUtils.printDouble(this.node.getMean(), this.frame.guiFrame.preferences.precision));
                this.retract.setEnabled(false);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private class ValueListener
    extends KeyAdapter {
        ContinuousChanceNode node;
        PastingTextField field;

        public ValueListener(ContinuousChanceNode continuousChanceNode, PastingTextField pastingTextField) {
            this.node = continuousChanceNode;
            this.field = pastingTextField;
        }

        public void keyReleased(KeyEvent keyEvent) {
            String string = InsertContinuousFindingPanel.this.enterValue.getText();
            try {
                double d = Double.parseDouble(this.field.getText());
                InsertContinuousFindingPanel.this.enter.setEnabled(true);
                if (keyEvent.getKeyChar() == '\n') {
                    try {
                        this.node.enterValue(d);
                        InsertContinuousFindingPanel.this.dispose();
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                }
            }
            catch (Exception exception) {
                InsertContinuousFindingPanel.this.enter.setEnabled(false);
            }
        }
    }
}

