/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.NodeTableColumnModel;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTableColumn
extends TableColumn {
    public static final int COLLAPSED = -10;
    public static final int INVALID = -1;
    protected static int MIN_WIDTH = 30;
    protected static int PREFERRED_WIDTH = 50;
    protected static int COLLAPSED_WIDTH = MIN_WIDTH / 2;
    protected static int PREFERRED_EXPRESSION_WIDTH = PREFERRED_WIDTH * 2;
    LinkedList<NodeTableColumn> children;
    boolean collapsed;
    boolean viewable;
    int subColumnCount;
    int leftIndex;
    int rightIndex;
    int collapsedPosition;
    private boolean resizable = false;
    private Node node;
    private int state;
    protected int depth;
    protected int columnIndex;
    protected int columnWidth;

    public NodeTableColumn(Node node, int n, NodeList nodeList) throws ExceptionHugin {
        this.headerValue = null;
        this.children = new LinkedList();
        this.minWidth = MIN_WIDTH;
        this.collapsed = false;
        this.viewable = true;
        this.node = node;
        this.state = n;
        if (nodeList == null || nodeList.size() == 0) {
            return;
        }
        NodeList nodeList2 = (NodeList)nodeList.clone();
        Node node2 = (Node)nodeList2.removeFirst();
        if (node2 instanceof DiscreteChanceNode || node instanceof DiscreteDecisionNode) {
            int n2 = ((DiscreteNode)node2).getNumberOfStates();
            for (int i = 0; i < n2; ++i) {
                this.children.add(new NodeTableColumn(node2, i, nodeList2));
            }
        }
    }

    public NodeTableColumn(Object object, NodeList nodeList) throws ExceptionHugin {
        this.headerValue = object;
        this.children = new LinkedList();
        this.minWidth = MIN_WIDTH;
        this.collapsed = false;
        this.viewable = true;
        if (nodeList == null || nodeList.size() == 0) {
            return;
        }
        NodeList nodeList2 = (NodeList)nodeList.clone();
        Node node = (Node)nodeList2.removeFirst();
        if (node instanceof DiscreteNode) {
            int n = ((DiscreteNode)node).getNumberOfStates();
            for (int i = 0; i < n; ++i) {
                this.children.add(new NodeTableColumn(node, i, nodeList2));
            }
        }
    }

    public NodeTableColumn(Node node, int n, NodeList nodeList, NodeTableColumnModel.CollapseList collapseList, int n2, int n3, int n4, int n5, int[] nArray) throws ExceptionHugin {
        int n6;
        int n7;
        this.headerValue = null;
        this.node = node;
        this.state = n;
        this.depth = nArray.length - 1 - n2;
        this.columnIndex = n3;
        this.columnWidth = nArray[n2];
        this.children = new LinkedList();
        this.minWidth = MIN_WIDTH;
        this.width = PREFERRED_WIDTH;
        this.viewable = true;
        if (nodeList == null || nodeList.size() == 0) {
            this.subColumnCount = 0;
            this.leftIndex = this.modelIndex = n3;
            this.rightIndex = this.leftIndex + 1;
            this.collapsed = collapseList.isCollapsed(new NodeTableColumnModel.Collapse(this.leftIndex, this.rightIndex, this.depth));
            return;
        }
        this.modelIndex = -1;
        this.leftIndex = n3;
        this.rightIndex = n3 + nArray[n2];
        this.subColumnCount = nArray[n2];
        this.collapsed = collapseList.isCollapsed(new NodeTableColumnModel.Collapse(this.leftIndex, this.rightIndex, this.depth));
        NodeList nodeList2 = (NodeList)nodeList.clone();
        Node node2 = (Node)nodeList2.removeFirst();
        int n8 = n3;
        if (node2 instanceof DiscreteChanceNode) {
            n7 = this.collapsed ? 1 : ((DiscreteNode)node2).getNumberOfStates();
            for (n6 = 0; n6 < n7; ++n6) {
                if (n8 + nArray[n2 + 1] > n4 && n8 < n5) {
                    this.children.add(new NodeTableColumn(node2, this.collapsed ? -1 : n6, nodeList2, collapseList, n2 + 1, n8, n4, n5, nArray));
                }
                n8 += nArray[n2 + 1];
            }
        }
        if (node2 instanceof DiscreteDecisionNode) {
            n7 = this.collapsed ? 1 : ((DiscreteNode)node2).getNumberOfStates();
            for (n6 = 0; n6 < n7; ++n6) {
                if (n8 + nArray[n2 + 1] > n4 && n8 < n5) {
                    this.children.add(new NodeTableColumn(node2, n6, nodeList2, collapseList, n2 + 1, n8, n4, n5, nArray));
                }
                n8 += nArray[n2 + 1];
            }
        }
    }

    @Override
    public Object getHeaderValue() {
        if (this.headerValue != null) {
            return this.headerValue;
        }
        try {
            String string = "";
            if (this.state >= 0) {
                string = HuginGUIUtils.getNodeStateLabel(this.node, this.state);
            }
            if (this.collapsed) {
                string = string + "(" + HuginGUIConstants.get("COLUMN_Collapsed") + ")";
            }
            return string;
        }
        catch (Exception exception) {
            return HuginGUIConstants.get("str_error");
        }
    }

    @Override
    public int getModelIndex() {
        return this.isCollapsed() ? -1 : this.modelIndex;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getCollapsedColumnCount() {
        if (this.isCollapsed()) {
            return 1;
        }
        if (this.modelIndex >= 0) {
            return 0;
        }
        int n = 0;
        for (NodeTableColumn nodeTableColumn : this.children) {
            n += nodeTableColumn.getCollapsedColumnCount();
        }
        return n;
    }

    public int getColumnWidth() {
        if (this.isCollapsed()) {
            return COLLAPSED_WIDTH;
        }
        if (this.modelIndex >= 0) {
            return this.getWidth();
        }
        int n = 0;
        for (NodeTableColumn nodeTableColumn : this.children) {
            n += nodeTableColumn.getColumnWidth();
        }
        return n;
    }

    public int getWidth(int n, int n2) {
        return this.getColumnWidth();
    }

    @Override
    public int getWidth() {
        if (!this.viewable) {
            return 0;
        }
        if (this.collapsed) {
            return COLLAPSED_WIDTH;
        }
        if (this.modelIndex >= 0) {
            return this.width;
        }
        return 0;
    }

    public int getTotalWidth() {
        int n = 0;
        if (this.children != null) {
            for (NodeTableColumn nodeTableColumn : this.children) {
                n += nodeTableColumn.getTotalWidth();
            }
        } else {
            n = this.getWidth();
        }
        return n;
    }

    public void setColumnWidth(int n) {
        if (n < this.minWidth) {
            return;
        }
        this.width = n;
        if (this.children != null) {
            for (NodeTableColumn nodeTableColumn : this.children) {
                nodeTableColumn.setColumnWidth(n);
            }
        }
    }

    public int getSharedWidth() {
        return this.width;
    }

    public void sizeToFit() {
    }

    @Override
    public void setWidth(int n) {
    }

    @Override
    public void setPreferredWidth(int n) {
    }

    public TableColumn getColumn(int n) {
        if (this.modelIndex == n) {
            return this;
        }
        if (n < this.leftIndex || n >= this.rightIndex) {
            return null;
        }
        if (this.isCollapsed()) {
            return this;
        }
        for (NodeTableColumn nodeTableColumn : this.children) {
            TableColumn tableColumn = nodeTableColumn.getColumn(n);
            if (tableColumn == null) continue;
            return tableColumn;
        }
        return null;
    }

    public NodeTableColumn getColumn(int n, int n2) {
        if (n >= this.children.size()) {
            return null;
        }
        if (this.isCollapsed()) {
            return this;
        }
        if (n2 == 0) {
            return this.children.get(n);
        }
        for (NodeTableColumn nodeTableColumn : this.children) {
            NodeTableColumn nodeTableColumn2 = nodeTableColumn.getColumn(n, n2 - 1);
            if (nodeTableColumn2 != null) {
                return nodeTableColumn2;
            }
            n -= nodeTableColumn.getChildCount();
        }
        return null;
    }

    public Vector<TableColumn> getColumns(Vector<TableColumn> vector, int n, int n2) {
        if (this.modelIndex >= 0 && n > this.modelIndex || !this.viewable || this.modelIndex > n2) {
            return vector;
        }
        if (!this.viewable) {
            return vector;
        }
        if (this.modelIndex >= 0) {
            vector.add(this);
            return vector;
        }
        for (NodeTableColumn nodeTableColumn : this.children) {
            nodeTableColumn.getColumns(vector, n, n2);
        }
        return vector;
    }

    public ListIterator<NodeTableColumn> getIterator() {
        return this.children.listIterator();
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getColumnCount() {
        return this.subColumnCount;
    }

    public int index(int n) {
        if (this.children.size() == 0) {
            this.subColumnCount = 0;
            this.leftIndex = this.rightIndex = (this.modelIndex = n++);
            return n;
        }
        this.modelIndex = -1;
        this.leftIndex = n;
        for (NodeTableColumn nodeTableColumn : this.children) {
            n = nodeTableColumn.index(n);
        }
        this.rightIndex = n;
        this.subColumnCount = this.rightIndex - this.leftIndex;
        return n;
    }

    @Override
    public void setResizable(boolean bl) {
        this.resizable = bl;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setViewable(boolean bl) {
        this.viewable = bl;
    }

    public boolean isViewable() {
        return this.viewable;
    }

    protected NodeTableColumnModel.Collapse collapse() {
        this.collapsed = true;
        return new NodeTableColumnModel.Collapse(this.leftIndex, this.rightIndex, this.depth);
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public NodeTableColumnModel.Collapse expand() {
        this.collapsed = false;
        return new NodeTableColumnModel.Collapse(this.leftIndex, this.rightIndex, this.depth);
    }

    public int transformColumns(int n, int[] nArray) {
        if (!this.viewable) {
            return n;
        }
        if (this.collapsed) {
            nArray[n] = this.collapsedPosition = this.getTransformPositionFor(n, nArray);
            this.modelIndex = -10;
            return n + 1;
        }
        if (this.modelIndex >= 0) {
            nArray[n] = this.modelIndex;
            return n + 1;
        }
        this.modelIndex = -1;
        for (NodeTableColumn nodeTableColumn : this.children) {
            n = nodeTableColumn.transformColumns(n, nArray);
        }
        return n;
    }

    private int getTransformPositionFor(int n, int[] nArray) {
        for (int i = n; i > 0; --i) {
            if (nArray[i] <= 0) continue;
            return nArray[i] + (n - i);
        }
        return n;
    }

    public void collapseInstantiated(LinkedList<NodeTableColumn> linkedList) throws ExceptionHugin {
        if (this.isCollapsed()) {
            return;
        }
        if (this.node.evidenceIsEntered() && !this.node.likelihoodIsEntered() && this.node instanceof DiscreteNode && ((DiscreteNode)this.node).getEnteredFinding(this.state) < 1.0) {
            linkedList.add(this);
            return;
        }
        for (NodeTableColumn nodeTableColumn : this.children) {
            nodeTableColumn.collapseInstantiated(linkedList);
        }
    }
}

