/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.NodeTableColumn;
import COM.hugin.HGUI.NodeTableColumnModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;

public class NodeTableHeader
extends JTableHeader {
    private static final String uiClassID = "NodeTableHeaderUI";
    NodeTableColumnModel columns;
    int cellHeight = 16;
    private NodeTableColumn active;
    private Point lastSeen;

    public NodeTableHeader(NodeTableColumnModel nodeTableColumnModel) {
        super(nodeTableColumnModel);
        this.columns = nodeTableColumnModel;
        this.setUI(new NodeTableHeaderUI(nodeTableColumnModel));
        this.addMouseListener(new ColumnCollapser());
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (NodeTableHeader.this.lastSeen == null) {
                    NodeTableHeader.this.lastSeen = new Point();
                }
                ((NodeTableHeader)NodeTableHeader.this).lastSeen.x = mouseEvent.getX();
                ((NodeTableHeader)NodeTableHeader.this).lastSeen.y = mouseEvent.getY();
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void updateUI() {
        this.setUI(new NodeTableHeaderUI(this.columns));
        this.resizeAndRepaint();
        this.invalidate();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.columns.getTotalColumnWidth(), this.columns.getDepth() * this.cellHeight);
    }

    public NodeTableColumn getColumnAt(int n, int n2) {
        return this.locateColumnAt(n, n2, this.columns.getRoot());
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        NodeTableColumn nodeTableColumn = this.getColumnAt(mouseEvent.getX(), mouseEvent.getY());
        if (this.active != nodeTableColumn) {
            this.active = nodeTableColumn;
            ToolTipManager.sharedInstance().mouseExited(mouseEvent);
            ToolTipManager.sharedInstance().mouseEntered(mouseEvent);
        }
        if (nodeTableColumn == null || nodeTableColumn.getHeaderValue() == null) {
            return "";
        }
        return nodeTableColumn.getHeaderValue().toString();
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return this.lastSeen;
        }
        return null;
    }

    private NodeTableColumn locateColumnAt(int n, int n2, NodeTableColumn nodeTableColumn) {
        this.cellHeight = this.getTable().getRowHeight();
        if (n2 < this.cellHeight) {
            for (NodeTableColumn nodeTableColumn2 : nodeTableColumn.children) {
                if (n < nodeTableColumn2.getWidth(this.columns.getViewPosition(), this.columns.getLastVisibleColumnIndex())) {
                    return nodeTableColumn2;
                }
                n -= nodeTableColumn2.getWidth(this.columns.getViewPosition(), this.columns.getLastVisibleColumnIndex());
            }
        }
        for (NodeTableColumn nodeTableColumn2 : nodeTableColumn.children) {
            if (n < nodeTableColumn2.getWidth(this.columns.getViewPosition(), this.columns.getLastVisibleColumnIndex())) {
                return this.locateColumnAt(n, n2 - this.cellHeight, nodeTableColumn2);
            }
            n -= nodeTableColumn2.getWidth(this.columns.getViewPosition(), this.columns.getLastVisibleColumnIndex());
        }
        return null;
    }

    private class NodeTableHeaderUI
    extends BasicTableHeaderUI {
        NodeTableColumnModel columns;

        public NodeTableHeaderUI(NodeTableColumnModel nodeTableColumnModel) {
            this.columns = nodeTableColumnModel;
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            NodeTableColumn nodeTableColumn = this.columns.getRoot();
            this.paintColumn(graphics, nodeTableColumn, 0, 0);
        }

        private void paintColumn(Graphics graphics, NodeTableColumn nodeTableColumn, int n, int n2) {
            if (nodeTableColumn.isCollapsed()) {
                this.paintCollapsedColumn(graphics, nodeTableColumn.getDepth(), nodeTableColumn.getWidth(), n, n2);
                return;
            }
            if (nodeTableColumn.getModelIndex() >= 0) {
                return;
            }
            NodeTableHeader.this.cellHeight = NodeTableHeader.this.getTable().getRowHeight();
            if ((double)n2 > graphics.getClipBounds().getY() + graphics.getClipBounds().getHeight()) {
                return;
            }
            for (NodeTableColumn nodeTableColumn2 : nodeTableColumn.children) {
                if (!nodeTableColumn2.isViewable()) continue;
                Component component = NodeTableHeader.this.getDefaultRenderer().getTableCellRendererComponent(NodeTableHeader.this.getTable(), nodeTableColumn2.getHeaderValue(), false, false, 0, 0);
                component.setSize(new Dimension(nodeTableColumn2.getWidth(this.columns.getViewPosition(), this.columns.getLastVisibleColumnIndex()), NodeTableHeader.this.cellHeight));
                this.rendererPane.add(component);
                this.rendererPane.paintComponent(graphics, component, NodeTableHeader.this, n, n2, nodeTableColumn2.getWidth(this.columns.getViewPosition(), this.columns.getLastVisibleColumnIndex()), NodeTableHeader.this.cellHeight);
                this.paintColumn(graphics, nodeTableColumn2, n, n2 + NodeTableHeader.this.cellHeight);
                n += nodeTableColumn2.getWidth(this.columns.getViewPosition(), this.columns.getLastVisibleColumnIndex());
            }
        }

        private void paintCollapsedColumn(Graphics graphics, int n, int n2, int n3, int n4) {
            Component component = NodeTableHeader.this.getDefaultRenderer().getTableCellRendererComponent(NodeTableHeader.this.getTable(), "...", false, false, 0, 0);
            component.setSize(new Dimension(n2, NodeTableHeader.this.cellHeight));
            for (int i = 0; i < n; ++i) {
                this.rendererPane.add(component);
                this.rendererPane.paintComponent(graphics, component, NodeTableHeader.this, n3, n4 + i * NodeTableHeader.this.cellHeight, n2, NodeTableHeader.this.cellHeight);
            }
        }
    }

    private class ColumnCollapser
    extends MouseAdapter {
        private ColumnCollapser() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() % 2 == 0) {
                NodeTableColumn nodeTableColumn = NodeTableHeader.this.getColumnAt(mouseEvent.getX(), mouseEvent.getY());
                if (nodeTableColumn == null) {
                    return;
                }
                try {
                    if (NodeTableHeader.this.columns.canCollapse(nodeTableColumn)) {
                        if (!nodeTableColumn.isCollapsed()) {
                            NodeTableHeader.this.columns.collapseColumn(nodeTableColumn);
                        } else {
                            NodeTableHeader.this.columns.expandColumn(nodeTableColumn);
                        }
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        }
    }
}

