/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Expression;
import COM.hugin.HAPI.FunctionNode;
import COM.hugin.HAPI.IfExpression;
import COM.hugin.HAPI.InstanceNode;
import COM.hugin.HAPI.Model;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.ExpressionTableModel;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginPrintablePage;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NodeTableFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.util.AbstractSequentialList;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class NodeTablePage
extends HuginPrintablePage {
    public static final int PRINT_ALL_TABLES = 0;
    public static final int PRINT_SELECTED_TABLES = 1;
    public static final int PRINT_OPEN_TABLES = 2;
    NetworkPanel networkPanel;
    LinkedList<Node> nodes;
    ListIterator<Node> currentNode;
    boolean done;
    boolean printNetName;
    boolean printDate;
    NodeTablePrintJob job;
    double scaleFactor;
    int precision = 6;
    Node node;
    private int lastPrintedPage = -1;
    private int textHeight = 0;

    public NodeTablePage(NetworkPanel networkPanel, int n, boolean bl, boolean bl2, double d) {
        Object object;
        Object object2;
        this.networkPanel = networkPanel;
        switch (n) {
            case 0: {
                this.nodes = new LinkedList<Node>(networkPanel.nodeList);
                break;
            }
            case 1: {
                this.nodes = new LinkedList<Node>(networkPanel.selectedNodes);
                break;
            }
            case 2: {
                object2 = networkPanel.projectFrame.getTablePanel().getVisibleTables();
                this.nodes = new LinkedList();
                object = ((AbstractSequentialList)object2).iterator();
                while (object.hasNext()) {
                    NodeTableFrame nodeTableFrame = (NodeTableFrame)object.next();
                    this.nodes.add(nodeTableFrame.getNode());
                }
                break;
            }
            default: {
                this.nodes = new LinkedList();
            }
        }
        object2 = this.nodes.listIterator();
        while (object2.hasNext()) {
            object = (Node)object2.next();
            if (!(((Node)object).getAPINode() instanceof InstanceNode)) continue;
            object2.remove();
        }
        this.currentNode = this.nodes.listIterator();
        this.done = this.nodes.size() == 0;
        this.printDate = bl2;
        this.printNetName = bl;
        this.scaleFactor = d;
        this.node = null;
        this.job = null;
    }

    public void reset() {
        this.lastPrintedPage = -1;
        this.node = null;
        this.job = null;
        this.currentNode = this.nodes.listIterator();
        this.done = this.nodes.size() == 0;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (Math.abs(n - this.lastPrintedPage) > 1) {
            this.moveToPageIndex(n, pageFormat);
        }
        RepaintManager repaintManager = RepaintManager.currentManager(this.networkPanel);
        repaintManager.setDoubleBufferingEnabled(false);
        graphics.setFont(new Font(HuginGUIConstants.defaultFont.getName(), 0, 8));
        boolean bl = false;
        try {
            int n2 = 0;
            int n3 = 0;
            if (this.printNetName) {
                this.textHeight = this.printCenteredText(graphics, this.networkPanel.projectFrame.getTitle(), (int)pageFormat.getWidth() / 2, (int)pageFormat.getImageableY() + 8, 1);
            }
            if (this.printDate) {
                this.textHeight = this.printCenteredText(graphics, new Date().toString(), (int)pageFormat.getWidth() / 2, (int)(pageFormat.getImageableHeight() + pageFormat.getImageableY()), 3);
                n2 += 4 * this.textHeight;
            }
            graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY() + 10);
            n3 += 10;
            boolean bl2 = false;
            while ((this.currentNode.hasNext() || this.job != null && this.job.hasNext()) && !bl2 && this.lastPrintedPage == n) {
                boolean bl3;
                if (this.job == null || !this.job.hasNext()) {
                    this.node = this.currentNode.next();
                    this.precision = this.getPrecision(this.node.getAPINode());
                    this.job = new NodeTablePrintJob(new NodeTableInfo(this.node), (int)pageFormat.getImageableWidth(), this.scaleFactor);
                    bl = false;
                }
                boolean bl4 = bl3 = this.job != null && this.job.hasNext();
                if (!bl3) {
                    this.node = this.currentNode.next();
                    this.precision = this.getPrecision(this.node.getAPINode());
                    this.job = new NodeTablePrintJob(new NodeTableInfo(this.node), (int)pageFormat.getImageableWidth(), this.scaleFactor);
                    if (this.job != null && this.job.getHeight() + n3 + 20 > (int)pageFormat.getImageableHeight() - n2) {
                        bl2 = true;
                        bl = false;
                    } else {
                        bl = true;
                        graphics.setColor(Color.black);
                        graphics.drawString(HuginGUIUtils.getNodeTitle(this.node.getAPINode()), 0, 15);
                        n3 += 20;
                        graphics.translate(0, 20);
                    }
                }
                if (!bl) {
                    n3 += 20;
                }
                while (this.job.hasNext() && !bl2) {
                    if (n3 + this.job.getHeight() > (int)pageFormat.getImageableHeight() - n2) {
                        bl2 = true;
                        continue;
                    }
                    if (this.job != null && !bl) {
                        bl = true;
                        graphics.setColor(Color.black);
                        graphics.drawString(HuginGUIUtils.getNodeTitle(this.node.getAPINode()), 0, 15);
                        graphics.translate(0, 20);
                    }
                    int n4 = this.job.printNext(graphics);
                    n3 += n4 + 10;
                    graphics.translate(0, n4 + 10);
                }
            }
            if (!this.done) {
                this.done = !this.currentNode.hasNext() && this.job != null && !this.job.hasNext();
                repaintManager.setDoubleBufferingEnabled(true);
                this.lastPrintedPage = n;
                return 0;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        repaintManager.setDoubleBufferingEnabled(true);
        return 1;
    }

    private int moveToPageIndex(int n, PageFormat pageFormat) {
        this.reset();
        int n2 = 0;
        boolean bl = false;
        Graphics graphics = new BufferedImage(1, 1, 12).getGraphics();
        graphics.setClip(0, 0, 0, 0);
        try {
            int n3 = 0;
            int n4 = 0;
            if (this.printDate) {
                n3 += 4 * this.textHeight;
            }
            boolean bl2 = false;
            while (this.currentNode.hasNext() || this.job != null && this.job.hasNext()) {
                boolean bl3;
                if (bl2) {
                    if (++n2 == n) {
                        this.lastPrintedPage = n - 1;
                        return 0;
                    }
                    n4 += 10;
                }
                bl2 = false;
                if (this.job == null || !this.job.hasNext()) {
                    this.node = this.currentNode.next();
                    this.precision = this.getPrecision(this.node.getAPINode());
                    this.job = new NodeTablePrintJob(new NodeTableInfo(this.node), (int)pageFormat.getImageableWidth(), this.scaleFactor);
                    bl = false;
                }
                boolean bl4 = bl3 = this.job != null && this.job.hasNext();
                if (!bl3) {
                    this.node = this.currentNode.next();
                    this.precision = this.getPrecision(this.node.getAPINode());
                    this.job = new NodeTablePrintJob(new NodeTableInfo(this.node), (int)pageFormat.getImageableWidth(), this.scaleFactor);
                    if (this.job != null && this.job.getHeight() + n4 + 20 > (int)pageFormat.getImageableHeight() - n3) {
                        bl2 = true;
                        n4 = 0;
                        bl = false;
                    } else {
                        bl = true;
                        n4 += 20;
                    }
                }
                if (!bl) {
                    n4 += 20;
                }
                while (this.job.hasNext() && !bl2) {
                    if (n4 + this.job.getHeight() > (int)pageFormat.getImageableHeight() - n3) {
                        bl2 = true;
                        n4 = 0;
                        continue;
                    }
                    if (this.job != null && !bl) {
                        bl = true;
                    }
                    int n5 = this.job.printNext(graphics);
                    n4 += n5 + 10;
                }
            }
            if (!this.done) {
                this.done = !this.currentNode.hasNext() && this.job != null && !this.job.hasNext();
                this.lastPrintedPage = n2;
                return 0;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return 1;
    }

    private int getPrecision(COM.hugin.HAPI.Node node) {
        try {
            String string = node.getAttribute("HR_TablePrecision");
            if (string == null || string.trim().length() == 0) {
                string = node.getHome().getAttribute("HR_Node_TablePrecision");
            }
            if (string == null || string.trim().length() == 0) {
                string = "6";
            }
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 6;
        }
    }

    private class NodeTablePrintJob {
        private NodeTableInfo table;
        private int paperWidth;
        private int position;
        private double[] data;
        private double[] experienceData = null;
        private double[] fadingData = null;
        private String[] expressions;
        int columnCount = 0;
        double scale = 0.7;
        float fontSize = 10.0f;
        int textCellWidth = 50;
        int cellWidth = 50;
        int maxExpIndex;
        int rowHeight = 16;
        int cptSeparator = 2;
        NodeList nodes;
        COM.hugin.HAPI.Node node;

        public NodeTablePrintJob(NodeTableInfo nodeTableInfo, int n) throws ExceptionHugin {
            this.table = nodeTableInfo;
            this.cellWidth = (int)((double)(NodeTablePage.this.precision + 2) * 7.0);
            if (this.cellWidth < this.textCellWidth) {
                this.cellWidth = this.textCellWidth;
            }
            this.paperWidth = n;
            this.position = 0;
            this.data = null;
            this.node = nodeTableInfo.getNode();
            if (this.node == null) {
                return;
            }
            if (nodeTableInfo.showExpressions()) {
                Model model = this.node.getModel();
                this.nodes = model.getNodes();
                this.nodes.remove(this.node);
                this.expressions = new String[model.getSize()];
                for (int i = 0; i < this.expressions.length; ++i) {
                    Expression expression = model.getExpression(i);
                    this.expressions[i] = expression instanceof IfExpression && ((Expression)((IfExpression)expression).getOperands().get(1)).expressionToString().equals("\"HR_Syntax_Error:\"") ? ExpressionTableModel.extractInvalidExpression(expression) : (expression == null ? HuginGUIConstants.get("str_undefined") : HuginGUIUtils.convertOctals(expression.expressionToString()));
                }
                this.columnCount = this.expressions.length;
            } else {
                if (this.node instanceof DiscreteNode) {
                    this.nodes = this.node.getTable().getNodes();
                    this.nodes.remove(this.node);
                    this.data = this.node.getTable().getData();
                    if (this.node instanceof DiscreteChanceNode && ((DiscreteChanceNode)this.node).hasFadingTable()) {
                        this.fadingData = ((DiscreteChanceNode)this.node).getFadingTable().getData();
                    }
                    if (this.node instanceof DiscreteChanceNode && ((DiscreteChanceNode)this.node).hasExperienceTable()) {
                        this.experienceData = ((DiscreteChanceNode)this.node).getExperienceTable().getData();
                    }
                    this.columnCount = this.data.length / ((DiscreteNode)this.node).getNumberOfStates();
                }
                if (this.node instanceof UtilityNode || this.node instanceof ContinuousChanceNode) {
                    this.nodes = this.node.getTable().getNodes();
                    this.data = this.node.getTable().getData();
                    this.columnCount = this.data.length;
                }
                if (this.nodes != null) {
                    ListIterator listIterator = this.nodes.listIterator();
                    while (listIterator.hasNext()) {
                        COM.hugin.HAPI.Node node = (COM.hugin.HAPI.Node)listIterator.next();
                        if (!(node instanceof ContinuousChanceNode)) continue;
                        listIterator.remove();
                    }
                }
            }
        }

        public NodeTablePrintJob(NodeTableInfo nodeTableInfo, int n, double d) throws ExceptionHugin {
            this(nodeTableInfo, n);
            this.scale *= d;
        }

        public int getHeight() {
            if (this.nodes == null) {
                return 0;
            }
            if (this.table.showExpressions()) {
                return (int)((double)((this.nodes.size() + 1) * this.rowHeight) * this.scale);
            }
            return (int)((double)(this.nodes.size() * this.rowHeight + this.table.getRowCount() * this.rowHeight + (this.table.showExperience() ? this.rowHeight : 0) + (this.table.showFading() ? this.rowHeight : 0) + (this.table.showExperience() || this.table.showFading() ? this.cptSeparator : 0)) * this.scale);
        }

        public boolean hasNext() {
            if (this.nodes == null) {
                return false;
            }
            return this.position < this.columnCount;
        }

        public int printNext(Graphics graphics) throws ExceptionHugin {
            JTextField jTextField;
            int n;
            int n2;
            if (this.nodes == null) {
                return 0;
            }
            this.maxExpIndex = -1;
            if (this.table.showExpressions()) {
                FontMetrics fontMetrics = graphics.getFontMetrics();
                n2 = this.cellWidth;
                for (int i = 0; i < this.expressions.length; ++i) {
                    if (fontMetrics.stringWidth(this.expressions[i]) <= n2) continue;
                    this.maxExpIndex = i;
                    n2 = fontMetrics.stringWidth(this.expressions[i]);
                }
            }
            int n3 = this.printStates(graphics);
            n2 = this.printHeader(graphics, n3);
            if (this.node instanceof ContinuousChanceNode) {
                return this.printContNodeTable(graphics, n3, n2);
            }
            if (this.table.showExpressions()) {
                return this.printExpNodeTable(graphics, n3, n2);
            }
            JPanel jPanel = new JPanel();
            int n4 = (int)((double)this.cellWidth * this.scale);
            int n5 = (int)((double)this.rowHeight * this.scale);
            int n6 = this.table.getRowCount();
            int n7 = 0;
            for (int i = 0; i < n6; ++i) {
                n = n3;
                n7 = 0;
                while (this.position + n7 < this.columnCount && n < this.paperWidth - n4) {
                    n += n4;
                    jTextField = new JTextField("" + HuginGUIUtils.printDouble(this.data[(n7 + this.position) * n6 + i], NodeTablePage.this.precision));
                    jPanel.add(jTextField);
                    jTextField.setSize(new Dimension(n4, n5));
                    jTextField.setFont(jTextField.getFont().deriveFont((float)((double)this.fontSize * this.scale)));
                    graphics.setFont(jTextField.getFont());
                    SwingUtilities.paintComponent(graphics, jTextField, jPanel, n3 + n7 * jTextField.getWidth(), n2 + i * jTextField.getHeight(), jTextField.getWidth(), jTextField.getHeight());
                    ++n7;
                }
            }
            n = n3;
            if (this.table.showExperience() || this.table.showFading()) {
                n7 = 0;
                while (this.position + n7 < this.columnCount && n < this.paperWidth - n4) {
                    n += n4;
                    if (this.table.showExperience()) {
                        jTextField = new JTextField("" + HuginGUIUtils.printDouble(this.experienceData[n7 + this.position]));
                        jTextField.setSize(new Dimension(n4, n5));
                        jTextField.setFont(jTextField.getFont().deriveFont((float)((double)this.fontSize * this.scale)));
                        graphics.setFont(jTextField.getFont());
                        SwingUtilities.paintComponent(graphics, jTextField, jPanel, n3 + n7 * jTextField.getWidth(), n2 + this.cptSeparator + n6 * jTextField.getHeight(), jTextField.getWidth(), jTextField.getHeight());
                    }
                    if (this.table.showFading()) {
                        jTextField = new JTextField("" + HuginGUIUtils.printDouble(this.fadingData[n7 + this.position], NodeTablePage.this.precision));
                        jTextField.setSize(new Dimension(n4, n5));
                        jTextField.setFont(jTextField.getFont().deriveFont((float)((double)this.fontSize * this.scale)));
                        graphics.setFont(jTextField.getFont());
                        SwingUtilities.paintComponent(graphics, jTextField, jPanel, n3 + n7 * jTextField.getWidth(), n2 + this.cptSeparator + (n6 + (this.table.showExperience() ? 1 : 0)) * jTextField.getHeight(), jTextField.getWidth(), jTextField.getHeight());
                    }
                    ++n7;
                }
            }
            this.position += n7;
            return n2 + (n6 + (this.table.showExperience() ? 1 : 0) + (this.table.showFading() ? 1 : 0)) * n5;
        }

        private int printContNodeTable(Graphics graphics, int n, int n2) throws ExceptionHugin {
            JPanel jPanel = new JPanel();
            int n3 = (int)((double)this.cellWidth * this.scale);
            int n4 = (int)((double)this.rowHeight * this.scale);
            int n5 = this.table.getRowCount();
            JTextField jTextField = new JTextField();
            int n6 = 0;
            ContinuousChanceNode continuousChanceNode = (ContinuousChanceNode)this.table.getNode();
            int n7 = n;
            jTextField.setFont(jTextField.getFont().deriveFont((float)((double)this.fontSize * this.scale)));
            graphics.setFont(jTextField.getFont());
            n6 = 0;
            while (this.position + n6 < this.columnCount && n7 < this.paperWidth - n3) {
                n7 += n3;
                jTextField.setText("" + continuousChanceNode.getAlpha(n6 + this.position));
                jTextField.setSize(new Dimension(n3, n4));
                SwingUtilities.paintComponent(graphics, jTextField, jPanel, n + n6 * jTextField.getWidth(), n2 + 0, jTextField.getWidth(), jTextField.getHeight());
                ++n6;
            }
            NodeList nodeList = continuousChanceNode.getTable().getNodes();
            int n8 = 1;
            for (COM.hugin.HAPI.Node node : nodeList) {
                if (!(node instanceof ContinuousChanceNode) || node == continuousChanceNode) continue;
                n7 = n;
                n6 = 0;
                while (this.position + n6 < this.columnCount && n7 < this.paperWidth - n3) {
                    n7 += n3;
                    jTextField.setText("" + continuousChanceNode.getBeta((ContinuousChanceNode)node, n6 + this.position));
                    jTextField.setSize(new Dimension(n3, n4));
                    SwingUtilities.paintComponent(graphics, jTextField, jPanel, n + n6 * jTextField.getWidth(), n2 + n8 * jTextField.getHeight(), jTextField.getWidth(), jTextField.getHeight());
                    ++n6;
                }
                ++n8;
            }
            n7 = n;
            n6 = 0;
            while (this.position + n6 < this.columnCount && n7 < this.paperWidth - n3) {
                n7 += n3;
                jTextField.setText("" + continuousChanceNode.getGamma(n6 + this.position));
                jTextField.setSize(new Dimension(n3, n4));
                SwingUtilities.paintComponent(graphics, jTextField, jPanel, n + n6 * jTextField.getWidth(), n2 + (n5 - 1) * jTextField.getHeight(), jTextField.getWidth(), jTextField.getHeight());
                ++n6;
            }
            this.position += n6;
            return n2 + n5 * n4;
        }

        private int printExpNodeTable(Graphics graphics, int n, int n2) throws ExceptionHugin {
            JPanel jPanel = new JPanel();
            int n3 = (int)((double)this.cellWidth * this.scale);
            int n4 = (int)((double)this.rowHeight * this.scale);
            int n5 = this.table.getRowCount();
            JTextField jTextField = new JTextField();
            int n6 = 0;
            jTextField.setFont(jTextField.getFont().deriveFont((float)((double)this.fontSize * this.scale)));
            graphics.setFont(jTextField.getFont());
            if (this.maxExpIndex >= 0) {
                n3 = jTextField.getFontMetrics(jTextField.getFont()).stringWidth(this.expressions[this.maxExpIndex]);
            }
            int n7 = n;
            for (n6 = 0; this.position + n6 < this.columnCount && (n6 == 0 || n7 < this.paperWidth - n3); n7 += n3, ++n6) {
                jTextField.setText(this.expressions[n6 + this.position]);
                jTextField.setSize(new Dimension(n3, n4));
                SwingUtilities.paintComponent(graphics, jTextField, jPanel, n + n6 * jTextField.getWidth(), n2, jTextField.getWidth(), jTextField.getHeight());
            }
            this.position = n6 + this.position;
            return this.getHeight();
        }

        private int printStates(Graphics graphics) throws ExceptionHugin {
            Object object;
            int n = (int)((double)(this.nodes.size() * this.rowHeight) * this.scale);
            JPanel jPanel = new JPanel();
            int n2 = (int)((double)this.textCellWidth * 1.5 * this.scale);
            int n3 = (int)((double)this.rowHeight * this.scale);
            JTextField jTextField = new JTextField();
            Color color = new Color(150, 150, 150);
            int n4 = 0;
            jTextField.setBackground(color);
            jTextField.setFont(jTextField.getFont().deriveFont((float)((double)this.fontSize * this.scale)));
            graphics.setFont(jTextField.getFont());
            for (COM.hugin.HAPI.Node node : this.nodes) {
                jTextField.setText(node.getName());
                jTextField.setSize(new Dimension(n2, n3));
                SwingUtilities.paintComponent(graphics, jTextField, jPanel, 0, n3 * n4, jTextField.getWidth(), jTextField.getHeight());
                ++n4;
            }
            color = new Color(190, 190, 190);
            jTextField.setBackground(color);
            if (this.table.showExpressions()) {
                jTextField.setText(HuginGUIConstants.get("str_expression"));
                jTextField.setSize(new Dimension(n2, n3));
                SwingUtilities.paintComponent(graphics, jTextField, jPanel, 0, n, jTextField.getWidth(), jTextField.getHeight());
                return n2;
            }
            for (n4 = 0; n4 < this.table.getRowCount(); ++n4) {
                object = this.table.getStateValue(n4);
                jTextField.setText((String)object);
                jTextField.setSize(new Dimension(n2, n3));
                SwingUtilities.paintComponent(graphics, jTextField, jPanel, 0, n + n3 * n4, jTextField.getWidth(), jTextField.getHeight());
            }
            jTextField.setSize(new Dimension(n2, n3));
            if (this.table.showExperience()) {
                object = HuginGUIConstants.get("str_experience");
                jTextField.setText((String)object);
                jTextField.setSize(new Dimension(n2, n3));
                SwingUtilities.paintComponent(graphics, jTextField, jPanel, 0, n + this.cptSeparator + n3 * n4, jTextField.getWidth(), jTextField.getHeight());
            }
            if (this.table.showFading()) {
                object = HuginGUIConstants.get("str_fading");
                jTextField.setText((String)object);
                jTextField.setSize(new Dimension(n2, n3));
                SwingUtilities.paintComponent(graphics, jTextField, jPanel, 0, n + this.cptSeparator + n3 * (n4 + (this.table.showExperience() ? 1 : 0)), jTextField.getWidth(), jTextField.getHeight());
            }
            return n2;
        }

        private int printHeader(Graphics graphics, int n) throws ExceptionHugin {
            JPanel jPanel = new JPanel();
            int[] nArray = this.getCellWidths(this.nodes);
            String[][] stringArray = this.getNodeLabels(this.nodes);
            int n2 = (int)((double)this.cellWidth * this.scale);
            int n3 = (int)((double)this.rowHeight * this.scale);
            JTextField jTextField = new JTextField();
            int n4 = 0;
            jTextField.setBackground(new Color(190, 190, 190));
            jTextField.setHorizontalAlignment(0);
            jTextField.setFont(jTextField.getFont().deriveFont((float)((double)this.fontSize * this.scale)));
            graphics.setFont(jTextField.getFont());
            if (this.maxExpIndex >= 0) {
                n2 = jTextField.getFontMetrics(jTextField.getFont()).stringWidth(this.expressions[this.maxExpIndex]);
            }
            for (int i = 1; i < nArray.length; ++i) {
                int n5;
                int n6 = n;
                for (n4 = 0; n4 + this.position < nArray[0] && (n4 == 0 || n6 < this.paperWidth); n6 += n5, n4 += nArray[i] - (this.position + n4) % nArray[i]) {
                    jTextField.setText(stringArray[i - 1][(n4 + this.position) / nArray[i] % stringArray[i - 1].length]);
                    n5 = Math.min(n2 * (nArray[i] - (this.position + n4) % nArray[i]), this.paperWidth - n6 - (this.paperWidth - n6) % n2);
                    jTextField.setSize(new Dimension(n5, n3));
                    SwingUtilities.paintComponent(graphics, jTextField, jPanel, n + n2 * n4, n3 * (i - 1), jTextField.getWidth(), jTextField.getHeight());
                }
            }
            return (int)((double)(this.nodes.size() * this.rowHeight) * this.scale);
        }

        private int[] getCellWidths(NodeList nodeList) throws ExceptionHugin {
            int n = 0;
            for (COM.hugin.HAPI.Node node : nodeList) {
                if (!(node instanceof DiscreteNode)) continue;
                ++n;
            }
            Object object = new int[n + 1];
            if (((Object)object).length == 0) {
                return object;
            }
            object[((Object)object).length - 1] = true;
            if (((Object)object).length == 1) {
                return object;
            }
            int n2 = ((Object)object).length - 1;
            ListIterator listIterator = nodeList.listIterator(nodeList.size());
            while (listIterator.hasPrevious()) {
                COM.hugin.HAPI.Node node = (COM.hugin.HAPI.Node)listIterator.previous();
                if (!(node instanceof DiscreteNode)) continue;
                object[n2 - 1] = object[n2] * ((DiscreteNode)node).getNumberOfStates();
                --n2;
            }
            return object;
        }

        private String[][] getNodeLabels(NodeList nodeList) throws ExceptionHugin {
            String[][] stringArray = new String[nodeList.size()][];
            int n = 0;
            for (COM.hugin.HAPI.Node node : nodeList) {
                if (node instanceof DiscreteNode) {
                    stringArray[n] = new String[((DiscreteNode)node).getNumberOfStates()];
                    for (int i = 0; i < stringArray[n].length; ++i) {
                        stringArray[n][i] = ((DiscreteNode)node).getStateLabel(i);
                    }
                }
                ++n;
            }
            return stringArray;
        }
    }

    private class NodeTableInfo {
        boolean showCPT;
        boolean showExpressions;
        boolean showExperience;
        boolean showFading;
        int rowCount;
        COM.hugin.HAPI.Node node;

        public NodeTableInfo(Node node) throws ExceptionHugin {
            this.node = node.getAPINode();
            if (node.getTable() != null) {
                this.showCPT = true;
                this.showFading = node.getTable().getTable().showFading();
                this.showExperience = node.getTable().getTable().showExperience();
                this.showExpressions = node.getTable().getTable().showExpressions();
            } else {
                this.showFading = this.node instanceof DiscreteChanceNode && ((DiscreteChanceNode)this.node).hasFadingTable();
                this.showExperience = this.node instanceof DiscreteChanceNode && ((DiscreteChanceNode)this.node).hasExperienceTable();
                this.showExpressions = (this.node instanceof DiscreteChanceNode || this.node instanceof UtilityNode || this.node instanceof FunctionNode) && this.node.getModel() != null;
                boolean bl = this.showCPT = !this.showExpressions;
            }
            if (this.showCPT && this.node instanceof DiscreteNode) {
                this.rowCount = ((DiscreteNode)this.node).getNumberOfStates();
            } else if (this.node instanceof ContinuousChanceNode) {
                this.rowCount = 2;
                for (COM.hugin.HAPI.Node node2 : this.node.getParents()) {
                    if (!(node2 instanceof ContinuousChanceNode)) continue;
                    ++this.rowCount;
                }
            } else {
                this.rowCount = 1;
            }
        }

        public boolean showExpressions() {
            return this.showExpressions;
        }

        public boolean showFading() {
            return this.showFading;
        }

        public boolean showExperience() {
            return this.showExperience;
        }

        public boolean showCPT() {
            return this.showCPT;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public String getStateValue(int n) throws ExceptionHugin {
            if (this.node instanceof DiscreteNode) {
                return ((DiscreteNode)this.node).getStateLabel(n);
            }
            if (this.node instanceof UtilityNode) {
                return HuginGUIConstants.get("str_utility");
            }
            if (this.node instanceof ContinuousChanceNode) {
                if (n == 0) {
                    return HuginGUIConstants.get("str_mean");
                }
                if (n == this.rowCount - 1) {
                    return HuginGUIConstants.get("str_variance");
                }
                int n2 = 1;
                for (COM.hugin.HAPI.Node node : this.node.getParents()) {
                    if (!(node instanceof ContinuousChanceNode)) continue;
                    if (n == n2) {
                        return HuginGUIUtils.getNodeTitle(node);
                    }
                    ++n2;
                }
            }
            return "";
        }

        public COM.hugin.HAPI.Node getNode() {
            return this.node;
        }
    }
}

