/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Expression;
import COM.hugin.HAPI.IfExpression;
import COM.hugin.HAPI.Model;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.ExpressionTableModel;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.NodeTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class NodeTablePrintJob {
    private NodeTable table;
    private int paperWidth;
    private int position;
    private double[] data;
    private double[] experienceData = null;
    private double[] fadingData = null;
    private String[] expressions;
    int columnCount = 0;
    double scale = 0.7;
    float fontSize = 10.0f;
    int textCellWidth = 50;
    int cellWidth = 50;
    int maxExpIndex;
    int rowHeight = 16;
    int cptSeparator = 2;
    NodeList nodes;
    Node node;

    public NodeTablePrintJob(NodeTable nodeTable, int n) throws ExceptionHugin {
        this.table = nodeTable;
        this.paperWidth = n;
        this.position = 0;
        this.data = null;
        this.node = nodeTable.getNode();
        int n2 = this.getPrecision(this.node);
        this.cellWidth = (int)((double)(n2 + 2) * 7.0);
        if (this.cellWidth < this.textCellWidth) {
            this.cellWidth = this.textCellWidth;
        }
        if (nodeTable.showExpressions()) {
            Model model = this.node.getModel();
            this.nodes = model.getNodes();
            this.nodes.remove(this.node);
            this.expressions = new String[model.getSize()];
            for (int i = 0; i < this.expressions.length; ++i) {
                Expression expression = model.getExpression(i);
                this.expressions[i] = expression instanceof IfExpression && ((Expression)((IfExpression)expression).getOperands().get(1)).expressionToString().equals("\"HR_Syntax_Error:\"") ? ExpressionTableModel.extractInvalidExpression(expression) : (expression == null ? HuginGUIConstants.get("str_undefined") : HuginGUIUtils.convertOctals(expression.expressionToString()));
            }
            this.columnCount = this.expressions.length;
        } else {
            if (this.node instanceof DiscreteNode) {
                this.nodes = this.node.getTable().getNodes();
                this.nodes.remove(this.node);
                this.data = this.node.getTable().getData();
                if (this.node instanceof DiscreteChanceNode && ((DiscreteChanceNode)this.node).hasFadingTable()) {
                    this.fadingData = ((DiscreteChanceNode)this.node).getFadingTable().getData();
                }
                if (this.node instanceof DiscreteChanceNode && ((DiscreteChanceNode)this.node).hasExperienceTable()) {
                    this.experienceData = ((DiscreteChanceNode)this.node).getExperienceTable().getData();
                }
                this.columnCount = this.data.length / ((DiscreteNode)this.node).getNumberOfStates();
            }
            if (this.node instanceof UtilityNode || this.node instanceof ContinuousChanceNode) {
                this.nodes = this.node.getTable().getNodes();
                this.data = this.node.getTable().getData();
                this.columnCount = this.data.length;
            }
            ListIterator listIterator = this.nodes.listIterator();
            while (listIterator.hasNext()) {
                if (!(listIterator.next() instanceof ContinuousChanceNode)) continue;
                listIterator.remove();
            }
        }
    }

    public NodeTablePrintJob(NodeTable nodeTable, int n, double d) throws ExceptionHugin {
        this(nodeTable, n);
        this.scale = d;
    }

    private int getPrecision(Node node) {
        try {
            String string = node.getAttribute("HR_TablePrecision");
            if (string == null || string.trim().length() == 0) {
                string = node.getHome().getAttribute("HR_Node_TablePrecision");
            }
            if (string == null || string.trim().length() == 0) {
                string = "6";
            }
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 6;
        }
    }

    public int getHeight() {
        if (this.table.showExpressions()) {
            return (int)((double)((this.nodes.size() + 1) * this.rowHeight) * this.scale);
        }
        return (int)((double)(this.nodes.size() * this.rowHeight + this.table.getStateTable().getRowCount() * this.rowHeight + (this.table.showExperience() ? this.rowHeight : 0) + (this.table.showFading() ? this.rowHeight : 0) + (this.table.showExperience() || this.table.showFading() ? this.cptSeparator : 0)) * this.scale);
    }

    public boolean hasNext() {
        return this.position < this.columnCount;
    }

    public int printNext(Graphics graphics) throws ExceptionHugin {
        Component component;
        int n;
        int n2;
        this.maxExpIndex = -1;
        if (this.table.showExpressions()) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n2 = this.cellWidth;
            for (int i = 0; i < this.expressions.length; ++i) {
                if (fontMetrics.stringWidth(this.expressions[i]) <= n2) continue;
                this.maxExpIndex = i;
                n2 = fontMetrics.stringWidth(this.expressions[i]);
            }
        }
        int n3 = this.printStates(graphics);
        n2 = this.printHeader(graphics, n3);
        if (this.node instanceof ContinuousChanceNode) {
            return this.printContNodeTable(graphics, n3, n2);
        }
        if (this.table.showExpressions()) {
            return this.printExpNodeTable(graphics, n3, n2);
        }
        JPanel jPanel = new JPanel();
        int n4 = (int)((double)this.cellWidth * this.scale);
        int n5 = (int)((double)this.rowHeight * this.scale);
        int n6 = this.table.getStateTable().getRowCount();
        int n7 = 0;
        for (int i = 0; i < n6; ++i) {
            n = n3;
            n7 = 0;
            while (this.position + n7 < this.columnCount && n < this.paperWidth - n4) {
                n += n4;
                component = this.table.getCPT().getDefaultRenderer(Double.class).getTableCellRendererComponent(this.table.getCPT(), "" + this.data[(n7 + this.position) * n6 + i], false, false, i, n7);
                ((JComponent)component).setBorder(BorderFactory.createLineBorder(Color.gray));
                component.setSize(new Dimension(n4, n5));
                component.setFont(component.getFont().deriveFont((float)((double)this.fontSize * this.scale)));
                SwingUtilities.paintComponent(graphics, component, jPanel, n3 + n7 * component.getWidth(), n2 + i * component.getHeight(), component.getWidth(), component.getHeight());
                ++n7;
            }
        }
        n = n3;
        if (this.table.showExperience() || this.table.showFading()) {
            n7 = 0;
            while (this.position + n7 < this.columnCount && n < this.paperWidth - n4) {
                n += n4;
                if (this.table.showExperience()) {
                    component = new JTextField("" + this.experienceData[n7 + this.position]);
                    component.setSize(new Dimension(n4, n5));
                    component.setFont(component.getFont().deriveFont((float)((double)this.fontSize * this.scale)));
                    SwingUtilities.paintComponent(graphics, component, jPanel, n3 + n7 * component.getWidth(), n2 + this.cptSeparator + n6 * component.getHeight(), component.getWidth(), component.getHeight());
                }
                if (this.table.showFading()) {
                    component = new JTextField("" + this.fadingData[n7 + this.position]);
                    component.setSize(new Dimension(n4, n5));
                    component.setFont(component.getFont().deriveFont((float)((double)this.fontSize * this.scale)));
                    SwingUtilities.paintComponent(graphics, component, jPanel, n3 + n7 * component.getWidth(), n2 + this.cptSeparator + (n6 + (this.table.showExperience() ? 1 : 0)) * component.getHeight(), component.getWidth(), component.getHeight());
                }
                ++n7;
            }
        }
        this.position += n7;
        return n2 + (n6 + (this.table.showExperience() ? 1 : 0) + (this.table.showFading() ? 1 : 0)) * n5;
    }

    private int printContNodeTable(Graphics graphics, int n, int n2) throws ExceptionHugin {
        JPanel jPanel = new JPanel();
        int n3 = (int)((double)this.cellWidth * this.scale);
        int n4 = (int)((double)this.rowHeight * this.scale);
        int n5 = this.table.getStateTable().getRowCount();
        JTextField jTextField = new JTextField();
        int n6 = 0;
        ContinuousChanceNode continuousChanceNode = (ContinuousChanceNode)this.table.getNode();
        int n7 = n;
        jTextField.setFont(jTextField.getFont().deriveFont((float)((double)this.fontSize * this.scale)));
        n6 = 0;
        while (this.position + n6 < this.columnCount && n7 < this.paperWidth - n3) {
            n7 += n3;
            jTextField.setText("" + continuousChanceNode.getAlpha(n6 + this.position));
            jTextField.setSize(new Dimension(n3, n4));
            SwingUtilities.paintComponent(graphics, jTextField, jPanel, n + n6 * jTextField.getWidth(), n2 + 0, jTextField.getWidth(), jTextField.getHeight());
            ++n6;
        }
        n7 = n;
        n6 = 0;
        while (this.position + n6 < this.columnCount && n7 < this.paperWidth - n3) {
            n7 += n3;
            jTextField.setText("" + continuousChanceNode.getGamma(n6 + this.position));
            jTextField.setSize(new Dimension(n3, n4));
            SwingUtilities.paintComponent(graphics, jTextField, jPanel, n + n6 * jTextField.getWidth(), n2 + jTextField.getHeight(), jTextField.getWidth(), jTextField.getHeight());
            ++n6;
        }
        int n8 = 2;
        for (Node node : continuousChanceNode.getTable().getNodes()) {
            if (!(node instanceof ContinuousChanceNode) || node == continuousChanceNode) continue;
            n7 = n;
            n6 = 0;
            while (this.position + n6 < this.columnCount && n7 < this.paperWidth - n3) {
                n7 += n3;
                jTextField.setText("" + continuousChanceNode.getBeta((ContinuousChanceNode)node, n6 + this.position));
                jTextField.setSize(new Dimension(n3, n4));
                SwingUtilities.paintComponent(graphics, jTextField, jPanel, n + n6 * jTextField.getWidth(), n2 + n8 * jTextField.getHeight(), jTextField.getWidth(), jTextField.getHeight());
                ++n6;
            }
            ++n8;
        }
        this.position += n6;
        return n2 + n5 * n4;
    }

    private int printExpNodeTable(Graphics graphics, int n, int n2) throws ExceptionHugin {
        JPanel jPanel = new JPanel();
        int n3 = (int)((double)this.cellWidth * this.scale);
        int n4 = (int)((double)this.rowHeight * this.scale);
        int n5 = this.table.getStateTable().getRowCount();
        JTextField jTextField = new JTextField();
        int n6 = 0;
        jTextField.setFont(jTextField.getFont().deriveFont((float)((double)this.fontSize * this.scale)));
        if (this.maxExpIndex >= 0) {
            n3 = jTextField.getFontMetrics(jTextField.getFont()).stringWidth(this.expressions[this.maxExpIndex]);
        }
        int n7 = n;
        for (n6 = 0; this.position + n6 < this.columnCount && (n6 == 0 || n7 < this.paperWidth - n3); n7 += n3, ++n6) {
            jTextField.setText(this.expressions[n6 + this.position]);
            jTextField.setSize(new Dimension(n3, n4));
            SwingUtilities.paintComponent(graphics, jTextField, jPanel, n + n6 * jTextField.getWidth(), n2, jTextField.getWidth(), jTextField.getHeight());
        }
        this.position = n6 + this.position;
        return this.getHeight();
    }

    private int printStates(Graphics graphics) throws ExceptionHugin {
        Object object;
        int n = (int)((double)(this.nodes.size() * this.rowHeight) * this.scale);
        JPanel jPanel = new JPanel();
        int n2 = (int)((double)this.textCellWidth * 1.5 * this.scale);
        int n3 = (int)((double)this.rowHeight * this.scale);
        JTextField jTextField = new JTextField();
        Color color = new Color(150, 150, 150);
        int n4 = 0;
        jTextField.setBackground(color);
        jTextField.setFont(jTextField.getFont().deriveFont((float)((double)this.fontSize * this.scale)));
        for (Node node : this.nodes) {
            jTextField.setText(node.getName());
            jTextField.setSize(new Dimension(n2, n3));
            SwingUtilities.paintComponent(graphics, jTextField, jPanel, 0, n3 * n4, jTextField.getWidth(), jTextField.getHeight());
            ++n4;
        }
        color = new Color(190, 190, 190);
        jTextField.setBackground(color);
        if (this.table.showExpressions()) {
            jTextField.setText(HuginGUIConstants.get("str_expression"));
            jTextField.setSize(new Dimension(n2, n3));
            SwingUtilities.paintComponent(graphics, jTextField, jPanel, 0, n, jTextField.getWidth(), jTextField.getHeight());
            return n2;
        }
        for (n4 = 0; n4 < this.table.getStateTable().getRowCount(); ++n4) {
            object = this.table.getStateTable().getValueAt(n4, 0).toString();
            jTextField.setText((String)object);
            jTextField.setSize(new Dimension(n2, n3));
            SwingUtilities.paintComponent(graphics, jTextField, jPanel, 0, n + n3 * n4, jTextField.getWidth(), jTextField.getHeight());
        }
        jTextField.setSize(new Dimension(n2, n3));
        if (this.table.showExperience()) {
            object = HuginGUIConstants.get("str_experience");
            jTextField.setText((String)object);
            jTextField.setSize(new Dimension(n2, n3));
            SwingUtilities.paintComponent(graphics, jTextField, jPanel, 0, n + this.cptSeparator + n3 * n4, jTextField.getWidth(), jTextField.getHeight());
        }
        if (this.table.showFading()) {
            object = HuginGUIConstants.get("str_fading");
            jTextField.setText((String)object);
            jTextField.setSize(new Dimension(n2, n3));
            SwingUtilities.paintComponent(graphics, jTextField, jPanel, 0, n + this.cptSeparator + n3 * (n4 + (this.table.showExperience() ? 1 : 0)), jTextField.getWidth(), jTextField.getHeight());
        }
        return n2;
    }

    private int printHeader(Graphics graphics, int n) throws ExceptionHugin {
        JPanel jPanel = new JPanel();
        int[] nArray = this.getCellWidths(this.nodes);
        String[][] stringArray = this.getNodeLabels(this.nodes);
        int n2 = (int)((double)this.cellWidth * this.scale);
        int n3 = (int)((double)this.rowHeight * this.scale);
        JTextField jTextField = new JTextField();
        int n4 = 0;
        jTextField.setBackground(new Color(190, 190, 190));
        jTextField.setHorizontalAlignment(0);
        jTextField.setFont(jTextField.getFont().deriveFont((float)((double)this.fontSize * this.scale)));
        if (this.maxExpIndex >= 0) {
            n2 = jTextField.getFontMetrics(jTextField.getFont()).stringWidth(this.expressions[this.maxExpIndex]);
        }
        for (int i = 1; i < nArray.length; ++i) {
            int n5;
            int n6 = n;
            for (n4 = 0; n4 + this.position < nArray[0] && (n4 == 0 || n6 < this.paperWidth); n6 += n5, n4 += nArray[i] - (this.position + n4) % nArray[i]) {
                jTextField.setText(stringArray[i - 1][(n4 + this.position) / nArray[i] % stringArray[i - 1].length]);
                n5 = Math.min(n2 * (nArray[i] - (this.position + n4) % nArray[i]), this.paperWidth - n6 - (this.paperWidth - n6) % n2);
                n5 = Math.max(n2, n5);
                jTextField.setSize(new Dimension(n5, n3));
                SwingUtilities.paintComponent(graphics, jTextField, jPanel, n + n2 * n4, n3 * (i - 1), jTextField.getWidth(), jTextField.getHeight());
            }
        }
        return (int)((double)(this.nodes.size() * this.rowHeight) * this.scale);
    }

    private int[] getCellWidths(NodeList nodeList) throws ExceptionHugin {
        int n = 0;
        for (Node node : nodeList) {
            if (!(node instanceof DiscreteNode)) continue;
            ++n;
        }
        Object object = new int[n + 1];
        if (((Object)object).length == 0) {
            return object;
        }
        object[((Object)object).length - 1] = true;
        if (((Object)object).length == 1) {
            return object;
        }
        int n2 = ((Object)object).length - 1;
        ListIterator listIterator = nodeList.listIterator(nodeList.size());
        while (listIterator.hasPrevious()) {
            Node node = (Node)listIterator.previous();
            if (!(node instanceof DiscreteNode)) continue;
            object[n2 - 1] = object[n2] * ((DiscreteNode)node).getNumberOfStates();
            --n2;
        }
        return object;
    }

    private String[][] getNodeLabels(NodeList nodeList) throws ExceptionHugin {
        String[][] stringArray = new String[nodeList.size()][];
        int n = 0;
        for (Node node : nodeList) {
            if (node instanceof DiscreteNode) {
                DiscreteNode discreteNode = (DiscreteNode)node;
                stringArray[n] = new String[discreteNode.getNumberOfStates()];
                for (int i = 0; i < stringArray[n].length; ++i) {
                    stringArray[n][i] = discreteNode.getStateLabel(i);
                }
            }
            ++n;
        }
        return stringArray;
    }
}

