/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plot
extends JPanel
implements Comparator<Renderable> {
    private static final int AxisNameFontSize = 12;
    private static final int AxisPointsFontSize = 9;
    private static final int DisplayPointFontSize = 14;
    private static final Color AxisNameColor = Color.RED;
    private static final Color AxisPointsColor = Color.BLACK;
    private static final Color DisplayPointColor = Color.RED;
    private Point3D c = new Point3D(-0.15, -0.15, -2.0);
    private Point3D theta = new Point3D(-0.47123889803846897, 0.47123889803846897, 0.0);
    private Point3D e = new Point3D(0.5, 0.5, -1.0);
    private Matrix3x3 rotation = null;
    private boolean trackingMouse = false;
    private int mouseX = 0;
    private int mouseY = 0;
    private int mouseButton = 0;
    private BufferedImage plotImage;
    private int width;
    private int height;
    private ImageIcon imageIcon;
    private ArrayList<Renderable> scene;
    private double minX = 0.0;
    private double maxX = 0.0;
    private double minY = 0.0;
    private double maxY = 0.0;
    private double minZ = 0.0;
    private double maxZ = 0.0;
    private Label displayPoint = null;
    private int batchNo = 100;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;
    private boolean complexScene = false;
    int[][] sides;
    AuxGraphics ag = new AuxGraphics();

    public Plot(ArrayList<Triangle> arrayList, String string, String string2, String string3, ArrayList<Label> arrayList2, ArrayList<Label> arrayList3, ArrayList<Label> arrayList4, double d, double d2, double d3, double d4, double d5, double d6) {
        super(new GridLayout(1, 1));
        Point3D point3D;
        Point3D point3D2;
        Point3D point3D3;
        Object object;
        Label label2;
        this.scene = new ArrayList();
        this.scene.addAll(arrayList);
        this.maxX = d2;
        this.maxY = d4;
        this.maxZ = d6;
        this.minX = d;
        this.minY = d3;
        this.minZ = d5;
        double d7 = 0.5;
        int n = 200;
        int n2 = 63;
        for (Label label2 : arrayList2) {
            object = new Point3D(label2.p.x, -d7, -d7);
            point3D3 = new Point3D(label2.p.x, -d7, d7);
            point3D2 = new Point3D(label2.p.x, -d7, d7);
            point3D = new Point3D(label2.p.x, d7, d7);
            this.scene.add(new Line((Point3D)object, point3D3, n));
            this.scene.add(new Line(point3D2, point3D, n));
            this.scene.add(new Line((Point3D)object, label2.p, n2));
        }
        for (Label label2 : arrayList3) {
            object = new Point3D(-d7, label2.p.y, -d7);
            point3D3 = new Point3D(-d7, label2.p.y, d7);
            point3D2 = new Point3D(-d7, label2.p.y, d7);
            point3D = new Point3D(d7, label2.p.y, d7);
            this.scene.add(new Line((Point3D)object, point3D3, n));
            this.scene.add(new Line(point3D2, point3D, n));
            this.scene.add(new Line((Point3D)object, label2.p, n2));
        }
        for (Label label2 : arrayList4) {
            object = new Point3D(-d7, -d7, label2.p.z);
            point3D3 = new Point3D(d7, -d7, label2.p.z);
            point3D2 = new Point3D(-d7, d7, label2.p.z);
            point3D = new Point3D(-d7, -d7, label2.p.z);
            this.scene.add(new Line((Point3D)object, point3D3, n));
            this.scene.add(new Line(point3D2, point3D, n));
            this.scene.add(new Line(point3D3, label2.p, n2));
        }
        this.scene.addAll(arrayList2);
        this.scene.addAll(arrayList3);
        this.scene.addAll(arrayList4);
        Label label3 = new Label(string, new Point3D(0.0, -d7, -d7 - 0.2), 12, AxisNameColor);
        label2 = new Label(string2, new Point3D(-d7, 0.0, -d7 - 0.2), 12, AxisNameColor);
        object = new Label(string3, new Point3D(d7 + 0.2, -d7, 0.0), 12, AxisNameColor);
        this.scene.add(label3);
        this.scene.add(label2);
        this.scene.add((Renderable)object);
        if (this.scene.size() > 3200) {
            this.complexScene = true;
        }
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Plot.this.trackingMouse = true;
                Plot.this.mouseButton = mouseEvent.getButton();
                Plot.this.mouseX = mouseEvent.getX();
                Plot.this.mouseY = mouseEvent.getY();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Plot.this.trackingMouse = false;
                Plot.this.mouseX = mouseEvent.getX();
                Plot.this.mouseY = mouseEvent.getY();
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n = mouseWheelEvent.getWheelRotation();
                ((Plot)Plot.this).c.z -= (double)n * 0.1;
                Plot.this.render();
                Plot.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (Plot.this.trackingMouse) {
                    int n = mouseEvent.getX();
                    int n2 = mouseEvent.getY();
                    int n3 = n - Plot.this.mouseX;
                    int n4 = n2 - Plot.this.mouseY;
                    Plot.this.mouseX = n;
                    Plot.this.mouseY = n2;
                    if (Plot.this.mouseButton == 1) {
                        ((Plot)Plot.this).theta.x -= (double)n4 * 0.5 * Math.PI / 180.0;
                        ((Plot)Plot.this).theta.y -= (double)n3 * 0.5 * Math.PI / 180.0;
                        if (((Plot)Plot.this).theta.x > Math.PI) {
                            ((Plot)Plot.this).theta.x = -Math.PI;
                        }
                        if (((Plot)Plot.this).theta.x < -Math.PI) {
                            ((Plot)Plot.this).theta.x = Math.PI;
                        }
                        if (((Plot)Plot.this).theta.y > Math.PI) {
                            ((Plot)Plot.this).theta.y = -Math.PI;
                        }
                        if (((Plot)Plot.this).theta.y < -Math.PI) {
                            ((Plot)Plot.this).theta.y = Math.PI;
                        }
                    } else if (Plot.this.mouseButton == 3) {
                        ((Plot)Plot.this).c.x -= (double)n3 * 0.005;
                        ((Plot)Plot.this).c.y += (double)n4 * 0.005;
                    }
                    Plot.this.render();
                    Plot.this.repaint();
                }
            }
        });
        this.imageIcon = new ImageIcon();
        this.add(new JLabel(this.imageIcon));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Plot.this.render();
                Plot.this.repaint();
            }
        });
    }

    public void showPoint(double d, double d2, double d3, String string) {
        double d4 = d * 1.0 / (this.maxX - this.minX) - 0.5 - this.minX / (this.maxX - this.minX);
        double d5 = d2 * 1.0 / (this.maxY - this.minY) - 0.5 - this.minY / (this.maxY - this.minY);
        double d6 = d3 * 1.0 / (this.maxZ - this.minZ) - 0.5 - this.minZ / (this.maxZ - this.minZ);
        this.displayPoint = new Label(string, new Point3D(d4, d5, d6), 14, DisplayPointColor);
        this.repaint();
    }

    public void clearPoint() {
        this.displayPoint = null;
        this.render();
        this.repaint();
    }

    public static ArrayList<Triangle> constructSurface(double[][] dArray, double d, double d2) {
        int n;
        int n2;
        double d3;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        ArrayList<Triangle> arrayList = new ArrayList<Triangle>();
        if (n3 < 2 || n4 < 2) {
            return arrayList;
        }
        double d4 = d2 - d;
        double d5 = 1.0;
        double d6 = d3 = d < 0.0 ? -d : 0.0;
        if (d4 > 0.0) {
            d5 = 1.0 / d4;
        }
        Point3D[][] point3DArray = new Point3D[n3][n4];
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                point3DArray[n][n2] = dArray[n][n2] < d || dArray[n][n2] > d2 ? null : new Point3D((double)n / ((double)n3 - 1.0) - 0.5, (dArray[n][n2] + d3) * d5 - 0.5, (double)n2 / ((double)n4 - 1.0) - 0.5);
            }
        }
        for (n2 = 1; n2 < n4; ++n2) {
            for (n = 1; n < n3; ++n) {
                Point3D point3D = point3DArray[n - 1][n2 - 1];
                Point3D point3D2 = point3DArray[n][n2 - 1];
                Point3D point3D3 = point3DArray[n - 1][n2];
                Point3D point3D4 = point3DArray[n][n2];
                Triangle triangle = null;
                Triangle triangle2 = null;
                if (point3D2 == null || point3D3 == null) {
                    if (point3D != null && point3D2 != null && point3D4 != null) {
                        triangle = new Triangle(point3D, point3D2, point3D4, true, false, false);
                    }
                    if (point3D != null && point3D3 != null && point3D4 != null) {
                        triangle2 = new Triangle(point3D, point3D4, point3D3);
                    }
                    if (n2 == n4 - 1 && triangle2 != null) {
                        triangle2.edgeBC = true;
                    }
                } else {
                    if (point3D != null && point3D2 != null && point3D3 != null) {
                        triangle = new Triangle(point3D3, point3D, point3D2, true, true, false);
                    }
                    if (point3D2 != null && point3D3 != null && point3D4 != null) {
                        triangle2 = new Triangle(point3D2, point3D4, point3D3);
                    }
                    if (n == n3 - 1 && triangle2 != null) {
                        triangle2.edgeAB = true;
                    }
                    if (n2 == n4 - 1 && triangle2 != null) {
                        triangle2.edgeBC = true;
                    }
                }
                if (triangle != null) {
                    arrayList.add(triangle);
                }
                if (triangle2 == null) continue;
                arrayList.add(triangle2);
            }
        }
        return arrayList;
    }

    public static ArrayList<Label> constructNumberedLabels(int n, double d, double d2, int n2) {
        double d3 = Math.abs(d2 - d);
        double d4 = d3 / (double)(n2 - 1);
        double[] dArray = new double[n2];
        String[] stringArray = new String[n2];
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(2);
        for (int i = 0; i < n2; ++i) {
            dArray[i] = d + (double)i * d4;
            stringArray[i] = decimalFormat.format(d + (double)i * d4);
        }
        return Plot.constructTextLabels(n, d, d2, dArray, stringArray);
    }

    public static ArrayList<Label> constructTextLabels(int n, double d, double d2, double[] dArray, String[] stringArray) {
        ArrayList<Label> arrayList = new ArrayList<Label>();
        double d3 = Math.abs(d2 - d);
        double d4 = 1.0 / d3;
        for (int i = 0; i < dArray.length; ++i) {
            double d5 = (dArray[i] - d) / d3 - 0.5;
            String string = stringArray[i];
            Point3D point3D = n == 0 ? new Point3D(d5, -0.5, -0.6) : (n == 1 ? new Point3D(-0.6, d5, -0.5) : new Point3D(0.6, -0.5, d5));
            Label label = new Label(string, point3D, 9, AxisPointsColor);
            arrayList.add(label);
        }
        return arrayList;
    }

    private Point project(Point3D point3D, Matrix3x3 matrix3x3, int n) {
        Point3D point3D2 = matrix3x3.multiply(point3D).subtract(this.c);
        if (point3D2.z < 0.1) {
            return null;
        }
        double d = 1.0 - (point3D2.x * (this.e.z / point3D2.z) + this.e.x);
        double d2 = point3D2.y * (this.e.z / point3D2.z) + this.e.y;
        return new Point((int)(d *= (double)n), (int)(d2 *= (double)n));
    }

    private void render() {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n;
        Dimension dimension = this.getSize();
        int n2 = n = dimension.width < dimension.height ? dimension.width : dimension.height;
        if (n < 1) {
            n = 10;
        }
        if (this.plotImage == null || this.plotImage.getWidth() != n) {
            this.plotImage = new BufferedImage(n, n, 1);
            this.width = n;
            this.height = n;
            this.sides = new int[this.height][2];
            this.imageIcon.setImage(this.plotImage);
        }
        Graphics2D graphics2D = this.plotImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.fillRect(0, 0, n, n);
        this.rotation = this.getRotationMatrix(-this.theta.x, -this.theta.y, -this.theta.z);
        Collections.sort(this.scene, this);
        ++this.batchNo;
        Color color = new Color(Color.BLACK.getRed(), Color.BLACK.getGreen(), Color.BLACK.getBlue(), 100);
        Color color2 = new Color(Color.GREEN.getRed(), Color.GREEN.getGreen(), Color.GREEN.getBlue(), 200);
        Color color3 = new Color(Color.BLUE.getRed(), Color.BLUE.getGreen(), Color.BLUE.getBlue(), 200);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        for (Renderable object6 : this.scene) {
            if (object6 instanceof Triangle) {
                object5 = (Triangle)object6;
                object4 = ((Triangle)object5).a.p2D;
                object3 = ((Triangle)object5).b.p2D;
                object2 = ((Triangle)object5).c.p2D;
                if (((Triangle)object5).a.batch != this.batchNo) {
                    object4 = this.project(((Triangle)object5).a, this.rotation, n);
                    ((Triangle)object5).a.batch = this.batchNo;
                    ((Triangle)object5).a.p2D = object4;
                }
                if (((Triangle)object5).b.batch != this.batchNo) {
                    object3 = this.project(((Triangle)object5).b, this.rotation, n);
                    ((Triangle)object5).b.batch = this.batchNo;
                    ((Triangle)object5).b.p2D = object3;
                }
                if (((Triangle)object5).c.batch != this.batchNo) {
                    object2 = this.project(((Triangle)object5).c, this.rotation, n);
                    ((Triangle)object5).c.batch = this.batchNo;
                    ((Triangle)object5).c.p2D = object2;
                }
                if (object4 == null || object3 == null || object2 == null) continue;
                object = this.c.subtract(this.rotation.multiply(((Triangle)object5).center));
                double shape = this.rotation.multiply(((Triangle)object5).n).dot((Point3D)object);
                serializable = shape <= 0.0 ? color2 : color3;
                nArray[0] = ((Point)object4).x;
                nArray2[0] = ((Point)object4).y;
                nArray[1] = ((Point)object3).x;
                nArray2[1] = ((Point)object3).y;
                nArray[2] = ((Point)object2).x;
                nArray2[2] = ((Point)object2).y;
                if (this.complexScene) {
                    this.ag.fillTriangle(nArray[0], nArray2[0], nArray[1], nArray2[1], nArray[2], nArray2[2], ((Color)serializable).getRGB());
                    if (((Triangle)object5).edgeAB) {
                        this.ag.drawLine(((Point)object4).x, ((Point)object4).y, ((Point)object3).x, ((Point)object3).y, color.getRGB());
                    }
                    if (((Triangle)object5).edgeAC) {
                        this.ag.drawLine(((Point)object4).x, ((Point)object4).y, ((Point)object2).x, ((Point)object2).y, color.getRGB());
                    }
                    if (!((Triangle)object5).edgeBC) continue;
                    this.ag.drawLine(((Point)object3).x, ((Point)object3).y, ((Point)object2).x, ((Point)object2).y, color.getRGB());
                    continue;
                }
                graphics2D.setStroke(new BasicStroke(1.0f));
                graphics2D.setColor((Color)serializable);
                graphics2D.fillPolygon(nArray, nArray2, 3);
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(1.0f));
                if (((Triangle)object5).edgeAB) {
                    graphics2D.drawLine(((Point)object4).x, ((Point)object4).y, ((Point)object3).x, ((Point)object3).y);
                }
                if (((Triangle)object5).edgeAC) {
                    graphics2D.drawLine(((Point)object4).x, ((Point)object4).y, ((Point)object2).x, ((Point)object2).y);
                }
                if (!((Triangle)object5).edgeBC) continue;
                graphics2D.drawLine(((Point)object3).x, ((Point)object3).y, ((Point)object2).x, ((Point)object2).y);
                continue;
            }
            if (object6 instanceof Line) {
                object5 = (Line)object6;
                object4 = new Color(0, 0, 0, ((Line)object5).opaque);
                object3 = this.project(((Line)object5).a, this.rotation, n);
                object2 = this.project(((Line)object5).b, this.rotation, n);
                if (object3 == null || object2 == null) continue;
                if (this.complexScene) {
                    this.ag.drawLine(((Point)object3).x, ((Point)object3).y, ((Point)object2).x, ((Point)object2).y, ((Color)object4).getRGB());
                    continue;
                }
                graphics2D.setColor((Color)object4);
                graphics2D.setStroke(new BasicStroke(1.5f));
                graphics2D.drawLine(((Point)object3).x, ((Point)object3).y, ((Point)object2).x, ((Point)object2).y);
                continue;
            }
            if (!(object6 instanceof Label)) continue;
            object5 = (Label)object6;
            object4 = this.project(((Label)object5).p, this.rotation, n);
            if (object4 == null) continue;
            object3 = new Font("Serif", 0, ((Label)object5).fontSize);
            graphics2D.setFont((Font)object3);
            object2 = ((Font)object3).getStringBounds(((Label)object5).text, fontRenderContext);
            object = ((Font)object3).createGlyphVector(fontRenderContext, ((Label)object5).text);
            Shape point2 = ((GlyphVector)object).getOutline(((Point)object4).x - (int)((RectangularShape)object2).getCenterX(), ((Point)object4).y - (int)((RectangularShape)object2).getCenterY());
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.draw(point2);
            graphics2D.setColor(((Label)object5).color);
            graphics2D.setStroke(new BasicStroke(1.5f));
            graphics2D.drawGlyphVector((GlyphVector)object, ((Point)object4).x - (int)((RectangularShape)object2).getCenterX(), ((Point)object4).y - (int)((RectangularShape)object2).getCenterY());
        }
        if (this.displayPoint != null) {
            Point point;
            Label label = this.displayPoint;
            Point3D point3D = new Point3D(label.p.x, -0.5, label.p.z);
            object5 = new Point3D(label.p.x, 0.5, label.p.z);
            object4 = new Point3D(-0.5, label.p.y, label.p.z);
            object3 = new Point3D(0.5, label.p.y, label.p.z);
            object2 = new Point3D(label.p.x, label.p.y, 0.5);
            object = new Point3D(label.p.x, label.p.y, -0.5);
            Point point2 = this.project(point3D, this.rotation, n);
            Point point3 = this.project((Point3D)object5, this.rotation, n);
            serializable = this.project((Point3D)object4, this.rotation, n);
            Point point4 = this.project((Point3D)object3, this.rotation, n);
            Point point5 = this.project((Point3D)object2, this.rotation, n);
            Point point6 = this.project((Point3D)object, this.rotation, n);
            Color color4 = new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), 100);
            graphics2D.setColor(color4);
            graphics2D.setStroke(new BasicStroke(2.0f));
            if (point2 != null && point3 != null) {
                graphics2D.drawLine(point2.x, point2.y, point3.x, point3.y);
            }
            if (serializable != null && point4 != null) {
                graphics2D.drawLine(((Point)serializable).x, ((Point)serializable).y, point4.x, point4.y);
            }
            if (point5 != null && point6 != null) {
                graphics2D.drawLine(point5.x, point5.y, point6.x, point6.y);
            }
            if ((point = this.project(label.p, this.rotation, n)) != null) {
                graphics2D.setColor(Color.RED);
                graphics2D.setStroke(new BasicStroke(4.0f));
                graphics2D.drawOval(point.x - 2, point.y - 2, 4, 4);
                graphics2D.setColor(Color.BLACK);
                graphics2D.setStroke(new BasicStroke(2.0f));
                graphics2D.drawOval(point.x - 2, point.y - 2, 4, 4);
                Font font = new Font("Serif", 0, label.fontSize);
                graphics2D.setFont(font);
                Rectangle2D rectangle2D = font.getStringBounds(label.text, fontRenderContext);
                GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, label.text);
                Shape shape = glyphVector.getOutline(point.x, point.y + (int)rectangle2D.getHeight());
                graphics2D.setStroke(new BasicStroke(2.0f));
                graphics2D.setColor(Color.LIGHT_GRAY);
                graphics2D.draw(shape);
                graphics2D.setColor(label.color);
                graphics2D.setStroke(new BasicStroke(1.5f));
                graphics2D.drawGlyphVector(glyphVector, point.x, point.y + (int)rectangle2D.getHeight());
            }
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.drawRect(0, 0, n - 1, n - 1);
    }

    @Override
    public int compare(Renderable renderable, Renderable renderable2) {
        Point3D point3D = this.rotation.multiply(renderable.center).subtract(this.c);
        double d = point3D.x * point3D.x + point3D.y * point3D.y + point3D.z * point3D.z;
        Point3D point3D2 = this.rotation.multiply(renderable2.center).subtract(this.c);
        double d2 = point3D2.x * point3D2.x + point3D2.y * point3D2.y + point3D2.z * point3D2.z;
        if (d > d2) {
            return -1;
        }
        if (d < d2) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }

    private Matrix3x3 getRotationMatrix(double d, double d2, double d3) {
        Matrix3x3 matrix3x3 = new Matrix3x3(1.0, 0.0, 0.0, 0.0, Math.cos(d), Math.sin(d), 0.0, -Math.sin(d), Math.cos(d));
        Matrix3x3 matrix3x32 = new Matrix3x3(Math.cos(d2), 0.0, -Math.sin(d2), 0.0, 1.0, 0.0, Math.sin(d2), 0.0, Math.cos(d2));
        Matrix3x3 matrix3x33 = new Matrix3x3(Math.cos(d3), Math.sin(d3), 0.0, -Math.sin(d3), Math.cos(d3), 0.0, 0.0, 0.0, 1.0);
        return matrix3x3.multiply(matrix3x32.multiply(matrix3x33));
    }

    private static Point3D cross(Point3D point3D, Point3D point3D2) {
        Point3D point3D3 = new Point3D(0.0, 0.0, 0.0);
        point3D3.x = point3D.y * point3D2.z - point3D.z * point3D2.y;
        point3D3.y = point3D.z * point3D2.x - point3D.x * point3D2.z;
        point3D3.z = point3D.x * point3D2.y - point3D.y * point3D2.x;
        return point3D3;
    }

    private class AuxGraphics {
        private AuxGraphics() {
        }

        private void fillTriangle(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            int n8;
            int n9 = Math.min(n, Math.min(n3, n5));
            int n10 = Math.max(n, Math.max(n3, n5));
            int n11 = Math.min(n2, Math.min(n4, n6));
            int n12 = Math.max(n2, Math.max(n4, n6));
            if (n10 - n9 < 4 && n12 - n11 < 4) {
                int n13 = (n + n3 + n5) / 3;
                int n14 = (n2 + n4 + n6) / 3;
                if (n13 > 0 && n13 < Plot.this.width - 1 && n14 > 0 && n14 < Plot.this.height - 1) {
                    this.setPixel(n13, n14, n7);
                }
                return;
            }
            n11 = n11 < 0 ? 0 : n11;
            n12 = n12 >= Plot.this.height ? Plot.this.height - 1 : n12;
            for (n8 = n11; n8 <= n12; ++n8) {
                Plot.this.sides[n8][0] = Plot.this.width;
                Plot.this.sides[n8][1] = 0;
            }
            this.triangleDrawLine(n, n2, n3, n4, Plot.this.sides);
            this.triangleDrawLine(n, n2, n5, n6, Plot.this.sides);
            this.triangleDrawLine(n5, n6, n3, n4, Plot.this.sides);
            for (n8 = n11; n8 <= n12; ++n8) {
                if (n8 <= 0 || n8 >= Plot.this.height) continue;
                for (int i = Plot.this.sides[n8][0]; i <= Plot.this.sides[n8][1]; ++i) {
                    if (i <= 0 || i >= Plot.this.width - 1 || n8 <= 0 || n8 >= Plot.this.height - 1) continue;
                    this.setPixel(i, n8, n7);
                }
            }
        }

        private void triangleDrawLine(int n, int n2, int n3, int n4, int[][] nArray) {
            int n5 = n3 - n;
            int n6 = n4 - n2;
            float f = Math.abs(n5) + Math.abs(n6);
            float f2 = n3 - n == 0 ? 0.0f : (float)n5 / f;
            float f3 = n4 - n2 == 0 ? 0.0f : (float)n6 / f;
            int n7 = n;
            int n8 = n2;
            int n9 = 0;
            while (n7 != n3 || n8 != n4) {
                int n10 = n7;
                int n11 = n8;
                while (n10 == n7 && n11 == n8) {
                    n7 = n + (int)((float)(++n9) * f2);
                    n8 = n2 + (int)((float)n9 * f3);
                }
                if (n8 <= 0 || n8 >= Plot.this.height - 1) continue;
                if (n7 < nArray[n8][0]) {
                    nArray[n8][0] = n7;
                }
                if (n7 <= nArray[n8][1]) continue;
                nArray[n8][1] = n7;
            }
        }

        private boolean insideTriangle(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            int n10;
            int n11;
            int n12 = Math.abs(n * n4 + n3 * n6 + n5 * n2 - n * n6 - n5 * n4 - n3 * n2);
            return n12 + (n11 = Math.abs(n * n4 + n3 * n8 + n7 * n2 - n * n8 - n7 * n4 - n3 * n2)) + (n10 = Math.abs(n * n6 + n5 * n8 + n7 * n2 - n * n8 - n7 * n6 - n5 * n2)) == n9;
        }

        private void drawLine(int n, int n2, int n3, int n4, int n5) {
            int n6 = n3 - n;
            int n7 = n4 - n2;
            if (Math.abs(n6) < 3 && Math.abs(n7) < 3) {
                if (n > 0 && n < Plot.this.width - 1 && n2 > 0 && n2 < Plot.this.height - 1) {
                    this.setPixel(n, n2, n5);
                }
                return;
            }
            float f = Math.abs(n6) + Math.abs(n7);
            float f2 = n3 - n == 0 ? 0.0f : (float)n6 / f;
            float f3 = n4 - n2 == 0 ? 0.0f : (float)n7 / f;
            int n8 = n;
            int n9 = n2;
            int n10 = 0;
            while (n8 != n3 || n9 != n4) {
                int n11 = n8;
                int n12 = n9;
                while (n11 == n8 && n12 == n9) {
                    n8 = n + (int)((float)(++n10) * f2);
                    n9 = n2 + (int)((float)n10 * f3);
                }
                if (n8 <= 0 || n8 >= Plot.this.width - 1 || n9 <= 0 || n9 >= Plot.this.height - 1) continue;
                this.setPixel(n8, n9, n5);
            }
        }

        private void setPixel(int n, int n2, int n3) {
            int n4 = Plot.this.plotImage.getRGB(n, n2);
            int n5 = n4 >> 16 & 0xFF;
            int n6 = n4 >> 8 & 0xFF;
            int n7 = n4 & 0xFF;
            int n8 = n3 >> 24 & 0xFF;
            int n9 = n3 >> 16 & 0xFF;
            int n10 = n3 >> 8 & 0xFF;
            int n11 = n3 & 0xFF;
            n9 = (n9 * n8 + n5 * (255 - n8)) / 255;
            n10 = (n10 * n8 + n6 * (255 - n8)) / 255;
            n11 = (n11 * n8 + n7 * (255 - n8)) / 255;
            Plot.this.plotImage.setRGB(n, n2, 0 | n9 << 16 | n10 << 8 | n11);
        }

        private void blurPixel(int n, int n2) {
            if (n < 2 || n > Plot.this.width - 2 || n2 < 2 || n2 > Plot.this.height - 2) {
                return;
            }
            for (int i = n2 - 1; i < n2 + 1; ++i) {
                for (int j = n - 1; j < n + 1; ++j) {
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    for (int k = 0; k < 3; ++k) {
                        for (int i2 = 0; i2 < 3; ++i2) {
                            int n6 = Plot.this.plotImage.getRGB(j - 1 + k, i - 1 + i2);
                            n3 += n6 >> 16 & 0xFF;
                            n4 += n6 >> 8 & 0xFF;
                            n5 += n6 & 0xFF;
                        }
                    }
                    Plot.this.plotImage.setRGB(j, i, 0 | (n3 /= 9) << 16 | (n4 /= 9) << 8 | (n5 /= 9));
                }
            }
        }
    }

    public static class Label
    extends Renderable {
        public Point3D p;
        public String text;
        public int fontSize;
        public Color color;

        public Label(String string, Point3D point3D, int n, Color color) {
            this.text = string;
            this.p = point3D;
            this.center = point3D;
            this.fontSize = n;
            this.color = color;
        }
    }

    public static class Line
    extends Renderable {
        public Point3D a;
        public Point3D b;
        int opaque = 255;

        public Line(Point3D point3D, Point3D point3D2) {
            this.a = point3D;
            this.b = point3D2;
            this.center = this.a.plus(this.b);
            this.center.x /= 2.0;
            this.center.y /= 2.0;
            this.center.z /= 2.0;
        }

        public Line(Point3D point3D, Point3D point3D2, int n) {
            this(point3D, point3D2);
            this.opaque = n;
        }
    }

    public static class Triangle
    extends Renderable {
        public Point3D a;
        public Point3D b;
        public Point3D c;
        public Point3D n;
        public boolean edgeAB = false;
        public boolean edgeAC = false;
        public boolean edgeBC = false;

        public Triangle(Point3D point3D, Point3D point3D2, Point3D point3D3) {
            this.a = point3D;
            this.b = point3D2;
            this.c = point3D3;
            this.center = this.a.plus(this.b.plus(this.c));
            this.center.x /= 3.0;
            this.center.y /= 3.0;
            this.center.z /= 3.0;
            this.updateNormal();
        }

        public Triangle(Point3D point3D, Point3D point3D2, Point3D point3D3, boolean bl, boolean bl2, boolean bl3) {
            this(point3D, point3D2, point3D3);
            this.edgeAB = bl;
            this.edgeAC = bl3;
            this.edgeBC = bl2;
        }

        public void updateNormal() {
            Point3D point3D = this.a.subtract(this.b);
            Point3D point3D2 = this.a.subtract(this.c);
            this.n = Plot.cross(point3D, point3D2);
            this.n.normalize();
        }
    }

    public static abstract class Renderable {
        public Point3D center = null;
    }

    private class Matrix3x3 {
        public double[][] a;

        public Matrix3x3() {
            this.a = new double[3][3];
        }

        public Matrix3x3(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
            this.a = new double[3][3];
            this.a[0][0] = d;
            this.a[0][1] = d2;
            this.a[0][2] = d3;
            this.a[1][0] = d4;
            this.a[1][1] = d5;
            this.a[1][2] = d6;
            this.a[2][0] = d7;
            this.a[2][1] = d8;
            this.a[2][2] = d9;
        }

        public Matrix3x3 multiply(Matrix3x3 matrix3x3) {
            Matrix3x3 matrix3x32 = this;
            Matrix3x3 matrix3x33 = new Matrix3x3();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        double[] dArray = matrix3x33.a[i];
                        int n = j;
                        dArray[n] = dArray[n] + matrix3x32.a[i][k] * matrix3x3.a[k][j];
                    }
                }
            }
            return matrix3x33;
        }

        public Point3D multiply(Point3D point3D) {
            Matrix3x3 matrix3x3 = this;
            Point3D point3D2 = new Point3D(0.0, 0.0, 0.0);
            point3D2.x = matrix3x3.a[0][0] * point3D.x + matrix3x3.a[0][1] * point3D.y + matrix3x3.a[0][2] * point3D.z;
            point3D2.y = matrix3x3.a[1][0] * point3D.x + matrix3x3.a[1][1] * point3D.y + matrix3x3.a[1][2] * point3D.z;
            point3D2.z = matrix3x3.a[2][0] * point3D.x + matrix3x3.a[2][1] * point3D.y + matrix3x3.a[2][2] * point3D.z;
            return point3D2;
        }
    }

    public static class Point3D {
        public double x;
        public double y;
        public double z;
        public Point p2D = null;
        public int batch = -1;

        public Point3D(double d, double d2, double d3) {
            this.x = d;
            this.y = d2;
            this.z = d3;
        }

        public Point3D subtract(Point3D point3D) {
            Point3D point3D2 = this;
            return new Point3D(point3D2.x - point3D.x, point3D2.y - point3D.y, point3D2.z - point3D.z);
        }

        public Point3D plus(Point3D point3D) {
            Point3D point3D2 = this;
            return new Point3D(point3D2.x + point3D.x, point3D2.y + point3D.y, point3D2.z + point3D.z);
        }

        public Point3D multiply(Point3D point3D) {
            Point3D point3D2 = this;
            return new Point3D(point3D2.x * point3D.x, point3D2.y * point3D.y, point3D2.z * point3D.z);
        }

        public void normalize() {
            double d = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
            this.x /= d;
            this.y /= d;
            this.z /= d;
        }

        public double dot(Point3D point3D) {
            Point3D point3D2 = this;
            return point3D2.x * point3D.x + point3D2.y * point3D.y + point3D2.z * point3D.z;
        }
    }
}

