/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HGUI.ComponentTree;
import COM.hugin.HGUI.ComponentTreePage;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.JunctionTree;
import COM.hugin.HGUI.JunctionTreePage;
import COM.hugin.HGUI.NetworkPage;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.NodeProbabilitiesPage;
import COM.hugin.HGUI.NodeTablePage;
import COM.hugin.HGUI.PrintPreview;
import COM.hugin.HGUI.TextPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Printer
extends JDialog {
    private PrintService[] services;
    private File file;
    private HuginGUIFrame frame;
    private static final int BASELINE_TOP = 1;
    private static final int BASELINE_MIDDLE = 2;
    private static final int BASELINE_BOTTOM = 3;
    boolean cancelled = true;
    private PrintThread thread;
    private PrinterJob print;
    PrintRequestAttributeSet attribs;
    private NetworkPanel network;
    JunctionTree jt;
    ComponentTree ct;
    String textToPrint;
    String title;
    private JTabbedPane tabs;
    private JButton printNow;
    private JButton cancel;
    private JButton preview;
    private JButton selectFile;
    private JButton pageSetup;
    private JCheckBox destFile;
    private JComboBox printers;
    private JTextField fileName;
    private JCheckBox printName;
    private JCheckBox printDate;
    JSpinner scaleFactor;
    JCheckBox fitToPage;
    JCheckBox includeMonitors;
    JLabel occupy;
    boolean inFit = false;
    JRadioButton printAll;
    JRadioButton printSelected;
    JRadioButton printOpen;
    private Rectangle treeBounds;
    private JunctionTree jTree;
    private Rectangle compBounds;
    private ComponentTree cTree;

    public Printer(HuginGUIFrame huginGUIFrame) {
        super(huginGUIFrame, HuginGUIConstants.get("MISCELLANEOUS_Print_network"), true);
        this.frame = huginGUIFrame;
        this.services = null;
        this.attribs = new HashPrintRequestAttributeSet();
        this.createDialog();
        this.thread = new PrintThread();
    }

    public void printNetwork(NetworkPanel networkPanel) {
        this.setTitle(HuginGUIConstants.get("MISCELLANEOUS_Print_network"));
        this.network = networkPanel;
        this.tabs.add((Component)this.createNetworkTab(), HuginGUIConstants.get("PRINTER_Network"));
        if (this.network.projectFrame == null) {
            this.printName.setEnabled(false);
            this.printName.setSelected(false);
        }
        this.preview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PageFormat pageFormat = Printer.this.print.defaultPage();
                Printer.this.setupPaper(pageFormat, Printer.this.attribs);
                PrintPreview printPreview = new PrintPreview(Printer.this, pageFormat, new NetworkPage(Printer.this.network, Printer.this.printName.isSelected(), Printer.this.printDate.isSelected(), (double)((Integer)Printer.this.scaleFactor.getValue()).intValue() / 100.0, Printer.this.fitToPage.isSelected()));
                printPreview.pack();
                HuginGUIUtils.placeNextTo(Printer.this, printPreview);
                printPreview.setVisible(true);
                if (printPreview.getResult() == 1) {
                    Printer.this.dispose();
                }
            }
        });
        this.pack();
        this.setVisible(true);
        if (this.cancelled) {
            return;
        }
        try {
            this.fillInAttributes(this.attribs);
            NetworkPage networkPage = new NetworkPage(this.network, this.printName.isSelected(), this.printDate.isSelected(), (double)((Integer)this.scaleFactor.getValue()).intValue() / 100.0, this.fitToPage.isSelected());
            this.print.setPrintable(networkPage);
            this.thread.setup(this.print, this.attribs, this.network.projectFrame, networkPage);
            this.thread.start();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public void printTable(NetworkPanel networkPanel) {
        this.setTitle(HuginGUIConstants.get("MISCELLANEOUS_Print_tables"));
        this.network = networkPanel;
        this.tabs.add((Component)this.createTableTab(), HuginGUIConstants.get("PRINTER_Tables"));
        if (this.network.projectFrame == null) {
            this.printName.setEnabled(false);
            this.printName.setSelected(false);
        }
        this.preview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Printer.this.printAll.isSelected() ? 0 : (Printer.this.printSelected.isSelected() ? 1 : 2);
                PageFormat pageFormat = Printer.this.print.defaultPage();
                Printer.this.setupPaper(pageFormat, Printer.this.attribs);
                PrintPreview printPreview = new PrintPreview(Printer.this, pageFormat, new NodeTablePage(Printer.this.network, n, Printer.this.printName.isSelected(), Printer.this.printDate.isSelected(), (double)((Integer)Printer.this.scaleFactor.getValue()).intValue() / 100.0));
                printPreview.pack();
                HuginGUIUtils.placeNextTo(Printer.this, printPreview);
                printPreview.setVisible(true);
                if (printPreview.getResult() == 1) {
                    Printer.this.dispose();
                }
            }
        });
        this.setVisible(true);
        if (this.cancelled) {
            return;
        }
        try {
            this.fillInAttributes(this.attribs);
            int n = this.printAll.isSelected() ? 0 : (this.printSelected.isSelected() ? 1 : 2);
            this.print.setPrintable(new NodeTablePage(this.network, n, this.printName.isSelected(), this.printDate.isSelected(), (double)((Integer)this.scaleFactor.getValue()).intValue() / 100.0));
            this.thread.setup(this.print, this.attribs, this.network.projectFrame);
            this.thread.start();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public void printProbabilities(NetworkPanel networkPanel) {
        this.setTitle(HuginGUIConstants.get("MISCELLANEOUS_Print_tables"));
        this.network = networkPanel;
        this.tabs.add((Component)this.createProbabilitiesTab(), HuginGUIConstants.get("PRINTER_Probabilities"));
        if (this.network.projectFrame == null) {
            this.printName.setEnabled(false);
            this.printName.setSelected(false);
        }
        this.preview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PageFormat pageFormat = Printer.this.print.defaultPage();
                Printer.this.setupPaper(pageFormat, Printer.this.attribs);
                PrintPreview printPreview = new PrintPreview(Printer.this, pageFormat, new NodeProbabilitiesPage(Printer.this.network, Printer.this.printAll.isSelected(), Printer.this.printName.isSelected(), Printer.this.printDate.isSelected()));
                printPreview.pack();
                HuginGUIUtils.placeNextTo(Printer.this, printPreview);
                printPreview.setVisible(true);
                if (printPreview.getResult() == 1) {
                    Printer.this.dispose();
                }
            }
        });
        this.setVisible(true);
        if (this.cancelled) {
            return;
        }
        try {
            this.fillInAttributes(this.attribs);
            this.print.setPrintable(new NodeProbabilitiesPage(this.network, this.printAll.isSelected(), this.printName.isSelected(), this.printDate.isSelected()));
            this.thread.setup(this.print, this.attribs, this.network.projectFrame);
            this.thread.start();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public void printJunctionTree(JunctionTree junctionTree, HuginProjectFrame huginProjectFrame) throws ExceptionHugin {
        this.setTitle(HuginGUIConstants.get("MENU_FILE_Print_JunctionTree"));
        this.jt = new JunctionTree(junctionTree.getAPIJunctionTree(), junctionTree.getIndex(), true);
        this.tabs.add((Component)this.createJunctionTreeTab(this.jt), HuginGUIConstants.get("PRINTER_Print_Junction_tree"));
        this.preview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PageFormat pageFormat = Printer.this.print.defaultPage();
                Printer.this.setupPaper(pageFormat, Printer.this.attribs);
                try {
                    PrintPreview printPreview = new PrintPreview(Printer.this, pageFormat, new JunctionTreePage(Printer.this.jt, Printer.this.printName.isSelected(), Printer.this.printDate.isSelected(), (double)((Integer)Printer.this.scaleFactor.getValue()).intValue() / 100.0, Printer.this.fitToPage.isSelected(), ""));
                    printPreview.pack();
                    HuginGUIUtils.placeNextTo(Printer.this, printPreview);
                    printPreview.setVisible(true);
                    if (printPreview.getResult() == 1) {
                        Printer.this.dispose();
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(HuginGUIConstants.get("str_unable_to_show_preview_") + exception.getMessage());
                }
            }
        });
        this.setVisible(true);
        if (this.cancelled) {
            return;
        }
        try {
            this.fillInAttributes(this.attribs);
            this.print.setPrintable(new JunctionTreePage(this.jt, this.printName.isSelected(), this.printDate.isSelected(), (double)((Integer)this.scaleFactor.getValue()).intValue() / 100.0, this.fitToPage.isSelected(), ""));
            this.thread.setup(this.print, this.attribs, huginProjectFrame);
            this.thread.start();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public void printComponentTree(ComponentTree componentTree, HuginProjectFrame huginProjectFrame) throws ExceptionHugin {
        this.setTitle(HuginGUIConstants.get("MENU_FILE_Print_ComponentTree"));
        this.ct = componentTree;
        this.tabs.add((Component)this.createComponentTreeTab(this.ct), HuginGUIConstants.get("PRINTER_Print_Component_tree"));
        this.preview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PageFormat pageFormat = Printer.this.print.defaultPage();
                Printer.this.setupPaper(pageFormat, Printer.this.attribs);
                try {
                    PrintPreview printPreview = new PrintPreview(Printer.this, pageFormat, new ComponentTreePage(Printer.this.ct, Printer.this.printName.isSelected(), Printer.this.printDate.isSelected(), (double)((Integer)Printer.this.scaleFactor.getValue()).intValue() / 100.0, Printer.this.fitToPage.isSelected(), ""));
                    printPreview.pack();
                    HuginGUIUtils.placeNextTo(Printer.this, printPreview);
                    printPreview.setVisible(true);
                    if (printPreview.getResult() == 1) {
                        Printer.this.dispose();
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(HuginGUIConstants.get("str_unable_to_show_preview_") + exception.getMessage());
                }
            }
        });
        this.setVisible(true);
        if (this.cancelled) {
            return;
        }
        try {
            this.fillInAttributes(this.attribs);
            this.print.setPrintable(new ComponentTreePage(this.ct, this.printName.isSelected(), this.printDate.isSelected(), (double)((Integer)this.scaleFactor.getValue()).intValue() / 100.0, this.fitToPage.isSelected(), ""));
            this.thread.setup(this.print, this.attribs, huginProjectFrame);
            this.thread.start();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public void printText(String string, HuginProjectFrame huginProjectFrame) throws ExceptionHugin {
        this.setTitle(HuginGUIConstants.get("LOG_VIEW_Print_Log"));
        this.textToPrint = string;
        this.title = huginProjectFrame.getTitle();
        this.preview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PageFormat pageFormat = Printer.this.print.defaultPage();
                Printer.this.setupPaper(pageFormat, Printer.this.attribs);
                PrintPreview printPreview = new PrintPreview(Printer.this, pageFormat, new TextPage(Printer.this.textToPrint, Printer.this.printName.isSelected() ? Printer.this.title : null, Printer.this.printDate.isSelected()));
                printPreview.pack();
                HuginGUIUtils.placeNextTo(Printer.this, printPreview);
                printPreview.setVisible(true);
                if (printPreview.getResult() == 1) {
                    Printer.this.dispose();
                }
            }
        });
        this.setVisible(true);
        if (this.cancelled) {
            return;
        }
        try {
            this.fillInAttributes(this.attribs);
            this.print.setPrintable(new TextPage(this.textToPrint, this.printName.isSelected() ? this.title : null, this.printDate.isSelected()));
            this.thread.setup(this.print, this.attribs, huginProjectFrame);
            this.thread.start();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private void setupPaper(PageFormat pageFormat, PrintRequestAttributeSet printRequestAttributeSet) {
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(MediaPrintableArea.class);
        if (mediaPrintableArea != null) {
            Paper paper = pageFormat.getPaper();
            float[] fArray = mediaPrintableArea.getPrintableArea(25400);
            if (printRequestAttributeSet.get(OrientationRequested.class) == OrientationRequested.LANDSCAPE || printRequestAttributeSet.get(OrientationRequested.class) == OrientationRequested.REVERSE_LANDSCAPE) {
                float f = fArray[0];
                fArray[0] = fArray[1];
                fArray[1] = f;
                f = fArray[2];
                fArray[2] = fArray[3];
                fArray[3] = f;
            }
            paper.setImageableArea(fArray[0] * 72.0f, fArray[1] * 72.0f, fArray[2] * 72.0f, fArray[3] * 72.0f);
            paper.setSize((2.0f * fArray[0] + fArray[2]) * 72.0f, (2.0f * fArray[1] + fArray[3]) * 72.0f);
            pageFormat.setPaper(paper);
        }
    }

    private void createDialog() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabs = new JTabbedPane();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("PRINTER_Destination")));
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1));
        JPanel jPanel5 = new JPanel(new GridLayout(2, 1));
        this.services = PrintServiceLookup.lookupPrintServices(null, null);
        this.printers = new JComboBox<PrintService>(new DefaultComboBoxModel<PrintService>(this.services));
        this.printers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Printer.this.print.setPrintService(Printer.this.services[Printer.this.printers.getSelectedIndex()]);
                }
                catch (Exception exception) {
                    new HuginGUIError(HuginGUIConstants.get("str_unable_to_use_printer_lb") + exception.getMessage());
                }
            }
        });
        this.print = PrinterJob.getPrinterJob();
        try {
            if (this.printers.getSelectedIndex() >= 0) {
                this.print.setPrintService(this.services[this.printers.getSelectedIndex()]);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(HuginGUIConstants.get("str_unable_to_use_printer_lb") + exception.getMessage());
        }
        jPanel5.add(this.printers);
        jPanel4.add(new JLabel(HuginGUIConstants.get("PRINTER_Printer")));
        JPanel jPanel6 = new JPanel(new BorderLayout(10, 10));
        this.destFile = new JCheckBox(HuginGUIConstants.get("PRINTER_File"));
        this.destFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Printer.this.printNow.setEnabled(!Printer.this.destFile.isSelected() || Printer.this.fileName.getText().trim().length() > 0);
            }
        });
        this.selectFile = new JButton(HuginGUIConstants.get("EMLearning_select_file"));
        this.selectFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(Printer.this.file);
                jFileChooser.setDialogTitle(HuginGUIConstants.get("BUG_REPORT_SELECT_FILE"));
                int n = jFileChooser.showDialog(Printer.this, HuginGUIConstants.get("BUG_REPORT_Select"));
                if (n == 0) {
                    Printer.this.fileName.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                    Printer.this.printNow.setEnabled(true);
                    Printer.this.destFile.setSelected(true);
                }
            }
        });
        this.fileName = new JTextField(15);
        this.fileName.setEditable(true);
        this.fileName.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                if (Printer.this.fileName.getText().trim().length() > 0) {
                    Printer.this.printNow.setEnabled(true);
                    Printer.this.destFile.setSelected(true);
                } else {
                    Printer.this.printNow.setEnabled(true);
                    Printer.this.destFile.setSelected(false);
                }
            }
        });
        jPanel6.add(this.fileName);
        jPanel6.add((Component)this.selectFile, "East");
        jPanel4.add(this.destFile);
        jPanel5.add(jPanel6);
        this.pageSetup = new JButton(HuginGUIConstants.get("PRINTER_Page_setup"));
        this.pageSetup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Printer.this.print.pageDialog(Printer.this.attribs);
            }
        });
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        jPanel7.add(this.pageSetup);
        jPanel3.add((Component)jPanel4, "West");
        jPanel3.add(jPanel5);
        jPanel3.add((Component)jPanel7, "South");
        JPanel jPanel8 = new JPanel(new GridLayout(2, 1));
        jPanel8.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("PRINTER_Other")));
        this.printName = new JCheckBox(HuginGUIConstants.get("PRINTER_Print_name"));
        this.printName.setSelected(true);
        this.printDate = new JCheckBox(HuginGUIConstants.get("PRINTER_Print_date"));
        this.printDate.setSelected(true);
        jPanel8.add(this.printName);
        jPanel8.add(this.printDate);
        JPanel jPanel9 = new JPanel(new BorderLayout());
        jPanel9.add((Component)jPanel3, "North");
        JPanel jPanel10 = new JPanel(new BorderLayout());
        jPanel10.add((Component)jPanel8, "North");
        jPanel9.add(jPanel10);
        jPanel2.add(jPanel9);
        this.tabs.add((Component)jPanel2, HuginGUIConstants.get("PRINTER_General"));
        JPanel jPanel11 = new JPanel(new FlowLayout(2));
        this.printNow = new JButton(HuginGUIConstants.get("PRINTER_Print"));
        this.printNow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Printer.this.cancelled = false;
                Printer.this.dispose();
            }
        });
        this.cancel = new JButton(HuginGUIConstants.get("cancel_button"));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Printer.this.cancelled = true;
                Printer.this.dispose();
            }
        });
        this.preview = new JButton(HuginGUIConstants.get("str_preview"));
        jPanel11.add(this.cancel);
        jPanel11.add(this.preview);
        jPanel11.add(this.printNow);
        jPanel.add(this.tabs);
        jPanel.add((Component)jPanel11, "South");
        this.setContentPane(jPanel);
        this.getRootPane().setDefaultButton(this.printNow);
    }

    private JPanel createNetworkTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.includeMonitors = new JCheckBox(HuginGUIConstants.get("PRINTER_IncludeMonitors"));
        try {
            this.includeMonitors.setEnabled(this.frame.getSelectedProjectFrame().runMode);
        }
        catch (Exception exception) {
            this.includeMonitors.setEnabled(false);
        }
        this.network.setIncludeMonitors(false);
        this.includeMonitors.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Printer.this.includeMonitors.isSelected()) {
                    Printer.this.network.setIncludeMonitors(true);
                } else {
                    Printer.this.network.setIncludeMonitors(false);
                }
            }
        });
        this.fitToPage = new JCheckBox(HuginGUIConstants.get("PRINTER_FitToPage"));
        this.fitToPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (Printer.this.fitToPage.isSelected()) {
                        double d = Printer.this.getFittingFactor(Printer.this.network.getBoundingBox());
                        Printer.this.inFit = true;
                        Printer.this.scaleFactor.setValue(new Integer((int)(d * 100.0)));
                        Printer.this.inFit = false;
                        Printer.this.occupy.setText(HuginGUIConstants.get("PRINTER_Occupy1") + " 1x1 " + HuginGUIConstants.get("PRINTER_Occupy2"));
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        this.fitToPage.setSelected(true);
        int n = 100;
        try {
            n = (int)(this.getFittingFactor(this.network.getBoundingBox()) * 100.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        this.scaleFactor = new JSpinner(new SpinnerNumberModel(n, 5, 10000, 5));
        this.scaleFactor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    int n;
                    int n2;
                    Printer.this.fitToPage.setSelected(Printer.this.inFit);
                    Rectangle rectangle = Printer.this.network.getBoundingBox();
                    MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)Printer.this.attribs.get(MediaPrintableArea.class);
                    if (mediaPrintableArea != null) {
                        n2 = (int)mediaPrintableArea.getHeight(25400) * 72;
                        n = (int)mediaPrintableArea.getWidth(25400) * 72;
                        if (Printer.this.attribs.get(OrientationRequested.class) == OrientationRequested.LANDSCAPE || Printer.this.attribs.get(OrientationRequested.class) == OrientationRequested.REVERSE_LANDSCAPE) {
                            int n3 = n;
                            n = n2;
                            n2 = n3;
                        }
                    } else {
                        PageFormat pageFormat = Printer.this.print.defaultPage();
                        n2 = (int)pageFormat.getImageableHeight();
                        n = (int)pageFormat.getImageableWidth();
                    }
                    double d = (double)((Integer)Printer.this.scaleFactor.getValue()).intValue() / 100.0;
                    int n4 = (int)Math.ceil(rectangle.getWidth() * d / (double)n);
                    int n5 = (int)Math.ceil(rectangle.getHeight() * d / (double)n2);
                    Printer.this.occupy.setText(HuginGUIConstants.get("PRINTER_Occupy1") + " " + n4 + "x" + n5 + " " + HuginGUIConstants.get("PRINTER_Occupy2"));
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        jPanel2.add(new JLabel(HuginGUIConstants.get("PRINTER_ScaleFactor")));
        jPanel2.add(this.scaleFactor);
        jPanel2.add(new JLabel(" % "));
        this.occupy = new JLabel(HuginGUIConstants.get("PRINTER_Occupy1") + " 1x1 " + HuginGUIConstants.get("PRINTER_Occupy2"));
        JPanel jPanel3 = new JPanel(new GridLayout(4, 1));
        jPanel3.add(this.includeMonitors);
        jPanel3.add(this.fitToPage);
        jPanel3.add(jPanel2);
        jPanel3.add(this.occupy);
        jPanel.add((Component)jPanel3, "North");
        return jPanel;
    }

    private double getFittingFactor(Rectangle rectangle) throws PrinterException {
        int n;
        int n2;
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)this.attribs.get(MediaPrintableArea.class);
        if (mediaPrintableArea != null) {
            n2 = (int)mediaPrintableArea.getHeight(25400) * 72;
            n = (int)mediaPrintableArea.getWidth(25400) * 72;
            if (this.attribs.get(OrientationRequested.class) == OrientationRequested.LANDSCAPE || this.attribs.get(OrientationRequested.class) == OrientationRequested.REVERSE_LANDSCAPE) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
        } else {
            PageFormat pageFormat = this.print.defaultPage();
            n2 = (int)pageFormat.getImageableHeight();
            n = (int)pageFormat.getImageableWidth();
        }
        return Math.min(1.0, Math.min((double)n / rectangle.getWidth(), (double)n2 / rectangle.getHeight()));
    }

    private JPanel createTableTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(4, 1));
        this.printAll = new JRadioButton(HuginGUIConstants.get("PRINTER_Print_all_tables"));
        this.printSelected = new JRadioButton(HuginGUIConstants.get("PRINTER_Print_selected_tables"));
        this.printOpen = new JRadioButton(HuginGUIConstants.get("PRINTER_Print_open_tables"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.printAll);
        buttonGroup.add(this.printSelected);
        buttonGroup.add(this.printOpen);
        if (this.network.selectedNodes.size() > 0) {
            this.printSelected.setSelected(true);
            this.printAll.setSelected(false);
            this.printOpen.setSelected(false);
        } else {
            this.printAll.setSelected(true);
            this.printSelected.setEnabled(false);
            this.printOpen.setSelected(false);
        }
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        this.scaleFactor = new JSpinner(new SpinnerNumberModel(100, 5, 1000, 5));
        jPanel3.add(new JLabel(HuginGUIConstants.get("PRINTER_ScaleFactor")));
        jPanel3.add(this.scaleFactor);
        jPanel3.add(new JLabel(" % "));
        jPanel2.add(this.printAll);
        jPanel2.add(this.printSelected);
        jPanel2.add(this.printOpen);
        jPanel2.add(jPanel3);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private JPanel createProbabilitiesTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        this.printAll = new JRadioButton(HuginGUIConstants.get("PRINTER_Print_all_probabilities"));
        this.printSelected = new JRadioButton(HuginGUIConstants.get("PRINTER_Print_selected_probabilities"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.printAll);
        buttonGroup.add(this.printSelected);
        if (this.network.selectedNodes.size() > 0) {
            this.printSelected.setSelected(true);
        } else {
            this.printAll.setSelected(true);
            this.printSelected.setEnabled(false);
        }
        jPanel2.add(this.printAll);
        jPanel2.add(this.printSelected);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private JPanel createJunctionTreeTab(JunctionTree junctionTree) {
        this.jTree = junctionTree;
        this.treeBounds = junctionTree.getBounds();
        this.treeBounds.setSize(junctionTree.getPreferredSize());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.fitToPage = new JCheckBox(HuginGUIConstants.get("PRINTER_FitToPage"));
        this.fitToPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (Printer.this.fitToPage.isSelected()) {
                        double d = Printer.this.getFittingFactor(Printer.this.treeBounds);
                        Printer.this.inFit = true;
                        Printer.this.scaleFactor.setValue(new Integer((int)(d * 100.0)));
                        Printer.this.inFit = false;
                        Printer.this.occupy.setText(HuginGUIConstants.get("PRINTER_Occupy3") + " 1x1 " + HuginGUIConstants.get("PRINTER_Occupy2"));
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        this.fitToPage.setSelected(true);
        int n = 100;
        try {
            n = (int)(this.getFittingFactor(this.treeBounds) * 100.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        this.scaleFactor = new JSpinner(new SpinnerNumberModel(n, 5, 10000, 5));
        this.scaleFactor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    int n;
                    int n2;
                    Printer.this.fitToPage.setSelected(Printer.this.inFit);
                    MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)Printer.this.attribs.get(MediaPrintableArea.class);
                    if (mediaPrintableArea != null) {
                        n2 = (int)mediaPrintableArea.getHeight(25400) * 72;
                        n = (int)mediaPrintableArea.getWidth(25400) * 72;
                        if (Printer.this.attribs.get(OrientationRequested.class) == OrientationRequested.LANDSCAPE || Printer.this.attribs.get(OrientationRequested.class) == OrientationRequested.REVERSE_LANDSCAPE) {
                            int n3 = n;
                            n = n2;
                            n2 = n3;
                        }
                    } else {
                        PageFormat pageFormat = Printer.this.print.defaultPage();
                        n2 = (int)pageFormat.getImageableHeight();
                        n = (int)pageFormat.getImageableWidth();
                    }
                    double d = (double)((Integer)Printer.this.scaleFactor.getValue()).intValue() / 100.0;
                    Printer.this.jTree.setScaleFactor(d);
                    Dimension dimension = Printer.this.jTree.getPreferredSize();
                    int n4 = (int)Math.ceil(dimension.getWidth() / (double)n);
                    int n5 = (int)Math.ceil(dimension.getHeight() / (double)n2);
                    Printer.this.occupy.setText(HuginGUIConstants.get("PRINTER_Occupy3") + " " + n4 + "x" + n5 + " " + HuginGUIConstants.get("PRINTER_Occupy2"));
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        jPanel2.add(new JLabel(HuginGUIConstants.get("PRINTER_ScaleFactor")));
        jPanel2.add(this.scaleFactor);
        jPanel2.add(new JLabel(" % "));
        this.occupy = new JLabel(HuginGUIConstants.get("PRINTER_Occupy3") + " 1x1 " + HuginGUIConstants.get("PRINTER_Occupy2"));
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1));
        jPanel3.add(this.fitToPage);
        jPanel3.add(jPanel2);
        jPanel3.add(this.occupy);
        jPanel.add((Component)jPanel3, "North");
        return jPanel;
    }

    private JPanel createComponentTreeTab(ComponentTree componentTree) {
        this.cTree = componentTree;
        this.compBounds = componentTree.getBounds();
        this.compBounds.setSize(componentTree.getPreferredSize());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.fitToPage = new JCheckBox(HuginGUIConstants.get("PRINTER_FitToPage"));
        this.fitToPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (Printer.this.fitToPage.isSelected()) {
                        double d = Printer.this.getFittingFactor(Printer.this.compBounds);
                        Printer.this.inFit = true;
                        Printer.this.scaleFactor.setValue(new Integer((int)(d * 100.0)));
                        Printer.this.inFit = false;
                        Printer.this.occupy.setText(HuginGUIConstants.get("PRINTER_Occupy_componentTree") + " 1x1 " + HuginGUIConstants.get("PRINTER_Occupy2"));
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        this.fitToPage.setSelected(true);
        int n = 100;
        try {
            n = (int)(this.getFittingFactor(this.compBounds) * 100.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        this.scaleFactor = new JSpinner(new SpinnerNumberModel(n, 5, 10000, 5));
        this.scaleFactor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    int n;
                    int n2;
                    Printer.this.fitToPage.setSelected(Printer.this.inFit);
                    MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)Printer.this.attribs.get(MediaPrintableArea.class);
                    if (mediaPrintableArea != null) {
                        n2 = (int)mediaPrintableArea.getHeight(25400) * 72;
                        n = (int)mediaPrintableArea.getWidth(25400) * 72;
                        if (Printer.this.attribs.get(OrientationRequested.class) == OrientationRequested.LANDSCAPE || Printer.this.attribs.get(OrientationRequested.class) == OrientationRequested.REVERSE_LANDSCAPE) {
                            int n3 = n;
                            n = n2;
                            n2 = n3;
                        }
                    } else {
                        PageFormat pageFormat = Printer.this.print.defaultPage();
                        n2 = (int)pageFormat.getImageableHeight();
                        n = (int)pageFormat.getImageableWidth();
                    }
                    double d = (double)((Integer)Printer.this.scaleFactor.getValue()).intValue() / 100.0;
                    Printer.this.cTree.setScaleFactor(d);
                    Dimension dimension = Printer.this.cTree.getPreferredSize();
                    int n4 = (int)Math.ceil(dimension.getWidth() / (double)n);
                    int n5 = (int)Math.ceil(dimension.getHeight() / (double)n2);
                    Printer.this.occupy.setText(HuginGUIConstants.get("PRINTER_Occupy_componentTree") + " " + n4 + "x" + n5 + " " + HuginGUIConstants.get("PRINTER_Occupy2"));
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        jPanel2.add(new JLabel(HuginGUIConstants.get("PRINTER_ScaleFactor")));
        jPanel2.add(this.scaleFactor);
        jPanel2.add(new JLabel(" % "));
        this.occupy = new JLabel(HuginGUIConstants.get("PRINTER_Occupy_componentTree") + " 1x1 " + HuginGUIConstants.get("PRINTER_Occupy2"));
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1));
        jPanel3.add(this.fitToPage);
        jPanel3.add(jPanel2);
        jPanel3.add(this.occupy);
        jPanel.add((Component)jPanel3, "North");
        return jPanel;
    }

    private void fillInAttributes(PrintRequestAttributeSet printRequestAttributeSet) {
        if (this.destFile.isSelected()) {
            printRequestAttributeSet.add(new Destination(new File(this.fileName.getText()).toURI()));
        }
    }

    class PrintJobWatcher {
        boolean done = false;

        PrintJobWatcher(DocPrintJob docPrintJob) {
            docPrintJob.addPrintJobListener(new PrintJobAdapter(){

                public void printJobCanceled(PrintJobEvent printJobEvent) {
                    this.allDone();
                }

                public void printJobCompleted(PrintJobEvent printJobEvent) {
                    this.allDone();
                }

                public void printJobFailed(PrintJobEvent printJobEvent) {
                    this.allDone();
                }

                public void printJobNoMoreEvents(PrintJobEvent printJobEvent) {
                    this.allDone();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                void allDone() {
                    PrintJobWatcher printJobWatcher = PrintJobWatcher.this;
                    synchronized (printJobWatcher) {
                        PrintJobWatcher.this.done = true;
                        PrintJobWatcher.this.notify();
                    }
                }
            });
        }

        public synchronized void waitForDone() {
            try {
                while (!this.done) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class PrintThread
    extends Thread {
        PrintRequestAttributeSet attribs;
        PrinterJob job;
        HuginProjectFrame owner;
        Printable printable;

        protected void setup(PrinterJob printerJob, PrintRequestAttributeSet printRequestAttributeSet, HuginProjectFrame huginProjectFrame) {
            this.job = printerJob;
            this.attribs = printRequestAttributeSet;
            this.owner = huginProjectFrame;
            this.printable = this.printable;
        }

        protected void setup(PrinterJob printerJob, PrintRequestAttributeSet printRequestAttributeSet, HuginProjectFrame huginProjectFrame, Printable printable) {
            this.job = printerJob;
            this.attribs = printRequestAttributeSet;
            this.owner = huginProjectFrame;
            this.printable = printable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (this.owner != null) {
                    this.owner.isPrinting(true);
                }
                if (this.printable == null) {
                    this.job.print(this.attribs);
                } else {
                    DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
                    SimpleDoc simpleDoc = new SimpleDoc(this.printable, sERVICE_FORMATTED, null);
                    DocPrintJob docPrintJob = this.job.getPrintService().createPrintJob();
                    PrintJobWatcher printJobWatcher = new PrintJobWatcher(docPrintJob);
                    docPrintJob.print(simpleDoc, this.attribs);
                    printJobWatcher.waitForDone();
                }
            }
            catch (Exception exception) {
                new HuginGUIError(HuginGUIConstants.get("str_unable_to_finish_print_lb") + exception.getMessage());
            }
            finally {
                if (this.owner != null) {
                    this.owner.isPrinting(false);
                }
            }
        }
    }
}

