/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.InternalTable;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NodeTable;
import COM.hugin.HGUI.TableInitializer;
import COM.hugin.HGUI.TitledPanel;
import COM.hugin.HGUI.WizardError;
import COM.hugin.HGUI.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class PriorDistributionsPanel
extends WizardPanel {
    Domain domain;
    InternalTable priorTable;
    JButton resetAll;
    JButton resetSelected;
    JButton randomizeAll;
    JButton randomizeSelected;
    JComboBox variable;
    private boolean updating = false;
    InternalTable experienceTable;
    JButton resetAllExperience;
    JButton resetSelectedExperience;
    JButton initializeAllExperience;
    JButton initializeSelectedExperience;
    JButton deleteExperience;
    JButton createExperience;
    JComboBox variableExperience;
    JPanel tableToNorth;
    boolean tablePanelEmpty = false;
    private static final int RESET_ALL_CPT = 0;
    private static final int RANDOMIZE_ALL_CPT = 1;
    private static final int RESET_ALL_EXPERIENCE = 2;
    private static final int INITIALIZE_ALL_EXPERIENCE = 3;

    public PriorDistributionsPanel(Domain domain, JButton[] jButtonArray) {
        super("Prior Distribution Knowledge");
        this.buttons = jButtonArray;
        this.domain = domain;
        try {
            domain.generateTables();
        }
        catch (Exception exception) {
            new HuginGUIError(exception.getMessage() + " " + "The generation of tables has failed due to at least one invalid expression. Some tables have not been generated correctly");
        }
        this.setImage(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("images/prior_knowledge.jpg")));
        this.interior = this.createInterior();
        this.addComponents();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (PriorDistributionsPanel.this.priorTable != null) {
                    PriorDistributionsPanel.this.priorTable.setMaxSize(PriorDistributionsPanel.this.interior.getWidth(), PriorDistributionsPanel.this.tableToNorth.getHeight() - 2);
                }
                PriorDistributionsPanel.this.priorTable.dispatchEvent(new ComponentEvent(PriorDistributionsPanel.this, 101));
                if (PriorDistributionsPanel.this.experienceTable != null) {
                    PriorDistributionsPanel.this.experienceTable.setMaxSize(PriorDistributionsPanel.this.interior.getWidth(), PriorDistributionsPanel.this.tableToNorth.getHeight() - 2);
                    PriorDistributionsPanel.this.experienceTable.dispatchEvent(new ComponentEvent(PriorDistributionsPanel.this, 101));
                }
                PriorDistributionsPanel.this.doLayout();
            }
        });
    }

    private Component createInterior() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        try {
            jTabbedPane.addTab("Distributions", this.createPriorDistributionsPanel());
            jTabbedPane.addTab("Experience", this.createExperiencePanel());
        }
        catch (ExceptionHugin exceptionHugin) {
            jTabbedPane.removeAll();
            jTabbedPane.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new GridLayout(2, 1));
            jPanel.add(new JLabel(HuginGUIConstants.get("str_unable_to_initialize_")));
            jPanel.add(new JLabel(exceptionHugin.getMessage()));
            jTabbedPane.add((Component)jPanel, "North");
        }
        return jTabbedPane;
    }

    private JPanel createPriorDistributionsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        this.variable = new JComboBox(new NodeListModel(this.domain));
        if (this.variable.getItemCount() == 0) {
            return jPanel;
        }
        this.variable.setSelectedIndex(0);
        this.variable.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!PriorDistributionsPanel.this.updating) {
                    PriorDistributionsPanel.this.updating = true;
                    PriorDistributionsPanel.this.variableExperience.setSelectedIndex(PriorDistributionsPanel.this.variable.getSelectedIndex());
                    PriorDistributionsPanel.this.updating = false;
                }
                PriorDistributionsPanel.this.priorTable.invalidate();
                COM.hugin.HAPI.Node node = ((NodeWrapper)PriorDistributionsPanel.this.variable.getSelectedItem()).node;
                PriorDistributionsPanel.this.priorTable.setNode(node);
                PriorDistributionsPanel.this.resetAll.setEnabled(node instanceof DiscreteChanceNode);
                PriorDistributionsPanel.this.resetSelected.setEnabled(node instanceof DiscreteChanceNode);
                PriorDistributionsPanel.this.randomizeSelected.setEnabled(node instanceof DiscreteChanceNode);
                PriorDistributionsPanel.this.randomizeAll.setEnabled(node instanceof DiscreteChanceNode);
                PriorDistributionsPanel.this.validate();
            }
        });
        jPanel2.add(new JLabel("Variable"));
        jPanel2.add(this.variable);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "West");
        this.tableToNorth = new JPanel(new BorderLayout());
        try {
            this.priorTable = ((NodeWrapper)this.variable.getSelectedItem()).node instanceof ContinuousChanceNode ? new InternalTable(((NodeWrapper)this.variable.getSelectedItem()).node, this, 4) : new InternalTable(((NodeWrapper)this.variable.getSelectedItem()).node, this, 1);
        }
        catch (ExceptionHugin exceptionHugin) {
            WizardError.showError(HuginGUIConstants.get("str_error"), exceptionHugin.getMessage(), this);
        }
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2));
        TitledPanel titledPanel = new TitledPanel("Reset");
        titledPanel.setLayout(new GridLayout(2, 1));
        this.resetSelected = new JButton("Selected");
        this.resetSelected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PriorDistributionsPanel.this.resetSelectedTable(1, ((NodeWrapper)PriorDistributionsPanel.this.variable.getSelectedItem()).node);
                PriorDistributionsPanel.this.writeStatus(HuginGUIConstants.get("str_reset_probability_table_for_") + PriorDistributionsPanel.this.variable.getSelectedItem());
            }
        });
        this.resetAll = new JButton("All");
        this.resetAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PriorDistributionsPanel.this.confirmOperation(0)) {
                    PriorDistributionsPanel.this.resetAllTables(1, ((NodeWrapper)PriorDistributionsPanel.this.variable.getSelectedItem()).node);
                    PriorDistributionsPanel.this.writeStatus(HuginGUIConstants.get("str_reset_all_probability_tables"));
                }
            }
        });
        titledPanel.add(this.resetSelected);
        titledPanel.add(this.resetAll);
        TitledPanel titledPanel2 = new TitledPanel("Randomize");
        titledPanel2.setLayout(new GridLayout(2, 1));
        this.randomizeSelected = new JButton("Selected");
        this.randomizeSelected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PriorDistributionsPanel.this.randomizeSelectedTable(1, ((NodeWrapper)PriorDistributionsPanel.this.variable.getSelectedItem()).node);
                PriorDistributionsPanel.this.writeStatus(HuginGUIConstants.get("str_randomized_probability_table_for_") + PriorDistributionsPanel.this.variable.getSelectedItem());
            }
        });
        this.randomizeAll = new JButton("All");
        this.randomizeAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PriorDistributionsPanel.this.confirmOperation(1)) {
                    PriorDistributionsPanel.this.randomizeAllTables(1, ((NodeWrapper)PriorDistributionsPanel.this.variable.getSelectedItem()).node);
                    PriorDistributionsPanel.this.writeStatus(HuginGUIConstants.get("str_randomized_all_probability_tables"));
                }
            }
        });
        titledPanel2.add(this.randomizeSelected);
        titledPanel2.add(this.randomizeAll);
        jPanel4.add(titledPanel);
        jPanel4.add(titledPanel2);
        this.tableToNorth.add((Component)this.priorTable, "North");
        this.priorTable.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel.add((Component)jPanel3, "North");
        jPanel.add((Component)this.tableToNorth, "West");
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private JPanel createExperiencePanel() throws ExceptionHugin {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        this.variableExperience = new JComboBox(new NodeListModel(this.domain));
        if (this.variableExperience.getItemCount() == 0) {
            return jPanel;
        }
        this.variableExperience.setSelectedIndex(0);
        this.variableExperience.addItemListener(new ExperienceTableListener());
        jPanel2.add(new JLabel("Variable"));
        jPanel2.add(this.variableExperience);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "West");
        this.tableToNorth = new JPanel(new BorderLayout());
        if (((NodeWrapper)this.variableExperience.getSelectedItem()).node instanceof DiscreteChanceNode && ((DiscreteChanceNode)((NodeWrapper)this.variableExperience.getSelectedItem()).node).hasExperienceTable()) {
            try {
                this.experienceTable = new InternalTable(((NodeWrapper)this.variableExperience.getSelectedItem()).node, this, 2);
            }
            catch (ExceptionHugin exceptionHugin) {
                WizardError.showError(HuginGUIConstants.get("str_error"), exceptionHugin.getMessage(), this);
            }
        }
        if (((NodeWrapper)this.variableExperience.getSelectedItem()).node instanceof ContinuousChanceNode && ((ContinuousChanceNode)((NodeWrapper)this.variableExperience.getSelectedItem()).node).hasExperienceTable()) {
            try {
                this.experienceTable = new InternalTable(((NodeWrapper)this.variableExperience.getSelectedItem()).node, this, 2);
            }
            catch (ExceptionHugin exceptionHugin) {
                WizardError.showError(HuginGUIConstants.get("str_error"), exceptionHugin.getMessage(), this);
            }
        }
        JPanel jPanel4 = new JPanel(new GridLayout(1, 3));
        TitledPanel titledPanel = new TitledPanel("Reset");
        titledPanel.setLayout(new GridLayout(2, 1));
        this.resetSelectedExperience = new JButton("Selected");
        this.resetSelectedExperience.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PriorDistributionsPanel.this.resetSelectedTable(2, ((NodeWrapper)PriorDistributionsPanel.this.variableExperience.getSelectedItem()).node);
                PriorDistributionsPanel.this.writeStatus(HuginGUIConstants.get("str_reset_experience_table_for_") + PriorDistributionsPanel.this.variableExperience.getSelectedItem());
            }
        });
        this.resetAllExperience = new JButton("All");
        this.resetAllExperience.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PriorDistributionsPanel.this.confirmOperation(2)) {
                    PriorDistributionsPanel.this.resetAllTables(2, ((NodeWrapper)PriorDistributionsPanel.this.variableExperience.getSelectedItem()).node);
                    PriorDistributionsPanel.this.writeStatus(HuginGUIConstants.get("str_reset_all_experience_tables"));
                }
            }
        });
        titledPanel.add(this.resetSelectedExperience);
        titledPanel.add(this.resetAllExperience);
        TitledPanel titledPanel2 = new TitledPanel("Initialize");
        titledPanel2.setLayout(new GridLayout(2, 1));
        this.initializeSelectedExperience = new JButton("Selected");
        this.initializeSelectedExperience.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PriorDistributionsPanel.this.resetSelectedTable(2, ((NodeWrapper)PriorDistributionsPanel.this.variableExperience.getSelectedItem()).node, 1);
                PriorDistributionsPanel.this.writeStatus(HuginGUIConstants.get("str_initialized_experience_table_for_") + PriorDistributionsPanel.this.variableExperience.getSelectedItem());
            }
        });
        this.initializeAllExperience = new JButton("All");
        this.initializeAllExperience.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PriorDistributionsPanel.this.confirmOperation(3)) {
                    PriorDistributionsPanel.this.resetAllTables(2, ((NodeWrapper)PriorDistributionsPanel.this.variableExperience.getSelectedItem()).node, 1);
                    PriorDistributionsPanel.this.writeStatus(HuginGUIConstants.get("str_initialized_all_experience_tables"));
                }
            }
        });
        titledPanel2.add(this.initializeSelectedExperience);
        titledPanel2.add(this.initializeAllExperience);
        TitledPanel titledPanel3 = new TitledPanel("Table Existence");
        titledPanel3.setLayout(new GridLayout(2, 1));
        this.createExperience = new JButton("Create");
        boolean bl = false;
        if (((NodeWrapper)this.variableExperience.getSelectedItem()).node instanceof DiscreteChanceNode) {
            bl = ((DiscreteChanceNode)((NodeWrapper)this.variableExperience.getSelectedItem()).node).hasExperienceTable();
        } else if (((NodeWrapper)this.variableExperience.getSelectedItem()).node instanceof ContinuousChanceNode) {
            bl = ((ContinuousChanceNode)((NodeWrapper)this.variableExperience.getSelectedItem()).node).hasExperienceTable();
        }
        this.createExperience.setEnabled(!bl);
        this.createExperience.addActionListener(new CreateExperienceTableListener());
        this.deleteExperience = new JButton("Delete");
        this.deleteExperience.setEnabled(bl);
        this.deleteExperience.addActionListener(new DeleteExperienceTableListener());
        titledPanel3.add(this.createExperience);
        titledPanel3.add(this.deleteExperience);
        jPanel4.add(titledPanel);
        jPanel4.add(titledPanel2);
        jPanel4.add(titledPanel3);
        if (this.experienceTable != null) {
            this.tableToNorth.add((Component)this.experienceTable, "North");
            this.experienceTable.setBorder(BorderFactory.createLineBorder(Color.black));
        } else {
            this.tableToNorth.add((Component)new JLabel("No Experience Table"), "North");
            this.tablePanelEmpty = true;
            this.createExperience.setEnabled(true);
            this.deleteExperience.setEnabled(false);
            this.resetSelectedExperience.setEnabled(false);
        }
        jPanel.add((Component)jPanel3, "North");
        jPanel.add((Component)this.tableToNorth, "West");
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private void resetSelectedTable(int n, COM.hugin.HAPI.Node node) {
        this.resetSelectedTable(n, node, n == 2 ? 0 : 1);
    }

    private void resetSelectedTable(int n, COM.hugin.HAPI.Node node, int n2) {
        try {
            if (n == 2 && n2 == 1) {
                new TableInitializer((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), node, 1);
            } else if (node instanceof DiscreteChanceNode) {
                Table table = this.getTable(n, (DiscreteChanceNode)node);
                double[] dArray = table.getData();
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = n2;
                }
                table.setData(dArray);
            } else if (node instanceof ContinuousChanceNode) {
                Table table = this.getTable(n, (ContinuousChanceNode)node);
                double[] dArray = table.getData();
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = n2;
                }
                table.setData(dArray);
            }
            this.getLocalTable(n).setNode(node);
        }
        catch (ExceptionHugin exceptionHugin) {
            WizardError.showError(HuginGUIConstants.get("str_error"), exceptionHugin.getMessage(), this);
        }
    }

    private void resetAllTables(int n, COM.hugin.HAPI.Node node) {
        this.resetAllTables(n, node, n == 2 ? 0 : 1);
    }

    private void resetAllTables(int n, COM.hugin.HAPI.Node node, int n2) {
        try {
            Object object;
            if (n == 2 && n2 == 1) {
                object = new NodeList();
                for (COM.hugin.HAPI.Node node2 : ((NodeListModel)this.variable.getModel()).getNodes()) {
                    COM.hugin.HAPI.Node node3 = node2;
                    if (node3 instanceof DiscreteChanceNode && ((DiscreteChanceNode)node3).hasExperienceTable()) {
                        ((LinkedList)object).add(node3);
                        continue;
                    }
                    if (!(node3 instanceof ContinuousChanceNode) || !((ContinuousChanceNode)node3).hasExperienceTable()) continue;
                    ((LinkedList)object).add(node3);
                }
                new TableInitializer((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), (NodeList)object, 1);
            } else {
                for (COM.hugin.HAPI.Node node4 : ((NodeListModel)this.variable.getModel()).getNodes()) {
                    int n3;
                    double[] dArray;
                    Table table;
                    COM.hugin.HAPI.Node node5 = node4;
                    if (node5 instanceof DiscreteChanceNode && (table = this.getTable(n, (DiscreteChanceNode)node5)) != null) {
                        dArray = table.getData();
                        for (n3 = 0; n3 < dArray.length; ++n3) {
                            dArray[n3] = n2;
                        }
                        table.setData(dArray);
                    }
                    if (!(node5 instanceof ContinuousChanceNode) || n != 2 || (table = this.getTable(n, node5)) == null) continue;
                    dArray = table.getData();
                    for (n3 = 0; n3 < dArray.length; ++n3) {
                        dArray[n3] = n2;
                    }
                    table.setData(dArray);
                }
            }
            object = this.getLocalTable(n);
            if (object != null) {
                ((InternalTable)object).setNode(node);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            WizardError.showError(HuginGUIConstants.get("str_error"), exceptionHugin.getMessage(), this);
        }
    }

    private void randomizeSelectedTable(int n, COM.hugin.HAPI.Node node) {
        Random random = new Random();
        try {
            if (node instanceof DiscreteChanceNode) {
                int n2;
                Table table = this.getTable(n, (DiscreteChanceNode)node);
                double[] dArray = table.getData();
                int[] nArray = new int[dArray.length];
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    nArray[n2] = Math.abs(random.nextInt() % 100) + 1;
                }
                if (n == 1) {
                    n2 = ((DiscreteChanceNode)node).getNumberOfStates();
                    dArray = this.normalizeData(nArray, n2);
                } else {
                    for (n2 = 0; n2 < dArray.length; ++n2) {
                        dArray[n2] = nArray[n2];
                    }
                }
                table.setData(dArray);
                this.getLocalTable(n).setNode((DiscreteChanceNode)node);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            WizardError.showError(HuginGUIConstants.get("str_error"), exceptionHugin.getMessage(), this);
        }
    }

    private void randomizeAllTables(int n, COM.hugin.HAPI.Node node) {
        Random random = new Random();
        try {
            for (COM.hugin.HAPI.Node node2 : ((NodeListModel)this.variable.getModel()).getNodes()) {
                int n2;
                COM.hugin.HAPI.Node node3 = node2;
                if (!(node3 instanceof DiscreteChanceNode)) continue;
                Table table = this.getTable(n, (DiscreteChanceNode)node3);
                double[] dArray = table.getData();
                int[] nArray = new int[dArray.length];
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    nArray[n2] = Math.abs(random.nextInt() % 100) + 1;
                }
                if (n == 1) {
                    n2 = ((DiscreteChanceNode)node3).getNumberOfStates();
                    dArray = this.normalizeData(nArray, n2);
                } else {
                    for (n2 = 0; n2 < dArray.length; ++n2) {
                        dArray[n2] = nArray[n2];
                    }
                }
                table.setData(dArray);
            }
            InternalTable internalTable = this.getLocalTable(n);
            if (internalTable != null) {
                internalTable.setNode((DiscreteChanceNode)node);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            WizardError.showError(HuginGUIConstants.get("str_error"), exceptionHugin.getMessage(), this);
        }
    }

    private Table getTable(int n, COM.hugin.HAPI.Node node) {
        Table table = null;
        try {
            switch (n) {
                case 1: {
                    table = node instanceof DiscreteChanceNode ? ((DiscreteChanceNode)node).getTable() : ((ContinuousChanceNode)node).getTable();
                    break;
                }
                case 2: {
                    table = node instanceof DiscreteChanceNode ? (((DiscreteChanceNode)node).hasExperienceTable() ? ((DiscreteChanceNode)node).getExperienceTable() : null) : (((ContinuousChanceNode)node).hasExperienceTable() ? ((ContinuousChanceNode)node).getExperienceTable() : null);
                }
            }
        }
        catch (Exception exception) {
            WizardError.showError(HuginGUIConstants.get("str_error"), exception.getMessage(), this);
        }
        return table;
    }

    private InternalTable getLocalTable(int n) {
        InternalTable internalTable = null;
        switch (n) {
            case 1: {
                internalTable = this.priorTable;
                break;
            }
            case 2: {
                if (this.tablePanelEmpty) break;
                internalTable = this.experienceTable;
            }
        }
        return internalTable;
    }

    private double[] normalizeData(int[] nArray, int n) {
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length / n; ++i) {
            int n2;
            long l = 0L;
            for (n2 = 0; n2 < n; ++n2) {
                l += (long)nArray[i * n + n2];
            }
            for (n2 = 0; n2 < n; ++n2) {
                dArray[i * n + n2] = (double)Math.round(10000.0 * (double)nArray[i * n + n2] / (double)l) / 10000.0;
            }
        }
        return dArray;
    }

    public void back() {
        if (this.variableExperience.getSelectedItem() != null) {
            this.resetAllTables(1, ((NodeWrapper)this.variableExperience.getSelectedItem()).node);
            this.resetAllTables(2, ((NodeWrapper)this.variableExperience.getSelectedItem()).node);
        }
        this.getPrevious().reInitialize();
    }

    public String getHelpText() {
        return "";
    }

    public Domain getDomain() {
        return this.domain;
    }

    protected void reInitialize() {
        if (this.variable.getSelectedItem() == null) {
            return;
        }
        DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)((NodeWrapper)this.variable.getSelectedItem()).node;
        this.getLocalTable(1).setNode(discreteChanceNode);
        InternalTable internalTable = this.getLocalTable(2);
        if (internalTable != null) {
            internalTable.setNode((DiscreteChanceNode)((NodeWrapper)this.variableExperience.getSelectedItem()).node);
        }
    }

    private boolean confirmOperation(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "This will reset all conditional probability tables.\nDo you want to proceed ?";
                break;
            }
            case 1: {
                string = "This will randomize all conditional probability tables.\nDo you want to proceed ?";
                break;
            }
            case 2: {
                string = "This will reset all Experience tables.\nDo you want to proceed ?";
                break;
            }
            case 3: {
                string = "This will initialize all Experience tables.\nDo you want to proceed ?";
            }
        }
        return JOptionPane.showConfirmDialog(this, string, "Please confirm", 2) == 0;
    }

    public static void updateGuiAndDomainTables(Domain domain) {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object42;
            boolean bl = domain.getUserData() != null && domain.getUserData() instanceof Class;
            Vector<Cloneable> vector = new Vector<Cloneable>();
            if (!bl) {
                for (COM.hugin.HAPI.Node object5 : domain.getNodes()) {
                    object42 = (Node)object5.getGUINode();
                    if (!(object5 instanceof DiscreteChanceNode) && !(object5 instanceof ContinuousChanceNode)) continue;
                    vector.add((Cloneable)object42);
                }
            } else {
                Iterator<Object> iterator = new ArrayList();
                for (Object object42 : domain.getNodes()) {
                    object3 = (COM.hugin.HAPI.Node)((COM.hugin.HAPI.Node)object42).getSource().getLast();
                    object2 = ((COM.hugin.HAPI.Node)object3).getHomeClass();
                    if (object2 == null || ((ArrayList)((Object)iterator)).contains(object2)) continue;
                    ((ArrayList)((Object)iterator)).add(object2);
                }
                Iterator iterator2 = ((ArrayList)((Object)iterator)).iterator();
                while (iterator2.hasNext()) {
                    object42 = (Class)iterator2.next();
                    object3 = HuginGUIFrame.getNetworkPanel((NetworkModel)object42);
                    object2 = ((NetworkPanel)object3).nodeList.iterator();
                    while (object2.hasNext()) {
                        object = (Node)object2.next();
                        vector.add((Cloneable)object);
                    }
                }
                for (Object object42 : domain.getNodes()) {
                    ContinuousChanceNode continuousChanceNode;
                    object3 = (COM.hugin.HAPI.Node)((COM.hugin.HAPI.Node)object42).getSource().getLast();
                    object2 = object42 instanceof DiscreteChanceNode ? (DiscreteChanceNode)object42 : null;
                    Object object5 = object = object3 instanceof DiscreteChanceNode ? (DiscreteChanceNode)object3 : null;
                    if (object2 != null && ((DiscreteChanceNode)object2).hasExperienceTable() != ((DiscreteChanceNode)object).hasExperienceTable()) {
                        if (((DiscreteChanceNode)object).hasExperienceTable()) {
                            ((DiscreteChanceNode)object2).getExperienceTable();
                        } else {
                            ((DiscreteChanceNode)object2).getExperienceTable().delete();
                        }
                    }
                    ContinuousChanceNode continuousChanceNode2 = object42 instanceof ContinuousChanceNode ? (ContinuousChanceNode)object42 : null;
                    ContinuousChanceNode continuousChanceNode3 = continuousChanceNode = object3 instanceof ContinuousChanceNode ? (ContinuousChanceNode)object3 : null;
                    if (continuousChanceNode2 == null || continuousChanceNode2.hasExperienceTable() == continuousChanceNode.hasExperienceTable()) continue;
                    if (continuousChanceNode.hasExperienceTable()) {
                        continuousChanceNode2.getExperienceTable();
                        continue;
                    }
                    continuousChanceNode2.getExperienceTable().delete();
                }
            }
            for (Node node : vector) {
                object42 = node.getAPINode();
                object3 = object42 instanceof DiscreteChanceNode ? (DiscreteChanceNode)object42 : null;
                Object object6 = object2 = object42 instanceof ContinuousChanceNode ? (ContinuousChanceNode)object42 : null;
                if ((object3 != null || object2 != null) && node != null && node.getTable() != null && node.getTable().getTable() != null) {
                    boolean bl2;
                    object = node.getTable().getTable();
                    boolean bl3 = object3 != null ? ((DiscreteChanceNode)object3).hasExperienceTable() : (bl2 = object2 != null ? ((ContinuousChanceNode)object2).hasExperienceTable() : false);
                    if (((NodeTable)object).showExperience() != bl2) {
                        ((NodeTable)object).showExperience(bl2);
                    }
                }
                if (node == null) continue;
                node.updateTable();
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private class NodeWrapper {
        COM.hugin.HAPI.Node node;
        String label;

        public NodeWrapper(COM.hugin.HAPI.Node node) {
            this.node = node;
            try {
                this.label = node.getLabel();
                if (this.label == null || this.label.length() == 0) {
                    this.label = node.getName();
                }
            }
            catch (Exception exception) {
                WizardError.showError(HuginGUIConstants.get("str_error"), exception.getMessage(), PriorDistributionsPanel.this);
            }
        }

        public String toString() {
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeListModel
    extends DefaultComboBoxModel {
        ArrayList<NodeWrapper> nodes;
        ArrayList<COM.hugin.HAPI.Node> addedNodes = new ArrayList();

        public NodeListModel(Domain domain) {
            this.nodes = new ArrayList();
            if (domain.getUserData() instanceof Class) {
                try {
                    for (COM.hugin.HAPI.Node node : domain.getNodes()) {
                        COM.hugin.HAPI.Node node2 = null;
                        if (node instanceof DiscreteChanceNode || node instanceof ContinuousChanceNode) {
                            node2 = (COM.hugin.HAPI.Node)node.getSource().getLast();
                        }
                        if (node2 == null || this.addedNodes.contains(node2)) continue;
                        this.addedNodes.add(node2);
                        this.nodes.add(new NodeWrapper(node2));
                    }
                }
                catch (Exception exception) {
                    WizardError.showError(HuginGUIConstants.get("str_error"), exception.getMessage(), PriorDistributionsPanel.this);
                }
            } else {
                try {
                    for (COM.hugin.HAPI.Node node : domain.getNodes()) {
                        if (node instanceof DiscreteChanceNode) {
                            this.nodes.add(new NodeWrapper(node));
                            this.addedNodes.add(node);
                        }
                        if (!(node instanceof ContinuousChanceNode)) continue;
                        this.nodes.add(new NodeWrapper(node));
                        this.addedNodes.add(node);
                    }
                }
                catch (Exception exception) {
                    WizardError.showError(HuginGUIConstants.get("str_error"), exception.getMessage(), PriorDistributionsPanel.this);
                }
            }
        }

        @Override
        public int getSize() {
            return this.nodes.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.nodes.get(n);
        }

        public ArrayList<COM.hugin.HAPI.Node> getNodes() {
            return this.addedNodes;
        }
    }

    private class DeleteExperienceTableListener
    implements ActionListener {
        private DeleteExperienceTableListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Table table;
                COM.hugin.HAPI.Node node = ((NodeWrapper)PriorDistributionsPanel.this.variableExperience.getSelectedItem()).node;
                Table table2 = node instanceof DiscreteChanceNode ? (((DiscreteChanceNode)node).hasExperienceTable() ? ((DiscreteChanceNode)node).getExperienceTable() : null) : (table = ((ContinuousChanceNode)node).hasExperienceTable() ? ((ContinuousChanceNode)node).getExperienceTable() : null);
                if (table != null) {
                    table.delete();
                    PriorDistributionsPanel.this.tableToNorth.invalidate();
                    PriorDistributionsPanel.this.tableToNorth.removeAll();
                    PriorDistributionsPanel.this.tableToNorth.add((Component)new JLabel("No Experience Table"), "North");
                    PriorDistributionsPanel.this.tablePanelEmpty = true;
                    PriorDistributionsPanel.this.tableToNorth.validate();
                    PriorDistributionsPanel.this.tableToNorth.repaint();
                }
                PriorDistributionsPanel.this.createExperience.setEnabled(true);
                PriorDistributionsPanel.this.deleteExperience.setEnabled(false);
                PriorDistributionsPanel.this.resetSelectedExperience.setEnabled(false);
                PriorDistributionsPanel.this.writeStatus("Deleted experience table for " + PriorDistributionsPanel.this.variableExperience.getSelectedItem());
            }
            catch (Exception exception) {
                WizardError.showError(HuginGUIConstants.get("str_error"), exception.getMessage(), PriorDistributionsPanel.this);
            }
        }
    }

    private class CreateExperienceTableListener
    implements ActionListener {
        private CreateExperienceTableListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                COM.hugin.HAPI.Node node = ((NodeWrapper)PriorDistributionsPanel.this.variableExperience.getSelectedItem()).node;
                if (PriorDistributionsPanel.this.tablePanelEmpty) {
                    PriorDistributionsPanel.this.tableToNorth.invalidate();
                    PriorDistributionsPanel.this.tableToNorth.removeAll();
                    if (PriorDistributionsPanel.this.experienceTable == null) {
                        PriorDistributionsPanel.this.experienceTable = new InternalTable(node, PriorDistributionsPanel.this, 2);
                        PriorDistributionsPanel.this.experienceTable.setBorder(BorderFactory.createLineBorder(Color.black));
                    }
                    PriorDistributionsPanel.this.experienceTable.setNode(node);
                    PriorDistributionsPanel.this.tableToNorth.add((Component)PriorDistributionsPanel.this.experienceTable, "North");
                    PriorDistributionsPanel.this.tablePanelEmpty = false;
                    PriorDistributionsPanel.this.tableToNorth.validate();
                    PriorDistributionsPanel.this.tableToNorth.repaint();
                }
                PriorDistributionsPanel.this.createExperience.setEnabled(false);
                PriorDistributionsPanel.this.deleteExperience.setEnabled(true);
                PriorDistributionsPanel.this.resetSelectedExperience.setEnabled(true);
                PriorDistributionsPanel.this.writeStatus("Created experience table for " + PriorDistributionsPanel.this.variableExperience.getSelectedItem());
                PriorDistributionsPanel.this.validate();
            }
            catch (Exception exception) {
                WizardError.showError(HuginGUIConstants.get("str_error"), exception.getMessage(), PriorDistributionsPanel.this);
            }
        }
    }

    private class ExperienceTableListener
    implements ItemListener {
        private ExperienceTableListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (!PriorDistributionsPanel.this.updating) {
                PriorDistributionsPanel.this.updating = true;
                PriorDistributionsPanel.this.variable.setSelectedIndex(PriorDistributionsPanel.this.variableExperience.getSelectedIndex());
                PriorDistributionsPanel.this.updating = false;
            }
            ContinuousChanceNode continuousChanceNode = ((NodeWrapper)PriorDistributionsPanel.this.variableExperience.getSelectedItem()).node instanceof ContinuousChanceNode ? (ContinuousChanceNode)((NodeWrapper)PriorDistributionsPanel.this.variableExperience.getSelectedItem()).node : null;
            DiscreteChanceNode discreteChanceNode = ((NodeWrapper)PriorDistributionsPanel.this.variableExperience.getSelectedItem()).node instanceof DiscreteChanceNode ? (DiscreteChanceNode)((NodeWrapper)PriorDistributionsPanel.this.variableExperience.getSelectedItem()).node : null;
            try {
                PriorDistributionsPanel.this.tableToNorth.invalidate();
                if (discreteChanceNode != null && discreteChanceNode.hasExperienceTable() || continuousChanceNode != null && continuousChanceNode.hasExperienceTable()) {
                    if (PriorDistributionsPanel.this.experienceTable == null) {
                        PriorDistributionsPanel.this.experienceTable = new InternalTable(discreteChanceNode != null ? discreteChanceNode : continuousChanceNode, PriorDistributionsPanel.this, 2);
                        PriorDistributionsPanel.this.experienceTable.setBorder(BorderFactory.createLineBorder(Color.black));
                    }
                    PriorDistributionsPanel.this.experienceTable.invalidate();
                    PriorDistributionsPanel.this.experienceTable.setNode(discreteChanceNode != null ? discreteChanceNode : continuousChanceNode);
                    if (PriorDistributionsPanel.this.tablePanelEmpty) {
                        PriorDistributionsPanel.this.tableToNorth.removeAll();
                        PriorDistributionsPanel.this.tableToNorth.add((Component)PriorDistributionsPanel.this.experienceTable, "North");
                    }
                    PriorDistributionsPanel.this.tablePanelEmpty = false;
                    PriorDistributionsPanel.this.createExperience.setEnabled(false);
                    PriorDistributionsPanel.this.deleteExperience.setEnabled(true);
                    PriorDistributionsPanel.this.resetSelectedExperience.setEnabled(true);
                } else {
                    PriorDistributionsPanel.this.tableToNorth.removeAll();
                    PriorDistributionsPanel.this.tableToNorth.add((Component)new JLabel("No Experience Table"), "North");
                    PriorDistributionsPanel.this.tablePanelEmpty = true;
                    PriorDistributionsPanel.this.createExperience.setEnabled(true);
                    PriorDistributionsPanel.this.deleteExperience.setEnabled(false);
                    PriorDistributionsPanel.this.resetSelectedExperience.setEnabled(false);
                }
                PriorDistributionsPanel.this.tableToNorth.repaint();
            }
            catch (Exception exception) {
                WizardError.showError(HuginGUIConstants.get("str_error"), exception.getMessage(), PriorDistributionsPanel.this);
            }
            PriorDistributionsPanel.this.validate();
        }
    }
}

