/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.UncertainEdge;
import COM.hugin.HGUI.AmbiguousRegion;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.PronelPanel;
import COM.hugin.HGUI.UncertainLink;
import COM.hugin.HGUI.UndoException;
import COM.hugin.HGUI.UndoableAction;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;

class PronelDecisionAction
extends UndoableAction {
    PronelPanel panel;
    UncertainLink link;
    AmbiguousRegion region;
    UncertainEdge.EdgeDecision decision;

    public PronelDecisionAction(PronelPanel pronelPanel, UncertainEdge.EdgeDecision edgeDecision, ImageIcon imageIcon) {
        super(pronelPanel, imageIcon);
        this.panel = pronelPanel;
        this.decision = edgeDecision;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.link = (UncertainLink)this.panel.selectedLinks.getFirst();
        try {
            this.link.getEdge().manualDecision(this.decision);
            this.panel.rebuildPronel();
            this.panel.repaint();
            this.makeUndoable();
            this.panel.updateComplete();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public void undo() throws UndoException {
    }

    public void redo() throws UndoException {
        try {
            UncertainLink uncertainLink = (UncertainLink)this.panel.getCorrespondingLink(this.link);
            uncertainLink.getEdge().manualDecision(this.decision);
            this.panel.rebuildPronel();
        }
        catch (Exception exception) {
            throw new UndoException(HuginGUIConstants.get("str_unable_to_redecide_") + this.link);
        }
    }

    public UndoableAction copy() {
        PronelDecisionAction pronelDecisionAction = new PronelDecisionAction(this.panel, this.decision, null);
        pronelDecisionAction.link = this.link;
        return pronelDecisionAction;
    }
}

