/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.UncertainEdge;
import COM.hugin.HAPI.UncertainEdgeList;
import COM.hugin.HGUI.CertainUndirectedLink;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIEventHandler;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginInsets;
import COM.hugin.HGUI.Link;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.PronelContainer;
import COM.hugin.HGUI.PronelDecisionAction;
import COM.hugin.HGUI.PronelDirectionAction;
import COM.hugin.HGUI.PronelPanel;
import COM.hugin.HGUI.UncertainLink;
import COM.hugin.HGUI.WizardPanel;
import COM.hugin.HGUI.ZoomFit;
import COM.hugin.HGUI.ZoomIn;
import COM.hugin.HGUI.ZoomOut;
import COM.hugin.HGUI.ZoomingPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PronelLearningPanel
extends WizardPanel {
    Domain domain;
    PronelPanel networkPanel;
    JButton printNet;
    JButton importSettings;
    JButton viewLog;
    JButton directForward;
    JButton directBackward;
    JButton include;
    JButton exclude;
    JButton undo;
    JButton zoomIn;
    JButton zoomOut;
    JButton zoomFit;
    JScrollPane networkScroller;
    JButton show_minimal;

    public PronelLearningPanel(Domain domain, JButton[] jButtonArray) {
        super("Structure Uncertainties", jButtonArray);
        this.setImage(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("images/pronel_learning.jpg")));
        this.domain = domain;
        this.setInterior(this.createInterior());
        this.networkPanel.addLinkSelectionChangeListener(new ButtonUpdater());
        this.networkPanel.addActionPerformedListener(new ActionPerformed());
        this.addComponents();
        this.reportModelSize();
    }

    public Component createInterior() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        JTextArea jTextArea = new JTextArea("The structure could not be completely determined. You may help resolving the structure uncertainties.");
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBackground(this.getBackground());
        this.networkPanel = new PronelPanel(this.domain);
        this.networkPanel.setLearningPanel(this);
        this.include = new JButton(new PronelDecisionAction(this.networkPanel, UncertainEdge.H_EDGE_DECISION_INCLUDE, new ImageIcon(ClassLoader.getSystemResource("icons/includePronel.gif"))));
        this.include.setMargin(new HuginInsets());
        this.include.setToolTipText(HuginGUIConstants.get("str_include_link"));
        this.exclude = new JButton(new PronelDecisionAction(this.networkPanel, UncertainEdge.H_EDGE_DECISION_EXCLUDE, new ImageIcon(ClassLoader.getSystemResource("icons/excludePronel.gif"))));
        this.exclude.setMargin(new HuginInsets());
        this.exclude.setToolTipText(HuginGUIConstants.get("str_exclude_link"));
        this.show_minimal = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/findMinimalSolution.png")));
        this.show_minimal.setMargin(new HuginInsets());
        this.show_minimal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShowMinimalDialog showMinimalDialog = new ShowMinimalDialog(PronelLearningPanel.this.networkPanel, (Dialog)PronelLearningPanel.this.getTopLevelAncestor());
                showMinimalDialog.pack();
                HuginGUIUtils.centerComponent(PronelLearningPanel.this, (Window)showMinimalDialog);
                showMinimalDialog.setVisible(true);
            }
        });
        this.show_minimal.setToolTipText(HuginGUIConstants.get("str_identify_minimal_solutions"));
        this.undo = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/undo.gif")));
        this.undo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PronelLearningPanel.this.networkPanel.getDomain().undoManualDecisions();
                    PronelLearningPanel.this.networkPanel.rebuildPronel();
                    PronelLearningPanel.this.networkPanel.getUndoQueue().undo();
                    PronelLearningPanel.this.networkPanel.rebuildPronel();
                    PronelLearningPanel.this.reportModelSize();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception.getMessage());
                    PronelLearningPanel.this.networkPanel.rebuildPronel();
                }
                PronelLearningPanel.this.networkPanel.repaint();
                PronelLearningPanel.this.undo.setEnabled(PronelLearningPanel.this.networkPanel.getUndoQueue().canUndo());
            }
        });
        this.undo.setMargin(new HuginInsets());
        this.undo.setToolTipText(HuginGUIConstants.get("str_undo"));
        this.directForward = new JButton(new PronelDirectionAction(this.networkPanel, 0, new ImageIcon(ClassLoader.getSystemResource("icons/forwardPronel.gif")))){

            public String getToolTipText(MouseEvent mouseEvent) {
                Link link;
                Link link2 = link = PronelLearningPanel.this.networkPanel.selectedLinks.size() == 1 ? (Link)PronelLearningPanel.this.networkPanel.selectedLinks.getFirst() : null;
                if (link instanceof CertainUndirectedLink) {
                    return link.parent + "->" + link.child;
                }
                return HuginGUIConstants.get("str_direct_forward");
            }

            public Point getToolTipLocation(MouseEvent mouseEvent) {
                Link link;
                Link link2 = link = PronelLearningPanel.this.networkPanel.selectedLinks.size() == 1 ? (Link)PronelLearningPanel.this.networkPanel.selectedLinks.getFirst() : null;
                if (!(link instanceof CertainUndirectedLink)) {
                    return super.getToolTipLocation(mouseEvent);
                }
                JToolTip jToolTip = this.createToolTip();
                jToolTip.setTipText(this.getToolTipText(mouseEvent));
                return new Point((this.getWidth() - jToolTip.getPreferredSize().width) / 2, -jToolTip.getPreferredSize().height);
            }
        };
        this.directForward.setToolTipText("This registers the button as having a tooltip");
        this.directForward.setMargin(new HuginInsets());
        this.directBackward = new JButton(new PronelDirectionAction(this.networkPanel, 1, new ImageIcon(ClassLoader.getSystemResource("icons/backwardPronel.gif")))){

            public String getToolTipText(MouseEvent mouseEvent) {
                Link link;
                Link link2 = link = PronelLearningPanel.this.networkPanel.selectedLinks.size() == 1 ? (Link)PronelLearningPanel.this.networkPanel.selectedLinks.getFirst() : null;
                if (link instanceof CertainUndirectedLink) {
                    return link.child + "->" + link.parent;
                }
                return HuginGUIConstants.get("str_direct_backward");
            }

            public Point getToolTipLocation(MouseEvent mouseEvent) {
                Link link;
                Link link2 = link = PronelLearningPanel.this.networkPanel.selectedLinks.size() == 1 ? (Link)PronelLearningPanel.this.networkPanel.selectedLinks.getFirst() : null;
                if (!(link instanceof CertainUndirectedLink)) {
                    return super.getToolTipLocation(mouseEvent);
                }
                JToolTip jToolTip = this.createToolTip();
                jToolTip.setTipText(this.getToolTipText(mouseEvent));
                return new Point((this.getWidth() - jToolTip.getPreferredSize().width) / 2, -jToolTip.getPreferredSize().height);
            }
        };
        this.directBackward.setToolTipText("This registers the button as having a tooltip");
        this.directBackward.setMargin(new HuginInsets());
        this.printNet = new JButton(new HuginGUIEventHandler.MENU_FILE_Print_NetworkAction(this.networkPanel));
        this.printNet.setText("");
        this.printNet.setToolTipText(HuginGUIConstants.get("str_print_network"));
        this.printNet.setMargin(new HuginInsets());
        this.importSettings = new JButton(new HuginGUIEventHandler.MENU_NETWORK_Import_Model_InformationAction(this.networkPanel));
        this.importSettings.setText("");
        this.importSettings.setToolTipText(HuginGUIConstants.get("MENU_NETWORK_Import_Model_Information_Tip"));
        this.importSettings.setMargin(new HuginInsets());
        this.viewLog = new JButton(new HuginGUIEventHandler.WIZARD_LogFileAction(this.getDomain()));
        this.viewLog.setText("");
        this.viewLog.setToolTipText(HuginGUIConstants.get("MENU_VIEW_Information_Tip"));
        this.viewLog.setMargin(new HuginInsets());
        this.zoomIn = new JButton();
        this.zoomIn.setAction(new ZoomIn(this, this.networkPanel));
        this.zoomIn.setText("");
        this.zoomIn.setToolTipText(HuginGUIConstants.get("str_zoom_in_by_ten_percent"));
        this.zoomIn.setMargin(new HuginInsets());
        this.zoomOut = new JButton();
        this.zoomOut.setAction(new ZoomOut(this, this.networkPanel));
        this.zoomOut.setText("");
        this.zoomOut.setToolTipText(HuginGUIConstants.get("str_zoom_out_by_ten_percent"));
        this.zoomOut.setMargin(new HuginInsets());
        this.zoomFit = new JButton();
        this.zoomFit.setAction(new ZoomFit(this, this.networkPanel));
        this.zoomFit.setText("");
        this.zoomFit.setToolTipText(HuginGUIConstants.get("str_zoom_to_fit"));
        this.zoomFit.setMargin(new HuginInsets());
        jToolBar.add(this.printNet);
        jToolBar.add(this.importSettings);
        jToolBar.add(this.viewLog);
        jToolBar.addSeparator(new Dimension(10, 0));
        jToolBar.add(this.include);
        jToolBar.add(this.exclude);
        jToolBar.add(this.show_minimal);
        jToolBar.add(this.directForward);
        jToolBar.add(this.directBackward);
        jToolBar.addSeparator(new Dimension(10, 0));
        jToolBar.add(this.undo);
        jToolBar.addSeparator(new Dimension(10, 0));
        jToolBar.add(this.zoomIn);
        jToolBar.add(this.zoomOut);
        jToolBar.add(this.zoomFit);
        jToolBar.setFloatable(false);
        this.include.setEnabled(false);
        this.exclude.setEnabled(false);
        this.show_minimal.setEnabled(false);
        this.directForward.setEnabled(false);
        this.directBackward.setEnabled(false);
        this.undo.setEnabled(false);
        this.networkScroller = new JScrollPane(this.networkPanel);
        this.networkScroller.getViewport().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PronelLearningPanel.this.networkPanel.repaint();
            }
        });
        this.networkScroller.getHorizontalScrollBar().setUnitIncrement(15);
        this.networkScroller.getVerticalScrollBar().setUnitIncrement(15);
        jPanel2.add((Component)jTextArea, "Center");
        jPanel2.add((Component)jToolBar, "South");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.networkScroller, "Center");
        return jPanel;
    }

    public void finish() throws ExceptionHugin {
        this.domain.decideAutomatically();
    }

    public Domain getDomain() {
        return this.domain;
    }

    protected JScrollPane getNetworkScroller() {
        return this.networkScroller;
    }

    protected PronelPanel getNetworkPanel() {
        return this.networkPanel;
    }

    public void reinitialize() {
    }

    public void rereadNodePositions() throws ExceptionHugin {
        this.networkPanel.rereadNodePositions();
    }

    protected void writePValue(double d) {
        this.writeStatus("p-value = " + this.formatDouble(d));
    }

    private String formatDouble(double d) {
        try {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator('.');
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            decimalFormat.setGroupingUsed(false);
            if (Math.abs(d) >= 1.0E-4) {
                decimalFormat.setMaximumFractionDigits(4);
            } else {
                decimalFormat.applyPattern("0E0");
            }
            return decimalFormat.format(d);
        }
        catch (NumberFormatException numberFormatException) {
            return "0.0";
        }
    }

    private void assignIconsToDirectButtons(Link link) {
        PronelContainer.DirectButtonImages directButtonImages = PronelContainer.getDirectButtonImages(link);
        this.directForward.setIcon(directButtonImages.forwardImage);
        this.directBackward.setIcon(directButtonImages.backwardImage);
    }

    protected void receiveKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        try {
            double d;
            if ((n == 40 || n == 98) && keyEvent.isControlDown()) {
                d = this.networkPanel.zoom(0.9);
                if (d > 0.0) {
                    this.writeStatus(HuginGUIConstants.get("str_scale_factor_set_to_") + (int)(100.0 * d) + "%");
                } else {
                    this.writeStatus("Unable to scale network (1 <= scale factor <= 10000)");
                }
            }
            if ((n == 38 || n == 104) && keyEvent.isControlDown()) {
                d = this.networkPanel.zoom(1.1111111111111112);
                if (d > 0.0) {
                    this.writeStatus(HuginGUIConstants.get("str_scale_factor_set_to_") + (int)(100.0 * d) + "%");
                } else {
                    this.writeStatus("Unable to scale network (1 <= scale factor <= 10000)");
                }
            }
            switch (n) {
                case 65: {
                    this.networkPanel.selectAllNodes();
                    if (this.networkPanel.selectedNodes.size() == 1) {
                        this.writeStatus(HuginGUIConstants.get("str_node_selected"));
                        break;
                    }
                    this.writeStatus(HuginGUIConstants.get("str_all_") + this.networkPanel.selectedNodes.size() + HuginGUIConstants.get("str__nodes_selected"));
                    break;
                }
                case 36: {
                    double d2 = 0.0;
                    if (keyEvent.isControlDown()) {
                        d2 = 1.0;
                        this.networkPanel.setScaleFactor(1.0);
                    }
                    if (keyEvent.isShiftDown()) {
                        d2 = ZoomingPane.computeFitFactor(this.networkPanel);
                        this.networkPanel.setScaleFactor(d2);
                    }
                    if (!(d2 > 0.0)) break;
                    this.writeStatus(HuginGUIConstants.get("str_scale_factor_set_to_") + (int)Math.rint(100.0 * d2) + "%");
                    break;
                }
                case 46: {
                    if (!keyEvent.isControlDown()) break;
                    this.networkPanel.showGrid(!this.networkPanel.showGrid());
                    this.writeStatus(HuginGUIConstants.get("str_grid_") + (this.networkPanel.showGrid() ? HuginGUIConstants.get("str_on") : HuginGUIConstants.get("str_off")));
                    break;
                }
                case 44: {
                    if (keyEvent.isControlDown()) {
                        this.networkPanel.snapToGrid(!this.networkPanel.snapToGrid());
                        this.writeStatus("Snap to grid " + (this.networkPanel.snapToGrid() ? "on" : "off"));
                    }
                    if (!keyEvent.isShiftDown() || !this.networkPanel.snapSelectedNodesToGrid()) break;
                    this.writeStatus(HuginGUIConstants.get("str_selected_nodes_snapped_to_grid"));
                    break;
                }
                case 35: {
                    if (!keyEvent.isShiftDown()) break;
                    this.networkPanel.setScaleFactor((double)ZoomingPane.computeSelectedFitZoom(this.networkPanel) / 100.0);
                    this.networkPanel.scrollToSelected();
                    this.writeStatus(HuginGUIConstants.get("str_zoomed_to_selected_nodes"));
                }
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private void reportModelSize() {
        this.writeStatus(HuginGUIConstants.get("str_model_size_") + this.networkPanel.getModelSize());
    }

    private class ShowMinimalDialog
    extends JDialog {
        Vector<MinimalSolution> groupData;
        PronelPanel panel;
        JList groups;
        JList links;
        JButton select;

        public ShowMinimalDialog(PronelPanel pronelPanel, Dialog dialog) {
            super(dialog, HuginGUIConstants.get("str_minimal_solutions"), true);
            this.panel = pronelPanel;
            this.groupData = new Vector();
            this.setContentPane(this.createContent());
            try {
                LinkedList<UncertainEdgeList> linkedList = ((UncertainLink)pronelPanel.selectedLinks.get(0)).getAmbiguousRegion().getAPIRegion().getMinimalSolutions();
                for (UncertainEdgeList uncertainEdgeList : linkedList) {
                    this.groupData.add(new MinimalSolution(uncertainEdgeList, this.groupData.size()));
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        private JPanel createContent() {
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
            this.groups = new JList<MinimalSolution>(this.groupData);
            jPanel2.add(new JScrollPane(this.groups));
            this.groups.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ShowMinimalDialog.this.links.setListData(((MinimalSolution)ShowMinimalDialog.this.groups.getSelectedValue()).getNames());
                    ShowMinimalDialog.this.select.setEnabled(ShowMinimalDialog.this.links.getSelectedIndex() >= 0);
                }
            });
            this.links = new JList();
            this.links.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ShowMinimalDialog.this.select.setEnabled(ShowMinimalDialog.this.links.getSelectedIndex() >= 0);
                    if (ShowMinimalDialog.this.links.getSelectedIndex() >= 0) {
                        MinimalSolution minimalSolution = (MinimalSolution)ShowMinimalDialog.this.groups.getSelectedValue();
                        UncertainEdge uncertainEdge = minimalSolution.links[ShowMinimalDialog.this.links.getSelectedIndex()];
                        try {
                            DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)uncertainEdge.getFirstNode();
                            DiscreteChanceNode discreteChanceNode2 = (DiscreteChanceNode)uncertainEdge.getSecondNode();
                            int n = discreteChanceNode.getNumberOfStates() * discreteChanceNode2.getNumberOfStates();
                            double d = discreteChanceNode.getDataIndependency(discreteChanceNode2);
                            PronelLearningPanel.this.writeStatus(HuginGUIConstants.get("str_weight_equals") + n + HuginGUIConstants.get("str__p_value_equals") + PronelLearningPanel.this.formatDouble(d));
                            System.err.println("BeliegBarnode l560 : compile (do first a qualitative and compute clique size");
                        }
                        catch (Exception exception) {
                            new HuginGUIError(exception);
                        }
                    }
                }
            });
            jPanel2.add(new JScrollPane(this.links));
            jPanel.add(jPanel2);
            this.select = new JButton(HuginGUIConstants.get("str_select"));
            this.select.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ((MinimalSolution)ShowMinimalDialog.this.groups.getSelectedValue()).select();
                        ShowMinimalDialog.this.dispose();
                        ShowMinimalDialog.this.panel.rebuildPronel();
                        ShowMinimalDialog.this.panel.repaint();
                        ShowMinimalDialog.this.panel.updateComplete();
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                }
            });
            this.select.setEnabled(false);
            JButton jButton = new JButton(HuginGUIConstants.get("CANCEL_BUTTON_LABEL"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ShowMinimalDialog.this.dispose();
                }
            });
            JPanel jPanel3 = new JPanel(new FlowLayout());
            jPanel3.add(jButton);
            jPanel3.add(this.select);
            jPanel.add((Component)jPanel3, "South");
            return jPanel;
        }

        private class MinimalSolution {
            UncertainEdge[] links;
            String[] names;
            int id;

            public MinimalSolution(UncertainEdgeList uncertainEdgeList, int n) {
                this.id = n;
                this.links = uncertainEdgeList.toArray(new UncertainEdge[0]);
                this.names = new String[this.links.length];
                for (int i = 0; i < this.names.length; ++i) {
                    try {
                        this.names[i] = HuginGUIUtils.getNodeTitle(this.links[i].getFirstNode()) + " - " + HuginGUIUtils.getNodeTitle(this.links[i].getSecondNode());
                        continue;
                    }
                    catch (Exception exception) {
                        this.names[i] = HuginGUIConstants.get("str____error__");
                    }
                }
            }

            public String toString() {
                return HuginGUIConstants.get("str_solution_") + this.id;
            }

            public String[] getNames() {
                return this.names;
            }

            public void select() throws ExceptionHugin {
                for (int i = 0; i < this.links.length; ++i) {
                    this.links[i].manualDecision(UncertainEdge.H_EDGE_DECISION_INCLUDE);
                }
            }
        }
    }

    private class ActionPerformed
    implements PronelPanel.ActionPerformedListener {
        private ActionPerformed() {
        }

        public void actionPerformed() {
            PronelLearningPanel.this.exclude.setEnabled(false);
            PronelLearningPanel.this.include.setEnabled(false);
            PronelLearningPanel.this.show_minimal.setEnabled(false);
            PronelLearningPanel.this.directForward.setEnabled(false);
            PronelLearningPanel.this.directBackward.setEnabled(false);
            PronelLearningPanel.this.undo.setEnabled(PronelLearningPanel.this.networkPanel.getUndoQueue().canUndo());
            PronelLearningPanel.this.reportModelSize();
        }
    }

    private class ButtonUpdater
    implements PronelPanel.LinkSelectionChangeListener {
        private ButtonUpdater() {
        }

        public void linkSelectionChanged(Link link) {
            if (link == null) {
                PronelLearningPanel.this.reportModelSize();
                PronelLearningPanel.this.include.setEnabled(false);
                PronelLearningPanel.this.exclude.setEnabled(false);
                PronelLearningPanel.this.show_minimal.setEnabled(false);
                PronelLearningPanel.this.directForward.setEnabled(false);
                PronelLearningPanel.this.directBackward.setEnabled(false);
                PronelLearningPanel.this.undo.setEnabled(false);
                return;
            }
            boolean bl = link instanceof UncertainLink;
            boolean bl2 = link instanceof CertainUndirectedLink;
            PronelLearningPanel.this.exclude.setEnabled(bl);
            PronelLearningPanel.this.include.setEnabled(bl);
            PronelLearningPanel.this.show_minimal.setEnabled(bl);
            PronelLearningPanel.this.directForward.setEnabled(bl2);
            PronelLearningPanel.this.directBackward.setEnabled(bl2);
            if (bl2) {
                PronelLearningPanel.this.assignIconsToDirectButtons(link);
            }
            Node node = link.parent;
            Node node2 = link.child;
            double d = 1.0;
            try {
                d = node.getAPINode().getDataIndependency(node2.getAPINode());
            }
            catch (ExceptionHugin exceptionHugin) {
                // empty catch block
            }
            PronelLearningPanel.this.writePValue(d);
        }
    }
}

