/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.UncertainEdge;
import COM.hugin.HGUI.AmbiguousRegion;
import COM.hugin.HGUI.CertainDirectedLink;
import COM.hugin.HGUI.CertainUndirectedLink;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.Link;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.PronelContainer;
import COM.hugin.HGUI.PronelLearningPanel;
import COM.hugin.HGUI.UncertainLink;
import COM.hugin.HGUI.UndoQueue;
import COM.hugin.HGUI.WizardConstants;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class PronelPanel
extends NetworkPanel
implements MouseListener,
MouseMotionListener {
    private Domain domain = null;
    protected static final int SELECT_MODE = 0;
    private int mode = 0;
    private Cursor arrowCursor;
    private Cursor noArrowCursor;
    private Cursor linkCursor;
    private Cursor noLinkCursor;
    private UndoQueue undoQueue = new UndoQueue();
    LinkedList<LinkSelectionChangeListener> linkListeners = new LinkedList();
    LinkedList<ActionPerformedListener> actionListeners = new LinkedList();
    PronelLearningPanel parent = null;
    PronelContainer container = null;

    protected Domain getDomain() {
        return this.domain;
    }

    protected NetworkModel getHome() {
        return this.domain;
    }

    protected int getMode() {
        return this.mode;
    }

    public PronelPanel(Domain domain) {
        this.init(domain, false);
    }

    public PronelPanel(PronelContainer pronelContainer) {
        this.init(pronelContainer.getDomain(), true);
        this.setContainer(pronelContainer);
    }

    private void init(Domain domain, boolean bl) {
        this.createCursors();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(Color.white);
        this.guiFrame = Hugin.mainFrame;
        this.loadNet(domain, bl);
    }

    protected void readLinks() {
        try {
            for (COM.hugin.HAPI.Node node : this.domain.getNodes()) {
                for (COM.hugin.HAPI.Node node2 : node.getChildren()) {
                    Link link = new Link(this.getNode(node), this.getNode(node2), this.scaleFactor);
                    link.setStrength(link.parent.getAPINode().getDataIndependency(link.child.getAPINode()));
                    this.linkList.add(link);
                }
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    protected void createCursors() {
        super.createCursors();
        try {
            Toolkit toolkit = this.getToolkit();
            Point point = WizardConstants.TOOL_CURSORS_HOTSPOT;
            Image image = WizardConstants.ARROW_CONSTRAINT_CURSOR_IMAGE;
            this.arrowCursor = toolkit.createCustomCursor(image, point, "ARROW Cursor");
            image = WizardConstants.NO_ARROW_CONSTRAINT_CURSOR_IMAGE;
            this.noArrowCursor = toolkit.createCustomCursor(image, point, "NO-ARROW Cursor");
            image = WizardConstants.LINK_CONSTRAINT_CURSOR_IMAGE;
            this.linkCursor = toolkit.createCustomCursor(image, point, "LINK Cursor");
            image = WizardConstants.NO_LINK_CONSTRAINT_CURSOR_IMAGE;
            this.noLinkCursor = toolkit.createCustomCursor(image, point, "NO-LINK Cursor");
            image = WizardConstants.LINK_CONSTRAINT_CURSOR_IMAGE;
        }
        catch (Exception exception) {
            new HuginGUIError("PronelPanel.createCursors", HuginGUIConstants.get("str_failed_to_create_cursor"));
        }
    }

    protected void loadNet(Domain domain) {
        this.loadNet(domain, false);
    }

    protected void loadNet(Domain domain, boolean bl) {
        this.domain = domain;
        this.nodeList.clear();
        this.linkList.clear();
        try {
            Cloneable cloneable;
            this.readDomainAttributes();
            if (bl) {
                this.layoutNodes();
            }
            NodeList nodeList = domain.getNodes();
            for (Object object : nodeList) {
                Object object2 = this.createNodeFromAPINode((COM.hugin.HAPI.Node)object);
                if (object2 != null) {
                    this.nodeList.add(object2);
                    continue;
                }
                new HuginGUIError("PronelPanel.loadNet", HuginGUIConstants.get("str_unkown_node_class"));
            }
            for (Object object : nodeList) {
                for (Cloneable cloneable2 : ((COM.hugin.HAPI.Node)object).getParents()) {
                    this.linkList.add(new Link(this.getNode((COM.hugin.HAPI.Node)cloneable2), this.getNode((COM.hugin.HAPI.Node)object), this.scaleFactor));
                }
            }
            for (Object object : nodeList) {
                for (Cloneable cloneable2 : ((COM.hugin.HAPI.Node)object).getPdagParents()) {
                    this.linkList.add(new CertainDirectedLink(this.getNode((COM.hugin.HAPI.Node)cloneable2), this.getNode((COM.hugin.HAPI.Node)object), this.scaleFactor));
                }
            }
            Iterator iterator = nodeList.listIterator();
            while (iterator.hasNext()) {
                Object object;
                object = (COM.hugin.HAPI.Node)iterator.next();
                for (Cloneable cloneable2 : ((COM.hugin.HAPI.Node)object).getPdagNeighbors()) {
                    Iterator iterator2 = nodeList.listIterator(iterator.previousIndex());
                    boolean bl2 = false;
                    while (iterator2.hasPrevious()) {
                        cloneable = (COM.hugin.HAPI.Node)iterator2.previous();
                        if (cloneable != cloneable2) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    this.linkList.add(new CertainUndirectedLink(this.getNode((COM.hugin.HAPI.Node)cloneable2), this.getNode((COM.hugin.HAPI.Node)object), this.scaleFactor));
                }
            }
            int n = 0;
            for (Object object2 : domain.getAmbiguousRegions()) {
                Cloneable cloneable2;
                cloneable2 = new AmbiguousRegion(n++, this, (COM.hugin.HAPI.AmbiguousRegion)object2);
                for (UncertainEdge uncertainEdge : ((COM.hugin.HAPI.AmbiguousRegion)object2).getEdges()) {
                    cloneable = new UncertainLink(this.getNode(uncertainEdge.getFirstNode()), this.getNode(uncertainEdge.getSecondNode()), uncertainEdge, this.scaleFactor, (AmbiguousRegion)cloneable2);
                    ((AmbiguousRegion)cloneable2).add((UncertainLink)cloneable);
                    this.linkList.add(cloneable);
                }
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            this.snapToGrid = true;
            this.showGrid = false;
        }
        this.readNodeAttributes();
        this.setGraphicsSize();
    }

    public void rebuildPronel() {
        this.loadNet(this.domain, false);
    }

    public void updateComplete() {
        this.fireActionPerformed();
    }

    public UndoQueue getUndoQueue() {
        return this.undoQueue;
    }

    public Link getCorrespondingLink(Link link) {
        for (Link link2 : this.linkList) {
            if (!link.equals(link2)) continue;
            return link2;
        }
        return null;
    }

    protected void rereadNodePositions() throws ExceptionHugin {
        for (Node node : this.nodeList) {
            node.rereadPosition();
        }
        this.relocateLinks();
    }

    protected void setMode(int n) {
        this.setMode(n, null);
    }

    private void setMode(int n, Point point) {
        this.mode = n;
        switch (n) {
            case 0: {
                if (point != null) {
                    Node node = this.whichNode(point);
                    if (node != null) {
                        this.setCursor(this.selectCursor);
                        break;
                    }
                    Link link = this.whichLink(point);
                    if (link != null) {
                        this.setCursor(link.isSelectable() ? this.selectCursor : this.defaultCursor);
                        break;
                    }
                    this.setCursor(this.defaultCursor);
                    break;
                }
                this.setCursor(this.defaultCursor);
                break;
            }
            default: {
                new HuginGUIError("NetworkPanel.setMode", HuginGUIConstants.get("str_unknown_mode"));
            }
        }
    }

    protected void setLearningPanel(PronelLearningPanel pronelLearningPanel) {
        this.parent = pronelLearningPanel;
    }

    protected void setContainer(PronelContainer pronelContainer) {
        this.container = pronelContainer;
    }

    protected Rectangle getViewRect() {
        if (this.parent != null) {
            return this.parent.getNetworkScroller().getViewport().getViewRect();
        }
        if (this.container != null) {
            this.container.getNetworkScroller().getViewport().getViewRect();
        }
        return new Rectangle(0, 0, this.getWidth(), this.getHeight());
    }

    public void addLinkSelectionChangeListener(LinkSelectionChangeListener linkSelectionChangeListener) {
        this.linkListeners.add(linkSelectionChangeListener);
    }

    public void removeLinkSelectionChangeListener(LinkSelectionChangeListener linkSelectionChangeListener) {
        this.linkListeners.remove(linkSelectionChangeListener);
    }

    private void fireLinkSelectionChanged() {
        Link link = this.selectedLinks.size() == 0 ? null : (Link)this.selectedLinks.getLast();
        for (LinkSelectionChangeListener linkSelectionChangeListener : this.linkListeners) {
            linkSelectionChangeListener.linkSelectionChanged(link);
        }
    }

    public void addActionPerformedListener(ActionPerformedListener actionPerformedListener) {
        this.actionListeners.add(actionPerformedListener);
    }

    public void removeActionPerformedListener(ActionPerformedListener actionPerformedListener) {
        this.actionListeners.remove(actionPerformedListener);
    }

    private void fireActionPerformed() {
        for (ActionPerformedListener actionPerformedListener : this.actionListeners) {
            actionPerformedListener.actionPerformed();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.isAltDown()) {
            this.leftMousePressed(mouseEvent);
        }
    }

    private void leftMousePressed(MouseEvent mouseEvent) {
        Rectangle rectangle = null;
        if (this.getMode() == 0) {
            rectangle = this.controlSelections(mouseEvent);
        } else {
            this.initLink(mouseEvent);
        }
        if (rectangle != null) {
            this.repaintRectangle(rectangle);
        }
    }

    protected Rectangle controlSelections(MouseEvent mouseEvent) {
        Node node = this.whichNode(mouseEvent.getPoint());
        Rectangle rectangle = new Rectangle(mouseEvent.getPoint());
        if (this.selectedLinks.size() == 1) {
            rectangle.add(((Link)this.selectedLinks.getFirst()).getBoundingBox());
            ((Link)this.selectedLinks.getFirst()).deselect();
            this.selectedLinks.clear();
        }
        if (node != null) {
            boolean bl = node.isSelected();
            if (!bl) {
                if (!mouseEvent.isShiftDown() && this.selectedNodes.size() > 0) {
                    rectangle.add(this.deselectNodes(null));
                }
                this.selectedNodes.add(node);
                rectangle.add(node.boundingBox);
            } else if (mouseEvent.isShiftDown()) {
                this.selectedNodes.remove(node);
                rectangle.add(node.boundingBox);
            }
            this.setCursor(this.moveCursor);
        } else {
            Link link = this.whichLink(mouseEvent.getPoint());
            if (!(this.selectedNodes.size() <= 0 || mouseEvent.isShiftDown() && link == null)) {
                rectangle.add(this.deselectNodes(null));
            }
            if (link != null && link.selectable && !link.atCollapsedNode()) {
                link.select();
                this.selectedLinks.add(link);
                rectangle.add(link.getBoundingBox());
            }
        }
        this.mousePressedAt.setLocation(mouseEvent.getPoint());
        this.fireLinkSelectionChanged();
        return rectangle.width == 0 ? null : rectangle;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        boolean bl = false;
        if (this.getMode() == 0) {
            this.dragNodesOrRegion(mouseEvent.getPoint(), mouseEvent.isShiftDown());
            bl = true;
        } else {
            bl = this.dragLink(mouseEvent.getPoint());
        }
        if (bl) {
            this.repaintRectangle(this.computeChangedDragRectangle(), mouseEvent.getPoint());
        }
    }

    private Rectangle computeChangedDragRectangle() {
        if (this.getMode() != 0) {
            return this.prevGhostLinkBoundingBox.union(this.newGhostLinkBoundingBox());
        }
        if (this.selectRegion != null) {
            return this.selectRegion.getBoundingBox().union(this.selectRegion.previous);
        }
        return this.newGhostGraphBoundingBox().union(this.prevGhostGraphBoundingBox);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Rectangle rectangle = null;
        rectangle = this.selectOrRelocateObjects(mouseEvent.getPoint());
        if (rectangle != null) {
            this.repaintRectangle(rectangle);
        }
    }

    protected void updateInstanceNodeTool() {
    }

    protected void containsUnsavedChanges(boolean bl) {
        this.containsUnsavedChanges = bl;
    }

    protected void updateButtonAndMenuStates() {
        boolean bl = this.nodeList.size() > 0;
        JMenuItem jMenuItem = this.guiFrame.saveFileMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        jMenuItem = this.guiFrame.saveAsFileMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        jMenuItem = this.guiFrame.printNetFileMenuItem;
        jMenuItem.setEnabled(bl);
        jMenuItem.getAction().setEnabled(bl);
        jMenuItem = this.guiFrame.printNodeTableFileMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        jMenuItem = this.guiFrame.printProbabilitesFileMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        this.guiFrame.saveNetworkToBMPFileMenuItem.setEnabled(true);
        this.guiFrame.saveNetworkToBMPFileMenuItem.getAction().setEnabled(true);
        jMenuItem = this.guiFrame.simulateCasesFileMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        this.guiFrame.getButton(2).setEnabled(false);
        jMenuItem = this.guiFrame.copyEditMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        this.guiFrame.getButton(3).setEnabled(false);
        jMenuItem = this.guiFrame.cutEditMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        this.guiFrame.getButton(4).setEnabled(false);
        jMenuItem = this.guiFrame.deleteStateEditMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        this.guiFrame.getButton(6).setEnabled(false);
        jMenuItem = this.guiFrame.pasteEditMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        this.guiFrame.getButton(5).setEnabled(false);
        jMenuItem = this.guiFrame.reverseLinkEditMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        jMenuItem = this.guiFrame.addStateEditMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        jMenuItem = this.guiFrame.deleteStateEditMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.selectToolEditMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        jMenuItem = this.guiFrame.discreteChanceToolEditMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        jMenuItem = this.guiFrame.continuousChanceToolEditMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        jMenuItem = this.guiFrame.utilityToolEditMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        jMenuItem = this.guiFrame.decisionToolEditMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        jMenuItem = this.guiFrame.linkToolEditMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        jMenuItem = this.guiFrame.instanceToolEditMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.selectAllEditMenuItem;
        jMenuItem.setEnabled(bl);
        jMenuItem.getAction().setEnabled(bl);
        jMenuItem = this.guiFrame.nodePropEditMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        this.guiFrame.inputOutput.setEnabled(false);
        jMenuItem = this.guiFrame.toggleBeliefBarViewMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem = this.guiFrame.expandNodeListViewMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.collapseNodeListViewMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.collapseInstanceNodesViewMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.expandInstanceNodesViewMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.showClassViewMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.showMonitorsViewMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.lockEvidenceViewMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.updateMonitorGraphsViewMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.showLastErrorViewMenuItem;
        jMenuItem.setEnabled(true);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.beliefPrecisionViewMenu;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        jMenuItem = this.guiFrame.initializeNetworkMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.propSumNormalNetworkMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.propMaxNormalNetworkMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.propSumFastRetractNetworkMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.propMaxFastRetractNetworkMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.enterLikelihoodNetworkMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.retractEvidNetworkMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        jMenuItem = this.guiFrame.renameNetworkMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        jMenuItem = this.guiFrame.propertiesNetworkMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        jMenuItem = this.guiFrame.editNetworkMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.compileNetworkMenuItem;
        jMenuItem.setVisible(false);
        jMenuItem = this.guiFrame.runNetworkMenuItem;
        jMenuItem.setVisible(false);
        jMenuItem = this.guiFrame.compileNetworkMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(bl);
        jMenuItem = this.guiFrame.runNetworkMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(false);
        jMenuItem = this.guiFrame.emLearningNetworkMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.addExperienceTableToAllNetworkMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.addFadingTableToAllNetworkMenuItem;
        jMenuItem.setEnabled(false);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        jMenuItem = this.guiFrame.alignOptionsMenu;
        jMenuItem.setEnabled(this.selectedNodes.size() > 1);
        jMenuItem.getAction().setEnabled(jMenuItem.isEnabled());
        boolean bl2 = !this.guiFrame.menuIsMinimized();
        boolean bl3 = this.guiFrame.getIconifiedProjectFramesCount() > 0;
        jMenuItem = this.guiFrame.cascadeWindowsMenuItem;
        jMenuItem.setEnabled(bl2);
        jMenuItem.getAction().setEnabled(bl2);
        this.guiFrame.getButton(9).setEnabled(bl2);
        jMenuItem = this.guiFrame.tileHorizontalWindowsMenuItem;
        jMenuItem.setEnabled(bl2);
        jMenuItem.getAction().setEnabled(bl2);
        this.guiFrame.getButton(7).setEnabled(bl2);
        jMenuItem = this.guiFrame.tileVerticalWindowsMenuItem;
        jMenuItem.setEnabled(bl2);
        jMenuItem.getAction().setEnabled(bl2);
        this.guiFrame.getButton(8).setEnabled(bl2);
        jMenuItem = this.guiFrame.closeAllWindowsMenuItem;
        jMenuItem.setEnabled(bl2);
        jMenuItem.getAction().setEnabled(bl2);
    }

    protected long getModelSize() {
        long l = 0L;
        try {
            for (Node node : this.nodeList) {
                l += (long)node.numberOfStates() * node.numberOfParentStates() * node.numberOfPdagParentStates();
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return 0L;
        }
        return l;
    }

    protected void setScaleFactor(double d, boolean bl) {
        double d2 = d / this.scaleFactor;
        boolean bl2 = false;
        Rectangle rectangle = this.showGrid ? new Rectangle(0, 0, this.getWidth(), this.getHeight()) : this.computeBoundingBox();
        for (Cloneable cloneable : this.nodeList) {
            try {
                ((Node)cloneable).scale(d2, bl);
            }
            catch (Exception exception) {
                if (!bl2) {
                    new HuginGUIError(exception);
                }
                bl2 = true;
            }
        }
        for (Cloneable cloneable : this.linkList) {
            ((Link)cloneable).scale(d2);
        }
        this.gridWidth *= d2;
        this.gridHeight *= d2;
        this.scaleFactor = d;
        try {
            this.getHome().setAttribute("HR_Zoom_ZoomFactor", String.valueOf((int)(100.0 * this.scaleFactor)));
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        if (!this.showGrid) {
            rectangle.add(this.computeBoundingBox());
        }
        this.repaintRectangle(rectangle);
        this.containsUnsavedChanges(true);
    }

    public static interface ActionPerformedListener
    extends EventListener {
        public void actionPerformed();
    }

    public static interface LinkSelectionChangeListener
    extends EventListener {
        public void linkSelectionChanged(Link var1);
    }
}

