/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.CustomModeGraphicTable;
import COM.hugin.HGUI.GenericTable;
import COM.hugin.HGUI.GraphicTable;
import COM.hugin.HGUI.HuginComboBox;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.Line;
import COM.hugin.HGUI.ModeGraphicTable;
import COM.hugin.HGUI.MultipleLineGraph;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NodeTable;
import COM.hugin.HGUI.NodeTableColumnModel;
import COM.hugin.HGUI.ParameterSensitivityWizard;
import COM.hugin.HGUI.Plot;
import COM.hugin.HGUI.SensitivitySetDialog;
import COM.hugin.HGUI.TableSorter;
import COM.hugin.HGUI.TableWrapper;
import COM.hugin.HGUI.TitledPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsPanel
extends JPanel {
    private ParameterSensitivityWizard psw;
    private final int TWO_CELL_SELECTION = 1;
    private final int ONE_CELL_WITH_COMPUTE_LISTENER = 2;
    private final int ONE_CELL_SELECTION = 3;
    private int pointsToPlot = 100;
    private JPanel mainPanel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JPanel bottomPanel;
    private JPanel buttonPanel;
    private JPanel graphPanel;
    private JPanel tablePanel;
    private JSplitPane topPanel;
    private JLabel hypoVariableLabel;
    private JLabel hypoStateLabel;
    private JLabel paraVariableLabel;
    private JLabel paraVariableLabel1;
    private JLabel databaseLabel;
    private JLabel numberOfCasesLabel;
    private HuginComboBox hypoStateCombo;
    private JCheckBox allStatesBox;
    private JCheckBox twoParametersBox;
    protected JButton networkButton;
    protected JButton computeButton;
    private JRadioButton minRadio;
    private JRadioButton maxRadio;
    protected HuginComboBox hypoVariableCombo;
    protected HuginComboBox paraVariableCombo;
    protected HuginComboBox paraVariableCombo1;
    private JScrollPane scrollpane;
    private JScrollPane tableScrollPane;
    private MultipleLineGraph mlg;
    private JTable dataTable;
    private NodeTable nt;
    private GraphicTable graphicTable;
    private TableWrapper tableWr = null;
    private PsPanel psp = null;
    private Color[] colors;
    SensitivitySetDialog ssd = null;
    private boolean originalCanShowExpressions = false;
    private Vector<String> nodeNameList;
    private NodeList nodes;
    private Domain domain;
    private HuginProjectFrame projectFrame;
    private double pointY;
    private final int oneWay = 1;
    private final int twoWay = 2;
    private int mode;
    private boolean triggerStateComboEvent = true;
    private Selection selected = null;
    private float[][] colorMapValues = null;
    private ModeGraphicTable mgt = null;
    private boolean selectedCases = false;

    public PsPanel(ParameterSensitivityWizard parameterSensitivityWizard, int n) {
        super(new GridLayout(1, 1));
        this.mode = n;
        this.pointsToPlot = n == 2 ? 30 : 100;
        this.psw = parameterSensitivityWizard;
        this.psw.addNewCaseInsertedListener(new CaseInsertedListener());
        this.domain = parameterSensitivityWizard.getDomain();
        this.nodeNameList = this.getNodeNameList(parameterSensitivityWizard.getDCNodeList());
        this.projectFrame = parameterSensitivityWizard.getProjectFrame();
        this.initialize();
        this.psp = this;
        this.add(this.mainPanel);
    }

    private void initialize() {
        this.fillColorArray();
        this.tablePanel = new JPanel(new GridLayout(1, 1));
        this.mainPanel = this.twoWayMode() ? new TitledPanel(HuginGUIConstants.get("SA_Two_Way_Title")) : new TitledPanel(HuginGUIConstants.get("SA_Title"));
        this.mainPanel.setLayout(new BorderLayout(5, 5));
        this.createLeftPanel();
        this.createRightPanel();
        this.createButtonPanel();
        this.createBottomPanel();
        this.topPanel = new JSplitPane(1, this.leftPanel, this.rightPanel);
        Dimension dimension = new Dimension(200, 0);
        this.leftPanel.setMinimumSize(dimension);
        this.rightPanel.setMinimumSize(dimension);
        this.topPanel.setBorder(null);
        this.topPanel.setDividerLocation(300);
        this.topPanel.setOneTouchExpandable(true);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)this.topPanel, "Center");
        jPanel.add((Component)this.buttonPanel, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)jPanel, "North");
        this.mainPanel.add((Component)this.bottomPanel, "Center");
    }

    private boolean twoWayMode() {
        return this.mode == 2;
    }

    private void createLeftPanel() {
        Dimension dimension = new Dimension(150, 20);
        Dimension dimension2 = new Dimension(150, 20);
        Dimension dimension3 = new Dimension(1, 3);
        Dimension dimension4 = new Dimension(1, 4);
        Dimension dimension5 = new Dimension(5, 1);
        try {
            this.nodes = this.domain.getNodes();
            this.leftPanel = new JPanel(new GridLayout(1, 1));
            JPanel jPanel = new JPanel(new BorderLayout(15, 15));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            GridLayout gridLayout = this.twoWayMode() ? new GridLayout(4, 1) : new GridLayout(3, 1);
            JPanel jPanel3 = new JPanel(gridLayout);
            JPanel jPanel4 = new JPanel(gridLayout);
            this.hypoStateCombo = new HuginComboBox();
            this.hypoVariableLabel = new JLabel("<html><B>" + HuginGUIConstants.get("SA_Hypo_Variable") + "</B></html>");
            this.hypoVariableCombo = new HuginComboBox((Vector)this.nodeNameList);
            this.initializeCombo(false);
            this.hypoVariableLabel.setPreferredSize(new Dimension((int)this.hypoVariableLabel.getPreferredSize().getWidth(), (int)this.hypoVariableCombo.getPreferredSize().getHeight()));
            this.hypoVariableCombo.setBackground(Color.WHITE);
            this.hypoVariableCombo.validatePopupWidth();
            this.hypoVariableCombo.setRenderer(new HypothesisComboRenderer(this.psw.getDCNodeList()));
            this.hypoVariableCombo.addItemListener(new HypothesisNodeComboListener(this.psw, this.hypoStateCombo));
            jPanel3.add(this.hypoVariableLabel);
            jPanel4.add(this.hypoVariableCombo);
            this.hypoStateLabel = new JLabel("<html><B>" + HuginGUIConstants.get("SA_State") + "</B></html>");
            this.hypoStateLabel.setPreferredSize(new Dimension((int)this.hypoVariableLabel.getPreferredSize().getWidth(), (int)this.hypoVariableCombo.getPreferredSize().getHeight()));
            this.hypoStateCombo.setBackground(Color.WHITE);
            this.hypoStateCombo.addItemListener(new StateComboListener(this.psw, this.hypoStateCombo));
            try {
                this.populateCombo(this.psw.getDCNodeList().get(this.hypoVariableCombo.getSelectedIndex()), this.hypoStateCombo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            JPanel jPanel5 = new JPanel(new GridLayout(1, 2));
            this.allStatesBox = new JCheckBox(HuginGUIConstants.get("SA_All_States"), false);
            jPanel5.add(this.hypoStateCombo);
            jPanel5.add(this.allStatesBox);
            jPanel3.add(this.hypoStateLabel);
            jPanel4.add(jPanel5);
            this.allStatesBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    PsPanel.this.enableRadioButtons(PsPanel.this.allStatesBox.isSelected());
                    PsPanel.this.clearGraph();
                    PsPanel.this.hypoStateCombo.setEnabled(!PsPanel.this.allStatesBox.isSelected());
                    DiscreteChanceNode discreteChanceNode = PsPanel.this.getSelectedHypothesisNode();
                    if (discreteChanceNode != null) {
                        PsPanel.this.computeSensitivityDataIfNecessary(discreteChanceNode);
                    }
                }
            });
            String string = this.twoWayMode() ? HuginGUIConstants.get("SA_Variable") + " " + 1 : HuginGUIConstants.get("SA_Para_Variable");
            this.paraVariableLabel = new JLabel("<html><B>" + string + "</B></html>");
            this.paraVariableLabel.setPreferredSize(new Dimension((int)this.hypoVariableLabel.getPreferredSize().getWidth(), (int)this.hypoVariableCombo.getPreferredSize().getHeight()));
            this.paraVariableCombo = new HuginComboBox((Vector)this.getNodeNameList(this.psw.getDCNodeList()));
            this.paraVariableCombo.setBackground(Color.WHITE);
            this.paraVariableCombo.addItemListener(new ParameterVariableListener(this.psw));
            int n = (int)this.hypoStateCombo.getPreferredSize().getWidth() + (int)this.allStatesBox.getPreferredSize().getWidth();
            this.hypoVariableCombo.setPreferredSize(new Dimension(n, 20));
            this.paraVariableCombo.setPreferredSize(new Dimension(n, 20));
            jPanel3.add(this.paraVariableLabel);
            jPanel4.add(this.paraVariableCombo);
            if (this.twoWayMode()) {
                this.twoParametersBox = new JCheckBox("");
                this.twoParametersBox.setToolTipText(HuginGUIConstants.get("SA_Enable_Second"));
                this.twoParametersBox.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        PsPanel.this.clearGraph();
                        PsPanel.this.paraVariableCombo1.setEnabled(PsPanel.this.twoParametersBox.isSelected());
                        PsPanel.this.paraVariableLabel.setEnabled(PsPanel.this.twoParametersBox.isSelected());
                        if (PsPanel.this.getSelectedVariableNode().equals(PsPanel.this.getSelectedVariableNode1()) && PsPanel.this.twoParametersBox.isSelected() && !PsPanel.this.resolveSelectionConflict(PsPanel.this.paraVariableCombo)) {
                            PsPanel.this.paraVariableCombo1.setEnabled(false);
                            PsPanel.this.paraVariableLabel.setEnabled(false);
                            PsPanel.this.twoParametersBox.setSelected(false);
                        }
                        PsPanel.this.createTable();
                    }
                });
                this.paraVariableLabel1 = new JLabel("<html><B>" + HuginGUIConstants.get("SA_Variable") + " " + 2 + "</B></html>");
                this.paraVariableLabel1.setPreferredSize(new Dimension((int)this.hypoVariableLabel.getPreferredSize().getWidth(), (int)this.hypoVariableCombo.getPreferredSize().getHeight()));
                this.paraVariableCombo1 = new HuginComboBox((Vector)this.getNodeNameList(this.psw.getDCNodeList()));
                this.paraVariableCombo1.setBackground(Color.WHITE);
                this.paraVariableCombo1.addItemListener(new ParameterVariableListener(this.psw));
                this.paraVariableCombo1.setPreferredSize(new Dimension(n, 20));
                this.paraVariableLabel1.setEnabled(false);
                this.paraVariableCombo1.setEnabled(false);
                jPanel5 = new JPanel(new BorderLayout());
                jPanel5.add((Component)this.paraVariableCombo1, "Center");
                jPanel5.add((Component)this.twoParametersBox, "East");
                jPanel3.add(this.paraVariableLabel1);
                jPanel4.add(jPanel5);
            }
            jPanel.add((Component)jPanel3, "West");
            jPanel.add((Component)jPanel4, "Center");
            jPanel5 = new JPanel();
            jPanel5.setLayout(new BoxLayout(jPanel5, 0));
            this.createColorChart();
            this.scrollpane.setPreferredSize(new Dimension(300, 150));
            this.scrollpane.getViewport().setBackground(Color.white);
            JPanel jPanel6 = new JPanel(new BorderLayout());
            jPanel6.add((Component)jPanel, "North");
            jPanel6.add((Component)new JLabel("  "), "South");
            jPanel2.add((Component)jPanel6, "North");
            jPanel2.add((Component)this.scrollpane, "Center");
            this.leftPanel.add(jPanel2);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
    }

    private void createRightPanel() {
        this.rightPanel = new JPanel(new GridLayout(1, 1));
        this.rightPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        if (this.twoWayMode()) {
            this.create3DGraph();
        } else {
            this.createGraph(0);
        }
        this.rightPanel.removeAll();
        this.rightPanel.add(this.graphPanel);
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel(new BorderLayout());
        this.networkButton = new JButton(HuginGUIConstants.get("SA_Open_Network"));
        this.networkButton.setToolTipText(HuginGUIConstants.get("SA_ToolTip_Open_Network"));
        this.networkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PsPanel.this.ssd = new SensitivitySetDialog(PsPanel.this.psw, PsPanel.this.projectFrame);
                PsPanel.this.networkButton.setEnabled(false);
                PsPanel.this.ssd.addParameterListener(new ParameterListener());
                PsPanel.this.computeSensitivityDataIfNecessary(PsPanel.this.getSelectedHypothesisNode());
            }
        });
        if (this.twoWayMode()) {
            this.computeButton = new JButton(HuginGUIConstants.get("PSW_Compute"));
            this.buttonPanel.add((Component)this.computeButton, "East");
        } else {
            this.buttonPanel.add((Component)this.networkButton, "East");
        }
        this.minRadio = new JRadioButton(HuginGUIConstants.get("PSW_Min_SV"));
        this.minRadio.setToolTipText(HuginGUIConstants.get("PSW_Min_Sensitivity_Values"));
        RadioListener radioListener = new RadioListener();
        this.minRadio.addActionListener(radioListener);
        this.maxRadio = new JRadioButton(HuginGUIConstants.get("PSW_Max_SV"));
        this.maxRadio.setToolTipText(HuginGUIConstants.get("PSW_Max_Sensitivity_Values"));
        this.minRadio.setSelected(true);
        this.maxRadio.addActionListener(radioListener);
        this.enableRadioButtons(false);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(this.minRadio);
        jPanel.add(this.maxRadio);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.minRadio);
        buttonGroup.add(this.maxRadio);
        if (!this.twoWayMode()) {
            this.buttonPanel.add((Component)jPanel, "West");
        }
    }

    private void createBottomPanel() {
        this.bottomPanel = new JPanel(new BorderLayout());
        this.bottomPanel.setBorder(BorderFactory.createEtchedBorder());
        this.databaseLabel = new JLabel(HuginGUIConstants.get("AW_Data_file") + ": " + "---");
        this.numberOfCasesLabel = new JLabel(HuginGUIConstants.get("AW_Data_number_of_cases") + "0", 4);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(this.databaseLabel);
        jPanel.add(this.numberOfCasesLabel);
        this.createTable();
        this.bottomPanel.add((Component)this.tablePanel, "Center");
    }

    private void createGraph(int n) {
        if (this.graphPanel == null) {
            this.graphPanel = new JPanel(new BorderLayout());
            this.createMultipleGraph(0);
            this.graphPanel.add((Component)this.mlg, "Center");
        } else {
            if (this.selectedCases) {
                DiscreteChanceNode discreteChanceNode = this.getSelectedHypothesisNode();
                if (discreteChanceNode != null) {
                    this.psw.computeSensitivityForSelectedCases(discreteChanceNode, n, this);
                    if (this.mlg.hasLines()) {
                        double d = 0.0;
                        for (int i = 0; i < this.mlg.getNumberOfLines(); ++i) {
                            Line line = this.mlg.getLine(i);
                            line.setParameterImportance((d += Math.abs(line.getSensitivityValue())) / (double)(i + 1));
                        }
                    }
                }
            } else {
                this.createMultipleGraph(n);
            }
            this.graphPanel.repaint();
            this.rightPanel.repaint();
        }
        this.graphPanel.setVisible(true);
        this.rightPanel.setVisible(true);
    }

    private void create3DGraph() {
        if (this.graphPanel == null) {
            this.graphPanel = new JPanel(new BorderLayout());
        }
        this.graphPanel.setVisible(true);
        this.rightPanel.setVisible(true);
    }

    private void initializeCombo(boolean bl) {
        DiscreteChanceNode discreteChanceNode = this.getSelectedHypothesisNode();
        int n = this.hypoVariableCombo.getSelectedIndex();
        this.hypoVariableCombo.setSelectedIndex(-1);
        try {
            if (!discreteChanceNode.evidenceIsEntered() && bl) {
                this.hypoVariableCombo.setSelectedIndex(n);
                this.validate();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setSelectedHypothesisNode(COM.hugin.HAPI.Node node) {
        if (node == null) {
            this.hypoVariableCombo.setSelectedIndex(-1);
        } else {
            Vector<DiscreteChanceNode> vector = this.psw.getDCNodeList();
            int n = vector.indexOf(node);
            this.hypoVariableCombo.setSelectedIndex(n);
        }
        this.validate();
    }

    protected DiscreteChanceNode getSelectedVariableNode() {
        Vector<DiscreteChanceNode> vector = this.psw.getDCNodeList();
        DiscreteChanceNode discreteChanceNode = vector.get(this.paraVariableCombo.getSelectedIndex());
        return discreteChanceNode;
    }

    protected DiscreteChanceNode getSelectedVariableNode1() {
        Vector<DiscreteChanceNode> vector = this.psw.getDCNodeList();
        DiscreteChanceNode discreteChanceNode = vector.get(this.paraVariableCombo1.getSelectedIndex());
        return discreteChanceNode;
    }

    protected DiscreteChanceNode getSelectedHypothesisNode() {
        String string = (String)this.hypoVariableCombo.getSelectedItem();
        if (string != null) {
            Vector<DiscreteChanceNode> vector = this.psw.getDCNodeList();
            DiscreteChanceNode discreteChanceNode = vector.get(this.hypoVariableCombo.getSelectedIndex());
            return discreteChanceNode;
        }
        return null;
    }

    protected int getSelectedState() {
        return this.hypoStateCombo.getSelectedIndex();
    }

    protected String getSelectedStateName() {
        return (String)this.hypoStateCombo.getItemAt(this.getSelectedState());
    }

    protected void closeNetworkPanel() {
        if (this.ssd != null) {
            this.ssd.dispose();
        }
        this.ssd = null;
    }

    public boolean resolveSelectionConflict(HuginComboBox huginComboBox) {
        boolean bl = false;
        if (huginComboBox.equals(this.paraVariableCombo)) {
            int n;
            int n2 = huginComboBox.getSelectedIndex();
            if (n2 == (n = this.paraVariableCombo1.getSelectedIndex())) {
                if (n2 != 0) {
                    this.paraVariableCombo1.setSelectedIndex(0);
                    bl = true;
                } else if (n2 != 1 && huginComboBox.getItemCount() > 1) {
                    this.paraVariableCombo1.setSelectedIndex(1);
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private void computeValues() {
        try {
            if (this.selectedCases || this.twoWayMode()) {
                this.psw.clearMinMaxSensitivityValues();
            } else if (this.allStatesBox.isSelected()) {
                this.psw.computeMinMaxForAllStatesAndAllVariables(this.getSelectedHypothesisNode());
            } else {
                this.psw.computeMinMaxSensitivtyValues(this.getSelectedHypothesisNode(), this.getSelectedState());
            }
            this.computeColorMapValues();
            this.updateColormapWithNewValues();
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
    }

    private Vector<String> getNodeNameList(Vector<DiscreteChanceNode> vector) {
        Vector<String> vector2 = new Vector<String>();
        for (DiscreteChanceNode discreteChanceNode : vector) {
            try {
                vector2.add(HuginGUIUtils.getNodeTitle(discreteChanceNode));
            }
            catch (ExceptionHugin exceptionHugin) {}
        }
        return vector2;
    }

    private void populateCombo(DiscreteChanceNode discreteChanceNode, HuginComboBox huginComboBox) {
        Vector<String> vector = this.psw.getNodeStatesDescription(discreteChanceNode);
        huginComboBox.removeAllItems();
        for (String string : vector) {
            huginComboBox.addItem(string);
        }
        if (vector.size() > 1) {
            huginComboBox.setSelectedIndex(1);
        }
        huginComboBox.setSelectedIndex(0);
        huginComboBox.validatePopupWidth();
    }

    private void createTable() {
        Node node = null;
        Object var2_2 = null;
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        DiscreteChanceNode discreteChanceNode = this.getSelectedVariableNode();
        DiscreteChanceNode discreteChanceNode2 = this.getSelectedHypothesisNode();
        if (discreteChanceNode == null) {
            return;
        }
        try {
            this.tablePanel.removeAll();
            node = this.projectFrame.getNetworkPanel().getNode(discreteChanceNode.getName());
            if (node != null) {
                JComponent jComponent;
                Cloneable cloneable;
                Object object;
                if (this.twoWayMode()) {
                    if (this.twoParametersBox.isSelected()) {
                        object = this.getSelectedVariableNode1();
                        cloneable = this.projectFrame.getNetworkPanel().getNode(((COM.hugin.HAPI.Node)object).getName());
                        jComponent = this.getTwoTableWrapper(node, (Node)cloneable);
                    } else {
                        jComponent = this.getTableWrapper(node, 1);
                    }
                } else {
                    jComponent = this.getTableWrapper(node, 2);
                }
                jPanel.add(jComponent);
                object = new JPanel(new GridLayout(1, 1));
                ((Container)object).add(jPanel);
                this.tableScrollPane = new JScrollPane((Component)object);
                cloneable = this.tableScrollPane.getViewport().getViewSize();
                this.tableScrollPane.setPreferredSize(new Dimension(450, 100));
                this.tablePanel.add(jComponent);
                this.tablePanel.validate();
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
    }

    private TableWrapper getTableWrapper(Node node, int n) throws ExceptionHugin {
        Object object;
        this.nt = this.getNodeTable(node);
        ListSelectionModel listSelectionModel = this.nt.getTable().getSelectionModel();
        if (n == 1) {
            object = new SelectedCells();
            TwoCellsListener twoCellsListener = new TwoCellsListener((SelectedCells)object, (GenericTable)this.nt.getTable());
            listSelectionModel.addListSelectionListener(twoCellsListener);
            this.nt.getTable().getColumnModel().getSelectionModel().addListSelectionListener(twoCellsListener);
            this.nt.getTable().setDefaultRenderer(Object.class, new SelectionRenderer((SelectedCells)object));
            this.addListenerToComputeButton((SelectedCells)object);
            this.mgt = new ModeGraphicTable(node, 0, (GenericTable)this.nt.getTable());
        } else if (n == 3) {
            object = new SelectedCells();
            TwoCellsListener twoCellsListener = new TwoCellsListener((SelectedCells)object, (GenericTable)this.nt.getTable());
            listSelectionModel.addListSelectionListener(twoCellsListener);
            this.nt.getTable().getColumnModel().getSelectionModel().addListSelectionListener(twoCellsListener);
            this.nt.getTable().setDefaultRenderer(Object.class, new SelectionRenderer((SelectedCells)object));
            this.addListenerToComputeButton(null);
            this.mgt = new ModeGraphicTable(node, 0, (GenericTable)this.nt.getTable());
        } else {
            object = new SelectionListener((GenericTable)this.nt.getTable());
            listSelectionModel.addListSelectionListener((ListSelectionListener)object);
            this.nt.getTable().getColumnModel().getSelectionModel().addListSelectionListener((ListSelectionListener)object);
            this.nt.getTable().setDefaultRenderer(Object.class, new SelectionRenderer());
            this.mgt = new CustomModeGraphicTable(node, 0, (GenericTable)this.nt.getTable(), this.colorMapValues);
        }
        int n2 = this.tableWr == null ? 150 : this.tableWr.contents.getDividerLocation();
        this.tableWr = new TableWrapper(this.nt, this.nt, this.mgt);
        this.tableWr.wrapInScrollPane();
        this.tableWr.setPreferredSize(new Dimension(500, 150));
        this.tableWr.contents.setDividerLocation(n2);
        return this.tableWr;
    }

    private JTabbedPane getTwoTableWrapper(Node node, Node node2) throws ExceptionHugin {
        NodeTable nodeTable = this.getNodeTable(node);
        NodeTable nodeTable2 = this.getNodeTable(node2);
        ListSelectionModel listSelectionModel = nodeTable.getTable().getSelectionModel();
        SelectedCells selectedCells = new SelectedCells(nodeTable.getTable(), nodeTable2.getTable());
        TwoCellsListener twoCellsListener = new TwoCellsListener(selectedCells, (GenericTable)nodeTable.getTable(), 1);
        listSelectionModel.addListSelectionListener(twoCellsListener);
        nodeTable.getTable().getColumnModel().getSelectionModel().addListSelectionListener(twoCellsListener);
        nodeTable.getTable().setDefaultRenderer(Object.class, new SelectionRenderer(selectedCells));
        ModeGraphicTable modeGraphicTable = new ModeGraphicTable(node, 0, (GenericTable)nodeTable.getTable());
        twoCellsListener = new TwoCellsListener(selectedCells, (GenericTable)nodeTable2.getTable(), 2);
        listSelectionModel = nodeTable2.getTable().getSelectionModel();
        listSelectionModel.addListSelectionListener(twoCellsListener);
        nodeTable2.getTable().getColumnModel().getSelectionModel().addListSelectionListener(twoCellsListener);
        nodeTable2.getTable().setDefaultRenderer(Object.class, new SelectionRenderer(selectedCells));
        ModeGraphicTable modeGraphicTable2 = new ModeGraphicTable(node2, 0, (GenericTable)nodeTable2.getTable());
        this.addListenerToComputeButton(selectedCells);
        int n = this.tableWr == null ? 150 : this.tableWr.contents.getDividerLocation();
        TableWrapper tableWrapper = new TableWrapper(nodeTable, nodeTable, modeGraphicTable);
        tableWrapper.wrapInScrollPane();
        tableWrapper.setPreferredSize(new Dimension(500, 150));
        tableWrapper.contents.setDividerLocation(n);
        TableWrapper tableWrapper2 = new TableWrapper(nodeTable2, nodeTable2, modeGraphicTable2);
        tableWrapper2.wrapInScrollPane();
        tableWrapper2.setPreferredSize(new Dimension(500, 150));
        tableWrapper2.contents.setDividerLocation(n);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(HuginGUIUtils.getNodeTitle(node.getAPINode()), tableWrapper);
        jTabbedPane.addTab(HuginGUIUtils.getNodeTitle(node2.getAPINode()), tableWrapper2);
        return jTabbedPane;
    }

    private NodeTable getNodeTable(Node node) throws ExceptionHugin {
        NodeTable nodeTable = new NodeTable(node);
        nodeTable.setEditable(false);
        this.originalCanShowExpressions = false;
        if (nodeTable.showExpressions()) {
            nodeTable.generateTable();
            nodeTable.enableDataTable(true);
        }
        if (nodeTable.showExperience()) {
            nodeTable.getExperienceTable().setEnabled(false);
        }
        if (nodeTable.showFading()) {
            nodeTable.getFadingTable().setEnabled(false);
        }
        nodeTable.getTable().setColumnSelectionAllowed(true);
        nodeTable.getTable().setRowSelectionAllowed(true);
        ListSelectionModel listSelectionModel = nodeTable.getTable().getSelectionModel();
        nodeTable.getTable().setSelectionMode(0);
        nodeTable.getTable().setCellSelectionEnabled(true);
        return nodeTable;
    }

    private void createColorChart() {
        if (this.scrollpane == null) {
            this.scrollpane = new JScrollPane();
            this.scrollpane.repaint();
        } else {
            this.scrollpane.repaint();
        }
    }

    private void fillColorArray() {
        this.colors = new Color[11];
        int n = 0;
        this.colors[n++] = Color.RED;
        this.colors[n++] = Color.CYAN;
        this.colors[n++] = Color.ORANGE;
        this.colors[n++] = Color.MAGENTA;
        this.colors[n++] = Color.GREEN;
        this.colors[n++] = Color.BLUE;
        this.colors[n++] = Color.GRAY;
        this.colors[n++] = Color.ORANGE;
        this.colors[n++] = Color.PINK;
        this.colors[n++] = Color.YELLOW;
        this.colors[n++] = Color.DARK_GRAY;
    }

    protected Color getColor() {
        int n = (int)(Math.random() * 255.0);
        int n2 = (int)(Math.random() * 255.0);
        int n3 = (int)(Math.random() * 255.0);
        return new Color(n, n2, n3);
    }

    protected Color getColor(int n) {
        Color color = n >= this.colors.length ? this.getColor() : this.colors[n];
        return color;
    }

    private void createMultipleGraph(int n) {
        if (this.mlg == null) {
            this.mlg = new MultipleLineGraph(HuginGUIConstants.get("SA_Graph_Title"), 0, 1);
        } else {
            DiscreteChanceNode discreteChanceNode = this.getSelectedVariableNode();
            DiscreteChanceNode discreteChanceNode2 = this.getSelectedHypothesisNode();
            if (discreteChanceNode == null || discreteChanceNode2 == null) {
                return;
            }
            if (!this.psw.isSensitivityComputedFor(discreteChanceNode2)) {
                return;
            }
            try {
                boolean bl;
                int[] nArray;
                int n2;
                this.mlg.removeLines();
                Object var2_4 = null;
                if (this.allStatesBox.isSelected()) {
                    n2 = discreteChanceNode2.getNumberOfStates();
                    nArray = new int[n2];
                    for (int i = 0; i < n2; ++i) {
                        nArray[i] = i;
                    }
                    bl = false;
                } else {
                    nArray = new int[]{this.getSelectedState()};
                    bl = true;
                }
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    this.addLineToGraph(discreteChanceNode, nArray[n2], n, "", this.getColor(n2), bl);
                }
                if (this.mlg.hasLines()) {
                    this.createTableView(this.mlg);
                } else {
                    this.createTableView(null);
                }
            }
            catch (Exception exception) {
                this.psw.clearMinMaxSensitivityValues();
            }
        }
    }

    public void addLineToGraph(DiscreteChanceNode discreteChanceNode, int n, int n2, String string, Color color, boolean bl) throws ExceptionHugin {
        double[] dArray;
        if (discreteChanceNode == null) {
            return;
        }
        try {
            dArray = discreteChanceNode.getSensitivityConstants(n2, n);
        }
        catch (ExceptionHugin exceptionHugin) {
            dArray = null;
        }
        if (dArray != null) {
            double d;
            double d2 = (dArray[0] * this.pointY + dArray[1]) / (dArray[2] * this.pointY + dArray[3]);
            int n3 = this.mlg.addLine(string, color);
            Line line = this.mlg.getLine(n3);
            line.setAlfa(dArray[0]);
            line.setBeta(dArray[1]);
            line.setGama(dArray[2]);
            line.setDelta(dArray[3]);
            line.calculateSensitivityValue(this.pointY);
            line.setState(this.hypoStateCombo.getItemAt(n));
            double d3 = d = 1.0 / (double)this.pointsToPlot;
            for (int i = 0; i < this.pointsToPlot - 1; ++i) {
                d2 = (dArray[0] * d3 + dArray[1]) / (dArray[2] * d3 + dArray[3]);
                this.mlg.addItem(d2, d3, n3);
                d3 += d;
            }
            d2 = (dArray[0] * this.pointY + dArray[1]) / (dArray[2] * this.pointY + dArray[3]);
            this.mlg.addPoint(d2, this.pointY, n3);
            if (bl) {
                this.addBoundsToLine(line, this.pointY, d2);
            }
        }
    }

    private void addListenerToComputeButton(SelectedCells selectedCells) {
        ActionListener[] actionListenerArray = this.computeButton.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.computeButton.removeActionListener(actionListenerArray[i]);
        }
        this.computeButton.addActionListener(new TwoWayComputeListener(selectedCells));
    }

    public void addLineToGraph(int n, String string, Color color) {
        double[] dArray;
        DiscreteChanceNode discreteChanceNode = this.getSelectedVariableNode();
        DiscreteChanceNode discreteChanceNode2 = this.getSelectedHypothesisNode();
        if (discreteChanceNode == null || discreteChanceNode2 == null) {
            return;
        }
        try {
            dArray = discreteChanceNode.getSensitivityConstants(n, this.getSelectedState());
        }
        catch (ExceptionHugin exceptionHugin) {
            dArray = null;
        }
        if (dArray != null) {
            double d;
            double d2 = (dArray[0] * this.pointY + dArray[1]) / (dArray[2] * this.pointY + dArray[3]);
            int n2 = this.mlg.addLine(string, color);
            Line line = this.mlg.getLine(n2);
            line.setAlfa(dArray[0]);
            line.setBeta(dArray[1]);
            line.setGama(dArray[2]);
            line.setDelta(dArray[3]);
            line.calculateSensitivityValue(this.pointY);
            line.setState(this.hypoStateCombo.getSelectedItem());
            double d3 = d = 1.0 / (double)this.pointsToPlot;
            for (int i = 0; i < this.pointsToPlot - 1; ++i) {
                d2 = (dArray[0] * d3 + dArray[1]) / (dArray[2] * d3 + dArray[3]);
                this.mlg.addItem(d2, d3, n2);
                d3 += d;
            }
            d2 = (dArray[0] * this.pointY + dArray[1]) / (dArray[2] * this.pointY + dArray[3]);
            this.mlg.addPoint(d2, this.pointY, n2);
        }
    }

    public void selectedCases(boolean bl) {
        this.selectedCases = bl;
        this.enableRadioButtons(this.allStatesBox.isSelected() && !bl);
        this.hypoStateCombo.setEnabled(!this.allStatesBox.isSelected() || bl);
        this.allStatesBox.setEnabled(!bl);
        this.networkButton.setEnabled(!bl && this.ssd == null);
        if (bl) {
            this.closeNetworkPanel();
        }
        this.validate();
        this.repaint();
    }

    public void createTableView() {
        if (this.mlg.hasLines()) {
            this.createTableView(this.mlg);
        } else {
            this.createTableView(null);
        }
        this.validate();
        this.repaint();
    }

    public void createTableView(MultipleLineGraph multipleLineGraph) {
        int n = this.scrollpane.getHorizontalScrollBar().getValue();
        this.scrollpane.setViewportView(null);
        this.scrollpane.setColumnHeaderView(null);
        if (multipleLineGraph != null) {
            try {
                TableSorter tableSorter = new TableSorter(new GraphInfoModel(multipleLineGraph));
                tableSorter.doubleLargerThanString(true);
                JTable jTable = new JTable(tableSorter){

                    public boolean isCellEditable(int n, int n2) {
                        return false;
                    }
                };
                jTable.getTableHeader().setDefaultRenderer(this.psw.new ParameterSensitivityWizard.RaisedHeader());
                tableSorter.setTableHeader(jTable.getTableHeader());
                this.psw.addTableToScrollPane(jTable, this.scrollpane);
                LineSelectionListener lineSelectionListener = new LineSelectionListener(jTable);
                ListSelectionModel listSelectionModel = jTable.getSelectionModel();
                jTable.setSelectionMode(0);
                listSelectionModel.addListSelectionListener(lineSelectionListener);
                TableColumnModel tableColumnModel = jTable.getColumnModel();
                TableColumn tableColumn = tableColumnModel.getColumn(0);
                tableColumn.setCellRenderer(new ColorRenderer(multipleLineGraph.getLines(), tableSorter));
                jTable.setDefaultRenderer(Double.class, new PrintDoublesRenderer());
                jTable.addMouseListener(new UnselectListener(jTable));
                int n2 = this.scrollpane.getHorizontalScrollBar().getMaximum();
                int n3 = this.scrollpane.getHorizontalScrollBar().getMinimum();
                if (n > n2) {
                    n = n2;
                }
                if (n < n3) {
                    n = n3;
                }
                this.scrollpane.getHorizontalScrollBar().setValue(n);
            }
            catch (ExceptionHugin exceptionHugin) {
                // empty catch block
            }
        }
    }

    public void createTwoWayTableView(TwoWayGraphInfoModel twoWayGraphInfoModel) {
        int n = this.scrollpane.getHorizontalScrollBar().getValue();
        this.scrollpane.setViewportView(null);
        this.scrollpane.setColumnHeaderView(null);
        if (twoWayGraphInfoModel != null) {
            TableSorter tableSorter = new TableSorter(twoWayGraphInfoModel);
            tableSorter.doubleLargerThanString(true);
            JTable jTable = new JTable(tableSorter){

                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            jTable.getTableHeader().setDefaultRenderer(this.psw.new ParameterSensitivityWizard.RaisedHeader());
            jTable.setDefaultRenderer(Double.class, new PrintDoublesRenderer());
            tableSorter.setTableHeader(jTable.getTableHeader());
            this.psw.addTableToScrollPane(jTable, this.scrollpane);
            Line3DSelectionListener line3DSelectionListener = new Line3DSelectionListener(jTable);
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            jTable.setSelectionMode(0);
            listSelectionModel.addListSelectionListener(line3DSelectionListener);
            int n2 = this.scrollpane.getHorizontalScrollBar().getMaximum();
            int n3 = this.scrollpane.getHorizontalScrollBar().getMinimum();
            if (n > n2) {
                n = n2;
            }
            if (n < n3) {
                n = n3;
            }
            this.scrollpane.getHorizontalScrollBar().setValue(n);
            jTable.changeSelection(0, 0, false, false);
        }
    }

    private Double upperBound(Double d, Double d2, Double d3) {
        Double d4 = this.delta(d, d2);
        Double d5 = d3 * Math.pow(Math.E, d4) / (d3 * (Math.pow(Math.E, d4) - 1.0) + 1.0);
        return d5;
    }

    private Double lowerBound(Double d, Double d2, Double d3) {
        Double d4 = this.delta(d, d2);
        Double d5 = d3 * Math.pow(Math.E, -d4.doubleValue()) / (d3 * (Math.pow(Math.E, -d4.doubleValue()) - 1.0) + 1.0);
        return d5;
    }

    private Double delta(Double d, Double d2) {
        Double d3 = Math.abs(Math.log(d2 / (1.0 - d2)) - Math.log(d / (1.0 - d)));
        return d3;
    }

    private void addBoundsToLine(Line line, double d, double d2) {
        Line line2 = new Line("bound", Color.gray);
        Line line3 = new Line("bound", Color.gray);
        for (double d3 = 0.0; d3 <= 1.0; d3 += 0.001) {
            Double d4;
            Double d5 = this.upperBound(d, d3, d2);
            if (!d5.equals(Double.NaN)) {
                line2.addItem(d5, d3);
            }
            if ((d4 = this.lowerBound(d, d3, d2)).equals(Double.NaN)) continue;
            line3.addItem(d4, d3);
        }
        line.setUpperBound(line2);
        line.setLowerBound(line3);
    }

    private void clearAndKeepSelectedHypo() {
        this.initializeCombo(true);
    }

    protected void clear() {
        this.initializeCombo(false);
        this.clearGraph();
        this.computeValues();
    }

    public void clearGraph() {
        this.clearGraph(true);
    }

    protected void clearGraph(boolean bl) {
        if (this.twoWayMode()) {
            this.graphPanel.removeAll();
        } else if (this.mlg != null) {
            this.mlg.removeLines();
            this.mlg.repaint();
        }
        this.graphPanel.repaint();
        this.rightPanel.repaint();
        this.createTableView(null);
        if (this.nt != null && bl) {
            int n;
            int n2;
            if (this.selected != null) {
                this.selected.clearSelection();
            }
            if ((n2 = this.nt.getTable().getSelectedRow()) != -1) {
                this.nt.getTable().removeRowSelectionInterval(n2, n2);
            }
            if ((n = this.nt.getTable().getSelectedColumn()) != -1) {
                this.nt.getTable().removeColumnSelectionInterval(n, n);
            }
        }
    }

    protected void computeColorMapValues() {
        this.colorMapValues = null;
        if (!this.psw.isSensitivityComputedFor(this.getSelectedHypothesisNode()) || this.twoWayMode()) {
            return;
        }
        try {
            int n;
            int n2;
            int n3;
            DiscreteChanceNode discreteChanceNode = this.getSelectedVariableNode();
            DiscreteChanceNode discreteChanceNode2 = this.getSelectedHypothesisNode();
            if (discreteChanceNode == null || discreteChanceNode2 == null) {
                return;
            }
            boolean bl = this.allStatesBox.isSelected();
            Table table = discreteChanceNode.getTable();
            int n4 = table.getSize() / discreteChanceNode.getNumberOfStates();
            int n5 = discreteChanceNode.getNumberOfStates();
            this.colorMapValues = new float[n4][n5];
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    this.colorMapValues[n3][n2] = 0.0f;
                }
            }
            n3 = this.hypoStateCombo.getSelectedIndex();
            n2 = n3 + 1;
            if (bl) {
                n3 = 0;
                n2 = discreteChanceNode2.getNumberOfStates();
            }
            boolean bl2 = (n = n2 - n3) != 1;
            for (int i = n3; i < n2; ++i) {
                for (int j = 0; j < n4; ++j) {
                    for (int k = 0; k < n5; ++k) {
                        try {
                            int n6 = j * n5 + k;
                            double[] dArray = discreteChanceNode.getSensitivityConstants(n6, i);
                            if (bl2) {
                                Double d;
                                if (this.minRadio.isSelected()) {
                                    d = this.psw.computeSensitivityValue(dArray, table.getDataItem(n6));
                                    this.colorMapValues[j][k] = Math.min(this.colorMapValues[j][k], d.floatValue());
                                    continue;
                                }
                                d = this.psw.computeSensitivityValue(dArray, table.getDataItem(n6));
                                this.colorMapValues[j][k] = Math.max(this.colorMapValues[j][k], d.floatValue());
                                continue;
                            }
                            float[] fArray = this.colorMapValues[j];
                            int n7 = k;
                            fArray[n7] = (float)((double)fArray[n7] + this.psw.computeSensitivityValue(dArray, table.getDataItem(n6)));
                            continue;
                        }
                        catch (ExceptionHugin exceptionHugin) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
    }

    protected void updateColormapWithNewValues() {
        if (this.mgt instanceof CustomModeGraphicTable) {
            CustomModeGraphicTable customModeGraphicTable = (CustomModeGraphicTable)this.mgt;
            customModeGraphicTable.setData(this.colorMapValues);
            customModeGraphicTable.validate();
            customModeGraphicTable.repaint();
        }
    }

    private void enableRadioButtons(boolean bl) {
        this.maxRadio.setEnabled(bl);
        this.minRadio.setEnabled(bl);
    }

    private void computeTwoWayMultipleCases(SelectedCells selectedCells, DiscreteChanceNode discreteChanceNode) {
        final SelectedCells selectedCells2 = selectedCells;
        final DiscreteChanceNode discreteChanceNode2 = discreteChanceNode;
        if (!selectedCells2.twoIndexesSelected()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                PsPanel.this.psw.setEnabled(false);
                try {
                    TableCell tableCell = selectedCells2.getSelected1();
                    TableCell tableCell2 = selectedCells2.getSelected2();
                    Vector<Object> vector = new Vector();
                    if (!selectedCells2.hasTwoTables()) {
                        vector = PsPanel.this.psw.computeTwoWaySensitivityForSelectedCases(discreteChanceNode2, tableCell, tableCell2, PsPanel.this.psp);
                        double d = 0.0;
                        double d2 = 0.0;
                        int n = 1;
                        for (LineData3D lineData3D : vector) {
                            lineData3D.setImportance1((d += Math.abs(lineData3D.getSensitivityValue1())) / (double)n);
                            lineData3D.setImportance2((d2 += Math.abs(lineData3D.getSensitivityValue2())) / (double)n);
                            ++n;
                        }
                    } else {
                        vector = PsPanel.this.psw.computeTwoWayTwoCPTSensitivityForSelectedCases(discreteChanceNode2, tableCell, tableCell2, PsPanel.this.psp);
                    }
                    if (vector.size() > 0) {
                        TwoWayGraphInfoModel twoWayGraphInfoModel = new TwoWayGraphInfoModel(vector);
                        PsPanel.this.createTwoWayTableView(twoWayGraphInfoModel);
                    }
                }
                catch (Exception exception) {
                    PsPanel.this.clearGraph(false);
                }
                PsPanel.this.psw.setEnabled(true);
                PsPanel.this.psw.toFront();
            }
        };
        thread.start();
    }

    protected double[] getSensitivityConstants(TableCell tableCell, TableCell tableCell2) throws ExceptionHugin {
        return this.getSensitivityConstants(tableCell, tableCell2, -1);
    }

    protected double[] getSensitivityConstants(TableCell tableCell, TableCell tableCell2, int n) throws ExceptionHugin {
        DiscreteNode discreteNode;
        boolean bl;
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        if (tableCell.getValue() == 1.0 || tableCell.getValue() == 0.0 || tableCell2.getValue() == 1.0 || tableCell2.getValue() == 0.0) {
            throw new ExceptionHugin(HuginGUIConstants.get("SA_Error_Extreme_Values"));
        }
        double d = 0.1;
        double d2 = 0.8;
        double d3 = 0.3;
        double d4 = 0.7;
        Vector<DiscreteDecisionNode> vector = this.psw.getDDNodesNotInstantiated();
        DiscreteChanceNode discreteChanceNode = this.getSelectedHypothesisNode();
        boolean bl2 = bl = n != -1;
        if (bl && vector.size() > 0 && (discreteNode = this.getUnInitializedDDNode(vector, discreteChanceNode)) != null) {
            throw new ExceptionHugin(HuginGUIConstants.get("SA_Error_Decision_Ancestor_Arg0__Not_Initialized", new String[]{HuginGUIUtils.getNodeTitle(discreteNode)}));
        }
        try {
            discreteNode = this.getSelectedVariableNode();
            DiscreteChanceNode discreteChanceNode2 = this.getSelectedVariableNode1();
            dArray[0] = this.getNormalizationConstant(discreteNode, discreteChanceNode2, d, d3, tableCell.getIndex(), tableCell2.getIndex(), n);
            dArray[1] = this.getNormalizationConstant(discreteNode, discreteChanceNode2, d, d4, tableCell.getIndex(), tableCell2.getIndex(), n);
            dArray[2] = this.getNormalizationConstant(discreteNode, discreteChanceNode2, d2, d3, tableCell.getIndex(), tableCell2.getIndex(), n);
            dArray[3] = this.getNormalizationConstant(discreteNode, discreteChanceNode2, d2, d4, tableCell.getIndex(), tableCell2.getIndex(), n);
            dArray2 = this.getConstants(dArray, d, d2, d3, d4);
        }
        catch (ExceptionHugin exceptionHugin) {
            this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
            throw exceptionHugin;
        }
        return dArray2;
    }

    private DiscreteDecisionNode getUnInitializedDDNode(Vector<DiscreteDecisionNode> vector, DiscreteChanceNode discreteChanceNode) throws ExceptionHugin {
        NodeList nodeList = discreteChanceNode.getAncestors();
        if (nodeList != null && nodeList.size() > 0) {
            for (DiscreteDecisionNode discreteDecisionNode : vector) {
                if (!nodeList.contains(discreteDecisionNode)) continue;
                return discreteDecisionNode;
            }
        }
        return null;
    }

    private double getNormalizationConstant(DiscreteNode discreteNode, DiscreteNode discreteNode2, double d, double d2, int n, int n2, int n3) throws ExceptionHugin {
        double[] dArray = discreteNode.getTable().getData();
        double[] dArray2 = discreteNode2.getTable().getData();
        this.changeCPTIndex(discreteNode, d, n);
        this.changeCPTIndex(discreteNode2, d2, n2);
        DiscreteChanceNode discreteChanceNode = this.getSelectedHypothesisNode();
        if (n3 != -1) {
            discreteChanceNode.selectState(n3);
        }
        try {
            this.psw.sensitivityComputed(false, discreteChanceNode);
            this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
        }
        catch (ExceptionHugin exceptionHugin) {
            if (n3 != -1) {
                discreteChanceNode.retractFindings();
            }
            discreteNode.getTable().setData(dArray);
            Node node = this.psw.projectFrame.getNetworkPanel().getNode(discreteNode.getName());
            this.psw.syncDomainToClass(node);
            discreteNode2.getTable().setData(dArray2);
            node = this.psw.projectFrame.getNetworkPanel().getNode(discreteNode2.getName());
            this.psw.syncDomainToClass(node);
            throw new ExceptionHugin(exceptionHugin.getMessage());
        }
        double d3 = this.domain.getNormalizationConstant();
        if (n3 != -1) {
            discreteChanceNode.retractFindings();
        }
        discreteNode.getTable().setData(dArray);
        Node node = this.psw.projectFrame.getNetworkPanel().getNode(discreteNode.getName());
        this.psw.syncDomainToClass(node);
        discreteNode2.getTable().setData(dArray2);
        node = this.psw.projectFrame.getNetworkPanel().getNode(discreteNode2.getName());
        this.psw.syncDomainToClass(node);
        return d3;
    }

    private double[] getConstants(double[] dArray, double d, double d2, double d3, double d4) throws ExceptionHugin {
        double[] dArray2 = new double[4];
        double d5 = dArray[0];
        double d6 = dArray[1];
        double d7 = dArray[2];
        double d8 = dArray[3];
        dArray2[0] = (d5 - d7 + d8 - d6) / (-d2 * d3 + d * d3 + d2 * d4 - d * d4);
        dArray2[1] = (-d4 * d5 + d4 * d7 - d8 * d3 + d6 * d3) / (-d2 * d3 + d * d3 + d2 * d4 - d * d4);
        dArray2[2] = (d * d7 - d * d8 - d2 * d5 + d2 * d6) / (-d2 * d3 + d * d3 + d2 * d4 - d * d4);
        dArray2[3] = (d8 * d * d3 - d4 * d * d7 - d6 * d2 * d3 + d4 * d2 * d5) / (-d2 * d3 + d * d3 + d2 * d4 - d * d4);
        return dArray2;
    }

    private void changeCPTIndex(DiscreteNode discreteNode, double d, int n) {
        if (discreteNode != null) {
            try {
                Node node = this.psw.projectFrame.getNetworkPanel().getNode(discreteNode.getName());
                this.psw.syncDomainToClass(node);
                Table table = discreteNode.getTable();
                int n2 = discreteNode.getNumberOfStates();
                int[] nArray = this.getColumnIndexes(n2, n);
                double d2 = 0.0;
                for (int i = 0; i < n2; ++i) {
                    d2 += table.getDataItem(nArray[i]);
                }
                double d3 = table.getDataItem(n);
                double d4 = d2 - d3;
                double d5 = d;
                double d6 = 1.0 - d5;
                for (int i = 0; i < n2; ++i) {
                    int n3 = nArray[i];
                    if (n3 == n) {
                        discreteNode.getTable().setDataItem(n, d5);
                        continue;
                    }
                    double d7 = table.getDataItem(n3);
                    if (d4 == 0.0) {
                        discreteNode.getTable().setDataItem(n3, d6 / (double)(nArray.length - 1));
                        continue;
                    }
                    if (d7 == 0.0) {
                        discreteNode.getTable().setDataItem(n3, 0.0);
                        continue;
                    }
                    discreteNode.getTable().setDataItem(n3, d6 * d7 / d4);
                }
                this.psw.syncDomainToClass(node);
            }
            catch (Exception exception) {
                new HuginGUIError(exception.getMessage());
            }
        }
    }

    private int[] getColumnIndexes(int n, int n2) {
        int[] nArray = new int[n];
        int n3 = (int)Math.floor(n2 / n);
        for (int i = 0; i < n; ++i) {
            nArray[i] = n * n3 + i;
        }
        return nArray;
    }

    public Vector<LineData3D> addLineTo3DGraph(Vector<LineData3D> vector, TableCell tableCell, TableCell tableCell2, int n) throws ExceptionHugin {
        DiscreteChanceNode discreteChanceNode = this.getSelectedVariableNode();
        if (discreteChanceNode != null) {
            int n2 = this.getSelectedState();
            double[] dArray = discreteChanceNode.getSensitivityConstants(tableCell.getIndex(), tableCell2.getIndex(), n2);
            double d = this.psw.computeSensitivityFunction(dArray, tableCell.getValue(), tableCell2.getValue());
            double[][] dArray2 = this.create3DPlotData(dArray, tableCell.hasSameParentConfiguration(tableCell2));
            vector.add(new LineData3D(dArray, (String)this.hypoStateCombo.getItemAt(n2), d, tableCell.getValue(), tableCell2.getValue(), dArray2, n));
        }
        return vector;
    }

    private double[][] create3DPlotData(double[] dArray, boolean bl) {
        double d;
        double d2 = d = 1.0 / (double)this.pointsToPlot;
        double d3 = d;
        double[][] dArray2 = new double[this.pointsToPlot - 1][this.pointsToPlot - 1];
        for (int i = 0; i < this.pointsToPlot - 1; ++i) {
            for (int j = 0; j < this.pointsToPlot - 1; ++j) {
                double d4;
                dArray2[i][j] = bl ? (d2 + d3 > 0.99999999999 ? -1.0 : (d4 = this.psw.computeSensitivityFunction(dArray, d2, d3))) : (d4 = this.psw.computeSensitivityFunction(dArray, d2, d3));
                d3 += d;
            }
            d2 += d;
            d3 = d;
        }
        return dArray2;
    }

    protected double[][] create3DPlotData(double[] dArray, double[] dArray2) {
        double d;
        double d2 = d = 1.0 / (double)this.pointsToPlot;
        double d3 = d;
        double[][] dArray3 = new double[this.pointsToPlot - 1][this.pointsToPlot - 1];
        for (int i = 0; i < this.pointsToPlot - 1; ++i) {
            for (int j = 0; j < this.pointsToPlot - 1; ++j) {
                double d4;
                dArray3[i][j] = d4 = this.psw.computeSensitivityFunction(dArray, dArray2, d2, d3);
                d3 += d;
            }
            d2 += d;
            d3 = d;
        }
        return dArray3;
    }

    protected LineData3D createLineData(double[] dArray, double[] dArray2, String string, double d, double d2, double d3, double[][] dArray3, int n) {
        return new LineData3D(dArray, dArray2, string, d, d2, d3, dArray3, n);
    }

    private String printDouble(double d) {
        return HuginGUIUtils.printDouble(d, this.psw.projectFrame.guiFrame.preferences.precision);
    }

    public void computeSensitivityDataIfNecessary(DiscreteChanceNode discreteChanceNode) {
        if (!this.psw.isSensitivityComputedFor(discreteChanceNode)) {
            this.psw.computeSensitivityData(discreteChanceNode);
        }
        this.computeValues();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TwoWayGraphInfoModel
    extends DefaultTableModel {
        Vector<LineData3D> lines;
        int numRows;
        Vector<String> columnNames = new Vector();

        public TwoWayGraphInfoModel(Vector<LineData3D> vector) throws ExceptionHugin {
            this.lines = vector;
            this.numRows = vector.size();
            if (vector != null && vector.size() > 0) {
                LineData3D lineData3D = vector.get(0);
                this.columnNames = lineData3D.getDataTitles();
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            LineData3D lineData3D;
            if (n >= 0 && n < this.lines.size() && (lineData3D = this.lines.elementAt(n)) != null) {
                return lineData3D.getDataValues().get(n2);
            }
            return "error";
        }

        public double[][] getPlotDataForRow(int n) {
            if (n >= 0 && n < this.lines.size()) {
                LineData3D lineData3D = this.lines.elementAt(n);
                return lineData3D.getPlotData();
            }
            return new double[0][0];
        }

        public LineData3D getLineData(int n) {
            if (n >= 0 && n <= this.lines.size()) {
                return this.lines.elementAt(n);
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            if (this.columnNames.size() > 0) {
                return this.columnNames.elementAt(n);
            }
            return " ";
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public int getRowCount() {
            return this.numRows;
        }
    }

    class Wrapper {
        private Object item;

        public Wrapper() {
            this.item = null;
        }

        public Wrapper(Object object) {
            this.item = object;
        }

        public Object getItem() {
            return this.item;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LineData3D {
        double[] constants;
        double[] constants1 = new double[0];
        String state;
        double result;
        double sv;
        double cptValue1;
        double cptValue2;
        int caseNum;
        double[][] plotData;
        double importance1 = -1.0;
        double importance2 = -1.0;
        Vector<Object> columnValues = null;

        public LineData3D(double[] dArray, String string, double d, double d2, double d3, double[][] dArray2) {
            this.constants = dArray;
            if (dArray.length == 4) {
                this.constants = new double[6];
                for (int i = 0; i < 4; ++i) {
                    this.constants[i] = dArray[i];
                }
            }
            this.state = string;
            this.result = d;
            this.cptValue1 = d2;
            this.cptValue2 = d3;
            this.plotData = dArray2;
            this.caseNum = -1;
        }

        public LineData3D(double[] dArray, String string, double d, double d2, double d3, double[][] dArray2, int n) {
            this.constants = dArray;
            if (dArray.length == 4) {
                this.constants = new double[6];
                for (int i = 0; i < 4; ++i) {
                    this.constants[i] = dArray[i];
                }
            }
            this.state = string;
            this.result = d;
            this.cptValue1 = d2;
            this.cptValue2 = d3;
            this.plotData = dArray2;
            this.caseNum = n;
        }

        public LineData3D(double[] dArray, double[] dArray2, String string, double d, double d2, double d3, double[][] dArray3) {
            this.constants = dArray;
            this.constants1 = dArray2;
            this.state = string;
            this.result = d;
            this.cptValue1 = d2;
            this.cptValue2 = d3;
            this.plotData = dArray3;
            this.caseNum = -1;
        }

        public LineData3D(double[] dArray, double[] dArray2, String string, double d, double d2, double d3, double[][] dArray3, int n) {
            this.constants = dArray;
            this.constants1 = dArray2;
            this.state = string;
            this.result = d;
            this.cptValue1 = d2;
            this.cptValue2 = d3;
            this.plotData = dArray3;
            this.caseNum = n;
        }

        public boolean hasTwoTables() {
            return this.constants1.length > 0;
        }

        public double[] getConstants() {
            return this.constants;
        }

        public double[] getConstants1() {
            return this.constants1;
        }

        public String getState() {
            return this.state;
        }

        public double getCptValue1() {
            return this.cptValue1;
        }

        public double getCptValue2() {
            return this.cptValue2;
        }

        public double getResult() {
            return this.result;
        }

        public int getCase() {
            return this.caseNum;
        }

        public double[][] getPlotData() {
            return this.plotData;
        }

        public double getAlfa() {
            return this.constants[0];
        }

        public double getAlfa1() {
            if (this.hasTwoTables()) {
                return this.constants1[0];
            }
            return this.constants[1];
        }

        public double getBeta() {
            if (this.hasTwoTables()) {
                return this.constants[1];
            }
            return this.constants[2];
        }

        public double getBeta1() {
            if (this.hasTwoTables()) {
                return this.constants1[1];
            }
            return new Double(Double.NaN);
        }

        public double getGama() {
            if (this.hasTwoTables()) {
                return this.constants[2];
            }
            return this.constants[3];
        }

        public double getGama1() {
            if (this.hasTwoTables()) {
                return this.constants1[2];
            }
            return this.constants[4];
        }

        public double getDelta() {
            if (this.hasTwoTables()) {
                return this.constants[3];
            }
            return this.constants[5];
        }

        public double getDelta1() {
            if (this.hasTwoTables()) {
                return this.constants1[3];
            }
            return new Double(Double.NaN);
        }

        public double getSensitivityValue1() {
            return PsPanel.this.psw.computeInput1SensitivityValue(this.constants, this.getCptValue1(), this.getCptValue2());
        }

        public double getSensitivityValue2() {
            return PsPanel.this.psw.computeInput2SensitivityValue(this.constants, this.getCptValue1(), this.getCptValue2());
        }

        public void setImportance1(double d) {
            this.importance1 = d;
        }

        public void setImportance2(double d) {
            this.importance2 = d;
        }

        public double getImportance1() {
            return this.importance1;
        }

        public double getImportance2() {
            return this.importance2;
        }

        public Vector<String> getDataTitles() {
            Vector<String> vector = new Vector<String>();
            if (this.getCase() != -1) {
                vector.add(HuginGUIConstants.get("SA_Case"));
            }
            vector.add(HuginGUIConstants.get("SA_State"));
            vector.add(HuginGUIConstants.get("SA_CPT") + 1);
            vector.add(HuginGUIConstants.get("SA_CPT") + 2);
            vector.add(HuginGUIConstants.get("SA_Result"));
            vector.add(HuginGUIConstants.get("SA_Alfa"));
            vector.add(HuginGUIConstants.get("SA_Alfa") + 1);
            vector.add(HuginGUIConstants.get("SA_Beta"));
            if (this.hasTwoTables()) {
                vector.add(HuginGUIConstants.get("SA_Beta") + 1);
            }
            vector.add(HuginGUIConstants.get("SA_Gamma"));
            vector.add(HuginGUIConstants.get("SA_Gamma") + 1);
            vector.add(HuginGUIConstants.get("SA_Delta"));
            if (this.hasTwoTables()) {
                vector.add(HuginGUIConstants.get("SA_Delta") + 1);
            } else {
                vector.add(HuginGUIConstants.get("SA_Sensitivity_Value") + 1);
                vector.add(HuginGUIConstants.get("SA_Sensitivity_Value") + 2);
                if (this.getCase() != -1) {
                    vector.add(HuginGUIConstants.get("SA_Parameter_Importance") + 1);
                    vector.add(HuginGUIConstants.get("SA_Parameter_Importance") + 2);
                }
            }
            return vector;
        }

        public Vector<Object> getDataValues() {
            if (this.columnValues == null) {
                this.columnValues = new Vector();
                if (this.getCase() != -1) {
                    this.columnValues.add(new Integer(this.getCase()));
                }
                this.columnValues.add(this.getState());
                this.columnValues.add(new Double(this.getCptValue1()));
                this.columnValues.add(new Double(this.getCptValue2()));
                this.columnValues.add(new Double(this.getResult()));
                this.columnValues.add(new Double(this.getAlfa()));
                this.columnValues.add(new Double(this.getAlfa1()));
                this.columnValues.add(new Double(this.getBeta()));
                if (this.hasTwoTables()) {
                    this.columnValues.add(new Double(this.getBeta1()));
                }
                this.columnValues.add(new Double(this.getGama()));
                this.columnValues.add(new Double(this.getGama1()));
                this.columnValues.add(new Double(this.getDelta()));
                if (this.hasTwoTables()) {
                    this.columnValues.add(new Double(this.getDelta1()));
                } else {
                    this.columnValues.add(new Double(this.getSensitivityValue1()));
                    this.columnValues.add(new Double(this.getSensitivityValue2()));
                    if (this.getCase() != -1) {
                        this.columnValues.add(new Double(this.getImportance1()));
                        this.columnValues.add(new Double(this.getImportance2()));
                    }
                }
            }
            return this.columnValues;
        }
    }

    public class TwoWayComputeListener
    implements ActionListener {
        private SelectedCells cells;

        public TwoWayComputeListener(SelectedCells selectedCells) {
            this.cells = selectedCells;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            if (!this.cells.twoIndexesSelected()) {
                return;
            }
            DiscreteChanceNode discreteChanceNode = PsPanel.this.getSelectedVariableNode();
            DiscreteChanceNode discreteChanceNode2 = PsPanel.this.getSelectedHypothesisNode();
            if (discreteChanceNode == null || discreteChanceNode2 == null) {
                PsPanel.this.psw.setEnabled(true);
                PsPanel.this.psw.toFront();
                return;
            }
            if (!(PsPanel.this.psw.isSensitivityComputedFor(discreteChanceNode2) || PsPanel.this.selectedCases || (bl = PsPanel.this.psw.computeSensitivityData(discreteChanceNode2)))) {
                PsPanel.this.psw.setEnabled(true);
                PsPanel.this.psw.toFront();
                return;
            }
            if (PsPanel.this.selectedCases) {
                PsPanel.this.computeTwoWayMultipleCases(this.cells, discreteChanceNode2);
                return;
            }
            try {
                int[] nArray;
                int n;
                TableCell tableCell = this.cells.getSelected1();
                TableCell tableCell2 = this.cells.getSelected2();
                Vector<LineData3D> vector = new Vector<LineData3D>();
                if (PsPanel.this.allStatesBox.isSelected()) {
                    n = discreteChanceNode2.getNumberOfStates();
                    nArray = new int[n];
                    for (int i = 0; i < n; ++i) {
                        nArray[i] = i;
                    }
                } else {
                    nArray = new int[]{PsPanel.this.getSelectedState()};
                }
                for (n = 0; n < nArray.length; ++n) {
                    double[][] dArray;
                    double d;
                    double[] dArray2;
                    if (this.cells.hasTwoTables()) {
                        dArray2 = PsPanel.this.getSensitivityConstants(tableCell, tableCell2, nArray[n]);
                        double[] dArray3 = PsPanel.this.getSensitivityConstants(tableCell, tableCell2);
                        PsPanel.this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                        PsPanel.this.psw.sensitivityComputed(false, discreteChanceNode2);
                        d = PsPanel.this.psw.computeSensitivityFunction(dArray2, dArray3, tableCell.getValue(), tableCell2.getValue());
                        dArray = PsPanel.this.create3DPlotData(dArray2, dArray3);
                        vector.add(new LineData3D(dArray2, dArray3, (String)PsPanel.this.hypoStateCombo.getItemAt(n), d, tableCell.getValue(), tableCell2.getValue(), dArray));
                        continue;
                    }
                    dArray2 = discreteChanceNode.getSensitivityConstants(tableCell.getIndex(), tableCell2.getIndex(), nArray[n]);
                    d = PsPanel.this.psw.computeSensitivityFunction(dArray2, tableCell.getValue(), tableCell2.getValue());
                    dArray = PsPanel.this.create3DPlotData(dArray2, tableCell.hasSameParentConfiguration(tableCell2));
                    vector.add(new LineData3D(dArray2, (String)PsPanel.this.hypoStateCombo.getItemAt(n), d, tableCell.getValue(), tableCell2.getValue(), dArray));
                }
                if (vector.size() > 0) {
                    TwoWayGraphInfoModel twoWayGraphInfoModel = new TwoWayGraphInfoModel(vector);
                    PsPanel.this.createTwoWayTableView(twoWayGraphInfoModel);
                }
            }
            catch (ExceptionHugin exceptionHugin) {
                PsPanel.this.clearGraph(false);
                new HuginGUIError(exceptionHugin.getMessage());
            }
            catch (Exception exception) {
                PsPanel.this.clearGraph(false);
            }
        }
    }

    public class PrintDoublesRenderer
    extends JLabel
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (object instanceof Double) {
                Double d = (Double)object;
                this.setText(PsPanel.this.printDouble(d));
            } else {
                this.setText(object.toString());
            }
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            return this;
        }
    }

    public class TwoCellsListener
    implements ListSelectionListener {
        public static final int FIRST = 1;
        public static final int SECOND = 2;
        GenericTable jt;
        DiscreteChanceNode varnode;
        DiscreteChanceNode varnode1;
        SelectedCells selected;
        int variable = -1;

        TwoCellsListener(SelectedCells selectedCells, GenericTable genericTable) {
            this.jt = genericTable;
            this.varnode = PsPanel.this.getSelectedVariableNode();
            this.varnode1 = PsPanel.this.getSelectedVariableNode1();
            this.selected = selectedCells;
        }

        TwoCellsListener(SelectedCells selectedCells, GenericTable genericTable, int n) {
            this.jt = genericTable;
            this.varnode = PsPanel.this.getSelectedVariableNode();
            this.varnode1 = PsPanel.this.getSelectedVariableNode1();
            this.selected = selectedCells;
            this.variable = n;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            block7: {
                this.jt.validate();
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!((ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty() && !((ListSelectionModel)listSelectionEvent.getSource()).getValueIsAdjusting()) {
                    try {
                        int n = this.jt.getSelectedRow();
                        int n2 = this.jt.getSelectedColumn();
                        int n3 = this.jt.getRowCount();
                        int n4 = ((NodeTableColumnModel)this.jt.getColumnModel()).getVisibleColumns();
                        int n5 = ((NodeTableColumnModel)this.jt.getColumnModel()).getLastVisibleColumnIndex();
                        int n6 = n5 - (n4 - n2);
                        int n7 = n + n6 * n3;
                        Double d = null;
                        if (n <= -1 || n2 <= -1) break block7;
                        try {
                            Table table = this.variable == 2 ? this.varnode1.getTable() : this.varnode.getTable();
                            d = table.getDataItem(n7);
                        }
                        catch (NullPointerException nullPointerException) {
                        }
                        catch (ExceptionHugin exceptionHugin) {
                            new HuginGUIError(exceptionHugin.getMessage());
                        }
                        if (d != null) {
                            this.selected.add(new TableCell(n7, d, n, n2, this.jt));
                            PsPanel.this.clearGraph(false);
                            this.jt.validate();
                            this.jt.repaint();
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class SelectionRenderer
    extends JLabel
    implements TableCellRenderer {
        SelectedCells cells;

        public SelectionRenderer() {
            this.cells = null;
        }

        public SelectionRenderer(SelectedCells selectedCells) {
            this.cells = selectedCells;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3 = jTable.getRowCount();
            int n4 = ((NodeTableColumnModel)jTable.getColumnModel()).getVisibleColumns();
            int n5 = ((NodeTableColumnModel)jTable.getColumnModel()).getLastVisibleColumnIndex();
            int n6 = n5 - (n4 - n2);
            int n7 = n + n6 * n3;
            String string = object.toString();
            this.setText(string);
            this.setOpaque(true);
            if (this.cells != null) {
                boolean bl3 = this.cells.hasTwoTables() ? this.cells.isSelected(n7, (GenericTable)jTable) : this.cells.isSelected(n7);
                if (bl3) {
                    this.setBackground(jTable.getSelectionBackground());
                } else {
                    this.setBackground(Color.white);
                }
            } else if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(Color.white);
            }
            return this;
        }
    }

    public class SelectedCells {
        LinkedList<TableCell> list = new LinkedList();
        boolean twoTables;
        GenericTable firstTable;
        GenericTable secondTable;

        public SelectedCells() {
            this.twoTables = false;
            this.firstTable = null;
            this.secondTable = null;
        }

        public SelectedCells(JTable jTable, JTable jTable2) {
            this.list.add(null);
            this.list.add(null);
            this.twoTables = true;
            this.firstTable = (GenericTable)jTable;
            this.secondTable = (GenericTable)jTable2;
        }

        public void add(TableCell tableCell) {
            if (this.twoTables) {
                if (tableCell.getTable().equals(this.firstTable)) {
                    this.list.remove(0);
                    this.list.add(0, tableCell);
                }
                if (tableCell.getTable().equals(this.secondTable)) {
                    this.list.remove(1);
                    this.list.add(1, tableCell);
                }
            } else {
                if (!this.isSelected(tableCell.getIndex())) {
                    this.list.add(tableCell);
                }
                if (this.list.size() > 2) {
                    this.list.removeFirst();
                }
            }
        }

        public boolean isSelected(int n) {
            if (!this.twoTables) {
                return this.isSelected(n, null);
            }
            return false;
        }

        public boolean isSelected(int n, GenericTable genericTable) {
            if (this.twoTables) {
                TableCell tableCell = this.list.get(0);
                TableCell tableCell2 = this.list.get(1);
                if (tableCell != null && genericTable.equals(tableCell.getTable()) && tableCell.getIndex() == n) {
                    return true;
                }
                if (tableCell2 != null && genericTable.equals(tableCell2.getTable()) && tableCell2.getIndex() == n) {
                    return true;
                }
            } else {
                for (int i = 0; i < this.list.size(); ++i) {
                    TableCell tableCell = this.list.get(i);
                    if (tableCell.getIndex() != n) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isSelected(int n, int n2) {
            if (!this.twoTables) {
                return this.isSelected(n, n2, null);
            }
            return false;
        }

        public boolean isSelected(int n, int n2, GenericTable genericTable) {
            if (this.twoTables) {
                TableCell tableCell = this.list.get(0);
                TableCell tableCell2 = this.list.get(1);
                if (tableCell != null && genericTable.equals(tableCell.getTable()) && tableCell.getRow() == n && tableCell.getColumn() == n2) {
                    return true;
                }
                if (tableCell2 != null && genericTable.equals(tableCell2.getTable()) && tableCell2.getRow() == n && tableCell2.getColumn() == n2) {
                    return true;
                }
            } else {
                for (int i = 0; i < this.list.size(); ++i) {
                    TableCell tableCell = this.list.get(i);
                    if (tableCell.getRow() != n || tableCell.getColumn() != n2) continue;
                    return true;
                }
            }
            return false;
        }

        public int size() {
            return this.list.size();
        }

        public boolean twoIndexesSelected() {
            if (this.twoTables) {
                return this.list.get(0) != null && this.list.get(1) != null;
            }
            return this.list.size() == 2;
        }

        public TableCell getSelected1() {
            return this.getSelected(0);
        }

        public TableCell getSelected2() {
            return this.getSelected(1);
        }

        private TableCell getSelected(int n) {
            try {
                if (this.list.size() > n) {
                    return this.list.get(n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public int getIndex1() {
            return this.getIndex(0);
        }

        public int getIndex2() {
            return this.getIndex(1);
        }

        private int getIndex(int n) {
            try {
                if (this.list.size() > n) {
                    return this.list.get(n).getIndex();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1;
        }

        public boolean hasTwoTables() {
            return this.twoTables;
        }
    }

    public class TableCell {
        int index;
        int row;
        int column;
        double value;
        GenericTable table;

        public TableCell(int n, double d, int n2, int n3, GenericTable genericTable) {
            this.index = n;
            this.value = d;
            this.column = n3;
            this.row = n2;
            this.table = genericTable;
        }

        public int getIndex() {
            return this.index;
        }

        public double getValue() {
            return this.value;
        }

        public int getColumn() {
            return this.column;
        }

        public int getRow() {
            return this.row;
        }

        public GenericTable getTable() {
            return this.table;
        }

        public boolean hasSameParentConfiguration(TableCell tableCell) {
            GenericTable genericTable = tableCell.getTable();
            if (this.table != null && genericTable != null && (this.table.equals(genericTable) || this.table == genericTable)) {
                int n = this.table.getModel().getRowCount();
                int[] nArray = PsPanel.this.getColumnIndexes(n, this.index);
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != tableCell.getIndex()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public class UnselectListener
    implements MouseListener {
        JTable table;

        public UnselectListener(JTable jTable) {
            this.table = jTable;
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                this.table.clearSelection();
            }
        }
    }

    public class Line3DSelectionListener
    implements ListSelectionListener {
        JTable jt;

        Line3DSelectionListener(JTable jTable) {
            this.jt = jTable;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!((ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty() && !((ListSelectionModel)listSelectionEvent.getSource()).getValueIsAdjusting()) {
                int n = this.jt.getSelectedRow();
                TwoWayGraphInfoModel twoWayGraphInfoModel = (TwoWayGraphInfoModel)((TableSorter)this.jt.getModel()).getTableModel();
                TableSorter tableSorter = (TableSorter)this.jt.getModel();
                int n2 = tableSorter.modelIndex(n);
                double[][] dArray = twoWayGraphInfoModel.getPlotDataForRow(n2);
                LineData3D lineData3D = twoWayGraphInfoModel.getLineData(n2);
                try {
                    double d = 0.0;
                    double d2 = 1.0;
                    double d3 = 0.0;
                    double d4 = 1.0;
                    double d5 = 0.0;
                    double d6 = 1.0;
                    ArrayList<Plot.Label> arrayList = Plot.constructNumberedLabels(0, d, d2, 5);
                    ArrayList<Plot.Label> arrayList2 = Plot.constructNumberedLabels(1, d3, d4, 5);
                    ArrayList<Plot.Label> arrayList3 = Plot.constructNumberedLabels(2, d5, d6, 5);
                    String string = HuginGUIConstants.get("SA_CPT") + 1;
                    String string2 = HuginGUIConstants.get("SA_Result");
                    String string3 = HuginGUIConstants.get("SA_CPT") + 2;
                    ArrayList<Plot.Triangle> arrayList4 = Plot.constructSurface(dArray, d3, d4);
                    Plot plot = new Plot(arrayList4, string, string2, string3, arrayList, arrayList2, arrayList3, d, d2, d3, d4, d5, d6);
                    plot.showPoint(lineData3D.getCptValue1(), lineData3D.getResult(), lineData3D.getCptValue2(), "Point (" + PsPanel.this.printDouble(lineData3D.getCptValue1()) + ", " + PsPanel.this.printDouble(lineData3D.getResult()) + ", " + PsPanel.this.printDouble(lineData3D.getCptValue2()) + ")");
                    PsPanel.this.graphPanel.removeAll();
                    PsPanel.this.graphPanel.add((Component)plot, "Center");
                    PsPanel.this.graphPanel.validate();
                    PsPanel.this.graphPanel.repaint();
                    PsPanel.this.rightPanel.repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public class LineSelectionListener
    implements ListSelectionListener {
        JTable jt;

        LineSelectionListener(JTable jTable) {
            this.jt = jTable;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (((ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty() || ((ListSelectionModel)listSelectionEvent.getSource()).getValueIsAdjusting()) {
                if (((ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty() && PsPanel.this.mlg.hasSelectedLine()) {
                    PsPanel.this.mlg.unselectLine();
                }
            } else {
                int n = this.jt.getSelectedRow();
                TableSorter tableSorter = (TableSorter)this.jt.getModel();
                int n2 = tableSorter.modelIndex(n);
                if (PsPanel.this.mlg != null) {
                    Line line = PsPanel.this.mlg.getLine(n2);
                    PsPanel.this.addBoundsToLine(line, PsPanel.this.pointY, PsPanel.this.mlg.getLine(n2).getPointX());
                    PsPanel.this.mlg.selectLine(n2);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HypothesisComboRenderer
    extends DefaultListCellRenderer {
        Vector<DiscreteChanceNode> nodeList;

        public HypothesisComboRenderer(Vector<DiscreteChanceNode> vector) {
            this.setOpaque(true);
            this.nodeList = vector;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            boolean bl3 = false;
            try {
                if (n <= this.nodeList.size() - 1) {
                    object2 = this.nodeList.get(n);
                    bl3 = ((COM.hugin.HAPI.Node)object2).evidenceIsEntered();
                }
            }
            catch (ExceptionHugin exceptionHugin) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl3) {
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
            object2 = object.toString();
            this.setText("<HTML><B><FONT COLOR=RED>(e) </FONT></B><FONT COLOR=BLACK>" + (String)object2 + "</FONT></HTML>");
            this.setBackground(bl ? Color.red : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }

    private class ParameterListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            COM.hugin.HAPI.Node node = (COM.hugin.HAPI.Node)changeEvent.getSource();
            try {
                Vector<DiscreteChanceNode> vector = PsPanel.this.psw.getDCNodeList();
                String string = node.getName();
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    COM.hugin.HAPI.Node node2 = vector.get(i);
                    if (!string.equals(node2.getName())) continue;
                    PsPanel.this.paraVariableCombo.setSelectedIndex(i);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ColorRenderer
    extends JTextField
    implements TableCellRenderer {
        Vector<Line> lines;
        TableSorter sorter;

        public ColorRenderer(Vector<Line> vector, TableSorter tableSorter) {
            super("  ");
            this.lines = vector;
            this.sorter = tableSorter;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.lines.size() > n && n >= 0) {
                int n3 = this.sorter.modelIndex(n);
                Line line = this.lines.elementAt(n3);
                this.setBackground(line.color);
                this.setPreferredSize(new Dimension(this.getHeight(), this.getHeight()));
            }
            return this;
        }
    }

    private class GraphInfoModel
    extends DefaultTableModel {
        Vector<Line> lines;
        int numRows;
        MultipleLineGraph graph;
        Vector<String> columnNames;

        public GraphInfoModel(MultipleLineGraph multipleLineGraph) throws ExceptionHugin {
            this.graph = multipleLineGraph;
            this.lines = new Vector();
            for (Line line : multipleLineGraph.getLines()) {
                if (!line.isSensitivityFunction()) continue;
                this.lines.add(line);
            }
            this.numRows = this.lines.size();
            this.populateColumnNames();
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return " ";
            }
            --n2;
            if (n >= 0 && n < this.lines.size()) {
                Line line = this.lines.elementAt(n);
                Object object = null;
                String string = "bound";
                int n3 = -1;
                if (PsPanel.this.selectedCases) {
                    switch (n2) {
                        case 0: {
                            object = line.title;
                            if (object != null) {
                                return new Integer(line.title);
                            }
                        }
                        case 1: {
                            object = line.getState();
                            if (object != null) {
                                return object;
                            }
                            return new String("");
                        }
                        case 2: {
                            object = line.getPointY();
                            if (object != null) {
                                return new Double(line.getPointY());
                            }
                        }
                        case 3: {
                            object = line.getPointX();
                            if (object != null) {
                                return new Double(line.getPointX());
                            }
                        }
                        case 4: {
                            object = line.getAlfa();
                            if (object != null && line.title != string) {
                                return new Double(line.getAlfa());
                            }
                        }
                        case 5: {
                            object = line.getBeta();
                            if (object != null && line.title != string) {
                                return new Double(line.getBeta());
                            }
                        }
                        case 6: {
                            object = line.getGama();
                            if (object != null && line.title != string) {
                                return new Double(line.getGama());
                            }
                        }
                        case 7: {
                            object = line.getDelta();
                            if (object != null && line.title != string) {
                                return new Double(line.getDelta());
                            }
                        }
                        case 8: {
                            object = line.getSensitivityValue();
                            if (object != null && line.title != string) {
                                return new Double(line.getSensitivityValue());
                            }
                        }
                        case 9: {
                            return new Double(line.getParameterImportance());
                        }
                    }
                } else {
                    switch (n2) {
                        case 0: {
                            object = line.getState();
                            if (object != null) {
                                return object;
                            }
                            return new String("");
                        }
                        case 1: {
                            object = line.getPointY();
                            if (object != null) {
                                return new Double(line.getPointY());
                            }
                        }
                        case 2: {
                            object = line.getPointX();
                            if (object != null) {
                                return new Double(line.getPointX());
                            }
                        }
                        case 3: {
                            object = line.getAlfa();
                            if (object != null && line.title != string) {
                                return new Double(line.getAlfa());
                            }
                        }
                        case 4: {
                            object = line.getBeta();
                            if (object != null && line.title != string) {
                                return new Double(line.getBeta());
                            }
                        }
                        case 5: {
                            object = line.getGama();
                            if (object != null && line.title != string) {
                                return new Double(line.getGama());
                            }
                        }
                        case 6: {
                            object = line.getDelta();
                            if (object != null && line.title != string) {
                                return new Double(line.getDelta());
                            }
                        }
                        case 7: {
                            object = line.getSensitivityValue();
                            if (object == null || line.title == string) break;
                            return new Double(line.getSensitivityValue());
                        }
                    }
                }
            }
            return "error";
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "  ";
            }
            --n;
            if (this.columnNames.size() > 0) {
                return this.columnNames.elementAt(n);
            }
            return " ";
        }

        public int getColumnCount() {
            return this.columnNames.size() + 1;
        }

        public int getRowCount() {
            return this.numRows;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        private void populateColumnNames() {
            this.columnNames = new Vector();
            if (this.lines.size() > 0) {
                Line line = this.lines.elementAt(0);
                if (PsPanel.this.selectedCases) {
                    this.columnNames.add(HuginGUIConstants.get("SA_Case"));
                }
                this.columnNames.add(HuginGUIConstants.get("SA_State"));
                this.columnNames.add(HuginGUIConstants.get("SA_CPT"));
                this.columnNames.add(HuginGUIConstants.get("SA_Result"));
                this.columnNames.add(HuginGUIConstants.get("SA_Alfa"));
                this.columnNames.add(HuginGUIConstants.get("SA_Beta"));
                this.columnNames.add(HuginGUIConstants.get("SA_Gamma"));
                this.columnNames.add(HuginGUIConstants.get("SA_Delta"));
                this.columnNames.add(HuginGUIConstants.get("SA_Sensitivity_Value"));
                if (PsPanel.this.selectedCases) {
                    this.columnNames.add(HuginGUIConstants.get("SA_Parameter_Importance"));
                }
            }
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        GenericTable jt;
        DiscreteChanceNode varnode;

        SelectionListener(GenericTable genericTable) {
            this.jt = genericTable;
            this.varnode = PsPanel.this.getSelectedVariableNode();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            block9: {
                this.jt.validate();
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!((ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty() && !((ListSelectionModel)listSelectionEvent.getSource()).getValueIsAdjusting()) {
                    try {
                        Object object;
                        int n = this.jt.getSelectedRow();
                        int n2 = this.jt.getSelectedColumn();
                        int n3 = this.jt.getRowCount();
                        int n4 = ((NodeTableColumnModel)this.jt.getColumnModel()).getVisibleColumns();
                        int n5 = ((NodeTableColumnModel)this.jt.getColumnModel()).getLastVisibleColumnIndex();
                        int n6 = n5 - (n4 - n2);
                        int n7 = n + n6 * n3;
                        Double d = null;
                        if (n <= -1 || n2 <= -1) break block9;
                        try {
                            object = this.varnode.getTable();
                            d = ((Table)object).getDataItem(n7);
                        }
                        catch (NullPointerException nullPointerException) {
                        }
                        catch (ExceptionHugin exceptionHugin) {
                            new HuginGUIError(exceptionHugin.getMessage());
                        }
                        if (d != null) {
                            object = new Selection(this.jt, n7, d);
                            if (((Selection)object).equals(PsPanel.this.selected)) {
                                return;
                            }
                            PsPanel.this.selected = (Selection)object;
                            if (!PsPanel.this.psw.isSensitivityComputedFor(PsPanel.this.getSelectedHypothesisNode()) && !PsPanel.this.selectedCases) {
                                PsPanel.this.computeSensitivityDataIfNecessary(PsPanel.this.getSelectedHypothesisNode());
                            }
                            PsPanel.this.pointY = d;
                            final int n8 = n7;
                            Thread thread = new Thread(){

                                public void run() {
                                    PsPanel.this.psw.setEnabled(false);
                                    PsPanel.this.createGraph(n8);
                                    PsPanel.this.psw.enableClearButton(true);
                                    PsPanel.this.psp.repaint();
                                    PsPanel.this.psw.setEnabled(true);
                                }
                            };
                            thread.start();
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    class Selection {
        int index;
        double value;
        GenericTable table;

        public Selection(GenericTable genericTable, int n, double d) {
            this.table = genericTable;
            this.index = n;
            this.value = d;
        }

        public GenericTable getTable() {
            return this.table;
        }

        public int getIndex() {
            return this.index;
        }

        public double getValue() {
            return this.value;
        }

        public boolean equals(Selection selection) {
            if (selection == null) {
                return false;
            }
            return this.table.equals(selection.getTable()) && this.index == selection.getIndex() && this.value == selection.getValue();
        }

        public void clearSelection() {
            this.index = -1;
        }
    }

    private class CaseInsertedListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            PsPanel.this.clearAndKeepSelectedHypo();
        }
    }

    private class ParameterVariableListener
    implements ItemListener {
        Vector<DiscreteChanceNode> list;
        ParameterSensitivityWizard wiz;

        public ParameterVariableListener(ParameterSensitivityWizard parameterSensitivityWizard) {
            this.wiz = parameterSensitivityWizard;
            this.list = parameterSensitivityWizard.getDCNodeList();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                PsPanel.this.clearGraph();
                if (PsPanel.this.twoWayMode()) {
                    if (PsPanel.this.twoParametersBox.isSelected() && PsPanel.this.getSelectedVariableNode().equals(PsPanel.this.getSelectedVariableNode1())) {
                        PsPanel.this.twoParametersBox.setSelected(false);
                    }
                } else {
                    PsPanel.this.computeSensitivityDataIfNecessary(PsPanel.this.getSelectedHypothesisNode());
                }
                PsPanel.this.createTable();
            }
        }
    }

    private class StateComboListener
    implements ItemListener {
        Vector<DiscreteChanceNode> list;
        JComboBox nodeCombo;
        ParameterSensitivityWizard wiz;

        public StateComboListener(ParameterSensitivityWizard parameterSensitivityWizard, JComboBox jComboBox) {
            this.wiz = parameterSensitivityWizard;
            this.list = parameterSensitivityWizard.getDCNodeList();
            this.nodeCombo = jComboBox;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (!PsPanel.this.triggerStateComboEvent) {
                return;
            }
            try {
                Object object = itemEvent.getSource();
                JComboBox jComboBox = null;
                if (object instanceof JComboBox) {
                    jComboBox = (JComboBox)object;
                }
                if (jComboBox != null && itemEvent.getStateChange() == 1) {
                    PsPanel.this.clearGraph();
                    PsPanel.this.computeSensitivityDataIfNecessary(PsPanel.this.getSelectedHypothesisNode());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class HypothesisNodeComboListener
    implements ItemListener {
        Vector<DiscreteChanceNode> list;
        HuginComboBox stateCombo;
        ParameterSensitivityWizard wiz;

        public HypothesisNodeComboListener(ParameterSensitivityWizard parameterSensitivityWizard, HuginComboBox huginComboBox) {
            this.wiz = parameterSensitivityWizard;
            this.list = parameterSensitivityWizard.getDCNodeList();
            this.stateCombo = huginComboBox;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            HuginComboBox huginComboBox = null;
            if (object instanceof HuginComboBox) {
                huginComboBox = (HuginComboBox)object;
            }
            if (huginComboBox != null && itemEvent.getStateChange() == 2) {
                this.stateCombo.removeAllItems();
                return;
            }
            if (huginComboBox != null && itemEvent.getStateChange() == 1) {
                try {
                    DiscreteChanceNode discreteChanceNode = this.list.get(huginComboBox.getSelectedIndex());
                    boolean bl = false;
                    if (!PsPanel.this.selectedCases && !PsPanel.this.psw.isSensitivityComputedFor(discreteChanceNode)) {
                        bl = PsPanel.this.psw.computeSensitivityData(discreteChanceNode);
                    }
                    Vector<String> vector = this.wiz.getNodeStatesDescription(discreteChanceNode);
                    ItemListener[] itemListenerArray = huginComboBox.getItemListeners();
                    PsPanel.this.triggerStateComboEvent = bl;
                    this.stateCombo.removeAllItems();
                    for (String string : vector) {
                        this.stateCombo.addItem(string);
                    }
                    this.stateCombo.setSelectedIndex(0);
                    this.stateCombo.validatePopupWidth();
                    PsPanel.this.triggerStateComboEvent = true;
                    PsPanel.this.clearGraph(false);
                    if (!bl) {
                        this.wiz.clearMinMaxSensitivityValues();
                        PsPanel.this.computeColorMapValues();
                        PsPanel.this.updateColormapWithNewValues();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PsPanel.this.computeSensitivityDataIfNecessary(PsPanel.this.getSelectedHypothesisNode());
        }
    }
}

