/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Model;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class SamplesPerIntervalDialog
extends JDialog {
    private Model model;
    private JButton cancel;
    private JButton ok;
    private JSpinner samples;

    public SamplesPerIntervalDialog(Model model) throws ExceptionHugin {
        super(Hugin.mainFrame, "Samples / Interval", true);
        this.model = model;
        this.setContentPane(this.createContent());
    }

    private JPanel createContent() throws ExceptionHugin {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.add((Component)new JLabel("Specify the number of samples / interval for the model"), "North");
        this.samples = new JSpinner(new SpinnerNumberModel(this.model.getNumberOfSamplesPerInterval(), 1, Integer.MAX_VALUE, 1));
        jPanel2.add((Component)this.samples, "East");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new FlowLayout());
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SamplesPerIntervalDialog.this.dispose();
            }
        });
        this.ok = new JButton("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SamplesPerIntervalDialog.this.apply();
                SamplesPerIntervalDialog.this.dispose();
            }
        });
        jPanel3.add(this.cancel);
        jPanel3.add(this.ok);
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    private void apply() {
        try {
            this.model.setNumberOfSamplesPerInterval((Integer)this.samples.getValue());
            Hugin.mainFrame.getStatusBar().write("Set number of samples / interval to " + this.samples.getValue());
        }
        catch (Exception exception) {
            new HuginGUIError("Unable to set samples / interval : " + exception.getMessage());
        }
    }
}

