/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.DataPreprocessingPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginFileLoader;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIEventHandler;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginInsets;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.Link;
import COM.hugin.HGUI.LinkConstraint;
import COM.hugin.HGUI.WizardNetworkPanel;
import COM.hugin.HGUI.WizardPanel;
import COM.hugin.HGUI.ZoomFit;
import COM.hugin.HGUI.ZoomIn;
import COM.hugin.HGUI.ZoomOut;
import COM.hugin.HGUI.ZoomingPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class StructuralConstraintsPanel
extends WizardPanel {
    private JPanel mainPanel;
    private WizardNetworkPanel networkPanel;
    private JScrollPane networkScroller;
    private Domain domain = null;
    private JButton printNet;
    private JButton importSettings;
    private JButton saveConstraints;
    private JButton deleteButton;
    private JToggleButton selectButton;

    public StructuralConstraintsPanel(Domain domain, JButton[] jButtonArray) throws ExceptionHugin {
        super("Structure Constraints", jButtonArray);
        this.setImage(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("images/structural_constraints.jpg")));
        this.domain = domain;
        this.setInterior(this.createInterior());
        HuginGUIUtils.performNodeTyping(domain, this.networkPanel);
        this.addComponents();
    }

    protected Domain getDomain() {
        return this.domain;
    }

    protected WizardNetworkPanel getNetworkPanel() {
        return this.networkPanel;
    }

    protected void setNetworkPanel(WizardNetworkPanel wizardNetworkPanel) {
        if (wizardNetworkPanel == null) {
            return;
        }
        this.networkPanel = wizardNetworkPanel;
        wizardNetworkPanel.setStructuralConstraintsPanel(this);
        this.mainPanel.remove(this.networkScroller);
        this.createNetworkScroller();
        this.mainPanel.add((Component)this.networkScroller, "Center");
    }

    protected void setPrevious(WizardPanel wizardPanel) {
        this.previous = wizardPanel;
        this.writeStatus(HuginGUIConstants.get("str_loaded_a_total_of_") + ((DataPreprocessingPanel)wizardPanel).getTotallyLoadedCaseCount() + HuginGUIConstants.get("str__cases"));
    }

    protected JScrollPane getNetworkScroller() {
        return this.networkScroller;
    }

    protected void setSelectMode() {
        this.selectButton.setSelected(true);
    }

    private void createNetworkScroller() {
        this.networkScroller = new JScrollPane(this.networkPanel);
        this.networkScroller.getHorizontalScrollBar().setUnitIncrement(15);
        this.networkScroller.getVerticalScrollBar().setUnitIncrement(15);
        this.networkScroller.setPreferredSize(new Dimension(200, 200));
        this.networkScroller.getViewport().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                StructuralConstraintsPanel.this.networkPanel.repaint();
            }
        });
    }

    private Component createInterior() {
        this.mainPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.networkPanel = new WizardNetworkPanel(this, this.domain);
        this.createNetworkScroller();
        JTextArea jTextArea = new JTextArea("Please specify any known dependences or independences in the data set.");
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBackground(this.getBackground());
        this.printNet = new JButton(new HuginGUIEventHandler.MENU_FILE_Print_NetworkAction(this.networkPanel));
        this.printNet.setText("");
        this.printNet.setToolTipText(HuginGUIConstants.get("str_print_network"));
        this.printNet.setMargin(new HuginInsets());
        jToolBar.add(this.printNet);
        this.importSettings = new JButton(new HuginGUIEventHandler.MENU_NETWORK_Import_Model_InformationAction(this.networkPanel));
        this.importSettings.setText("");
        this.importSettings.setToolTipText(HuginGUIConstants.get("MENU_NETWORK_Import_Model_Information_Tip"));
        this.importSettings.setMargin(new HuginInsets());
        jToolBar.add(this.importSettings);
        this.saveConstraints = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/save.gif")));
        this.saveConstraints.setText("");
        this.saveConstraints.setToolTipText("Save network with constraints");
        this.saveConstraints.setMargin(new HuginInsets());
        this.saveConstraints.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    StructuralConstraintsPanel.this.saveConstraints();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        jToolBar.add(this.saveConstraints);
        jToolBar.addSeparator(new Dimension(10, 0));
        this.selectButton = new JToggleButton();
        this.selectButton.setAction(new SelectTool(this.networkPanel));
        this.selectButton.setText("");
        this.selectButton.setToolTipText(HuginGUIConstants.get("str_select_tool"));
        this.selectButton.setMargin(new HuginInsets());
        jToolBar.add(this.selectButton);
        buttonGroup.add(this.selectButton);
        this.selectButton.setSelected(true);
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setAction(new ArrowConstraintTool(this.networkPanel));
        jToggleButton.setText("");
        jToggleButton.setToolTipText(HuginGUIConstants.get("str_arrow_constraint_tool"));
        jToggleButton.setMargin(new HuginInsets());
        jToolBar.add(jToggleButton);
        buttonGroup.add(jToggleButton);
        jToggleButton = new JToggleButton();
        jToggleButton.setAction(new NoArrowConstraintTool(this.networkPanel));
        jToggleButton.setText("");
        jToggleButton.setToolTipText(HuginGUIConstants.get("str_no_arrow_constraint_tool"));
        jToggleButton.setMargin(new HuginInsets());
        jToolBar.add(jToggleButton);
        buttonGroup.add(jToggleButton);
        jToggleButton = new JToggleButton();
        jToggleButton.setAction(new LinkConstraintTool(this.networkPanel));
        jToggleButton.setText("");
        jToggleButton.setToolTipText(HuginGUIConstants.get("str_link_constraint_tool"));
        jToggleButton.setMargin(new HuginInsets());
        jToolBar.add(jToggleButton);
        buttonGroup.add(jToggleButton);
        jToggleButton = new JToggleButton();
        jToggleButton.setAction(new NoLinkConstraintTool(this.networkPanel));
        jToggleButton.setText("");
        jToggleButton.setToolTipText(HuginGUIConstants.get("str_no_link_constraint_tool"));
        jToggleButton.setMargin(new HuginInsets());
        jToolBar.add(jToggleButton);
        buttonGroup.add(jToggleButton);
        jToolBar.addSeparator(new Dimension(10, 0));
        JButton jButton = new JButton();
        jButton.setAction(new ZoomIn(this, this.networkPanel));
        jButton.setText("");
        jButton.setToolTipText(HuginGUIConstants.get("str_zoom_in_by_ten_percent"));
        jButton.setMargin(new HuginInsets());
        jToolBar.add(jButton);
        jButton = new JButton();
        jButton.setAction(new ZoomOut(this, this.networkPanel));
        jButton.setText("");
        jButton.setToolTipText(HuginGUIConstants.get("str_zoom_out_by_ten_percent"));
        jButton.setMargin(new HuginInsets());
        jToolBar.add(jButton);
        jButton = new JButton();
        jButton.setAction(new ZoomFit(this, this.networkPanel));
        jButton.setText("");
        jButton.setToolTipText(HuginGUIConstants.get("str_zoom_to_fit"));
        jButton.setMargin(new HuginInsets());
        jToolBar.add(jButton);
        jToolBar.addSeparator(new Dimension(10, 0));
        this.deleteButton = new JButton();
        this.deleteButton.setAction(new Delete(this.networkPanel));
        this.deleteButton.setText("");
        this.deleteButton.setToolTipText(HuginGUIConstants.get("str_delete_selected_constraint_link"));
        this.deleteButton.setMargin(new HuginInsets());
        jToolBar.add(this.deleteButton);
        this.deleteButton.setEnabled(false);
        jToolBar.setFloatable(false);
        jPanel.add((Component)jTextArea, "Center");
        jPanel.add((Component)jToolBar, "South");
        this.mainPanel.add((Component)jPanel, "North");
        this.mainPanel.add((Component)this.networkScroller, "Center");
        return this.mainPanel;
    }

    protected JButton getDeleteButton() {
        return this.deleteButton;
    }

    public void back() {
        try {
            this.networkPanel.clearConstraints();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.back();
    }

    protected void rereadNodePositions() {
        try {
            this.networkPanel.rereadNodePositions();
            this.networkPanel.repaint();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    protected void reinitialize() {
        try {
            for (Link link : this.networkPanel.linkList) {
                link.deselect();
            }
            this.networkPanel.linkList.clear();
            this.networkPanel.rereadNodePositions();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    protected void receiveKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        try {
            double d;
            if ((n == 40 || n == 98) && keyEvent.isControlDown()) {
                d = this.networkPanel.zoom(0.9);
                if (d > 0.0) {
                    this.writeStatus(HuginGUIConstants.get("str_scale_factor_set_to_") + (int)(100.0 * d) + "%");
                } else {
                    this.writeStatus("Unable to scale network (1 <= scale factor <= 10000)");
                }
            }
            if ((n == 38 || n == 104) && keyEvent.isControlDown()) {
                d = this.networkPanel.zoom(1.1111111111111112);
                if (d > 0.0) {
                    this.writeStatus(HuginGUIConstants.get("str_scale_factor_set_to_") + (int)(100.0 * d) + "%");
                } else {
                    this.writeStatus("Unable to scale network (1 <= scale factor <= 10000)");
                }
            }
            switch (n) {
                case 65: {
                    this.networkPanel.selectAllNodes();
                    break;
                }
                case 36: {
                    double d2 = 0.0;
                    if (keyEvent.isControlDown()) {
                        d2 = 1.0;
                        this.networkPanel.setScaleFactor(1.0);
                    }
                    if (keyEvent.isShiftDown()) {
                        d2 = ZoomingPane.computeFitFactor(this.networkPanel);
                        this.networkPanel.setScaleFactor(d2);
                    }
                    if (!(d2 > 0.0)) break;
                    this.writeStatus(HuginGUIConstants.get("str_scale_factor_set_to_") + (int)Math.rint(100.0 * d2) + "%");
                    break;
                }
                case 46: {
                    if (!keyEvent.isControlDown()) break;
                    this.networkPanel.showGrid(!this.networkPanel.showGrid());
                    this.writeStatus(HuginGUIConstants.get("str_grid_") + (this.networkPanel.showGrid() ? HuginGUIConstants.get("str_on") : HuginGUIConstants.get("str_off")));
                    break;
                }
                case 44: {
                    if (keyEvent.isControlDown()) {
                        this.networkPanel.snapToGrid(!this.networkPanel.snapToGrid());
                        this.writeStatus(HuginGUIConstants.get("str_snap_to_grid_") + (this.networkPanel.snapToGrid() ? HuginGUIConstants.get("str_on") : HuginGUIConstants.get("str_off")));
                    }
                    if (!keyEvent.isShiftDown() || !this.networkPanel.snapSelectedNodesToGrid()) break;
                    this.writeStatus(HuginGUIConstants.get("str_selected_nodes_snapped_to_grid"));
                    break;
                }
                case 35: {
                    if (!keyEvent.isShiftDown()) break;
                    this.networkPanel.setScaleFactor((double)ZoomingPane.computeSelectedFitZoom(this.networkPanel) / 100.0);
                    this.networkPanel.scrollToSelected();
                    this.writeStatus(HuginGUIConstants.get("str_zoomed_to_selected_nodes"));
                }
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private void saveConstraints() throws ExceptionHugin {
        File file = Hugin.mainFrame.getMostRecentFile();
        HuginFileLoader huginFileLoader = file == null ? new HuginFileLoader(4, 2) : new HuginFileLoader(4, file, 2);
        if (huginFileLoader.showSaveDialog(new JFrame()) == 0) {
            for (Link link : this.networkPanel.linkList) {
                String string;
                if (!(link instanceof LinkConstraint)) continue;
                switch (((LinkConstraint)link).getType()) {
                    case 1: {
                        string = HuginGUIConstants.get("str_arrow");
                        break;
                    }
                    case 2: {
                        string = HuginGUIConstants.get("str_noarrow");
                        break;
                    }
                    case 3: {
                        string = HuginGUIConstants.get("str_link");
                        break;
                    }
                    case 4: {
                        string = HuginGUIConstants.get("str_nolink");
                        break;
                    }
                    default: {
                        string = HuginGUIConstants.get("str_invalid");
                    }
                }
                link.parent.getAPINode().setAttribute("HR_Constraint_" + link.child.getName(), string);
            }
            this.networkPanel.getHome().setAttribute("HR_Has_Constraints", "yes");
            HuginProjectFrame.flipNet(this.networkPanel.getHome());
            this.networkPanel.getHome().saveAsNet(huginFileLoader.getSelectedFile().getAbsolutePath());
            HuginProjectFrame.flipNet(this.networkPanel.getHome());
            for (Link link : this.networkPanel.linkList) {
                if (!(link instanceof LinkConstraint)) continue;
                link.parent.getAPINode().setAttribute("HR_Constraint_" + link.child.getName(), null);
            }
            this.networkPanel.getHome().setAttribute("HR_Has_Constraints", null);
        }
    }

    protected void setTimeStamped() throws ExceptionHugin {
        Domain domain = (Domain)this.networkPanel.getHome();
        NodeList nodeList = domain.getNodes();
        int n = 0;
        NodeList nodeList2 = new NodeList();
        for (Node node : nodeList) {
            String string = node.getAttribute("HR_Grp");
            if (string != null && string.trim().length() != 0) continue;
            nodeList2.add(node);
        }
        int n2 = (int)(HuginGUIUtils.layoutNodes(nodeList2, 0, 0, 2 * (int)domain.getNodeSize().getX(), 2 * (int)domain.getNodeSize().getY()).getY() + domain.getNodeSize().getY());
        int n3 = Integer.parseInt(domain.getAttribute("HR_Groups_UserGroupsNo"));
        for (int i = 0; i < n3; ++i) {
            nodeList2.clear();
            for (Node node : nodeList) {
                String string = node.getAttribute("HR_Grp");
                if (string == null || string.trim().length() <= 0 || Integer.parseInt(string) != i) continue;
                nodeList2.add(node);
            }
            n = (int)(HuginGUIUtils.layoutNodes(nodeList2, n, n2, 2 * (int)domain.getNodeSize().getX(), 2 * (int)domain.getNodeSize().getY()).getX() - domain.getNodeSize().getX());
        }
        this.networkPanel.rereadNodePositions();
        this.addTimeConstraints(domain);
    }

    private int getGroup(Node node) throws ExceptionHugin {
        int n = -1;
        String string = node.getAttribute("HR_Grp");
        if (string != null && string.trim().length() > 0) {
            String string2 = node.getName();
            n = Integer.parseInt(string2.substring(string2.lastIndexOf("_") + 1));
        }
        return n;
    }

    protected void addTimeConstraints(Domain domain) throws ExceptionHugin {
        NodeList nodeList = domain.getNodes();
        for (Node node : nodeList) {
            int n = this.getGroup(node);
            for (Node node2 : nodeList) {
                int n2 = this.getGroup(node2);
                if (n2 == -1) continue;
                if (n < 0 && n2 >= 0) {
                    node2.setEdgeConstraint(node, Domain.H_CONSTRAINT_FORWARD_EDGE_FORBIDDEN);
                    continue;
                }
                if (n + 1 == n2) {
                    node2.setEdgeConstraint(node, Domain.H_CONSTRAINT_FORWARD_EDGE_FORBIDDEN);
                }
                if (n <= n2 + 1) continue;
                node2.setEdgeConstraint(node, Domain.H_CONSTRAINT_EDGE_FORBIDDEN);
            }
        }
    }

    private class Delete
    extends AbstractAction {
        WizardNetworkPanel networkPanel;

        public Delete(WizardNetworkPanel wizardNetworkPanel) {
            super("Delete", new ImageIcon(ClassLoader.getSystemResource("icons/delete.gif")));
            this.networkPanel = wizardNetworkPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.networkPanel.deleteSelectedObjects();
        }
    }

    private class NoLinkConstraintTool
    extends AbstractAction {
        WizardNetworkPanel networkPanel;

        public NoLinkConstraintTool(WizardNetworkPanel wizardNetworkPanel) {
            super("No-Link Constraint Tool", new ImageIcon(ClassLoader.getSystemResource("icons/no_link_constraint.gif")));
            this.networkPanel = wizardNetworkPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.networkPanel.setMode(4);
        }
    }

    private class LinkConstraintTool
    extends AbstractAction {
        WizardNetworkPanel networkPanel;

        public LinkConstraintTool(WizardNetworkPanel wizardNetworkPanel) {
            super("Link Constraint Tool", new ImageIcon(ClassLoader.getSystemResource("icons/link_constraint.gif")));
            this.networkPanel = wizardNetworkPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.networkPanel.setMode(3);
        }
    }

    private class NoArrowConstraintTool
    extends AbstractAction {
        WizardNetworkPanel networkPanel;

        public NoArrowConstraintTool(WizardNetworkPanel wizardNetworkPanel) {
            super("No-Arrow Constraint Tool", new ImageIcon(ClassLoader.getSystemResource("icons/no_arrow_constraint.gif")));
            this.networkPanel = wizardNetworkPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.networkPanel.setMode(2);
        }
    }

    private class ArrowConstraintTool
    extends AbstractAction {
        WizardNetworkPanel networkPanel;

        public ArrowConstraintTool(WizardNetworkPanel wizardNetworkPanel) {
            super("Arrow Constraint Tool", new ImageIcon(ClassLoader.getSystemResource("icons/arrow_constraint.gif")));
            this.networkPanel = wizardNetworkPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.networkPanel.setMode(1);
        }
    }

    private class SelectTool
    extends AbstractAction {
        WizardNetworkPanel networkPanel;

        public SelectTool(WizardNetworkPanel wizardNetworkPanel) {
            super("Select Tool", new ImageIcon(ClassLoader.getSystemResource("icons/arrow.gif")));
            this.networkPanel = wizardNetworkPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.networkPanel.setMode(0);
        }
    }
}

