/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class TableInitializer
extends JDialog {
    protected static final int EXPERIENCE_TABLE = 1;
    protected static final int FADING_TABLE = 2;
    private HuginGUIFrame guiFrame;
    private JPanel mainPanel;
    private JSpinner valueSpinner;
    private JRadioButton userInputRadio;
    private JRadioButton computeRadio;
    private JLabel valueLabel;
    private NodeList nodeList;

    public TableInitializer(Frame frame, NodeList nodeList, int n) {
        super(frame, HuginGUIConstants.get("IT_Title"), true);
        this.nodeList = nodeList;
        this.initialize(frame, n);
    }

    public TableInitializer(Dialog dialog, NodeList nodeList, int n) {
        super(dialog, HuginGUIConstants.get("IT_Title"), true);
        this.nodeList = nodeList;
        this.initialize(dialog, n);
    }

    public TableInitializer(Frame frame, Node node, int n) {
        super(frame, HuginGUIConstants.get("IT_Title"), true);
        this.nodeList = new NodeList();
        this.nodeList.add(node);
        this.initialize(frame, n);
    }

    public TableInitializer(Dialog dialog, Node node, int n) {
        super(dialog, HuginGUIConstants.get("IT_Title"), true);
        this.nodeList = new NodeList();
        this.nodeList.add(node);
        this.initialize(dialog, n);
    }

    private void initialize(Component component, int n) {
        this.mainPanel = new JPanel(new BorderLayout(5, 5));
        switch (n) {
            case 1: {
                this.createExperiencePanel(component);
                break;
            }
            case 2: {
                this.createFadingPanel(component);
                break;
            }
            default: {
                this.dispose();
            }
        }
        this.setLayout(new GridLayout(1, 1));
        this.getContentPane().add(this.mainPanel);
        this.pack();
        HuginGUIUtils.centerComponent(component, (Window)this);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setVisible(true);
    }

    private void createExperiencePanel(Component component) {
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("TI_initialize_experience")));
        this.userInputRadio = new JRadioButton(HuginGUIConstants.get("TI_user_radio"));
        this.userInputRadio.setSelected(true);
        this.computeRadio = new JRadioButton(HuginGUIConstants.get("TI_compute_radio"));
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.add(this.userInputRadio);
        jPanel.add(this.computeRadio);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "West");
        this.mainPanel.add((Component)jPanel2, "North");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.userInputRadio);
        buttonGroup.add(this.computeRadio);
        this.valueSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, Double.MAX_VALUE, 0.5));
        this.mainPanel.add((Component)this.getInputPanel(this.valueSpinner, HuginGUIConstants.get("TI_experience_count")), "Center");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableInitializer.this.valueSpinner.setEnabled(TableInitializer.this.userInputRadio.isSelected());
                TableInitializer.this.valueLabel.setEnabled(TableInitializer.this.userInputRadio.isSelected());
            }
        };
        this.userInputRadio.addActionListener(actionListener);
        this.computeRadio.addActionListener(actionListener);
        ExperienceListener experienceListener = new ExperienceListener();
        JPanel jPanel3 = this.createButtonPanel(experienceListener);
        this.mainPanel.add((Component)jPanel3, "South");
    }

    private void createFadingPanel(Component component) {
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("TI_initialize_fading")));
        this.valueSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 1.0, 0.05));
        this.mainPanel.add((Component)this.getInputPanel(this.valueSpinner, HuginGUIConstants.get("TI_fading")), "Center");
        FadingListener fadingListener = new FadingListener();
        JPanel jPanel = this.createButtonPanel(fadingListener);
        this.mainPanel.add((Component)jPanel, "South");
    }

    private JPanel getInputPanel(JSpinner jSpinner, String string) {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        this.valueLabel = new JLabel(string);
        jPanel.add((Component)this.valueLabel, "West");
        jPanel.add((Component)jSpinner, "Center");
        jSpinner.setPreferredSize(new Dimension(60, jSpinner.getHeight()));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        return jPanel2;
    }

    private JPanel createButtonPanel(ActionListener actionListener) {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        JButton jButton = new JButton(HuginGUIConstants.get("TI_ok"));
        jButton.addActionListener(actionListener);
        JButton jButton2 = new JButton(HuginGUIConstants.get("TI_close"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableInitializer.this.dispose();
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "East");
        return jPanel;
    }

    private void initializeExperienceTables(double d) {
        try {
            for (Node node : this.nodeList) {
                Table table = null;
                if (node instanceof DiscreteChanceNode) {
                    table = ((DiscreteChanceNode)node).getExperienceTable();
                }
                if (node instanceof ContinuousChanceNode) {
                    table = ((ContinuousChanceNode)node).getExperienceTable();
                }
                if (table == null) continue;
                double[] dArray = table.getData();
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = d;
                }
                table.setData(dArray);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(HuginGUIConstants.get("TI_error_initializing_experience"));
        }
    }

    private void computeExperienceValues() {
        try {
            for (Node node : this.nodeList) {
                Table table = null;
                if (node instanceof DiscreteChanceNode) {
                    table = ((DiscreteChanceNode)node).getExperienceTable();
                }
                if (node instanceof ContinuousChanceNode) {
                    table = ((ContinuousChanceNode)node).getExperienceTable();
                }
                double d = 1.0;
                if (table == null) continue;
                d = 1.0 / (double)table.getSize();
                double[] dArray = table.getData();
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = d;
                }
                table.setData(dArray);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(HuginGUIConstants.get("TI_error_initializing_experience"));
        }
    }

    class FadingListener
    implements ActionListener {
        FadingListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                double d = (Double)TableInitializer.this.valueSpinner.getValue();
                for (Node node : TableInitializer.this.nodeList) {
                    Table table;
                    if (!(node instanceof DiscreteChanceNode) || (table = ((DiscreteChanceNode)node).getFadingTable()) == null) continue;
                    double[] dArray = table.getData();
                    for (int i = 0; i < dArray.length; ++i) {
                        dArray[i] = d;
                    }
                    table.setData(dArray);
                }
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(HuginGUIConstants.get("TI_error_initializing_fading"));
            }
            TableInitializer.this.dispose();
        }
    }

    class ExperienceListener
    implements ActionListener {
        ExperienceListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (TableInitializer.this.userInputRadio.isSelected()) {
                TableInitializer.this.initializeExperienceTables((Double)TableInitializer.this.valueSpinner.getValue());
            } else {
                TableInitializer.this.computeExperienceValues();
            }
            TableInitializer.this.dispose();
        }
    }
}

