/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.HuginGUIUtils;

class TotalImpactDistribution {
    Domain domain = null;
    IntervalDCNode totalImpact = null;
    double[] values = null;
    IntervalDCNode costNode = null;
    NumberedDCNode freqNode = null;
    NumberedDCNode xNode = null;
    BooleanDCNode oNode = null;
    IntervalDCNode iNode = null;

    TotalImpactDistribution(NumberedDCNode numberedDCNode, BooleanDCNode booleanDCNode, IntervalDCNode intervalDCNode) throws ExceptionHugin {
        this.xNode = numberedDCNode;
        this.oNode = booleanDCNode;
        this.iNode = intervalDCNode;
        this.domain = new Domain();
        this.totalImpact = new IntervalDCNode(this.domain);
    }

    TotalImpactDistribution(IntervalDCNode intervalDCNode, NumberedDCNode numberedDCNode) throws ExceptionHugin {
        this.costNode = intervalDCNode;
        this.freqNode = numberedDCNode;
        this.domain = new Domain();
        this.totalImpact = new IntervalDCNode(this.domain);
    }

    public void delete() throws ExceptionHugin {
        if (this.domain != null) {
            this.domain.delete();
        }
    }

    public double[] getValues() {
        return this.values;
    }

    public IntervalDCNode getNode() {
        return this.totalImpact;
    }

    public void setIntervals(IntervalDCNode intervalDCNode) throws ExceptionHugin {
        int n = intervalDCNode.getNumberOfStates();
        this.totalImpact.setNumberOfStates(n);
        for (int i = 0; i <= n; ++i) {
            this.totalImpact.setStateValue(i, n);
        }
    }

    public void setIntervals(double[] dArray) throws ExceptionHugin {
        int n = dArray.length;
        this.totalImpact.setNumberOfStates(n);
        for (int i = 0; i <= n; ++i) {
            this.totalImpact.setStateValue(i, n);
        }
    }

    public double[] fitIntervals() throws ExceptionHugin {
        int n = this.totalImpact.getNumberOfStates();
        double d = this.totalImpact.getStateValue(n);
        if (d != Domain.INFINITY()) {
            this.totalImpact.setNumberOfStates(n + 1);
            this.totalImpact.setStateValue(n + 1, Domain.INFINITY());
            n = this.totalImpact.getNumberOfStates();
            this.domain.uncompile();
        }
        HuginGUIUtils.configureDomain(this.domain);
        if (!this.domain.isCompiled()) {
            this.domain.compile();
        }
        Table table = this.totalImpact.getConvolution(this.freqNode, this.costNode);
        double[] dArray = table.getData();
        while (dArray[n - 1] > 0.02) {
            double d2 = this.totalImpact.getStateValue(n - 1);
            table.delete();
            this.totalImpact.setStateValue(n - 1, 2.0 * d2);
            this.domain.uncompile();
            HuginGUIUtils.configureDomain(this.domain);
            this.domain.compile();
            table = this.totalImpact.getConvolution(this.freqNode, this.costNode);
            dArray = table.getData();
            System.err.println(2.0 * d2 + " " + dArray[n - 1]);
        }
        table.delete();
        return dArray;
    }

    public void calculate() throws ExceptionHugin {
        this.calculate(false);
    }

    public void calculate(boolean bl) throws ExceptionHugin {
        int n = this.costNode.getNumberOfStates();
        this.totalImpact.setNumberOfStates(n);
        for (int i = 0; i <= n; ++i) {
            this.totalImpact.setStateValue(i, this.costNode.getStateValue(i));
        }
        HuginGUIUtils.configureDomain(this.domain);
        if (!this.domain.isCompiled()) {
            this.domain.compile();
        }
        if (bl) {
            this.values = this.fitIntervals();
        } else {
            Table table = this.totalImpact.getConvolution(this.freqNode, this.costNode);
            this.values = table.getData();
            table.delete();
        }
    }
}

