/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.HuginGUIError;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class WizardStatus
extends JPanel {
    private String[] steps;
    private int activeStep;
    private Image background;
    private Image pending;
    private Image completed;
    private Image current;
    private Dimension pendingSize;
    private Dimension completedSize;
    private Dimension currentSize;
    private Dimension maximumSize;
    private static final int MARGIN = 10;
    private static final int TEXT_HEIGHT = 15;

    public WizardStatus(String[] stringArray) {
        this.steps = stringArray;
        this.setFont(this.getFont().deriveFont(1));
        this.activeStep = 0;
        this.background = null;
        this.pending = null;
        this.completed = null;
        this.maximumSize = new Dimension(0, 0);
    }

    public WizardStatus(String[] stringArray, Image image) {
        this(stringArray);
        this.background = image;
        try {
            while (image.getWidth(this) == -1) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            new HuginGUIError(interruptedException);
        }
    }

    public WizardStatus(String[] stringArray, Image image, Image image2, Image image3, Image image4) {
        this(stringArray, image);
        this.setPending(image2);
        this.setCompleted(image3);
        this.setCurrent(image4);
    }

    public void setSteps(String[] stringArray) {
        this.steps = stringArray;
    }

    public void setActiveStep(int n) {
        this.activeStep = n;
    }

    public void setCompleted(Image image) {
        this.completed = image;
        this.completedSize = new Dimension(image.getWidth(this), image.getHeight(this));
        this.maximumSize = this.getMaxIconSize();
    }

    public void setPending(Image image) {
        this.pending = image;
        this.pendingSize = new Dimension(image.getWidth(this), image.getHeight(this));
    }

    public void setCurrent(Image image) {
        this.current = image;
        this.currentSize = new Dimension(image.getWidth(this), image.getHeight(this));
    }

    public void setBackground(Image image) {
        this.background = image;
    }

    public Dimension getPreferredSize() {
        if (this.background == null) {
            return new Dimension(200, 300);
        }
        return new Dimension(this.background.getWidth(this), this.background.getHeight(this));
    }

    private Dimension getMaxIconSize() {
        Dimension dimension = new Dimension(0, 0);
        if (this.currentSize != null) {
            dimension.width = Math.max(dimension.width, this.currentSize.width);
            dimension.height = Math.max(dimension.height, this.currentSize.height);
        }
        if (this.pendingSize != null) {
            dimension.width = Math.max(dimension.width, this.pendingSize.width);
            dimension.height = Math.max(dimension.height, this.pendingSize.height);
        }
        if (this.completedSize != null) {
            dimension.width = Math.max(dimension.width, this.completedSize.width);
            dimension.height = Math.max(dimension.height, this.completedSize.height);
        }
        return dimension;
    }

    public void insertItemAt(String string, int n) {
        int n2;
        String[] stringArray = new String[this.steps.length + 1];
        for (n2 = 0; n2 < n; ++n2) {
            stringArray[n2] = this.steps[n2];
        }
        stringArray[n] = string;
        for (n2 = n + 1; n2 < stringArray.length; ++n2) {
            stringArray[n2] = this.steps[n2 - 1];
        }
        this.steps = stringArray;
    }

    public void removeItemAt(int n) {
        int n2;
        String[] stringArray = new String[this.steps.length - 1];
        for (n2 = 0; n2 < n; ++n2) {
            stringArray[n2] = this.steps[n2];
        }
        for (n2 = n; n2 < stringArray.length; ++n2) {
            stringArray[n2] = this.steps[n2 + 1];
        }
        this.steps = stringArray;
    }

    public void paint(Graphics graphics) {
        int n;
        graphics.setFont(this.getFont().deriveFont(1));
        int n2 = Math.max(15, this.maximumSize.height) + 5;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.background != null) {
            graphics.drawImage(this.background, 0, 0, this);
        }
        graphics.setColor(new Color(0, 155, 255, 80));
        graphics.fillRoundRect(5, 10 + this.activeStep * n2, this.getWidth() - 10, n2, 10, 10);
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        for (int i = 0; i < this.activeStep; ++i) {
            graphics.setColor(Color.gray);
            graphics.drawString(this.steps[i], 20 + this.maximumSize.width, 25 + i * n2);
        }
        int[] nArray = new int[]{1, 0, -1, 0};
        int[] nArray2 = new int[]{0, 1, 0, -1};
        int n3 = -1;
        int n4 = -1;
        graphics.setColor(Color.black);
        for (n = 0; n < nArray.length; ++n) {
            for (int i = 0; i < 3; ++i) {
                graphics.drawString(this.steps[this.activeStep], 20 + this.maximumSize.width + n3, 25 + n4 + this.activeStep * n2);
                n3 += nArray[n];
                n4 += nArray2[n];
            }
        }
        graphics.setColor(Color.white);
        graphics.drawString(this.steps[this.activeStep], 20 + this.maximumSize.width, 25 + this.activeStep * n2);
        graphics.setColor(Color.black);
        for (n = this.activeStep + 1; n < this.steps.length; ++n) {
            graphics.drawString(this.steps[n], 20 + this.maximumSize.width, 25 + n * n2);
        }
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }
}

