/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI.zoom;

import COM.hugin.HGUI.zoom.ZoomableCombobox;
import COM.hugin.HGUI.zoom.ZoomableScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class ZoomablePopupMenu
extends JPopupMenu {
    double scaleFactor = 1.0;
    Font font;
    ZoomableCombobox invoker;
    JList elements;
    ZoomableScrollPane scroller;

    public ZoomablePopupMenu(ZoomableCombobox zoomableCombobox) {
        this.invoker = zoomableCombobox;
        this.font = this.getFont();
        this.elements = new JList(zoomableCombobox.getModel());
        this.elements.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                ZoomablePopupMenu.this.elements.setSelectedIndex(ZoomablePopupMenu.this.elements.locationToIndex(new Point(mouseEvent.getX(), mouseEvent.getY())));
            }
        });
        this.elements.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ZoomablePopupMenu.this.invoker.setSelectedIndex(ZoomablePopupMenu.this.elements.locationToIndex(new Point(mouseEvent.getX(), mouseEvent.getY())));
                ZoomablePopupMenu.this.setVisible(false);
            }
        });
        this.scroller = new ZoomableScrollPane(this.elements);
        this.elements.setBackground(UIManager.getDefaults().getColor("ComboBox.background"));
        if (this.elements.getModel().getSize() < this.elements.getVisibleRowCount()) {
            this.scroller.setPreferredSize(new Dimension(this.scroller.getPreferredSize().width, this.elements.getPreferredSize().height));
        }
        this.scroller.getVerticalScrollBar().setUnitIncrement(this.elements.getPreferredSize().height / this.elements.getModel().getSize());
        this.add(this.scroller);
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        this.elements.setCellRenderer(listCellRenderer);
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
        Font font = this.font.deriveFont((float)((double)this.font.getSize2D() * d));
        this.setFont(font);
        this.scroller.setScaleFactor(d);
        this.scroller.getVerticalScrollBar().setUnitIncrement(this.elements.getPreferredSize().height / this.elements.getModel().getSize());
    }

    public void show(Component component, int n, int n2) {
        super.show(component, n, n2);
    }

    public int getWidth() {
        return this.invoker.getWidth();
    }

    public int getHeight() {
        Insets insets;
        int n = 0;
        if (this.isBorderPainted()) {
            insets = this.getBorder().getBorderInsets(this);
            n += insets.top;
            n += insets.bottom;
        }
        insets = this.getMargin();
        n += insets.top;
        n += insets.bottom;
        return n += this.scroller.getPreferredSize().height;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }
}

