/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.MODEL;

import COM.hugin.MODEL.Network;
import COM.hugin.MODEL.Node;
import java.io.Serializable;

public class ContinuousChanceNode
extends Node
implements Serializable {
    double enteredValue;
    boolean hasEvidence = false;

    public ContinuousChanceNode(Network network) {
        super(network);
    }

    protected void updateFromNode(ContinuousChanceNode continuousChanceNode) {
        super.updateFromNode(continuousChanceNode);
        this.configureContinuousChanceNode(continuousChanceNode.enteredValue, continuousChanceNode.hasEvidence);
    }

    public void configureContinuousChanceNode(double d, boolean bl) {
        this.enteredValue = d;
        this.hasEvidence = bl;
    }

    public boolean hasEvidence() {
        return this.hasEvidence;
    }

    public double getEnteredValue() throws Exception {
        if (this.hasEvidence) {
            return this.enteredValue;
        }
        throw new Exception("No evidence entered");
    }

    public void enterValue(double d) {
        if (!this.hasEvidence || this.enteredValue != d) {
            this.net.setEvidenceToPropagate();
        }
        this.enteredValue = d;
        this.hasEvidence = true;
    }

    public void retractFindings() {
        this.enteredValue = 0.0;
        this.hasEvidence = false;
    }
}

