/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.MODEL;

import COM.hugin.MODEL.Network;
import COM.hugin.MODEL.Node;
import java.io.Serializable;

public abstract class DiscreteNode
extends Node
implements Serializable {
    double[] stateBeliefs;
    String[] stateLabels;
    double[] stateFindings;
    double[] expectedUtilities;

    public DiscreteNode(Network network) {
        super(network);
    }

    protected void updateFromNode(DiscreteNode discreteNode) {
        super.updateFromNode(discreteNode);
        this.configureDiscreteNode(discreteNode.stateBeliefs, discreteNode.stateLabels, discreteNode.stateFindings, discreteNode.expectedUtilities);
    }

    public void configureDiscreteNode(double[] dArray, String[] stringArray, double[] dArray2, double[] dArray3) {
        this.stateBeliefs = dArray;
        this.stateLabels = stringArray;
        this.stateFindings = dArray2;
        this.expectedUtilities = dArray3;
    }

    public double getBelief(int n) {
        return this.stateBeliefs[n];
    }

    public double getEnteredFinding(int n) {
        return this.stateFindings[n];
    }

    public void enterFinding(int n, double d) {
        if (this.stateFindings[n] != d) {
            this.net.setEvidenceToPropagate();
        }
        this.stateFindings[n] = d;
    }

    public double getExpectedUtility(int n) {
        return this.expectedUtilities[n];
    }

    public int getNumberOfStates() {
        return this.stateBeliefs.length;
    }

    public String getStateLabel(int n) {
        return this.stateLabels[n];
    }

    public void retractFindings() {
        for (int i = 0; i < this.stateFindings.length; ++i) {
            if (this.stateFindings[i] != 1.0) {
                this.net.setEvidenceToPropagate();
            }
            this.stateFindings[i] = 1.0;
        }
    }

    public void selectState(int n) {
        for (int i = 0; i < this.stateFindings.length; ++i) {
            double d;
            double d2 = d = i == n ? 1.0 : 0.0;
            if (this.stateFindings[i] != d) {
                this.net.setEvidenceToPropagate();
            }
            this.stateFindings[i] = d;
        }
    }
}

