/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.REPORT;

import COM.hugin.MODEL.Batch;
import COM.hugin.MODEL.CaseSet;
import COM.hugin.MODEL.DiscreteNode;
import COM.hugin.MODEL.Network;
import COM.hugin.REPORT.ReportElement;
import COM.hugin.REPORT.Section;
import COM.hugin.REPORT.Table;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Scrollable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Report
extends ReportElement
implements Scrollable {
    protected ReportElement header;
    protected ReportElement footer;
    protected ArrayList<Section> sections = new ArrayList();
    protected ArrayList<String> userFields = new ArrayList();
    protected HashMap<String, String> userInput = null;
    protected String name = "Report name";
    protected int pageSize = 0;
    private JPanel headerPanel = new JPanel();
    private JPanel footerPanel = new JPanel();
    private JPanel sectionsPanel = new JPanel();
    private Report report = this;
    public String tmpPathPdf = null;

    public Report(String string) {
        this.name = string;
        this.setLayout(new BoxLayout(this, 1));
        this.headerPanel.setLayout(new BoxLayout(this.headerPanel, 1));
        this.footerPanel.setLayout(new BoxLayout(this.footerPanel, 1));
        this.sectionsPanel.setLayout(new BoxLayout(this.sectionsPanel, 1));
        this.headerPanel.setOpaque(false);
        this.sectionsPanel.setOpaque(false);
        this.footerPanel.setOpaque(false);
        this.add(this.headerPanel);
        this.add(this.sectionsPanel);
        this.add(this.footerPanel);
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.add(new JLabel("<HEADER>", 0));
        jPanel.setOpaque(false);
        this.headerPanel.add(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
        jPanel2.add(new JLabel("<FOOTER>", 0));
        jPanel2.setOpaque(false);
        this.footerPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
        jPanel3.add(new JLabel("<SECTIONS>", 0));
        jPanel3.setOpaque(false);
        this.sectionsPanel.add(jPanel3);
        this.setBackground(Color.WHITE);
    }

    public void setPageSize(int n) {
        this.pageSize = n;
    }

    public boolean isEmpty() {
        return this.sections.size() == 0;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setHeader(ReportElement reportElement) {
        this.header = reportElement;
        this.headerPanel.removeAll();
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.add(new JLabel("<HEADER>", 0));
        jPanel.setOpaque(false);
        this.headerPanel.add(jPanel);
        if (this.header != null) {
            this.header.setReportParent(this);
            this.headerPanel.add(this.header);
        }
        this.validate();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public ReportElement getHeader() {
        return this.header;
    }

    public void setFooter(ReportElement reportElement) {
        this.footer = reportElement;
        this.footerPanel.removeAll();
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.add(new JLabel("<FOOTER>", 0));
        jPanel.setOpaque(false);
        this.footerPanel.add(jPanel);
        if (this.footer != null) {
            this.footer.setReportParent(this);
            this.footerPanel.add(this.footer);
        }
        this.validate();
    }

    public ReportElement getFooter() {
        return this.footer;
    }

    public void addSection(Section section) {
        section.setReportParent(this);
        this.sections.add(section);
        this.sectionsPanel.add(section);
        this.validate();
    }

    public ArrayList<Section> getSections() {
        return this.sections;
    }

    public void addSection(Section section, int n) {
        section.setReportParent(this);
        this.sections.add(n, section);
        this.sectionsPanel.add((Component)section, n + 1);
        this.validate();
    }

    public void removeSection(Section section) {
        this.sections.remove(section);
        this.sectionsPanel.remove(section);
        this.validate();
    }

    @Override
    public Element render(Report report, Document document, PdfWriter pdfWriter) {
        return null;
    }

    public boolean generate(String string, CaseSet caseSet, Batch batch, HashMap<String, String> hashMap) {
        this.userInput = hashMap;
        Rectangle rectangle = null;
        switch (this.pageSize) {
            case 1: {
                rectangle = PageSize.A4.rotate();
                break;
            }
            case 2: {
                rectangle = PageSize.A3;
                break;
            }
            case 3: {
                rectangle = PageSize.A3.rotate();
                break;
            }
            case 4: {
                rectangle = PageSize.A2;
                break;
            }
            case 5: {
                rectangle = PageSize.A2.rotate();
                break;
            }
            default: {
                rectangle = PageSize.A4;
            }
        }
        Document document = new Document(rectangle);
        try {
            this.tmpPathPdf = string;
            PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(string));
            MyPageEvent myPageEvent = new MyPageEvent(document, this.header, this.footer, pdfWriter);
            pdfWriter.setPageEvent(myPageEvent);
            document.open();
            if (this.sections.size() == 0) {
                document.add(new Paragraph(" "));
            }
            for (Section section : this.sections) {
                section.setBackingData(caseSet, batch);
                Element element = section.render(this.report, document, pdfWriter);
                if (element == null) {
                    try {
                        document.close();
                        this.tmpPathPdf = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return false;
                }
                document.add(element);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        document.close();
        this.tmpPathPdf = null;
        return true;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(600, 400);
    }

    @Override
    public int getScrollableBlockIncrement(java.awt.Rectangle rectangle, int n, int n2) {
        return 1;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(java.awt.Rectangle rectangle, int n, int n2) {
        return 1;
    }

    public DiscreteNode[] getResultNodesForBatch(Network network) {
        DiscreteNode[] discreteNodeArray;
        HashSet<DiscreteNode> hashSet = new HashSet<DiscreteNode>();
        for (Section section : this.sections) {
            DiscreteNode[] discreteNodeArray2 = discreteNodeArray = section.getResultNodesForBatch(network);
            int n = discreteNodeArray2.length;
            for (int i = 0; i < n; ++i) {
                DiscreteNode discreteNode = discreteNodeArray2[i];
                hashSet.add(discreteNode);
            }
        }
        DiscreteNode[] discreteNodeArray3 = hashSet.toArray(new DiscreteNode[0]);
        int n = 0;
        for (DiscreteNode discreteNode : discreteNodeArray3) {
            if (discreteNode != null) continue;
            ++n;
        }
        discreteNodeArray = discreteNodeArray3;
        if (n > 0) {
            discreteNodeArray = new DiscreteNode[discreteNodeArray3.length - n];
        }
        n = 0;
        for (int i = 0; i < discreteNodeArray.length; ++i) {
            while (discreteNodeArray3[i + n] == null) {
                ++n;
            }
            discreteNodeArray[i] = discreteNodeArray3[i + n];
        }
        return discreteNodeArray;
    }

    private class MyPageEvent
    extends PdfPageEventHelper {
        private ReportElement headerElement = null;
        private ReportElement footerElement = null;
        private float headerHeight = 0.0f;
        private float footerHeight = 0.0f;
        private float headerFooterWidth;
        private Document doc;
        private PdfWriter writer;

        public MyPageEvent(Document document, ReportElement reportElement, ReportElement reportElement2, PdfWriter pdfWriter) {
            this.doc = document;
            this.writer = pdfWriter;
            this.headerElement = reportElement;
            this.footerElement = reportElement2;
            PdfPTable pdfPTable = null;
            PdfPTable pdfPTable2 = null;
            Rectangle rectangle = this.doc.getPageSize();
            this.headerFooterWidth = rectangle.getWidth() - this.doc.leftMargin() - this.doc.rightMargin();
            if (this.headerElement != null && this.headerElement instanceof Table) {
                pdfPTable = (PdfPTable)this.headerElement.render(Report.this.report, this.doc, this.writer);
                pdfPTable.setTotalWidth(this.headerFooterWidth);
                this.headerHeight = pdfPTable.getTotalHeight();
            }
            if (this.footerElement != null && this.footerElement instanceof Table) {
                pdfPTable2 = (PdfPTable)this.footerElement.render(Report.this.report, this.doc, this.writer);
                pdfPTable2.setTotalWidth(this.headerFooterWidth);
                this.footerHeight = pdfPTable2.getTotalHeight();
            }
            this.doc.setMargins(36.0f, 36.0f, 36.0f + this.headerHeight, 36.0f + this.footerHeight);
        }

        public void onEndPage(PdfWriter pdfWriter, Document document) {
            PdfPTable pdfPTable = null;
            PdfPTable pdfPTable2 = null;
            Rectangle rectangle = this.doc.getPageSize();
            this.headerFooterWidth = rectangle.getWidth() - this.doc.leftMargin() - this.doc.rightMargin();
            if (this.headerElement != null && this.headerElement instanceof Table) {
                pdfPTable = (PdfPTable)this.headerElement.render(Report.this.report, this.doc, pdfWriter);
                pdfPTable.setTotalWidth(this.headerFooterWidth);
                this.headerHeight = pdfPTable.getTotalHeight();
            }
            if (this.footerElement != null && this.footerElement instanceof Table) {
                pdfPTable2 = (PdfPTable)this.footerElement.render(Report.this.report, this.doc, pdfWriter);
                pdfPTable2.setTotalWidth(this.headerFooterWidth);
                this.footerHeight = pdfPTable2.getTotalHeight();
            }
            this.doc.setMargins(36.0f, 36.0f, 36.0f + this.headerHeight, 36.0f + this.footerHeight);
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            if (pdfPTable != null) {
                pdfPTable.writeSelectedRows(0, -1, (document.right() - document.left() - this.headerFooterWidth) / 2.0f + document.leftMargin(), document.top() + 10.0f + this.headerHeight, pdfContentByte);
            }
            if (pdfPTable2 != null) {
                pdfPTable2.writeSelectedRows(0, -1, (document.right() - document.left() - this.headerFooterWidth) / 2.0f + document.leftMargin(), document.bottom() - 10.0f, pdfContentByte);
            }
        }
    }
}

