/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.REPORT;

import COM.hugin.MODEL.Batch;
import COM.hugin.MODEL.BeliefEngine;
import COM.hugin.MODEL.CaseSet;
import COM.hugin.MODEL.Network;
import COM.hugin.REPORT.AutoField;
import COM.hugin.REPORT.DynamicLine;
import COM.hugin.REPORT.Report;
import COM.hugin.REPORT.ReportElement;
import COM.hugin.REPORT.RequestUserInput;
import COM.hugin.REPORT.Section;
import COM.hugin.REPORT.Table;
import COM.hugin.REPORT.TextLabel;
import COM.hugin.REPORT.UserInput;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportTools {
    public static final String TagContent = "content";
    public static final String TagReport = "report";
    public static final String TagReportHeader = "header";
    public static final String TagReportFooter = "footer";
    public static final String TagTable = "table";
    public static final String TagTableEmptyCell = "emptyCell";
    public static final String TagSection = "section";
    public static final String TagSectionDescription = "description";
    public static final String TagTextLabel = "textLabel";
    public static final String TagUserInput = "userInput";
    public static final String TagUserField = "userField";
    public static final String TagAutoField = "autoField";
    public static final String TagDynamicLine = "dynamicLine";
    public static final String TagDynamicLineHeaderValue = "headerValue";
    public static final String TagDynamicLineColumnWidthValue = "colWidth";
    public static final String TagDynamicLineSingleStateBeliefField = "singleStateBeliefField";
    public static final String TagDynamicLineHighestBeliefState = "highestBeliefState";
    public static final String TagDynamicLineCaseState = "caseState";
    public static final String TagDynamicLineDataFileValue = "dataFileValue";
    public static final String TagDynamicLineDataValueGreaterThan = "dataValueGreater";
    public static final String TagDynamicLineDataValueLessThan = "dataValueLess";
    public static final String TagDynamicLineUserInputValue = "userInputValue";
    public static final String TagDynamicLineNullField = "null";
    public static final String TagDynamicLineRule = "rule";
    public static final String TagDynamicLineEverythingRule = "everything";
    public static final String TagDynamicLineBeliefRule = "belief";
    public static final String TagDynamicLineDataFileValueEquals = "dataFileValueEquals";
    public static final String TagDynamicLineAndRule = "and";
    public static final String TagDynamicLineOrRule = "or";
    public static final String TagDynamicLineNegateRule = "negate";
    public static final String AttReportName = "reportName";
    public static final String AttTableRows = "rows";
    public static final String AttTableCols = "cols";
    public static final String AttTextLabelFont = "font";
    public static final String AttTextLabelSize = "size";
    public static final String AttTextLabelText = "text";
    public static final String AttUserInputFieldName = "name";
    public static final String AttUserFieldName = "name";
    public static final String AttDynamicLineNumberOfColumns = "cols";
    public static final String AttDynamicLineHeaderSettings = "headerSettings";
    public static final String AttDynamicLineHeaderText = "text";
    public static final String AttDynamicLineColumnWidth = "width";
    public static final String AttDynamicLineSingleStateBeliefFieldNodeName = "nodeName";
    public static final String AttDynamicLineSingleStateBeliefFieldState = "state";
    public static final String AttDynamicLineHighestBeliefStateNodeName = "nodeName";
    public static final String AttDynamicLineCaseStateNodeName = "nodeName";
    public static final String AttDynamicLineDataFileValueColumnName = "colName";
    public static final String AttDynamicLineUserInputValueFieldName = "fieldName";
    public static final String AttDynamicLineBeliefRuleNodeName = "nodeName";
    public static final String AttDynamicLineBeliefRuleState = "state";
    public static final String AttDynamicLineBeliefRuleThreshold = "threshold";
    public static final String AttDynamicLineDataFileValueEqualsColumnName = "colName";
    public static final String AttDynamicLineDataFileValueEqualsValue = "equals";
    public static final String AttAlignment = "alignment";
    public static final String AttDynamicLineSortNodeName = "sortNodeName";
    public static final String AttDynamicLineSortStateIndex = "sortStateIndex";
    public static final String AttDynamicLineSortColumnName = "sortColumnName";
    public static final String AttDynamicLineSortAscending = "sortAscending";
    public static final String AttDynamicLineMaxLines = "maxLines";
    public static final String AttDynamicLineFont = "font";
    public static final String AttDynamicLineFontSize = "fontSize";
    public static final String AttReportPageSize = "pageSize";
    public static final String AttDynamicLineDataFileValueGreaterLessColumn = "colName";
    public static final String AttDynamicLineDataFileValueGreaterLessValue = "value";
    public static final String AttAutoFieldType = "fieldType";

    public static JPanel getTransparentPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        return jPanel;
    }

    private static Element toElement(Object object) {
        if (object instanceof Element) {
            return (Element)object;
        }
        return null;
    }

    private static void toXML(ReportElement reportElement, Document document, Element element) {
        if (reportElement instanceof Table.EmptyCell) {
            ReportTools.toXML((Table.EmptyCell)reportElement, document, element);
        } else if (reportElement instanceof Table) {
            ReportTools.toXML((Table)reportElement, document, element);
        } else if (reportElement instanceof Section) {
            ReportTools.toXML((Section)reportElement, document, element);
        } else if (reportElement instanceof UserInput) {
            ReportTools.toXML((UserInput)reportElement, document, element);
        } else if (reportElement instanceof AutoField) {
            ReportTools.toXML((AutoField)reportElement, document, element);
        } else if (reportElement instanceof TextLabel) {
            ReportTools.toXML((TextLabel)reportElement, document, element);
        } else if (reportElement instanceof DynamicLine) {
            ReportTools.toXML((DynamicLine)reportElement, document, element);
        }
    }

    private static void toXML(Table.EmptyCell emptyCell, Document document, Element element) {
        Element element2 = document.createElement(TagTableEmptyCell);
        element.appendChild(element2);
    }

    private static void toXML(Table table, Document document, Element element) {
        Element element2 = document.createElement(TagTable);
        element.appendChild(element2);
        element2.setAttribute(AttTableRows, "" + table.rows);
        element2.setAttribute("cols", "" + table.cols);
        for (ReportElement reportElement : table.contents) {
            ReportTools.toXML(reportElement, document, element2);
        }
    }

    private static void toXML(Section section, Document document, Element element) {
        Element element2 = document.createElement(TagSection);
        element.appendChild(element2);
        Element element3 = document.createElement(TagSectionDescription);
        element2.appendChild(element3);
        if (section.description != null) {
            ReportTools.toXML(section.description, document, element3);
        }
        if (section.dynLine != null) {
            ReportTools.toXML(section.dynLine, document, element2);
        }
    }

    private static void toXML(UserInput userInput, Document document, Element element) {
        Element element2 = document.createElement(TagUserInput);
        element.appendChild(element2);
        element2.setAttribute("name", userInput.fieldName);
        element2.setAttribute("font", "" + userInput.font);
        element2.setAttribute(AttTextLabelSize, "" + userInput.size);
        element2.setAttribute(AttAlignment, "" + userInput.alignment);
    }

    private static void toXML(AutoField autoField, Document document, Element element) {
        Element element2 = document.createElement(TagAutoField);
        element.appendChild(element2);
        element2.setAttribute(AttAutoFieldType, "" + autoField.fieldType);
        element2.setAttribute("font", "" + autoField.font);
        element2.setAttribute(AttTextLabelSize, "" + autoField.size);
        element2.setAttribute(AttAlignment, "" + autoField.alignment);
    }

    private static void toXML(TextLabel textLabel, Document document, Element element) {
        Element element2 = document.createElement(TagTextLabel);
        element.appendChild(element2);
        element2.setAttribute("font", "" + textLabel.font);
        element2.setAttribute(AttTextLabelSize, "" + textLabel.size);
        element2.setAttribute("text", textLabel.text);
        element2.setAttribute(AttAlignment, "" + textLabel.alignment);
    }

    private static void toXML(DynamicLine.InclusionRule inclusionRule, Document document, Element element) {
        if (inclusionRule instanceof DynamicLine.EverythingRule) {
            Element element2 = document.createElement(TagDynamicLineEverythingRule);
            element.appendChild(element2);
        } else if (inclusionRule instanceof DynamicLine.BeliefRule) {
            DynamicLine.BeliefRule beliefRule = (DynamicLine.BeliefRule)inclusionRule;
            Element element3 = document.createElement(TagDynamicLineBeliefRule);
            element.appendChild(element3);
            element3.setAttribute("nodeName", beliefRule.nodeName);
            element3.setAttribute("state", "" + beliefRule.stateNumber);
            element3.setAttribute(AttDynamicLineBeliefRuleThreshold, "" + beliefRule.beliefThreshold);
        } else if (inclusionRule instanceof DynamicLine.DataFileValueEquals) {
            DynamicLine.DataFileValueEquals dataFileValueEquals = (DynamicLine.DataFileValueEquals)inclusionRule;
            Element element4 = document.createElement(TagDynamicLineDataFileValueEquals);
            element.appendChild(element4);
            element4.setAttribute("colName", dataFileValueEquals.dataColumnName);
            element4.setAttribute(AttDynamicLineDataFileValueEqualsValue, dataFileValueEquals.equals);
        } else if (inclusionRule instanceof DynamicLine.AndRule) {
            DynamicLine.AndRule andRule = (DynamicLine.AndRule)inclusionRule;
            Element element5 = document.createElement(TagDynamicLineAndRule);
            element.appendChild(element5);
            ReportTools.toXML(andRule.first, document, element5);
            ReportTools.toXML(andRule.second, document, element5);
        } else if (inclusionRule instanceof DynamicLine.OrRule) {
            DynamicLine.OrRule orRule = (DynamicLine.OrRule)inclusionRule;
            Element element6 = document.createElement(TagDynamicLineOrRule);
            element.appendChild(element6);
            ReportTools.toXML(orRule.first, document, element6);
            ReportTools.toXML(orRule.second, document, element6);
        } else if (inclusionRule instanceof DynamicLine.NegateRule) {
            DynamicLine.NegateRule negateRule = (DynamicLine.NegateRule)inclusionRule;
            Element element7 = document.createElement(TagDynamicLineNegateRule);
            element.appendChild(element7);
            ReportTools.toXML(negateRule.rule, document, element7);
        } else if (inclusionRule instanceof DynamicLine.DataFileValueGreaterThan) {
            DynamicLine.DataFileValueGreaterThan dataFileValueGreaterThan = (DynamicLine.DataFileValueGreaterThan)inclusionRule;
            Element element8 = document.createElement(TagDynamicLineDataValueGreaterThan);
            element.appendChild(element8);
            element8.setAttribute("colName", dataFileValueGreaterThan.dataColumnName);
            element8.setAttribute(AttDynamicLineDataFileValueGreaterLessValue, dataFileValueGreaterThan.value);
        } else if (inclusionRule instanceof DynamicLine.DataFileValueLessThan) {
            DynamicLine.DataFileValueLessThan dataFileValueLessThan = (DynamicLine.DataFileValueLessThan)inclusionRule;
            Element element9 = document.createElement(TagDynamicLineDataValueLessThan);
            element.appendChild(element9);
            element9.setAttribute("colName", dataFileValueLessThan.dataColumnName);
            element9.setAttribute(AttDynamicLineDataFileValueGreaterLessValue, dataFileValueLessThan.value);
        }
    }

    private static void toXML(DynamicLine dynamicLine, Document document, Element element) {
        Object object;
        Element element2 = document.createElement(TagDynamicLine);
        element.appendChild(element2);
        element2.setAttribute("cols", "" + dynamicLine.numberOfColumns);
        element2.setAttribute(AttDynamicLineHeaderSettings, "" + dynamicLine.headerSettings);
        element2.setAttribute(AttDynamicLineMaxLines, "" + dynamicLine.getMaxLines());
        element2.setAttribute("font", "" + dynamicLine.getLineFont());
        element2.setAttribute(AttDynamicLineFontSize, "" + dynamicLine.getLineFontSize());
        if (dynamicLine.sortingHasBeenSpecified()) {
            if (dynamicLine.sortBeliefNodeName != null) {
                element2.setAttribute(AttDynamicLineSortNodeName, dynamicLine.sortBeliefNodeName);
                element2.setAttribute(AttDynamicLineSortStateIndex, "" + dynamicLine.sortBeliefState);
                element2.setAttribute(AttDynamicLineSortAscending, "" + dynamicLine.sortAscending);
            } else if (dynamicLine.sortColumn != null) {
                element2.setAttribute(AttDynamicLineSortColumnName, dynamicLine.sortColumn);
                element2.setAttribute(AttDynamicLineSortAscending, "" + dynamicLine.sortAscending);
            }
        }
        for (String object2 : dynamicLine.header) {
            object = document.createElement(TagDynamicLineHeaderValue);
            object.setAttribute("text", object2);
            element2.appendChild((Node)object);
        }
        for (Float f : dynamicLine.columnWidths) {
            object = document.createElement(TagDynamicLineColumnWidthValue);
            object.setAttribute(AttDynamicLineColumnWidth, "" + f);
            element2.appendChild((Node)object);
        }
        for (DynamicLine.Field field : dynamicLine.columns) {
            Element element3;
            if (field instanceof DynamicLine.SingleStateBeliefField) {
                object = (DynamicLine.SingleStateBeliefField)field;
                element3 = document.createElement(TagDynamicLineSingleStateBeliefField);
                element2.appendChild(element3);
                element3.setAttribute("nodeName", ((DynamicLine.SingleStateBeliefField)object).nodeName);
                element3.setAttribute("state", "" + ((DynamicLine.SingleStateBeliefField)object).state);
                continue;
            }
            if (field instanceof DynamicLine.HighestBeliefState) {
                object = (DynamicLine.HighestBeliefState)field;
                element3 = document.createElement(TagDynamicLineHighestBeliefState);
                element2.appendChild(element3);
                element3.setAttribute("nodeName", ((DynamicLine.HighestBeliefState)object).nodeName);
                continue;
            }
            if (field instanceof DynamicLine.CaseState) {
                object = (DynamicLine.CaseState)field;
                element3 = document.createElement(TagDynamicLineCaseState);
                element2.appendChild(element3);
                element3.setAttribute("nodeName", ((DynamicLine.CaseState)object).nodeName);
                continue;
            }
            if (field instanceof DynamicLine.DataFileValue) {
                object = (DynamicLine.DataFileValue)field;
                element3 = document.createElement(TagDynamicLineDataFileValue);
                element2.appendChild(element3);
                element3.setAttribute("colName", ((DynamicLine.DataFileValue)object).dataColumnName);
                continue;
            }
            if (field instanceof DynamicLine.UserInputValue) {
                object = (DynamicLine.UserInputValue)field;
                element3 = document.createElement(TagDynamicLineUserInputValue);
                element2.appendChild(element3);
                element3.setAttribute(AttDynamicLineUserInputValueFieldName, ((DynamicLine.UserInputValue)object).userFieldName);
                continue;
            }
            object = document.createElement(TagDynamicLineNullField);
            element2.appendChild((Node)object);
        }
        Element element4 = document.createElement(TagDynamicLineRule);
        element2.appendChild(element4);
        ReportTools.toXML(dynamicLine.rule, document, element4);
    }

    public static String reportToXML(Vector<Report> vector) {
        try {
            Object object;
            Object object2;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(TagContent);
            document.appendChild(element);
            HashSet<String> hashSet = new HashSet<String>();
            for (Report object32 : vector) {
                object2 = document.createElement(TagReport);
                while (!hashSet.add(object32.name)) {
                    object32.name = object32.name + "_1";
                }
                object2.setAttribute(AttReportPageSize, "" + object32.getPageSize());
                object2.setAttribute(AttReportName, object32.name);
                element.appendChild((Node)object2);
                object = document.createElement(TagReportHeader);
                object2.appendChild((Node)object);
                if (object32.header != null) {
                    ReportTools.toXML(object32.header, document, (Element)object);
                }
                Element element2 = document.createElement(TagReportFooter);
                object2.appendChild(element2);
                if (object32.footer != null) {
                    ReportTools.toXML(object32.footer, document, element2);
                }
                for (String string : object32.userFields) {
                    Element element3 = document.createElement(TagUserField);
                    element3.setAttribute("name", string);
                }
                for (Section section : object32.sections) {
                    ReportTools.toXML(section, document, (Element)object2);
                }
            }
            document.normalizeDocument();
            DOMSource dOMSource = new DOMSource(document);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            object2 = new StringWriter();
            object = new StreamResult((Writer)object2);
            transformer.transform(dOMSource, (Result)object);
            return ((StringWriter)object2).toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static int parseInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    private static double parseDouble(String string, double d) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return d;
        }
    }

    private static Table XMLToTable(Element element) {
        int n = ReportTools.parseInt(element.getAttribute(AttTableRows), 1);
        int n2 = ReportTools.parseInt(element.getAttribute("cols"), 1);
        Table table = new Table(n, n2);
        NodeList nodeList = element.getChildNodes();
        ArrayList<ReportElement> arrayList = table.getContents();
        arrayList.clear();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = ReportTools.toElement(nodeList.item(i));
            if (element2 == null) continue;
            if (element2.getTagName().equals(TagTableEmptyCell)) {
                arrayList.add(table.createEmptyCell());
                continue;
            }
            ReportElement reportElement = ReportTools.XMLToReportElement(element2);
            if (reportElement == null) continue;
            arrayList.add(reportElement);
        }
        table.setRowsColumns(n, n2);
        return table;
    }

    private static DynamicLine XMLToDynamicLine(Element element) {
        int n = ReportTools.parseInt(element.getAttribute("cols"), 1);
        int n2 = ReportTools.parseInt(element.getAttribute(AttDynamicLineHeaderSettings), 0);
        String string = null;
        int n3 = -1;
        String string2 = null;
        boolean bl = true;
        if (element.hasAttribute(AttDynamicLineSortNodeName) && element.hasAttribute(AttDynamicLineSortStateIndex)) {
            string = element.getAttribute(AttDynamicLineSortNodeName);
            n3 = ReportTools.parseInt(element.getAttribute(AttDynamicLineSortStateIndex), 0);
            bl = Boolean.parseBoolean(element.getAttribute(AttDynamicLineSortAscending));
        } else if (element.hasAttribute(AttDynamicLineSortColumnName)) {
            string2 = element.getAttribute(AttDynamicLineSortColumnName);
            bl = Boolean.parseBoolean(element.getAttribute(AttDynamicLineSortAscending));
        }
        int n4 = ReportTools.parseInt(element.getAttribute(AttDynamicLineMaxLines), 0);
        int n5 = ReportTools.parseInt(element.getAttribute("font"), 0);
        int n6 = ReportTools.parseInt(element.getAttribute(AttDynamicLineFontSize), 12);
        DynamicLine dynamicLine = new DynamicLine();
        dynamicLine.setLineFont(n5, n6);
        dynamicLine.setMaxLines(n4);
        if (string != null) {
            dynamicLine.setSortBeliefNode(string, n3, bl);
        } else if (string2 != null) {
            dynamicLine.setSortColumn(string2, bl);
        }
        dynamicLine.setNumberOfColumns(n);
        dynamicLine.setHeaderSettings(n2);
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        NodeList nodeList = element.getChildNodes();
        block0: for (int i = 0; i < nodeList.getLength(); ++i) {
            int n10;
            Object object;
            Element element2 = ReportTools.toElement(nodeList.item(i));
            if (element2 == null) continue;
            if (element2.getTagName().equals(TagDynamicLineHeaderValue)) {
                object = element2.getAttribute("text");
                dynamicLine.setHeaderString(n7++, (String)object);
                continue;
            }
            if (element2.getTagName().equals(TagDynamicLineColumnWidthValue)) {
                float f = Float.parseFloat(element2.getAttribute(AttDynamicLineColumnWidth));
                dynamicLine.setColWidth(n9++, f);
                continue;
            }
            if (element2.getTagName().equals(TagDynamicLineSingleStateBeliefField)) {
                object = element2.getAttribute("nodeName");
                n10 = ReportTools.parseInt(element2.getAttribute("state"), 0);
                dynamicLine.setField(n8++, dynamicLine.createSingleStateBeliefField((String)object, n10));
                continue;
            }
            if (element2.getTagName().equals(TagDynamicLineHighestBeliefState)) {
                object = element2.getAttribute("nodeName");
                dynamicLine.setField(n8++, dynamicLine.createHighestBeliefState((String)object));
                continue;
            }
            if (element2.getTagName().equals(TagDynamicLineCaseState)) {
                object = element2.getAttribute("nodeName");
                dynamicLine.setField(n8++, dynamicLine.createCaseState((String)object));
                continue;
            }
            if (element2.getTagName().equals(TagDynamicLineDataFileValue)) {
                object = element2.getAttribute("colName");
                dynamicLine.setField(n8++, dynamicLine.createDataFileValue((String)object));
                continue;
            }
            if (element2.getTagName().equals(TagDynamicLineUserInputValue)) {
                object = element2.getAttribute(AttDynamicLineUserInputValueFieldName);
                dynamicLine.setField(n8++, dynamicLine.createUserInputValue((String)object));
                continue;
            }
            if (element2.getTagName().equals(TagDynamicLineNullField)) {
                dynamicLine.setField(n8++, null);
                continue;
            }
            if (!element2.getTagName().equals(TagDynamicLineRule)) continue;
            object = element2.getChildNodes();
            for (n10 = 0; n10 < object.getLength(); ++n10) {
                Element element3 = ReportTools.toElement(object.item(n10));
                if (element3 == null) continue;
                DynamicLine.InclusionRule inclusionRule = ReportTools.XMLToDynamicLineRule(element3, dynamicLine);
                if (inclusionRule == null) continue block0;
                dynamicLine.setRule(inclusionRule);
                continue block0;
            }
        }
        return dynamicLine;
    }

    private static DynamicLine.InclusionRule XMLToDynamicLineRule(Element element, DynamicLine dynamicLine) {
        if (element.getTagName().equals(TagDynamicLineEverythingRule)) {
            return dynamicLine.createEverythingRule();
        }
        if (element.getTagName().equals(TagDynamicLineBeliefRule)) {
            String string = element.getAttribute("nodeName");
            int n = ReportTools.parseInt(element.getAttribute("state"), 0);
            double d = ReportTools.parseDouble(element.getAttribute(AttDynamicLineBeliefRuleThreshold), 0.5);
            return dynamicLine.createBeliefRule(string, n, d);
        }
        if (element.getTagName().equals(TagDynamicLineDataFileValueEquals)) {
            String string = element.getAttribute("colName");
            String string2 = element.getAttribute(AttDynamicLineDataFileValueEqualsValue);
            return dynamicLine.createDataFileValueEquals(string, string2);
        }
        if (element.getTagName().equals(TagDynamicLineAndRule)) {
            DynamicLine.InclusionRule inclusionRule = null;
            DynamicLine.InclusionRule inclusionRule2 = null;
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = ReportTools.toElement(nodeList.item(i));
                if (element2 != null && inclusionRule == null) {
                    inclusionRule = ReportTools.XMLToDynamicLineRule(element2, dynamicLine);
                    continue;
                }
                if (element2 == null || inclusionRule2 != null) continue;
                inclusionRule2 = ReportTools.XMLToDynamicLineRule(element2, dynamicLine);
            }
            return dynamicLine.createAndRule(inclusionRule, inclusionRule2);
        }
        if (element.getTagName().equals(TagDynamicLineOrRule)) {
            DynamicLine.InclusionRule inclusionRule = null;
            DynamicLine.InclusionRule inclusionRule3 = null;
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element3 = ReportTools.toElement(nodeList.item(i));
                if (element3 != null && inclusionRule == null) {
                    inclusionRule = ReportTools.XMLToDynamicLineRule(element3, dynamicLine);
                    continue;
                }
                if (element3 == null || inclusionRule3 != null) continue;
                inclusionRule3 = ReportTools.XMLToDynamicLineRule(element3, dynamicLine);
            }
            return dynamicLine.createOrRule(inclusionRule, inclusionRule3);
        }
        if (element.getTagName().equals(TagDynamicLineNegateRule)) {
            DynamicLine.InclusionRule inclusionRule = null;
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element4 = ReportTools.toElement(nodeList.item(i));
                if (element4 == null || inclusionRule != null) continue;
                inclusionRule = ReportTools.XMLToDynamicLineRule(element4, dynamicLine);
            }
            return dynamicLine.createNegateRule(inclusionRule);
        }
        if (element.getTagName().equals(TagDynamicLineDataValueLessThan)) {
            String string = element.getAttribute("colName");
            String string3 = element.getAttribute(AttDynamicLineDataFileValueGreaterLessValue);
            return dynamicLine.createDataFileValueLessThan(string, string3);
        }
        if (element.getTagName().equals(TagDynamicLineDataValueGreaterThan)) {
            String string = element.getAttribute("colName");
            String string4 = element.getAttribute(AttDynamicLineDataFileValueGreaterLessValue);
            return dynamicLine.createDataFileValueGreaterThan(string, string4);
        }
        return null;
    }

    private static Section XMLToSection(Element element) {
        Section section = new Section();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Element element2 = ReportTools.toElement(nodeList.item(i));
            if (element2 != null && section.description == null && element2.getTagName().equals(TagSectionDescription)) {
                object = element2.getChildNodes();
                for (int j = 0; j < object.getLength(); ++j) {
                    Table table;
                    Element element3 = ReportTools.toElement(object.item(j));
                    if (element3 == null || !element3.getTagName().equals(TagTable) || (table = ReportTools.XMLToTable(element3)) == null) continue;
                    section.setDescription(table);
                }
            }
            if (element2 == null || section.dynLine != null || !element2.getTagName().equals(TagDynamicLine) || (object = ReportTools.XMLToDynamicLine(element2)) == null) continue;
            section.setLine((DynamicLine)object);
        }
        return section;
    }

    private static UserInput XMLToUserInput(Element element) {
        String string = element.getAttribute("name");
        int n = ReportTools.parseInt(element.getAttribute("font"), 0);
        int n2 = ReportTools.parseInt(element.getAttribute(AttTextLabelSize), 12);
        int n3 = ReportTools.parseInt(element.getAttribute(AttAlignment), 0);
        UserInput userInput = new UserInput(string, n, n2);
        userInput.setAlignment(n3);
        return userInput;
    }

    private static AutoField XMLToAutoField(Element element) {
        int n = ReportTools.parseInt(element.getAttribute(AttAutoFieldType), 0);
        int n2 = ReportTools.parseInt(element.getAttribute("font"), 0);
        int n3 = ReportTools.parseInt(element.getAttribute(AttTextLabelSize), 12);
        int n4 = ReportTools.parseInt(element.getAttribute(AttAlignment), 0);
        AutoField autoField = new AutoField(n, n2, n3);
        autoField.setAlignment(n4);
        return autoField;
    }

    private static TextLabel XMLToTextLabel(Element element) {
        String string = element.getAttribute("text");
        int n = ReportTools.parseInt(element.getAttribute("font"), 0);
        int n2 = ReportTools.parseInt(element.getAttribute(AttTextLabelSize), 12);
        int n3 = ReportTools.parseInt(element.getAttribute(AttAlignment), 0);
        TextLabel textLabel = new TextLabel(string, n, n2);
        textLabel.setAlignment(n3);
        return textLabel;
    }

    private static ReportElement XMLToReportElement(Element element) {
        if (element.getTagName().equals(TagTable)) {
            return ReportTools.XMLToTable(element);
        }
        if (element.getTagName().equals(TagSection)) {
            return ReportTools.XMLToSection(element);
        }
        if (element.getTagName().equals(TagTextLabel)) {
            return ReportTools.XMLToTextLabel(element);
        }
        if (element.getTagName().equals(TagUserInput)) {
            return ReportTools.XMLToUserInput(element);
        }
        if (element.getTagName().equals(TagAutoField)) {
            return ReportTools.XMLToAutoField(element);
        }
        if (element.getTagName().equals(TagDynamicLine)) {
            return ReportTools.XMLToDynamicLine(element);
        }
        return null;
    }

    public static Vector<Report> XMLToReport(String string, Network network) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            Vector<Report> vector = new Vector<Report>();
            Element element = (Element)document.getElementsByTagName(TagContent).item(0);
            NodeList nodeList = element.getElementsByTagName(TagReport);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string2 = element2.getAttribute(AttReportName);
                int n = ReportTools.parseInt(element2.getAttribute(AttReportPageSize), 0);
                Report report = new Report(string2);
                report.setPageSize(n);
                vector.add(report);
                NodeList nodeList2 = element2.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    try {
                        ReportElement reportElement;
                        Element element3;
                        int n2;
                        Object object;
                        Element element4 = ReportTools.toElement(nodeList2.item(j));
                        if (element4 != null && element4.getTagName().equals(TagUserField)) {
                            report.userFields.add(element4.getAttribute("name"));
                        }
                        if (element4 != null && element4.getTagName().equals(TagReportHeader)) {
                            object = element4.getChildNodes();
                            for (n2 = 0; n2 < object.getLength(); ++n2) {
                                element3 = ReportTools.toElement(object.item(n2));
                                if (element3 == null || (reportElement = ReportTools.XMLToReportElement(element3)) == null) continue;
                                report.setHeader(reportElement);
                                break;
                            }
                        }
                        if (element4 != null && element4.getTagName().equals(TagReportFooter)) {
                            object = element4.getChildNodes();
                            for (n2 = 0; n2 < object.getLength(); ++n2) {
                                element3 = ReportTools.toElement(object.item(n2));
                                if (element3 == null || (reportElement = ReportTools.XMLToReportElement(element3)) == null) continue;
                                report.setFooter(reportElement);
                                break;
                            }
                        }
                        if (element4 == null || !element4.getTagName().equals(TagSection) || (object = ReportTools.XMLToSection(element4)) == null) continue;
                        report.addSection((Section)object);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            return vector;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Vector<Report> vector = new Vector<Report>();
            vector.add(new Report("empty"));
            return vector;
        }
    }

    public static void generateReport(Object object, final Vector<Report> vector, final CaseSet caseSet, final BeliefEngine beliefEngine, final Network network) {
        final JDialog jDialog = object instanceof Frame ? new JDialog((Frame)object) : (object instanceof Dialog ? new JDialog((Dialog)object) : new JDialog());
        jDialog.setDefaultCloseOperation(2);
        jDialog.setTitle("Generate report");
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        JPanel jPanel2 = new JPanel();
        jPanel.add(jPanel2);
        jPanel2.add(new JLabel("Choose report"));
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = vector.elementAt(i).getName();
        }
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jPanel2.add(jComboBox);
        JPanel jPanel3 = new JPanel();
        jPanel.add(jPanel3);
        jPanel3.add(new JLabel("Save as"));
        final JTextField jTextField = new JTextField("", 20);
        jPanel3.add(jTextField);
        final JButton jButton = new JButton("Select");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextField.getText();
                if (string.length() == 0) {
                    string = System.getProperty("user.dir");
                }
                JFileChooser jFileChooser = new JFileChooser(string);
                FileFilter fileFilter = new FileFilter(){

                    public boolean accept(File file) {
                        if (file.getName().toLowerCase().endsWith(".pdf")) {
                            return true;
                        }
                        return file.isDirectory();
                    }

                    public String getDescription() {
                        return "PDF (Portable Document Format)";
                    }
                };
                jFileChooser.setFileFilter(fileFilter);
                int n = jFileChooser.showOpenDialog(jDialog);
                if (n == 0) {
                    String string2 = jFileChooser.getSelectedFile().getPath();
                    if (!string2.toLowerCase().endsWith(".pdf")) {
                        string2 = string2 + ".pdf";
                    }
                    jTextField.setText(string2);
                }
            }
        });
        jPanel3.add(jButton);
        JPanel jPanel4 = new JPanel();
        jPanel.add(jPanel4);
        final JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        final JButton jButton3 = new JButton("Generate");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                final Report report = (Report)vector.elementAt(jComboBox.getSelectedIndex());
                final String string = jTextField.getText();
                File file = new File(string);
                if (file.exists() && (n = JOptionPane.showConfirmDialog(jDialog, "This file already exists. Replace?", "Saving", 0)) != 0) {
                    return;
                }
                if (string.length() == 0) {
                    JOptionPane.showMessageDialog(jDialog, "No file selected", "Message", 1);
                } else {
                    final RequestUserInput requestUserInput = new RequestUserInput(report);
                    requestUserInput.prompt();
                    jButton3.setEnabled(false);
                    jButton.setEnabled(false);
                    jComboBox.setEnabled(false);
                    jTextField.setEnabled(false);
                    final Batch batch = new Batch(network, beliefEngine, report.getResultNodesForBatch(network), caseSet);
                    for (ActionListener actionListener : jButton2.getActionListeners()) {
                        jButton2.removeActionListener(actionListener);
                    }
                    jButton2.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            batch.stop();
                        }
                    });
                    Runnable runnable = new Runnable(){

                        public void run() {
                            if (report.generate(string, caseSet, batch, requestUserInput.getUserInput())) {
                                try {
                                    File file = new File(string);
                                    ReportTools.launchFile(file);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            } else {
                                JOptionPane.showMessageDialog(jDialog, "Report generation failed.", "Failed", 0);
                            }
                            jDialog.dispose();
                        }
                    };
                    Thread thread = new Thread(runnable);
                    thread.start();
                }
            }
        });
        jPanel4.add(jButton3);
        jPanel4.add(jButton2);
        jDialog.add(jPanel);
        jDialog.pack();
        if (object instanceof Component) {
            jDialog.setLocationRelativeTo((Component)object);
        }
        jDialog.setVisible(true);
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("windows") != -1 || string.indexOf("nt") != -1;
    }

    public static boolean isMac() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("mac") != -1;
    }

    public static boolean isLinux() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("linux") != -1;
    }

    public static void launchFile(File file) throws IOException {
        String string = file.getPath();
        if (ReportTools.isLinux()) {
            Runtime.getRuntime().exec(String.format("gnome-open %s", string));
        } else if (ReportTools.isMac()) {
            Runtime.getRuntime().exec(String.format("open %s", string));
        } else if (ReportTools.isWindows()) {
            Runtime.getRuntime().exec("cmd /C \"start /D\"" + file.getParent() + "\" \"" + file.getName() + "\" \"" + file.getName() + "\"\"");
        }
    }
}

