<?xml version="1.0" encoding="UTF-8"?>

<!--
    Document   : ab2html.xsl
    Created on : March 31, 2009, 10:15 AM
    Author     : tomp
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="html"/>

    <xsl:template match="/people">
        <html>
            <head>
                <title>Contacts</title>
            </head>
            <body>
                <h1>Contacts</h1>
                <xsl:apply-templates mode="links"/>
                <hr/>
                <h2>People</h2>
                <xsl:apply-templates select="person"/>
                <h2>Companies</h2>
                <xsl:apply-templates select="company"/>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="person|company" mode="links">
        [<a href="#{@id}">
            <xsl:value-of select="@id"/>
        </a>]
    </xsl:template>

    <xsl:template match="person[@id]|company[@id]">
        <p><a name="{@id}"/>
            <xsl:value-of select="text()"/>
            (<xsl:value-of select="@id"/>)
        </p>
    </xsl:template>

    <xsl:template match="person|company" priority="100">
        <p>
            <xsl:value-of select="text()"/>
        </p>
    </xsl:template>

</xsl:stylesheet>
