/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HAPI;

import COM.hugin.HAPI.Clique;
import COM.hugin.HAPI.CliqueList;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.Native.HAPI;

public class JunctionTree {
    protected int jtPeer = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    private JunctionTree(int n) throws ExceptionHugin {
        if (!$assertionsDisabled && n == 0) {
            throw new AssertionError();
        }
        this.jtPeer = n;
        ExceptionHugin.throwException(HAPI.nativeHAPI.hJTSetBackpointer(n, this));
    }

    protected static JunctionTree convert(int n) throws ExceptionHugin {
        if (n == 0) {
            ExceptionHugin.throwException();
            return null;
        }
        JunctionTree junctionTree = (JunctionTree)HAPI.nativeHAPI.hJTGetBackpointer(n);
        if (junctionTree != null) {
            return junctionTree;
        }
        return new JunctionTree(n);
    }

    public boolean cgEvidenceIsPropagated() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hJTCGEvidenceIsPropagated(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public boolean equilibriumIs(Domain.Equilibrium equilibrium) throws ExceptionHugin {
        if (equilibrium == null) {
            throw new ExceptionUsage("Argument 'equilibrium' is 'null'");
        }
        boolean bl = HAPI.nativeHAPI.hJTEquilibriumIs(this.thisPeer(), equilibrium.value);
        ExceptionHugin.throwException();
        return bl;
    }

    public boolean evidenceIsPropagated() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hJTEvidenceIsPropagated(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public boolean evidenceModeIs(Domain.EvidenceMode evidenceMode) throws ExceptionHugin {
        if (evidenceMode == null) {
            throw new ExceptionUsage("Argument 'mode' is 'null'");
        }
        boolean bl = HAPI.nativeHAPI.hJTEvidenceModeIs(this.thisPeer(), evidenceMode.value);
        ExceptionHugin.throwException();
        return bl;
    }

    public boolean evidenceToPropagate() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hJTEvidenceToPropagate(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public CliqueList getCliques() throws ExceptionHugin {
        return new CliqueList(HAPI.nativeHAPI.hJTGetCliques(this.thisPeer()));
    }

    public double getConflict() throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hJTGetConflict(this.thisPeer());
        if (d < 0.0) {
            ExceptionHugin.throwException();
        }
        return d;
    }

    public Clique getRoot() throws ExceptionHugin {
        return Clique.convert(HAPI.nativeHAPI.hJTGetRoot(this.thisPeer()));
    }

    public long getTotalSize() throws ExceptionHugin {
        long l = HAPI.nativeHAPI.hJTGetTotalSize(this.thisPeer());
        ExceptionHugin.throwException();
        return l;
    }

    public long getTotalCGSize() throws ExceptionHugin {
        long l = HAPI.nativeHAPI.hJTGetTotalCGSize(this.thisPeer());
        ExceptionHugin.throwException();
        return l;
    }

    public boolean likelihoodIsPropagated() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hJTLikelihoodIsPropagated(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public void propagate(Domain.Equilibrium equilibrium, Domain.EvidenceMode evidenceMode) throws ExceptionHugin {
        if (equilibrium == null || evidenceMode == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        ExceptionHugin.throwException(HAPI.nativeHAPI.hJTPropagate(this.thisPeer(), equilibrium.value, evidenceMode.value));
    }

    public boolean tablesToPropagate() throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hJTTablesToPropagate(this.thisPeer());
        ExceptionHugin.throwException();
        return bl;
    }

    public boolean isAlive() {
        return this.jtPeer != 0;
    }

    private int thisPeer() throws ExceptionObjectNotAlive {
        if (this.jtPeer == 0) {
            throw new ExceptionObjectNotAlive();
        }
        return this.jtPeer;
    }

    static {
        $assertionsDisabled = !JunctionTree.class.desiredAssertionStatus();
    }
}

