/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HAPI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HAPI.Native.HAPI;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.UncertainEdge;
import COM.hugin.HAPI.UncertainEdgeList;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmbiguousRegion {
    protected NetworkModel belongsTo = null;
    protected int ambiguousRegionPeer = 0;
    protected UncertainEdgeList edges = null;

    protected AmbiguousRegion(NetworkModel networkModel, int n) throws ExceptionHugin {
        this.belongsTo = networkModel;
        this.ambiguousRegionPeer = n;
        this.createEdgeList();
    }

    public UncertainEdgeList getEdges() throws ExceptionHugin {
        if (!this.isAlive()) {
            throw new ExceptionObjectNotAlive();
        }
        return this.edges;
    }

    protected UncertainEdgeList createEdgeList() throws ExceptionHugin {
        int n;
        if (!this.isAlive()) {
            throw new ExceptionObjectNotAlive();
        }
        int n2 = HAPI.nativeHAPI.hAmbiguousRegionGetEdges(this.ambiguousRegionPeer);
        if (n2 == 0) {
            ExceptionHugin.throwException();
        }
        UncertainEdgeList uncertainEdgeList = new UncertainEdgeList();
        int n3 = 0;
        while ((n = HAPI.nativeHAPI.hListGetItem(n2, n3)) != 0) {
            Node node = Node.convert(HAPI.nativeHAPI.hUncertainEdgeGetFirstNode(n));
            Node node2 = Node.convert(HAPI.nativeHAPI.hUncertainEdgeGetSecondNode(n));
            uncertainEdgeList.add(new UncertainEdge(this, node, node2, n));
            ++n3;
        }
        this.edges = uncertainEdgeList;
        return uncertainEdgeList;
    }

    public boolean isAlive() {
        return this.ambiguousRegionPeer != 0;
    }

    private void setNotAlive() {
        this.ambiguousRegionPeer = 0;
    }

    protected void delete() throws ExceptionHugin {
        if (!this.isAlive()) {
            throw new ExceptionObjectNotAlive();
        }
        for (UncertainEdge uncertainEdge : this.edges) {
            uncertainEdge.setNotAlive();
        }
        this.setNotAlive();
    }

    protected void updateEdgeList() throws ExceptionHugin {
        int n;
        if (!this.isAlive()) {
            throw new ExceptionObjectNotAlive();
        }
        int n2 = HAPI.nativeHAPI.hAmbiguousRegionGetEdges(this.ambiguousRegionPeer);
        if (n2 == 0) {
            ExceptionHugin.throwException();
        }
        for (Object object : (UncertainEdgeList)this.edges.clone()) {
            int n3 = 0;
            while ((n = HAPI.nativeHAPI.hListGetItem(n2, n3)) != 0 && n != ((UncertainEdge)object).uncertainEdgePeer) {
                ++n3;
            }
            if (n == ((UncertainEdge)object).uncertainEdgePeer) continue;
            this.edges.remove(object);
            ((UncertainEdge)object).setNotAlive();
        }
        int n4 = 0;
        while ((n = HAPI.nativeHAPI.hListGetItem(n2, n4)) != 0) {
            if (this.edges.findUncertainEdge(n) == null) {
                Object object;
                object = Node.convert(HAPI.nativeHAPI.hUncertainEdgeGetFirstNode(n));
                Node node = Node.convert(HAPI.nativeHAPI.hUncertainEdgeGetSecondNode(n));
                this.edges.add(new UncertainEdge(this, (Node)object, node, n));
            }
            ++n4;
        }
    }

    public LinkedList<UncertainEdgeList> getMinimalSolutions() throws ExceptionHugin {
        if (!this.isAlive()) {
            throw new ExceptionObjectNotAlive();
        }
        if (HAPI.nativeHAPI.hAmbiguousRegionFindMinimalSolutions(this.ambiguousRegionPeer) == 0) {
            ExceptionHugin.throwException();
        }
        LinkedList<UncertainEdgeList> linkedList = new LinkedList<UncertainEdgeList>();
        int n = HAPI.nativeHAPI.hAmbiguousRegionGetFirstSolution(this.ambiguousRegionPeer);
        while (n != 0) {
            int n2;
            UncertainEdgeList uncertainEdgeList = new UncertainEdgeList();
            int n3 = HAPI.nativeHAPI.hSolutionGetEdges(n);
            if (n3 == 0) {
                ExceptionHugin.throwException();
            }
            int n4 = 0;
            while ((n2 = HAPI.nativeHAPI.hListGetItem(n3, n4)) != 0) {
                uncertainEdgeList.add(this.edges.findUncertainEdge(n2));
                ++n4;
            }
            linkedList.add(uncertainEdgeList);
            n = HAPI.nativeHAPI.hSolutionGetNext(n);
        }
        return linkedList;
    }
}

