/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HAPI;

import COM.hugin.HAPI.AbsExpression;
import COM.hugin.HAPI.AddExpression;
import COM.hugin.HAPI.AndExpression;
import COM.hugin.HAPI.BetaDistribution;
import COM.hugin.HAPI.BinomialDistribution;
import COM.hugin.HAPI.BooleanExpression;
import COM.hugin.HAPI.CeilExpression;
import COM.hugin.HAPI.CosExpression;
import COM.hugin.HAPI.CoshExpression;
import COM.hugin.HAPI.DistributionDistribution;
import COM.hugin.HAPI.DivideExpression;
import COM.hugin.HAPI.EqualsExpression;
import COM.hugin.HAPI.ExceptionArgumentNotAlive;
import COM.hugin.HAPI.ExceptionError;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.ExpExpression;
import COM.hugin.HAPI.ExponentialDistribution;
import COM.hugin.HAPI.ExpressionList;
import COM.hugin.HAPI.FloorExpression;
import COM.hugin.HAPI.GammaDistribution;
import COM.hugin.HAPI.GeometricDistribution;
import COM.hugin.HAPI.GreaterThanExpression;
import COM.hugin.HAPI.GreaterThanOrEqualsExpression;
import COM.hugin.HAPI.IfExpression;
import COM.hugin.HAPI.LabelExpression;
import COM.hugin.HAPI.LessThanExpression;
import COM.hugin.HAPI.LessThanOrEqualsExpression;
import COM.hugin.HAPI.Log10Expression;
import COM.hugin.HAPI.Log2Expression;
import COM.hugin.HAPI.LogExpression;
import COM.hugin.HAPI.LogNormalDistribution;
import COM.hugin.HAPI.MaxExpression;
import COM.hugin.HAPI.MinExpression;
import COM.hugin.HAPI.ModExpression;
import COM.hugin.HAPI.Model;
import COM.hugin.HAPI.MultiplyExpression;
import COM.hugin.HAPI.Native.HAPI;
import COM.hugin.HAPI.NegateExpression;
import COM.hugin.HAPI.NegativeBinomialDistribution;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeExpression;
import COM.hugin.HAPI.NoisyOrDistribution;
import COM.hugin.HAPI.NormalDistribution;
import COM.hugin.HAPI.NotEqualsExpression;
import COM.hugin.HAPI.NotExpression;
import COM.hugin.HAPI.NumberExpression;
import COM.hugin.HAPI.OrExpression;
import COM.hugin.HAPI.PERTDistribution;
import COM.hugin.HAPI.ParseListener;
import COM.hugin.HAPI.PoissonDistribution;
import COM.hugin.HAPI.PowerExpression;
import COM.hugin.HAPI.SinExpression;
import COM.hugin.HAPI.SinhExpression;
import COM.hugin.HAPI.SqrtExpression;
import COM.hugin.HAPI.SubtractExpression;
import COM.hugin.HAPI.TanExpression;
import COM.hugin.HAPI.TanhExpression;
import COM.hugin.HAPI.TriangularDistribution;
import COM.hugin.HAPI.TruncateExpression;
import COM.hugin.HAPI.UniformDistribution;
import COM.hugin.HAPI.WeibullDistribution;

public abstract class Expression {
    public static final int H_OPERATOR_NORMAL = 60;
    public static final int H_OPERATOR_LOGNORMAL = 61;
    public static final int H_OPERATOR_BETA = 62;
    public static final int H_OPERATOR_GAMMA = 63;
    public static final int H_OPERATOR_EXPONENTIAL = 64;
    public static final int H_OPERATOR_WEIBULL = 65;
    public static final int H_OPERATOR_UNIFORM = 66;
    public static final int H_OPERATOR_TRIANGULAR = 67;
    public static final int H_OPERATOR_PERT = 68;
    public static final int H_OPERATOR_BINOMIAL = 69;
    public static final int H_OPERATOR_POISSON = 70;
    public static final int H_OPERATOR_NEGATIVEBINOMIAL = 71;
    public static final int H_OPERATOR_GEOMETRIC = 72;
    public static final int H_OPERATOR_DISTRIBUTION = 73;
    public static final int H_OPERATOR_NOISYOR = 74;
    public static final int H_OPERATOR_TRUNCATE = 75;
    public static final int H_OPERATOR_MIN = 76;
    public static final int H_OPERATOR_MAX = 77;
    public static final int H_OPERATOR_LOG = 78;
    public static final int H_OPERATOR_LOG2 = 79;
    public static final int H_OPERATOR_LOG10 = 80;
    public static final int H_OPERATOR_EXP = 81;
    public static final int H_OPERATOR_SIN = 82;
    public static final int H_OPERATOR_COS = 83;
    public static final int H_OPERATOR_TAN = 84;
    public static final int H_OPERATOR_SINH = 85;
    public static final int H_OPERATOR_COSH = 86;
    public static final int H_OPERATOR_TANH = 87;
    public static final int H_OPERATOR_SQRT = 88;
    public static final int H_OPERATOR_ABS = 89;
    public static final int H_OPERATOR_FLOOR = 90;
    public static final int H_OPERATOR_CEIL = 91;
    public static final int H_OPERATOR_MOD = 92;
    public static final int H_OPERATOR_IF = 93;
    public static final int H_OPERATOR_AND = 94;
    public static final int H_OPERATOR_OR = 95;
    public static final int H_OPERATOR_NOT = 96;
    public static final int H_OPERATOR_ADD = 97;
    public static final int H_OPERATOR_SUBTRACT = 98;
    public static final int H_OPERATOR_MULTIPLY = 99;
    public static final int H_OPERATOR_DIVIDE = 100;
    public static final int H_OPERATOR_POWER = 101;
    public static final int H_OPERATOR_NEGATE = 102;
    public static final int H_OPERATOR_EQUALS = 103;
    public static final int H_OPERATOR_LESS_THAN = 104;
    public static final int H_OPERATOR_GREATER_THAN = 105;
    public static final int H_OPERATOR_NOT_EQUALS = 106;
    public static final int H_OPERATOR_LESS_THAN_OR_EQUALS = 107;
    public static final int H_OPERATOR_GREATER_THAN_OR_EQUALS = 108;
    public static final int H_OPERATOR_NUMBER = 109;
    public static final int H_OPERATOR_LABEL = 110;
    public static final int H_OPERATOR_NODE = 111;
    public static final int H_OPERATOR_BOOLEAN = 112;

    protected Expression() {
    }

    public static Expression stringToExpression(String string, Model model, ParseListener parseListener) throws ExceptionHugin {
        if (string == null || model == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        if (!model.isAlive()) {
            throw new ExceptionArgumentNotAlive();
        }
        if (string.length() == 0) {
            return null;
        }
        return Expression.fromNativeToJava(HAPI.nativeHAPI.hStringParseExpression(string, model.modelPeer, parseListener));
    }

    public static Expression stringToExpression(String string, NetworkModel networkModel, ParseListener parseListener) throws ExceptionHugin {
        if (string == null || networkModel == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        if (!networkModel.isAlive()) {
            throw new ExceptionArgumentNotAlive();
        }
        if (string.length() == 0) {
            return null;
        }
        return Expression.fromNativeToJava(HAPI.nativeHAPI.hDomainStringToExpression(networkModel.modelPeer, string, parseListener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Expression fromNativeToJava(int n) throws ExceptionHugin {
        if (n != 0) {
            try {
                Expression expression = Expression.hExpressionToExpression(n);
                return expression;
            }
            finally {
                HAPI.nativeHAPI.hExpressionDelete(n);
            }
        }
        ExceptionHugin.throwException();
        return null;
    }

    protected static Expression hExpressionToExpression(int n) throws ExceptionHugin {
        if (n == 0) {
            return null;
        }
        int n2 = HAPI.nativeHAPI.hExpressionGetOperator(n);
        ExceptionHugin.throwException();
        if (HAPI.nativeHAPI.hExpressionIsComposite(n)) {
            ExceptionHugin.throwException();
            int n3 = HAPI.nativeHAPI.hExpressionGetOperands(n);
            if (n3 == 0) {
                ExceptionHugin.throwException();
            }
            ExpressionList expressionList = Expression.hExpressionsToExpressions(n3);
            switch (n2) {
                case 60: {
                    return new NormalDistribution(expressionList);
                }
                case 61: {
                    return new LogNormalDistribution(expressionList);
                }
                case 62: {
                    return new BetaDistribution(expressionList);
                }
                case 63: {
                    return new GammaDistribution(expressionList);
                }
                case 64: {
                    return new ExponentialDistribution(expressionList);
                }
                case 65: {
                    return new WeibullDistribution(expressionList);
                }
                case 66: {
                    return new UniformDistribution(expressionList);
                }
                case 67: {
                    return new TriangularDistribution(expressionList);
                }
                case 68: {
                    return new PERTDistribution(expressionList);
                }
                case 69: {
                    return new BinomialDistribution(expressionList);
                }
                case 70: {
                    return new PoissonDistribution(expressionList);
                }
                case 71: {
                    return new NegativeBinomialDistribution(expressionList);
                }
                case 72: {
                    return new GeometricDistribution(expressionList);
                }
                case 73: {
                    return new DistributionDistribution(expressionList);
                }
                case 74: {
                    return new NoisyOrDistribution(expressionList);
                }
                case 75: {
                    return new TruncateExpression(expressionList);
                }
                case 76: {
                    return new MinExpression(expressionList);
                }
                case 77: {
                    return new MaxExpression(expressionList);
                }
                case 78: {
                    return new LogExpression(expressionList);
                }
                case 79: {
                    return new Log2Expression(expressionList);
                }
                case 80: {
                    return new Log10Expression(expressionList);
                }
                case 81: {
                    return new ExpExpression(expressionList);
                }
                case 82: {
                    return new SinExpression(expressionList);
                }
                case 83: {
                    return new CosExpression(expressionList);
                }
                case 84: {
                    return new TanExpression(expressionList);
                }
                case 85: {
                    return new SinhExpression(expressionList);
                }
                case 86: {
                    return new CoshExpression(expressionList);
                }
                case 87: {
                    return new TanhExpression(expressionList);
                }
                case 88: {
                    return new SqrtExpression(expressionList);
                }
                case 89: {
                    return new AbsExpression(expressionList);
                }
                case 90: {
                    return new FloorExpression(expressionList);
                }
                case 91: {
                    return new CeilExpression(expressionList);
                }
                case 92: {
                    return new ModExpression(expressionList);
                }
                case 93: {
                    return new IfExpression(expressionList);
                }
                case 94: {
                    return new AndExpression(expressionList);
                }
                case 95: {
                    return new OrExpression(expressionList);
                }
                case 96: {
                    return new NotExpression(expressionList);
                }
                case 97: {
                    return new AddExpression(expressionList);
                }
                case 98: {
                    return new SubtractExpression(expressionList);
                }
                case 99: {
                    return new MultiplyExpression(expressionList);
                }
                case 100: {
                    return new DivideExpression(expressionList);
                }
                case 101: {
                    return new PowerExpression(expressionList);
                }
                case 102: {
                    return new NegateExpression(expressionList);
                }
                case 103: {
                    return new EqualsExpression(expressionList);
                }
                case 104: {
                    return new LessThanExpression(expressionList);
                }
                case 105: {
                    return new GreaterThanExpression(expressionList);
                }
                case 106: {
                    return new NotEqualsExpression(expressionList);
                }
                case 107: {
                    return new LessThanOrEqualsExpression(expressionList);
                }
                case 108: {
                    return new GreaterThanOrEqualsExpression(expressionList);
                }
            }
            throw new ExceptionError();
        }
        switch (n2) {
            case 110: {
                String string = HAPI.nativeHAPI.hExpressionGetLabel(n);
                if (string == null) {
                    ExceptionHugin.throwException();
                }
                return new LabelExpression(string);
            }
            case 109: {
                double d = HAPI.nativeHAPI.hExpressionGetNumber(n);
                ExceptionHugin.throwException();
                return new NumberExpression(d);
            }
            case 111: {
                return new NodeExpression(Node.convert(HAPI.nativeHAPI.hExpressionGetNode(n)));
            }
            case 112: {
                boolean bl = HAPI.nativeHAPI.hExpressionGetBoolean(n);
                ExceptionHugin.throwException();
                return new BooleanExpression(bl);
            }
        }
        throw new ExceptionError();
    }

    public boolean isCompositeExpression() {
        return false;
    }

    public boolean isConstantExpression() {
        return false;
    }

    public boolean isNodeExpression() {
        return false;
    }

    public String expressionToString() throws ExceptionHugin {
        String string = HAPI.nativeHAPI.hExpressionToString(this.toNative());
        if (string == null) {
            ExceptionHugin.throwException();
        }
        assert (string != null);
        return string;
    }

    private static ExpressionList hExpressionsToExpressions(int n) throws ExceptionHugin {
        int n2;
        assert (n != 0);
        ExpressionList expressionList = new ExpressionList();
        int n3 = 0;
        while ((n2 = HAPI.nativeHAPI.hListGetItem(n, n3)) != 0) {
            expressionList.add(Expression.hExpressionToExpression(n2));
            ++n3;
        }
        return expressionList;
    }

    public abstract int getOperator();

    public Object clone() {
        return this;
    }

    public void delete() {
    }

    protected abstract int toNative() throws ExceptionHugin;
}

