/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HAPI;

import COM.hugin.HAPI.ExceptionArgumentNotAlive;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.Expression;
import COM.hugin.HAPI.Native.HAPI;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.ParseListener;

public class Model {
    protected int modelPeer = 0;

    public Model(Node node, NodeList nodeList) throws ExceptionHugin {
        if (node == null || nodeList == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        if (!node.isAlive()) {
            throw new ExceptionArgumentNotAlive();
        }
        int n = NetworkModel.convertNodeList(nodeList);
        this.modelPeer = HAPI.nativeHAPI.hNodeNewModel(node.nodePeer, n);
        HAPI.nativeHAPI.hListDelete(n);
        if (this.modelPeer == 0) {
            ExceptionHugin.throwException();
        }
        ExceptionHugin.throwException(HAPI.nativeHAPI.hModelSetBackpointer(this.modelPeer, this));
    }

    protected Model(int n) throws ExceptionHugin {
        assert (n != 0);
        this.modelPeer = n;
        ExceptionHugin.throwException(HAPI.nativeHAPI.hModelSetBackpointer(n, this));
    }

    public void delete() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hModelDelete(this.thisPeer()));
        assert (!this.isAlive());
    }

    public NodeList getNodes() throws ExceptionHugin {
        return new NodeList(HAPI.nativeHAPI.hModelGetNodes(this.thisPeer()));
    }

    public int getSize() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hModelGetSize(this.thisPeer());
        ExceptionHugin.throwException();
        return n;
    }

    public void setExpression(int n, Expression expression) throws ExceptionHugin {
        int n2 = this.thisPeer();
        int n3 = 0;
        if (expression != null) {
            n3 = expression.toNative();
        }
        ExceptionHugin.throwException(HAPI.nativeHAPI.hModelSetExpression(n2, n, n3));
    }

    public void setExpression(int n, String string, ParseListener parseListener) throws ExceptionHugin {
        int n2 = this.thisPeer();
        if (string == null || string.length() == 0) {
            ExceptionHugin.throwException(HAPI.nativeHAPI.hModelSetExpression(n2, n, 0));
        } else {
            ExceptionHugin.throwException(HAPI.nativeHAPI.hModelSetExpressionFromString(n2, n, string, parseListener));
        }
    }

    public Expression getExpression(int n) throws ExceptionHugin {
        int n2 = HAPI.nativeHAPI.hModelGetExpression(this.thisPeer(), n);
        if (n2 != 0) {
            return Expression.hExpressionToExpression(n2);
        }
        ExceptionHugin.throwException();
        return null;
    }

    public void setNumberOfSamplesPerInterval(int n) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hModelSetNumberOfSamplesPerInterval(this.thisPeer(), n));
    }

    public int getNumberOfSamplesPerInterval() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hModelGetNumberOfSamplesPerInterval(this.thisPeer());
        if (n < 0) {
            ExceptionHugin.throwException();
        }
        return n;
    }

    public boolean tableIsGenerated() throws ExceptionHugin {
        return HAPI.nativeHAPI.hModelTableIsGenerated(this.thisPeer());
    }

    public boolean isAlive() {
        return this.modelPeer != 0;
    }

    private int thisPeer() throws ExceptionObjectNotAlive {
        if (this.modelPeer == 0) {
            throw new ExceptionObjectNotAlive();
        }
        return this.modelPeer;
    }
}

