/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HAPIMODELTOOLS;

import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.BooleanDDNode;
import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.IntervalDDNode;
import COM.hugin.HAPI.LabelledDCNode;
import COM.hugin.HAPI.LabelledDDNode;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.NumberedDDNode;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.MODEL.BeliefEngine;
import COM.hugin.MODEL.CaseSet;
import COM.hugin.MODEL.Network;
import COM.hugin.REPORT.Report;
import COM.hugin.REPORT.ReportTools;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelTools {
    private static final int Color_DiscreteChance = 16;
    private static final int Color_ContinuousChance = 48;
    private static final int Color_Decision = 17;
    private static final int Color_Utility = 36;
    private static final int MAX_COLORS = 64;
    private static int[] r = new int[]{255, 192, 128, 0};
    private static int[] g = new int[]{255, 192, 128, 0};
    private static int[] b = new int[]{255, 192, 128, 0};
    private static final int ARCH32 = 32;
    private static final int ARCH64 = 64;
    private static int ARCH = 32;
    private static Object[] NO_PARAMS = null;
    private static Method _getNumberOfStates = null;
    private static Method _getStateLabel = null;
    private static Method _getBelief = null;
    private static Method _getEnteredFinding = null;
    private static Method _getExpectedUtility = null;
    private static Method _getNumberOfCases = null;
    private static Method _caseIsSet = null;
    private static Method _getCaseState = null;
    private static Method _getCaseValue = null;
    private static Method _getEnteredValue = null;

    private static void handleReflectionException(Exception exception) throws ExceptionHugin {
        if (exception instanceof InvocationTargetException && exception.getCause() instanceof ExceptionHugin) {
            throw (ExceptionHugin)exception.getCause();
        }
        throw new ExceptionUsage("HAPIMODELTOOLS reflection related: " + exception.getMessage());
    }

    private static int getNumberOfStates(DiscreteNode discreteNode) throws ExceptionHugin {
        int n = 0;
        try {
            switch (ARCH) {
                case 32: {
                    n = discreteNode.getNumberOfStates();
                    break;
                }
                case 64: {
                    n = (int)((Long)_getNumberOfStates.invoke((Object)discreteNode, NO_PARAMS)).longValue();
                }
            }
        }
        catch (Exception exception) {
            ModelTools.handleReflectionException(exception);
        }
        return n;
    }

    private static String getStateLabel(DiscreteNode discreteNode, int n) throws ExceptionHugin {
        String string = null;
        try {
            switch (ARCH) {
                case 32: {
                    string = discreteNode.getStateLabel(n);
                    break;
                }
                case 64: {
                    string = (String)_getStateLabel.invoke((Object)discreteNode, n);
                }
            }
        }
        catch (Exception exception) {
            ModelTools.handleReflectionException(exception);
        }
        return string;
    }

    private static double getBelief(DiscreteNode discreteNode, int n) throws ExceptionHugin {
        double d = 0.0;
        try {
            switch (ARCH) {
                case 32: {
                    d = discreteNode.getBelief(n);
                    break;
                }
                case 64: {
                    d = (Double)_getBelief.invoke((Object)discreteNode, n);
                }
            }
        }
        catch (Exception exception) {
            ModelTools.handleReflectionException(exception);
        }
        return d;
    }

    private static double getEnteredFinding(DiscreteNode discreteNode, int n) throws ExceptionHugin {
        double d = 0.0;
        try {
            switch (ARCH) {
                case 32: {
                    d = discreteNode.getEnteredFinding(n);
                    break;
                }
                case 64: {
                    d = (Double)_getEnteredFinding.invoke((Object)discreteNode, n);
                }
            }
        }
        catch (Exception exception) {
            ModelTools.handleReflectionException(exception);
        }
        return d;
    }

    private static double getExpectedUtility(DiscreteNode discreteNode, int n) throws ExceptionHugin {
        double d = 0.0;
        try {
            switch (ARCH) {
                case 32: {
                    d = discreteNode.getExpectedUtility(n);
                    break;
                }
                case 64: {
                    d = (Double)_getExpectedUtility.invoke((Object)discreteNode, n);
                }
            }
        }
        catch (Exception exception) {
            ModelTools.handleReflectionException(exception);
        }
        return d;
    }

    private static int getNumberOfCases(Domain domain) throws ExceptionHugin {
        int n = 0;
        try {
            switch (ARCH) {
                case 32: {
                    n = domain.getNumberOfCases();
                    break;
                }
                case 64: {
                    n = (int)((Long)_getNumberOfCases.invoke((Object)domain, NO_PARAMS)).longValue();
                }
            }
        }
        catch (Exception exception) {
            ModelTools.handleReflectionException(exception);
        }
        return n;
    }

    private static boolean caseIsSet(DiscreteNode discreteNode, int n) throws ExceptionHugin {
        boolean bl = false;
        try {
            switch (ARCH) {
                case 32: {
                    bl = discreteNode.caseIsSet(n);
                    break;
                }
                case 64: {
                    bl = (Boolean)_caseIsSet.invoke((Object)discreteNode, n);
                }
            }
        }
        catch (Exception exception) {
            ModelTools.handleReflectionException(exception);
        }
        return bl;
    }

    private static boolean caseIsSet(ContinuousChanceNode continuousChanceNode, int n) throws ExceptionHugin {
        boolean bl = false;
        try {
            switch (ARCH) {
                case 32: {
                    bl = continuousChanceNode.caseIsSet(n);
                    break;
                }
                case 64: {
                    bl = (Boolean)_caseIsSet.invoke((Object)continuousChanceNode, n);
                }
            }
        }
        catch (Exception exception) {
            ModelTools.handleReflectionException(exception);
        }
        return bl;
    }

    private static int getCaseState(DiscreteNode discreteNode, int n) throws ExceptionHugin {
        int n2 = -1;
        try {
            switch (ARCH) {
                case 32: {
                    n2 = discreteNode.getCaseState(n);
                    break;
                }
                case 64: {
                    n2 = (int)((Long)_getCaseState.invoke((Object)discreteNode, n)).longValue();
                }
            }
        }
        catch (Exception exception) {
            ModelTools.handleReflectionException(exception);
        }
        return n2;
    }

    private static double getEnteredValue(ContinuousChanceNode continuousChanceNode) throws ExceptionHugin {
        double d = 0.0;
        try {
            switch (ARCH) {
                case 32: {
                    d = continuousChanceNode.getEnteredValue();
                    break;
                }
                case 64: {
                    d = (Double)_getEnteredValue.invoke((Object)continuousChanceNode, new Object[0]);
                }
            }
        }
        catch (Exception exception) {
            ModelTools.handleReflectionException(exception);
        }
        return d;
    }

    private static double getCaseValue(ContinuousChanceNode continuousChanceNode, int n) throws ExceptionHugin {
        double d = -1.0;
        try {
            switch (ARCH) {
                case 32: {
                    d = continuousChanceNode.getCaseValue(n);
                    break;
                }
                case 64: {
                    d = (Double)_getCaseValue.invoke((Object)continuousChanceNode, n);
                }
            }
        }
        catch (Exception exception) {
            ModelTools.handleReflectionException(exception);
        }
        return d;
    }

    public static Network createModel(String string, Domain domain, int n) throws ExceptionHugin {
        return ModelTools.createModel(string, domain, n, true);
    }

    public static Network createModel(String string, NetworkModel networkModel, int n, boolean bl) throws ExceptionHugin {
        Serializable serializable;
        Cloneable cloneable;
        ArrayList<COM.hugin.MODEL.Node> arrayList = new ArrayList<COM.hugin.MODEL.Node>();
        double d = 0.0;
        double d2 = 0.0;
        if (bl) {
            d = ((Domain)networkModel).getExpectedUtility();
            d2 = ((Domain)networkModel).getNormalizationConstant();
        }
        if (networkModel instanceof Domain) {
            ModelTools.flip(networkModel);
        }
        Point point = new Point((int)networkModel.getNodeSize().getX(), (int)networkModel.getNodeSize().getY());
        Network network = new Network(arrayList, string, point, d, d2, n);
        for (Node object2 : networkModel.getNodes()) {
            cloneable = object2;
            serializable = ModelTools.createModelNode(network, (Node)cloneable, bl);
            if (serializable == null) continue;
            arrayList.add((COM.hugin.MODEL.Node)serializable);
        }
        for (COM.hugin.MODEL.Node node : arrayList) {
            cloneable = node.getParents();
            serializable = node.getChildren();
            Node node2 = networkModel.getNodeByName(node.getName());
            for (Node node3 : node2.getParents()) {
                ((ArrayList)cloneable).add(network.getNodeByName(node3.getName()));
            }
            for (Node node3 : node2.getChildren()) {
                ((ArrayList)serializable).add(network.getNodeByName(node3.getName()));
            }
        }
        if (networkModel instanceof Domain) {
            ModelTools.flip(networkModel);
        }
        return network;
    }

    private static void flip(NetworkModel networkModel) {
        try {
            Object object;
            double d = 0.0;
            for (Node node : networkModel.getNodes()) {
                object = node;
                d = Math.max(d, ((Node)object).getPosition().getY());
            }
            double d2 = networkModel.getNodeSize().getY() / 2.0;
            object = networkModel.getNodes().iterator();
            while (object.hasNext()) {
                Node node;
                Node node2 = node = (Node)object.next();
                node2.setPosition(new Point2D.Double(node2.getPosition().getX(), d - node2.getPosition().getY() + d2));
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            exceptionHugin.printStackTrace();
        }
    }

    public static void configureDomain(Domain domain, Network network) throws ExceptionHugin {
        domain.initialize();
        for (COM.hugin.MODEL.Node node : network.getNodes()) {
            if (!(node instanceof COM.hugin.MODEL.DiscreteNode)) continue;
            ModelTools.updateApiNode((DiscreteNode)domain.getNodeByName(node.getName()), (COM.hugin.MODEL.DiscreteNode)node);
        }
    }

    public static void updateApiNode(DiscreteNode discreteNode, COM.hugin.MODEL.DiscreteNode discreteNode2) throws ExceptionHugin {
        for (int i = 0; i < discreteNode2.getNumberOfStates(); ++i) {
            discreteNode.enterFinding(i, discreteNode2.getEnteredFinding(i));
        }
    }

    public static CaseSet loadHuginDataFile(String string, Network network) {
        try {
            String string2;
            CaseSet caseSet = null;
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
            String string3 = null;
            COM.hugin.MODEL.Node[] nodeArray = null;
            int[] nArray = null;
            String[] stringArray = null;
            Object var11_11 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                String[] stringArray2;
                if (string3 == null) {
                    string3 = string2;
                    stringArray2 = string3.split("\\s*,\\s*|\\s+");
                    int n2 = 0;
                    String[] stringArray3 = stringArray2;
                    n = stringArray3.length;
                    for (int i = 0; i < n; ++i) {
                        String string4 = stringArray3[i];
                        if (network.getNodeByName(string4) == null) continue;
                        ++n2;
                    }
                    nodeArray = new COM.hugin.MODEL.DiscreteNode[n2];
                    nArray = new int[n2];
                    n2 = 0;
                    int n3 = 0;
                    while (n3 < stringArray2.length) {
                        String string5 = stringArray2[n3];
                        nArray[n2] = n3++;
                        nodeArray[n2++] = (COM.hugin.MODEL.DiscreteNode)network.getNodeByName(string5);
                    }
                    caseSet = new CaseSet(network, nodeArray, stringArray);
                    continue;
                }
                stringArray2 = string2.split("\\s*,\\s*|\\s+");
                int[] nArray2 = new int[nArray.length];
                String[] stringArray4 = new String[(var11_11).length];
                for (n = 0; n < stringArray2.length; ++n) {
                    int n4;
                    String string6 = stringArray2[n];
                    for (n4 = 0; n4 < nArray.length; ++n4) {
                        if (nArray[n4] != n) continue;
                        int n5 = -1;
                        COM.hugin.MODEL.Node node = nodeArray[n4];
                        if (node instanceof COM.hugin.MODEL.NumberedDCNode || node instanceof COM.hugin.MODEL.NumberedDDNode) {
                            try {
                                double d = Double.parseDouble(string6);
                                n5 = node instanceof COM.hugin.MODEL.NumberedDCNode ? ((COM.hugin.MODEL.NumberedDCNode)node).getStateIndex(d) : ((COM.hugin.MODEL.NumberedDDNode)node).getStateIndex(d);
                            }
                            catch (Exception exception) {}
                        } else if (node instanceof COM.hugin.MODEL.IntervalDCNode || node instanceof COM.hugin.MODEL.IntervalDDNode) {
                            try {
                                double d = Double.parseDouble(string6);
                                n5 = node instanceof COM.hugin.MODEL.IntervalDCNode ? ((COM.hugin.MODEL.IntervalDCNode)node).getStateIndex(d) : ((COM.hugin.MODEL.IntervalDDNode)node).getStateIndex(d);
                            }
                            catch (Exception exception) {}
                        } else {
                            if (string6.length() > 2 && string6.charAt(0) == '\"' && string6.charAt(string6.length() - 1) == '\"' && string6.length() > 1) {
                                string6 = string6.substring(1, string6.length() - 1);
                            }
                            for (int i = 0; i < ((COM.hugin.MODEL.DiscreteNode)node).getNumberOfStates(); ++i) {
                                if ((node instanceof COM.hugin.MODEL.BooleanDCNode || node instanceof COM.hugin.MODEL.BooleanDDNode || node instanceof COM.hugin.MODEL.LabelledDCNode || node instanceof COM.hugin.MODEL.LabelledDDNode) && string6.equals(((COM.hugin.MODEL.DiscreteNode)node).getStateLabel(i))) {
                                    n5 = i;
                                    break;
                                }
                                if (n5 != -1 || !(node instanceof COM.hugin.MODEL.BooleanDCNode) && !(node instanceof COM.hugin.MODEL.BooleanDDNode)) continue;
                                if (string6.toLowerCase().equals("false")) {
                                    n5 = 0;
                                    continue;
                                }
                                if (!string6.toLowerCase().equals("true")) continue;
                                n5 = 1;
                            }
                        }
                        nArray2[n4] = n5;
                        break;
                    }
                    for (n4 = 0; n4 < (var11_11).length; ++n4) {
                        if (var11_11[n4] != n) continue;
                        if (string6.length() > 2 && string6.charAt(0) == '\"' && string6.charAt(string6.length() - 1) == '\"' && string6.length() > 1) {
                            string6 = string6.substring(1, string6.length() - 1);
                        }
                        stringArray4[n4] = string6;
                    }
                }
                System.err.println("comment alm 220409 out");
            }
            dataInputStream.close();
            return caseSet;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static CaseSet loadHuginDataFileAndCasesFromDomain(String string, Network network, Domain domain) {
        try {
            Object object;
            String string2;
            CaseSet caseSet = null;
            FileInputStream fileInputStream = string != null ? new FileInputStream(string) : null;
            DataInputStream dataInputStream = fileInputStream != null ? new DataInputStream(fileInputStream) : null;
            BufferedReader bufferedReader = dataInputStream != null ? new BufferedReader(new InputStreamReader(dataInputStream)) : null;
            String string3 = null;
            COM.hugin.MODEL.Node[] nodeArray = null;
            String[] stringArray = null;
            int[] nArray = null;
            if (bufferedReader == null || (string2 = bufferedReader.readLine()) == null) {
                string2 = "";
            }
            string3 = string2;
            String[] stringArray2 = string3.split("\\s*,\\s*|\\s+");
            int n = 0;
            for (Node node : domain.getNodes()) {
                object = node;
                if (!(object instanceof DiscreteNode) && !(object instanceof ContinuousChanceNode)) continue;
                ++n;
            }
            nodeArray = new COM.hugin.MODEL.Node[n];
            n = 0;
            for (Node node : domain.getNodes()) {
                object = node;
                if (object instanceof DiscreteNode) {
                    nodeArray[n++] = (COM.hugin.MODEL.DiscreteNode)network.getNodeByName(((Node)object).getName());
                }
                if (!(object instanceof ContinuousChanceNode)) continue;
                nodeArray[n++] = (COM.hugin.MODEL.ContinuousChanceNode)network.getNodeByName(((Node)object).getName());
            }
            nArray = new int[stringArray2.length];
            stringArray = new String[stringArray2.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < stringArray2.length) {
                object = stringArray2[n3];
                nArray[n2] = n3++;
                stringArray[n2++] = object;
            }
            caseSet = new CaseSet(network, nodeArray, stringArray);
            if (string3 != null) {
                for (n3 = 0; n3 < domain.getNumberOfCases(); ++n3) {
                    Object object2;
                    object = new int[nodeArray.length];
                    double[] dArray = new double[nodeArray.length];
                    boolean[] blArray = new boolean[nodeArray.length];
                    for (int i = 0; i < nodeArray.length; ++i) {
                        blArray[i] = false;
                    }
                    String[] stringArray3 = new String[nArray.length];
                    for (int i = 0; i < nodeArray.length; ++i) {
                        Node node = domain.getNodeByName(nodeArray[i].getName());
                        if (node instanceof DiscreteNode) {
                            object2 = (DiscreteNode)node;
                            object[i] = ((DiscreteNode)object2).caseIsSet(n3) ? ((DiscreteNode)object2).getCaseState(n3) : -1;
                            continue;
                        }
                        if (!(node instanceof ContinuousChanceNode)) continue;
                        object2 = (ContinuousChanceNode)node;
                        blArray[i] = ((ContinuousChanceNode)object2).caseIsSet(n3);
                        if (!blArray[i]) continue;
                        dArray[i] = ((ContinuousChanceNode)object2).getCaseValue(n3);
                    }
                    if (bufferedReader != null && (string2 = bufferedReader.readLine()) != null) {
                        String[] stringArray4 = string2.split("\\s*,\\s*|\\s+");
                        for (int i = 0; i < stringArray4.length; ++i) {
                            object2 = stringArray4[i];
                            for (int j = 0; j < nArray.length; ++j) {
                                if (nArray[j] != i) continue;
                                if (((String)object2).length() > 2 && ((String)object2).charAt(0) == '\"' && ((String)object2).charAt(((String)object2).length() - 1) == '\"' && ((String)object2).length() > 1) {
                                    object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                                }
                                stringArray3[j] = object2;
                            }
                        }
                    }
                    System.err.println("comment out alm");
                }
            }
            if (dataInputStream != null) {
                dataInputStream.close();
            }
            return caseSet;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static CaseSet loadDataFromProviderAndCasesFromDomain(DataProvider dataProvider, Network network, Domain domain) {
        try {
            Node node;
            CaseSet caseSet = null;
            COM.hugin.MODEL.Node[] nodeArray = null;
            int n = 0;
            for (Node node2 : domain.getNodes()) {
                node = node2;
                if (!(node instanceof DiscreteNode) && !(node instanceof ContinuousChanceNode)) continue;
                ++n;
            }
            nodeArray = new COM.hugin.MODEL.Node[n];
            n = 0;
            for (Node node2 : domain.getNodes()) {
                node = node2;
                if (node instanceof DiscreteNode) {
                    nodeArray[n++] = (COM.hugin.MODEL.DiscreteNode)network.getNodeByName(node.getName());
                }
                if (!(node instanceof ContinuousChanceNode)) continue;
                nodeArray[n++] = (COM.hugin.MODEL.ContinuousChanceNode)network.getNodeByName(node.getName());
            }
            String[] stringArray = dataProvider.getColumnNames();
            caseSet = new CaseSet(network, nodeArray, stringArray);
            int n2 = ModelTools.getNumberOfCases(domain);
            for (int i = 0; i < n2; ++i) {
                int n3;
                int[] nArray = new int[nodeArray.length];
                double[] dArray = new double[nodeArray.length];
                boolean[] blArray = new boolean[nodeArray.length];
                for (n3 = 0; n3 < nodeArray.length; ++n3) {
                    blArray[n3] = false;
                }
                for (n3 = 0; n3 < nodeArray.length; ++n3) {
                    Node node3;
                    Node node4 = domain.getNodeByName(nodeArray[n3].getName());
                    if (node4 instanceof DiscreteNode) {
                        node3 = (DiscreteNode)node4;
                        nArray[n3] = ((DiscreteNode)node3).caseIsSet(i) ? ((DiscreteNode)node3).getCaseState(i) : -1;
                        continue;
                    }
                    if (!(node4 instanceof ContinuousChanceNode)) continue;
                    node3 = (ContinuousChanceNode)node4;
                    blArray[n3] = ((ContinuousChanceNode)node3).caseIsSet(i);
                    if (!blArray[n3]) continue;
                    dArray[n3] = ((ContinuousChanceNode)node3).getCaseValue(i);
                }
                String[] stringArray2 = dataProvider.getCase(i);
                caseSet.addCase(nArray, dArray, blArray, stringArray2);
            }
            return caseSet;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void generateReport(Object object, Vector<Report> vector, CaseSet caseSet, BeliefEngine beliefEngine, Network network) {
        ReportTools.generateReport(object, vector, caseSet, beliefEngine, network);
    }

    private static Color HGUIindex2color(int n) {
        if (n < 0 || n >= 64) {
            return new Color(r[0], g[0], b[0]);
        }
        int n2 = n / 16;
        int n3 = (n - n2 * 16) / 4;
        int n4 = n - n2 * 16 - n3 * 4;
        return new Color(r[n3], g[n4], b[n2]);
    }

    private static Color getNodeColor(NetworkModel networkModel, Node node) {
        try {
            String string = node.getAttribute("HR_Group");
            int n = 0;
            if (string != null && !string.equals("")) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n != 0) {
                String string2 = networkModel.getAttribute("HR_Group_" + n + "_Color");
                try {
                    return ModelTools.HGUIindex2color(Integer.parseInt(string2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (node instanceof DiscreteChanceNode) {
                return ModelTools.HGUIindex2color(16);
            }
            if (node instanceof ContinuousChanceNode) {
                return ModelTools.HGUIindex2color(48);
            }
            if (node instanceof DiscreteDecisionNode) {
                return ModelTools.HGUIindex2color(17);
            }
            if (node instanceof UtilityNode) {
                return ModelTools.HGUIindex2color(36);
            }
            return ModelTools.HGUIindex2color(0);
        }
        catch (ExceptionHugin exceptionHugin) {
            System.out.println(exceptionHugin);
            return ModelTools.HGUIindex2color(16);
        }
    }

    public static COM.hugin.MODEL.Node createModelNode(Network network, Node node, boolean bl) {
        try {
            String string = node.getName();
            String string2 = node.getLabel();
            Point2D point2D = node.getPosition();
            Point point = new Point((int)point2D.getX(), (int)point2D.getY());
            Color color = ModelTools.getNodeColor(node.getHome(), node);
            Point point2 = null;
            String string3 = node.getAttribute("HR_NodeSize");
            if (string3 != null && string3.length() != 0) {
                try {
                    int n = (int)Double.parseDouble(string3.substring(string3.indexOf("(") + 1, string3.indexOf(",")).trim());
                    int n2 = (int)Double.parseDouble(string3.substring(string3.indexOf(",") + 1, string3.indexOf(")")).trim());
                    if (n < 1) {
                        n = 1;
                    }
                    if (n2 < 1) {
                        n2 = 1;
                    }
                    point2 = new Point(n, n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (node instanceof DiscreteNode) {
                COM.hugin.MODEL.DiscreteNode discreteNode = ModelTools.createModelNode(network, (DiscreteNode)node, bl);
                discreteNode.configureNode(string, string2, point, color, point2);
                return discreteNode;
            }
            if (node instanceof ContinuousChanceNode) {
                COM.hugin.MODEL.ContinuousChanceNode continuousChanceNode = ModelTools.createModelNode(network, (ContinuousChanceNode)node, bl);
                continuousChanceNode.configureNode(string, string2, point, color, point2);
                return continuousChanceNode;
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            System.out.println(exceptionHugin);
        }
        return null;
    }

    private static COM.hugin.MODEL.DiscreteNode createModelNode(Network network, DiscreteNode discreteNode, boolean bl) throws ExceptionHugin {
        int n = ModelTools.getNumberOfStates(discreteNode);
        if (discreteNode instanceof DiscreteChanceNode) {
            return ModelTools.createModelNode(network, (DiscreteChanceNode)discreteNode, bl, n);
        }
        if (discreteNode instanceof DiscreteDecisionNode) {
            return ModelTools.createModelNode(network, (DiscreteDecisionNode)discreteNode, bl, n);
        }
        return null;
    }

    private static COM.hugin.MODEL.DiscreteChanceNode createModelNode(Network network, DiscreteChanceNode discreteChanceNode, boolean bl, int n) throws ExceptionHugin {
        double[] dArray = new double[n];
        String[] stringArray = new String[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ModelTools.getStateLabel(discreteChanceNode, i);
            if (bl) {
                dArray[i] = ModelTools.getBelief(discreteChanceNode, i);
                dArray2[i] = ModelTools.getEnteredFinding(discreteChanceNode, i);
                dArray3[i] = ModelTools.getExpectedUtility(discreteChanceNode, i);
                continue;
            }
            dArray[i] = 1.0 / (double)n;
            dArray2[i] = 1.0;
        }
        if (discreteChanceNode instanceof LabelledDCNode) {
            COM.hugin.MODEL.LabelledDCNode labelledDCNode = ModelTools.createModelNode(network, (LabelledDCNode)discreteChanceNode, bl);
            labelledDCNode.configureDiscreteNode(dArray, stringArray, dArray2, dArray3);
            return labelledDCNode;
        }
        if (discreteChanceNode instanceof BooleanDCNode) {
            COM.hugin.MODEL.BooleanDCNode booleanDCNode = ModelTools.createModelNode(network, (BooleanDCNode)discreteChanceNode, bl);
            booleanDCNode.configureDiscreteNode(dArray, stringArray, dArray2, dArray3);
            return booleanDCNode;
        }
        if (discreteChanceNode instanceof NumberedDCNode) {
            COM.hugin.MODEL.NumberedDCNode numberedDCNode = ModelTools.createModelNode(network, (NumberedDCNode)discreteChanceNode, bl, n);
            numberedDCNode.configureDiscreteNode(dArray, stringArray, dArray2, dArray3);
            return numberedDCNode;
        }
        if (discreteChanceNode instanceof IntervalDCNode) {
            COM.hugin.MODEL.IntervalDCNode intervalDCNode = ModelTools.createModelNode(network, (IntervalDCNode)discreteChanceNode, bl, n);
            intervalDCNode.configureDiscreteNode(dArray, stringArray, dArray2, dArray3);
            return intervalDCNode;
        }
        return null;
    }

    private static COM.hugin.MODEL.ContinuousChanceNode createModelNode(Network network, ContinuousChanceNode continuousChanceNode, boolean bl) throws ExceptionHugin {
        double d = 0.0;
        boolean bl2 = continuousChanceNode.evidenceIsEntered();
        if (bl2) {
            d = ModelTools.getEnteredValue(continuousChanceNode);
        }
        COM.hugin.MODEL.ContinuousChanceNode continuousChanceNode2 = new COM.hugin.MODEL.ContinuousChanceNode(network);
        continuousChanceNode2.configureContinuousChanceNode(d, bl2);
        return continuousChanceNode2;
    }

    private static COM.hugin.MODEL.LabelledDCNode createModelNode(Network network, LabelledDCNode labelledDCNode, boolean bl) throws ExceptionHugin {
        return new COM.hugin.MODEL.LabelledDCNode(network);
    }

    private static COM.hugin.MODEL.BooleanDCNode createModelNode(Network network, BooleanDCNode booleanDCNode, boolean bl) throws ExceptionHugin {
        return new COM.hugin.MODEL.BooleanDCNode(network);
    }

    private static COM.hugin.MODEL.NumberedDCNode createModelNode(Network network, NumberedDCNode numberedDCNode, boolean bl, int n) throws ExceptionHugin {
        COM.hugin.MODEL.NumberedDCNode numberedDCNode2 = new COM.hugin.MODEL.NumberedDCNode(network);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = numberedDCNode.getStateValue(i);
        }
        numberedDCNode2.configureNumberedDCNode(dArray);
        return numberedDCNode2;
    }

    private static COM.hugin.MODEL.IntervalDCNode createModelNode(Network network, IntervalDCNode intervalDCNode, boolean bl, int n) throws ExceptionHugin {
        COM.hugin.MODEL.IntervalDCNode intervalDCNode2 = new COM.hugin.MODEL.IntervalDCNode(network);
        double[] dArray = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            dArray[i] = intervalDCNode.getStateValue(i);
        }
        intervalDCNode2.configureIntervalDCNode(dArray);
        return intervalDCNode2;
    }

    private static COM.hugin.MODEL.DiscreteDecisionNode createModelNode(Network network, DiscreteDecisionNode discreteDecisionNode, boolean bl, int n) throws ExceptionHugin {
        double[] dArray = new double[n];
        String[] stringArray = new String[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ModelTools.getStateLabel(discreteDecisionNode, i);
            if (bl) {
                dArray[i] = ModelTools.getBelief(discreteDecisionNode, i);
                dArray2[i] = ModelTools.getEnteredFinding(discreteDecisionNode, i);
                dArray3[i] = ModelTools.getExpectedUtility(discreteDecisionNode, i);
                continue;
            }
            dArray[i] = 1.0 / (double)n;
            dArray2[i] = 1.0;
        }
        if (discreteDecisionNode instanceof LabelledDDNode) {
            COM.hugin.MODEL.LabelledDDNode labelledDDNode = ModelTools.createModelNode(network, (LabelledDDNode)discreteDecisionNode, bl);
            labelledDDNode.configureDiscreteNode(dArray, stringArray, dArray2, dArray3);
            return labelledDDNode;
        }
        if (discreteDecisionNode instanceof BooleanDDNode) {
            COM.hugin.MODEL.BooleanDDNode booleanDDNode = ModelTools.createModelNode(network, (BooleanDDNode)discreteDecisionNode, bl);
            booleanDDNode.configureDiscreteNode(dArray, stringArray, dArray2, dArray3);
            return booleanDDNode;
        }
        if (discreteDecisionNode instanceof NumberedDDNode) {
            COM.hugin.MODEL.NumberedDDNode numberedDDNode = ModelTools.createModelNode(network, (NumberedDDNode)discreteDecisionNode, bl, n);
            numberedDDNode.configureDiscreteNode(dArray, stringArray, dArray2, dArray3);
            return numberedDDNode;
        }
        if (discreteDecisionNode instanceof IntervalDDNode) {
            COM.hugin.MODEL.IntervalDDNode intervalDDNode = ModelTools.createModelNode(network, (IntervalDDNode)discreteDecisionNode, bl, n);
            intervalDDNode.configureDiscreteNode(dArray, stringArray, dArray2, dArray3);
            return intervalDDNode;
        }
        return null;
    }

    private static COM.hugin.MODEL.LabelledDDNode createModelNode(Network network, LabelledDDNode labelledDDNode, boolean bl) throws ExceptionHugin {
        return new COM.hugin.MODEL.LabelledDDNode(network);
    }

    private static COM.hugin.MODEL.BooleanDDNode createModelNode(Network network, BooleanDDNode booleanDDNode, boolean bl) throws ExceptionHugin {
        return new COM.hugin.MODEL.BooleanDDNode(network);
    }

    private static COM.hugin.MODEL.NumberedDDNode createModelNode(Network network, NumberedDDNode numberedDDNode, boolean bl, int n) throws ExceptionHugin {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = numberedDDNode.getStateValue(i);
        }
        COM.hugin.MODEL.NumberedDDNode numberedDDNode2 = new COM.hugin.MODEL.NumberedDDNode(network);
        numberedDDNode2.configureNumberedDDNode(dArray);
        return numberedDDNode2;
    }

    private static COM.hugin.MODEL.IntervalDDNode createModelNode(Network network, IntervalDDNode intervalDDNode, boolean bl, int n) throws ExceptionHugin {
        double[] dArray = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            dArray[i] = intervalDDNode.getStateValue(i);
        }
        COM.hugin.MODEL.IntervalDDNode intervalDDNode2 = new COM.hugin.MODEL.IntervalDDNode(network);
        intervalDDNode2.configureIntervalDDNode(dArray);
        return intervalDDNode2;
    }

    static {
        try {
            Class<?> clazz = Class.forName("COM.hugin.HAPI.ContinuousChanceNode");
            Class<?> clazz2 = Class.forName("COM.hugin.HAPI.DiscreteNode");
            Class<?> clazz3 = Class.forName("COM.hugin.HAPI.Domain");
            _getNumberOfStates = clazz2.getMethod("getNumberOfStates", new Class[0]);
            if (_getNumberOfStates.getGenericReturnType() == Long.TYPE) {
                ARCH = 64;
                _getStateLabel = clazz2.getMethod("getStateLabel", Long.TYPE);
                _getBelief = clazz2.getMethod("getBelief", Long.TYPE);
                _getEnteredFinding = clazz2.getMethod("getEnteredFinding", Long.TYPE);
                _getExpectedUtility = clazz2.getMethod("getExpectedUtility", Long.TYPE);
                _getNumberOfCases = clazz3.getMethod("getNumberOfCases", new Class[0]);
                _caseIsSet = clazz2.getMethod("caseIsSet", Long.TYPE);
                _getCaseState = clazz2.getMethod("getCaseState", Long.TYPE);
                _getCaseValue = clazz.getMethod("getCaseValue", Long.TYPE);
                _getEnteredValue = clazz.getMethod("getEnteredValue", new Class[0]);
            } else {
                ARCH = 32;
                _getStateLabel = clazz2.getMethod("getStateLabel", Integer.TYPE);
                _getBelief = clazz2.getMethod("getBelief", Integer.TYPE);
                _getEnteredFinding = clazz2.getMethod("getEnteredFinding", Integer.TYPE);
                _getExpectedUtility = clazz2.getMethod("getExpectedUtility", Integer.TYPE);
                _getNumberOfCases = clazz3.getMethod("getNumberOfCases", new Class[0]);
                _caseIsSet = clazz2.getMethod("caseIsSet", Integer.TYPE);
                _getCaseState = clazz2.getMethod("getCaseState", Integer.TYPE);
                _getCaseValue = clazz.getMethod("getCaseValue", Integer.TYPE);
                _getEnteredValue = clazz.getMethod("getEnteredValue", new Class[0]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static interface DataProvider {
        public String[] getColumnNames();

        public String[] getCase(int var1);
    }
}

