/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.MultipleLineGraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Random;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccuracyAnalysis {
    private Domain domain;
    private Node[] nodes;
    private int numRows;
    private DiscreteChanceNode theNode;
    private String[] beliefs;
    private double[] conflicts;
    private int[] caseHits;
    private int[][] confusionMatrix;
    private int numberOfErrorsObserved = 0;
    private int numberOfInvalidCases = 0;
    private double quadraticSum = 0.0;
    private double kulbachSum = 0.0;
    private double predictionThreshold = 0.5;
    private double sliderThreshold = 0.5;
    private double AUC = 0.0;
    private AccuracyModel accuracyModel = null;
    private boolean hasContinuous = false;
    private ROCTest[][] ROCTests = null;
    private int[] positiveExamples = null;
    private int[] negativeExamples = null;
    private Vector<ROCPoint> activeROCPoints = null;
    private Vector<Vector<ROCPoint>> ROCPoints = null;
    private MultipleLineGraph _ROCCurve = null;
    private JLabel _AUCLabel = null;
    private JSlider _ROCCutoffSlider = null;
    private JComboBox _ROCStateSelector = null;
    private Vector<CustomComputation> customComputations = null;

    public AccuracyAnalysis(Domain domain, Node node, double d, Vector<CustomComputation> vector) throws ExceptionHugin {
        this.domain = domain;
        NodeList nodeList = this.domain.getNodes();
        this.theNode = (DiscreteChanceNode)node;
        this.customComputations = vector;
        this.hasContinuous = false;
        for (Node node2 : nodeList) {
            if (!(node2 instanceof ContinuousChanceNode)) continue;
            this.hasContinuous = true;
        }
        if (this.theNode != null) {
            Node node3 = (Node)nodeList.getLast();
            if (node3 != node) {
                nodeList.add(nodeList.indexOf(node), node3);
                nodeList.remove(node);
                nodeList.remove(nodeList.size() - 1);
                nodeList.addLast(node);
            }
            this.nodes = nodeList.toArray(new Node[nodeList.size()]);
            this.numRows = this.domain.getNumberOfCases();
            this.accuracyModel = new AccuracyModel();
            this.performComputations(d);
        }
    }

    public int caseIsHit(int n) {
        return this.caseHits[n];
    }

    public double getAUC() {
        return this.AUC;
    }

    public DiscreteChanceNode getNode() {
        return this.theNode;
    }

    public JTable getDataAccuracyTable() {
        JTable jTable = new JTable(this.accuracyModel){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        jTable.setAutoResizeMode(0);
        jTable.setDefaultRenderer(jTable.getColumnClass(jTable.getColumnCount() - 1), new ColorTableCellRenderer(jTable, this));
        return jTable;
    }

    public TableModel getDataAccuracyTableModel() {
        return this.accuracyModel;
    }

    public double getROCSliderThreshold() {
        return this.sliderThreshold;
    }

    public JLabel getAUCLabel() throws ExceptionHugin {
        if (this._AUCLabel == null) {
            this.createROCInvetory();
        }
        return this._AUCLabel;
    }

    public JPanel getROCCurve() throws ExceptionHugin {
        if (this._ROCCurve == null) {
            this.createROCInvetory();
        }
        return this._ROCCurve;
    }

    public JComboBox getROCStateSelector() throws ExceptionHugin {
        if (this._ROCStateSelector == null) {
            this.createROCInvetory();
        }
        return this._ROCStateSelector;
    }

    public JSlider getROCCutoffSlider() throws ExceptionHugin {
        if (this._ROCCutoffSlider == null) {
            this.createROCInvetory();
        }
        return this._ROCCutoffSlider;
    }

    public void performComputations(double d) {
        try {
            int n;
            int n2;
            this.predictionThreshold = d;
            this.beliefs = new String[this.numRows];
            this.conflicts = new double[this.numRows];
            this.caseHits = new int[this.numRows];
            int n3 = this.theNode.getNumberOfStates();
            this.confusionMatrix = new int[n3][n3];
            int n4 = 0;
            this.numberOfErrorsObserved = 0;
            this.numberOfInvalidCases = 0;
            this.quadraticSum = 0.0;
            this.kulbachSum = 0.0;
            Random random = new Random();
            int n5 = this.domain.getNumberOfCases();
            this.ROCPoints = new Vector();
            this.ROCTests = new ROCTest[n3 + 1][n5];
            this.positiveExamples = new int[n3 + 1];
            this.negativeExamples = new int[n3 + 1];
            for (n2 = 0; n2 < this.numRows; ++n2) {
                if (n2 >= this.domain.getNumberOfCases()) continue;
                this.domain.enterCase(n2);
                this.theNode.retractFindings();
                this.domain.resetInferenceEngine();
                this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                if (!this.hasContinuous) {
                    this.conflicts[n4] = Math.log(this.domain.getConflict());
                }
                if (this.theNode.caseIsSet(n2)) {
                    int n6;
                    int n7;
                    for (int i = 0; i < n3; ++i) {
                        this.ROCTests[i][n2] = new ROCTest(this.theNode.getBelief(i), this.theNode.getCaseState(n2) == i);
                        if (this.theNode.getCaseState(n2) == i) {
                            this.positiveExamples[i] = this.positiveExamples[i] + 1;
                            this.positiveExamples[n3] = this.positiveExamples[n3] + 1;
                            continue;
                        }
                        this.negativeExamples[i] = this.negativeExamples[i] + 1;
                        this.negativeExamples[n3] = this.negativeExamples[n3] + 1;
                    }
                    this.beliefs[n4] = "" + HuginGUIUtils.round(this.theNode.getBelief(this.theNode.getCaseState(n2)), 2);
                    double[] dArray = new double[n3];
                    for (n = 0; n < n3; ++n) {
                        dArray[n] = this.theNode.getBelief(n);
                    }
                    n = 0;
                    int[] nArray = new int[n];
                    if (d < 0.0) {
                        int n8;
                        double d2 = 0.0;
                        boolean bl = false;
                        for (n8 = 0; n8 < n3; ++n8) {
                            if (!(d2 < this.theNode.getBelief(n8))) continue;
                            d2 = this.theNode.getBelief(n8);
                        }
                        n = 0;
                        for (n8 = 0; n8 < n3; ++n8) {
                            if (!(this.theNode.getBelief(n8) >= d2)) continue;
                            ++n;
                        }
                        nArray = new int[n];
                        n8 = 0;
                        for (n7 = 0; n7 < n3; ++n7) {
                            if (!(this.theNode.getBelief(n7) >= d2)) continue;
                            nArray[n8] = n7;
                            ++n8;
                        }
                    } else {
                        n = 0;
                        for (n6 = 0; n6 < n3; ++n6) {
                            if (!(this.theNode.getBelief(n6) >= d)) continue;
                            ++n;
                        }
                        nArray = new int[n];
                        n6 = 0;
                        for (int i = 0; i < n3; ++i) {
                            if (!(this.theNode.getBelief(i) >= d)) continue;
                            nArray[n6] = i;
                            ++n6;
                        }
                    }
                    n6 = -1;
                    if (n > 0) {
                        n6 = nArray[random.nextInt(n)];
                        int[] nArray2 = this.confusionMatrix[this.theNode.getCaseState(n2)];
                        int n9 = n6;
                        nArray2[n9] = nArray2[n9] + 1;
                    }
                    if (n6 == -1) {
                        ++this.numberOfInvalidCases;
                    } else if (this.theNode.getCaseState(n2) == n6) {
                        this.caseHits[n4] = 1;
                    } else {
                        this.caseHits[n4] = 0;
                        ++this.numberOfErrorsObserved;
                    }
                    double[] dArray2 = new double[n3];
                    dArray2[this.theNode.getCaseState((int)n2)] = 1.0;
                    double d3 = 0.0;
                    for (n7 = 0; n7 < n3; ++n7) {
                        d3 += Math.pow(dArray2[n7] - dArray[n7], 2.0);
                    }
                    this.quadraticSum += d3;
                    double d4 = 0.0;
                    for (int i = 0; i < n3; ++i) {
                        d4 += dArray2[i] == 0.0 ? 0.0 : dArray2[i] * (Math.log(dArray2[i]) - Math.log(dArray[i]));
                    }
                    this.kulbachSum += d4;
                } else {
                    for (int i = 0; i < n3; ++i) {
                        this.ROCTests[i][n2] = new ROCTest(-1.0, false);
                    }
                    this.beliefs[n4] = HuginGUIConstants.get("str_NA");
                    this.caseHits[n4] = -1;
                    ++this.numberOfInvalidCases;
                }
                if (this.customComputations != null) {
                    for (CustomComputation customComputation : this.customComputations) {
                        customComputation.casePropagated(this.domain, n2, this.theNode);
                    }
                }
                ++n4;
            }
            for (n2 = 0; n2 <= n3; ++n2) {
                int n10;
                Object[] objectArray = null;
                if (n2 < n3) {
                    objectArray = this.ROCTests[n2];
                } else {
                    objectArray = new ROCTest[n5 * n3];
                    for (n = 0; n < n5; ++n) {
                        for (n10 = 0; n10 < n3; ++n10) {
                            objectArray[n * n3 + n10] = this.ROCTests[n10][n];
                        }
                    }
                }
                Arrays.sort(objectArray);
                n = 0;
                n10 = 0;
                this.ROCPoints.add(n2, new Vector());
                Object object = null;
                if (this.positiveExamples[n2] + this.negativeExamples[n2] > 0) {
                    this.ROCPoints.get(n2).add(new ROCPoint(0.0, 0.0, 1.0));
                    object = objectArray[0];
                }
                boolean bl = false;
                for (int i = 1; i < this.positiveExamples[n2] + this.negativeExamples[n2]; ++i) {
                    if (((ROCTest)objectArray[i]).belief != ((ROCTest)object).belief) {
                        this.ROCPoints.get(n2).add(new ROCPoint(n == 0 ? 0.0 : (double)n / (double)this.negativeExamples[n2], n10 == 0 ? 0.0 : (double)n10 / (double)this.positiveExamples[n2], ((ROCTest)objectArray[i]).belief));
                        object = objectArray[i];
                        bl = true;
                    }
                    if (((ROCTest)objectArray[i]).positive) {
                        ++n10;
                        continue;
                    }
                    ++n;
                }
                if (!bl && object != null) {
                    this.ROCPoints.get(n2).add(new ROCPoint(n == 0 ? 0.0 : (double)n / (double)this.negativeExamples[n2], n10 == 0 ? 0.0 : (double)n10 / (double)this.positiveExamples[n2], ((ROCTest)object).belief));
                }
                if (this.positiveExamples[n2] + this.negativeExamples[n2] <= 0) continue;
                this.ROCPoints.get(n2).add(new ROCPoint(1.0, 1.0, 0.0));
            }
            if (this.activeROCPoints == null) {
                this.selectROCPoints(n3);
            }
            this.accuracyModel.fireTableChanged(new TableModelEvent(this.accuracyModel));
            this.updateROCCurve();
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    public String getAccuracyReport() {
        String string = HuginGUIConstants.get("str_analysis_report_n_n_n");
        if (this.theNode == null) {
            return "";
        }
        try {
            String string2;
            int n;
            string = this.theNode.getLabel().equals("") ? string + "Node: " + this.theNode.getName() + "\n" : string + "Node: " + this.theNode.getLabel() + " (" + this.theNode.getName() + ")\n";
            string = string + HuginGUIConstants.get("str_number_of_cases_ARG0_lb_lb", new String[]{"" + (this.domain.getNumberOfCases() - this.numberOfInvalidCases)});
            string = this.predictionThreshold < 0.0 ? string + HuginGUIConstants.get("str_confusion_threshold_max") : string + HuginGUIConstants.get("str_confusion_threshold_ARG0", new String[]{"" + HuginGUIUtils.printDouble(this.predictionThreshold, 4)});
            string = string + HuginGUIConstants.get("str_confusion_matrix") + "\n" + HuginGUIConstants.get("str_actual") + "\n";
            int n2 = this.theNode.getNumberOfStates();
            for (n = 0; n < n2; ++n) {
                string2 = "";
                string2 = HuginGUIUtils.getNodeStateLabel(this.theNode, n);
                string = string + HuginGUIUtils.rightJustify(string2, 12);
            }
            string = string + HuginGUIUtils.rightJustify(HuginGUIConstants.get("str_predicted"), 12) + "\n";
            n2 = this.theNode.getNumberOfStates();
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < n2; ++i) {
                    string = string + HuginGUIUtils.rightJustify("" + this.confusionMatrix[i][n], 12);
                }
                string2 = "";
                string2 = HuginGUIUtils.getNodeStateLabel(this.theNode, n);
                string = string + HuginGUIUtils.rightJustify(string2, 12) + "\n";
            }
            string = string + "\n" + HuginGUIConstants.get("str_error_rate_ARG0", new String[]{"" + HuginGUIUtils.round(this.getErrorRate(), 2)}) + "\n";
            string = string + "\n";
            string = string + HuginGUIConstants.get("str_avg_euclidian_distance_ARG0", new String[]{"" + HuginGUIUtils.round(this.getQuadraticScore(), 5)}) + "\n";
            string = string + HuginGUIConstants.get("str_avg_kulbach_leibler_divergence_ARG0", new String[]{"" + HuginGUIUtils.round(this.getKulbachLeibler(), 5)}) + "\n";
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        return string;
    }

    private void selectROCPoints(int n) {
        this.activeROCPoints = this.ROCPoints.get(n);
        this.AUC = 0.0;
        ROCPoint rOCPoint = null;
        for (ROCPoint rOCPoint2 : this.activeROCPoints) {
            if (rOCPoint != null) {
                double d = Math.abs(rOCPoint.x - rOCPoint2.x);
                double d2 = (rOCPoint.y + rOCPoint2.y) / 2.0;
                this.AUC += d * d2;
            }
            rOCPoint = rOCPoint2;
        }
    }

    private void updateROCCurve() {
        if (this._ROCCurve == null) {
            return;
        }
        this._ROCCurve.removeLines();
        this._ROCCurve.addLine("", Color.RED);
        ROCPoint rOCPoint = new ROCPoint(1.0, 1.0, 0.0);
        for (ROCPoint rOCPoint2 : this.activeROCPoints) {
            if (rOCPoint2.threshold == this.sliderThreshold || rOCPoint.threshold != this.sliderThreshold && Math.abs(this.sliderThreshold - rOCPoint2.threshold) < Math.abs(this.sliderThreshold - rOCPoint.threshold)) {
                rOCPoint = rOCPoint2;
            }
            this._ROCCurve.addItem(rOCPoint2.y, rOCPoint2.x, 0);
        }
        this._ROCCurve.repaint();
        this._ROCCutoffSlider.setMaximum(this.activeROCPoints.size());
        if (this.activeROCPoints.size() == 0) {
            this._ROCCutoffSlider.setEnabled(false);
        }
        this.sliderThreshold = rOCPoint.threshold;
        this._ROCCurve.addPoint(rOCPoint.y, rOCPoint.x, 0);
        this._ROCCurve.setTitle(HuginGUIConstants.get("str_cutoff_ARG0", new String[]{"" + HuginGUIUtils.printDouble(rOCPoint.threshold, 4)}));
        this._AUCLabel.setText(HuginGUIConstants.get("str_AUC_ARG0", new String[]{"" + HuginGUIUtils.printDouble(this.AUC, 5)}));
    }

    private void createROCInvetory() throws ExceptionHugin {
        this._ROCCurve = new MultipleLineGraph(HuginGUIConstants.get("str_ROC"), 0, 1);
        this._ROCCurve.addLine("", Color.RED);
        for (ROCPoint rOCPoint : this.activeROCPoints) {
            this._ROCCurve.addItem(rOCPoint.y, rOCPoint.x, 0);
        }
        String[] stringArray = new String[this.theNode.getNumberOfStates() + 1];
        for (int i = 0; i < this.theNode.getNumberOfStates(); ++i) {
            stringArray[i] = this.theNode.getStateLabel(i);
        }
        stringArray[this.theNode.getNumberOfStates()] = HuginGUIConstants.get("str_multi_class_all_states");
        this._ROCStateSelector = new JComboBox<String>(stringArray);
        this._ROCStateSelector.setSelectedIndex(stringArray.length - 1);
        this._ROCStateSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                AccuracyAnalysis.this.selectROCPoints(jComboBox.getSelectedIndex());
                AccuracyAnalysis.this.updateROCCurve();
            }
        });
        this._AUCLabel = new JLabel(HuginGUIConstants.get("str_AUC_ARG0", new String[]{"" + HuginGUIUtils.printDouble(this.AUC, 5)}));
        this._ROCCutoffSlider = new JSlider(0, 0, this.activeROCPoints.size(), 0);
        this._ROCCutoffSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (jSlider.getValue() >= AccuracyAnalysis.this.activeROCPoints.size()) {
                    return;
                }
                double d = ((ROCPoint)((AccuracyAnalysis)AccuracyAnalysis.this).activeROCPoints.elementAt((int)jSlider.getValue())).threshold;
                ROCPoint rOCPoint = null;
                Object var6_5 = null;
                ROCPoint rOCPoint2 = null;
                for (ROCPoint rOCPoint3 : AccuracyAnalysis.this.activeROCPoints) {
                    if (rOCPoint2 == null) {
                        rOCPoint2 = rOCPoint3;
                    }
                    if (rOCPoint3.threshold == d) {
                        rOCPoint = rOCPoint3;
                        break;
                    }
                    if (rOCPoint2.threshold > d && rOCPoint3.threshold < d) {
                        rOCPoint = rOCPoint3;
                        break;
                    }
                    rOCPoint2 = rOCPoint3;
                }
                if (rOCPoint == null) {
                    return;
                }
                AccuracyAnalysis.this.sliderThreshold = rOCPoint.threshold;
                AccuracyAnalysis.this._ROCCurve.addPoint(rOCPoint.y, rOCPoint.x, 0);
                AccuracyAnalysis.this._ROCCurve.setTitle(HuginGUIConstants.get("str_cutoff_ARG0", new String[]{"" + HuginGUIUtils.printDouble(rOCPoint.threshold, 4)}));
                AccuracyAnalysis.this._ROCCurve.repaint();
            }
        });
    }

    private double getErrorRate() {
        return (float)this.numberOfErrorsObserved == 0.0f ? 0.0 : (double)(100.0f / ((float)(this.numRows - this.numberOfInvalidCases) / (float)this.numberOfErrorsObserved));
    }

    private double getQuadraticScore() {
        return this.quadraticSum / (double)(this.numRows - this.numberOfInvalidCases);
    }

    private double getKulbachLeibler() {
        return this.kulbachSum / (double)(this.numRows - this.numberOfInvalidCases);
    }

    private String getNodeName(Node node) {
        String string = "";
        try {
            String string2 = this.domain.getAttribute("HR_Node_Label_Style");
            string = string2 == null ? (!node.getLabel().equals("") ? node.getLabel() : node.getName()) : (string2.equals("1") ? node.getName() : (string2.equals("2") ? (!node.getLabel().equals("") ? node.getLabel() + " (" + node.getName() + ")" : node.getName()) : (!node.getLabel().equals("") ? node.getLabel() : node.getName())));
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        return string;
    }

    private class AccuracyModel
    extends DefaultTableModel {
        private AccuracyModel() {
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return "" + n;
            }
            if (n2 == 1) {
                return HuginGUIUtils.printDouble(AccuracyAnalysis.this.conflicts[n], 5);
            }
            --n2;
            --n2;
            try {
                if (n2 == AccuracyAnalysis.this.nodes.length) {
                    return AccuracyAnalysis.this.beliefs[n];
                }
                if (AccuracyAnalysis.this.nodes[n2] instanceof DiscreteChanceNode) {
                    DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)AccuracyAnalysis.this.nodes[n2];
                    if (discreteChanceNode.caseIsSet(n)) {
                        return HuginGUIUtils.getNodeStateLabel(discreteChanceNode, discreteChanceNode.getCaseState(n));
                    }
                    return HuginGUIConstants.get("str_NA");
                }
                if (AccuracyAnalysis.this.nodes[n2] instanceof ContinuousChanceNode) {
                    ContinuousChanceNode continuousChanceNode = (ContinuousChanceNode)AccuracyAnalysis.this.nodes[n2];
                    if (continuousChanceNode.caseIsSet(n)) {
                        return new Double(continuousChanceNode.getCaseValue(n)).toString();
                    }
                    return HuginGUIConstants.get("str_NA");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return "-";
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return HuginGUIConstants.get("AW_Accuracy_case_no");
            }
            if (n == 1) {
                return "Conflict";
            }
            --n;
            --n;
            String string = HuginGUIConstants.get("str_error_detected");
            try {
                int n2 = n;
                if (n == AccuracyAnalysis.this.nodes.length) {
                    --n2;
                }
                String string2 = AccuracyAnalysis.this.getNodeName(AccuracyAnalysis.this.nodes[n2]);
                string = n == AccuracyAnalysis.this.nodes.length ? HuginGUIConstants.get("str_P_ARG0_state_in_case_", new String[]{string2}) : string2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }

        public int getColumnCount() {
            if (AccuracyAnalysis.this.theNode == null) {
                return 0;
            }
            return AccuracyAnalysis.this.nodes.length + 3;
        }

        public int getRowCount() {
            if (AccuracyAnalysis.this.theNode == null) {
                return 0;
            }
            return AccuracyAnalysis.this.numRows;
        }
    }

    private class ColorTableCellRenderer
    extends DefaultTableCellRenderer {
        private JTable theTable;
        private AccuracyAnalysis accuracyAnalysisTool;

        public ColorTableCellRenderer(JTable jTable, AccuracyAnalysis accuracyAnalysis2) {
            this.theTable = jTable;
            this.accuracyAnalysisTool = accuracyAnalysis2;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (this.accuracyAnalysisTool.caseIsHit(n) == 1) {
                component.setBackground(Color.green);
            } else if (this.accuracyAnalysisTool.caseIsHit(n) == 0) {
                component.setBackground(Color.red);
            } else if (this.accuracyAnalysisTool.caseIsHit(n) == -1) {
                component.setBackground(Color.blue);
            }
            return component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ROCTest
    implements Comparable<ROCTest> {
        public double belief = -1.0;
        public boolean positive = false;

        public ROCTest(double d, boolean bl) {
            this.belief = d;
            this.positive = bl;
        }

        @Override
        public int compareTo(ROCTest rOCTest) {
            if (this.belief == rOCTest.belief) {
                return 0;
            }
            if (this.belief > rOCTest.belief) {
                return -1;
            }
            return 1;
        }
    }

    private class ROCPoint
    extends Point2D.Double {
        public double threshold;

        public ROCPoint(double d, double d2, double d3) {
            super(d, d2);
            this.threshold = 0.0;
            this.threshold = d3;
        }
    }

    public static interface CustomComputation {
        public void casePropagated(Domain var1, int var2, Node var3);
    }
}

