/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.CounterField;
import COM.hugin.HGUI.DiscretizeProcess;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.NumberField;
import COM.hugin.HGUI.WizardError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AutoIntervalDialog
extends JDialog {
    DiscretizeProcess.Interval[] result;
    NumberField lower;
    NumberField upper;
    CounterField intervals;
    JButton ok;
    JCheckBox includeUpperInf;
    JCheckBox includeLowerInf;

    public AutoIntervalDialog(JDialog jDialog) {
        super((Dialog)jDialog, true);
        this.getContentPane().add(this.createInterior());
        this.result = null;
    }

    private JPanel createInterior() {
        EnableOKListener enableOKListener = new EnableOKListener();
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1));
        this.lower = new NumberField(0);
        this.lower.addKeyListener(enableOKListener);
        jPanel.add(this.lower);
        JLabel jLabel = new JLabel("Specify lower bound");
        jLabel.setForeground(this.lower.getForeground());
        jPanel2.add(jLabel);
        this.intervals = new CounterField("", 1, 10000, 5);
        this.intervals.addKeyListener(enableOKListener);
        jPanel.add(this.intervals);
        JLabel jLabel2 = new JLabel("Number of intervals");
        jLabel2.setForeground(this.intervals.getForeground());
        jPanel2.add(jLabel2);
        this.upper = new NumberField(1);
        this.upper.addKeyListener(enableOKListener);
        jPanel.add(this.upper);
        JLabel jLabel3 = new JLabel("Specify upper bound");
        jLabel3.setForeground(this.upper.getForeground());
        jPanel2.add(jLabel3);
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 0));
        jPanel3.add((Component)jPanel, "East");
        jPanel3.add(jPanel2);
        this.includeLowerInf = new JCheckBox("Extend lower bound to infinity");
        this.includeUpperInf = new JCheckBox("Extend upper bound to infinity");
        jPanel3.add((Component)this.includeLowerInf, "North");
        jPanel3.add((Component)this.includeUpperInf, "South");
        JPanel jPanel4 = new JPanel(new FlowLayout());
        this.ok = new JButton(HuginGUIConstants.get("OK_button"));
        this.ok.addActionListener(new OKListener());
        this.ok.setEnabled(false);
        JButton jButton = new JButton(HuginGUIConstants.get("cancel_button"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutoIntervalDialog.this.dispose();
            }
        });
        jPanel4.add(jButton);
        jPanel4.add(this.ok);
        JPanel jPanel5 = new JPanel(new BorderLayout(5, 5));
        jPanel5.add(jPanel3);
        jPanel5.add((Component)jPanel4, "South");
        return jPanel5;
    }

    protected DiscretizeProcess.Interval[] getIntervals() {
        return this.result;
    }

    private class EnableOKListener
    extends KeyAdapter {
        private EnableOKListener() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            boolean bl = false;
            try {
                AutoIntervalDialog.this.intervals.getValue();
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            AutoIntervalDialog.this.ok.setEnabled(AutoIntervalDialog.this.lower.isNumber() && AutoIntervalDialog.this.upper.isNumber() && AutoIntervalDialog.this.lower.getNumber() < AutoIntervalDialog.this.upper.getNumber() && bl);
        }
    }

    private class OKListener
    implements ActionListener {
        private OKListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                double d;
                double d2;
                double d3 = AutoIntervalDialog.this.lower.getNumber();
                if (d3 == Double.NEGATIVE_INFINITY) {
                    d3 = -1.7976931348623157E308;
                }
                if ((d2 = AutoIntervalDialog.this.upper.getNumber()) == Double.POSITIVE_INFINITY) {
                    d2 = Double.MAX_VALUE;
                }
                double d4 = (d2 - d3) / (double)AutoIntervalDialog.this.intervals.getValue();
                AutoIntervalDialog.this.result = new DiscretizeProcess.Interval[AutoIntervalDialog.this.intervals.getValue()];
                double d5 = d3;
                DecimalFormat decimalFormat = new DecimalFormat();
                decimalFormat.setMaximumFractionDigits(10);
                for (int i = 0; i < AutoIntervalDialog.this.result.length - 1; ++i) {
                    if (d5 == -1.7976931348623157E308) {
                        d5 = Double.NEGATIVE_INFINITY;
                    }
                    if ((d = d5 + d4) > 1.0E-6) {
                        d = decimalFormat.parse(decimalFormat.format(d), new ParsePosition(0)).doubleValue();
                    }
                    AutoIntervalDialog.this.result[i] = new DiscretizeProcess.Interval(d5, d);
                    d5 = d;
                }
                d = d2;
                if (d == Double.MAX_VALUE) {
                    d = Double.POSITIVE_INFINITY;
                }
                AutoIntervalDialog.this.result[AutoIntervalDialog.this.result.length - 1] = new DiscretizeProcess.Interval(d5, d);
                if (AutoIntervalDialog.this.includeLowerInf.isSelected()) {
                    AutoIntervalDialog.this.result[0].lower = Double.NEGATIVE_INFINITY;
                }
                if (AutoIntervalDialog.this.includeUpperInf.isSelected()) {
                    AutoIntervalDialog.this.result[AutoIntervalDialog.this.result.length - 1].upper = Double.POSITIVE_INFINITY;
                }
                AutoIntervalDialog.this.dispose();
            }
            catch (Exception exception) {
                WizardError.showError(HuginGUIConstants.get("str_error"), HuginGUIConstants.get("str_errors_in_specified_numbers_ARG0", new String[]{exception.getMessage()}), AutoIntervalDialog.this);
            }
        }
    }
}

