/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.ImageExporter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;

public class BMPFile
extends Component {
    private static final int BITMAPFILEHEADER_SIZE = 14;
    private static final int BITMAPINFOHEADER_SIZE = 40;
    private byte[] bitmapFileHeader = new byte[14];
    private byte[] bfType = new byte[]{66, 77};
    private int bfSize = 0;
    private int bfReserved1 = 0;
    private int bfReserved2 = 0;
    private int bfOffBits = 54;
    private byte[] bitmapInfoHeader = new byte[40];
    private int biSize = 40;
    private int biWidth = 0;
    private int biHeight = 0;
    private int biPlanes = 1;
    private int biBitCount = 24;
    private int biCompression = 0;
    private int biSizeImage = 196608;
    private int biXPelsPerMeter = 0;
    private int biYPelsPerMeter = 0;
    private int biClrUsed = 0;
    private int biClrImportant = 0;
    private int[] bitmap;
    private BufferedOutputStream fo;
    String fileName;
    Image image;
    ImageExporter exporter;
    boolean cancelled = false;

    public BMPFile() {
        this.fileName = null;
        this.image = null;
    }

    public BMPFile(String string, Image image) {
        this(string, image, null);
    }

    public BMPFile(String string, Image image, ImageExporter imageExporter) {
        this.fileName = string;
        this.image = image;
        this.exporter = imageExporter;
    }

    public void saveBitmap() {
        if (this.fileName == null || this.image == null) {
            return;
        }
        this.saveBitmap(this.fileName, this.image, this.image.getWidth(this), this.image.getHeight(this));
    }

    public void saveBitmapAs(String string) {
        if (this.image == null) {
            return;
        }
        this.fileName = string;
        this.saveBitmap(string, this.image, this.image.getWidth(this), this.image.getHeight(this));
    }

    public void saveBitmap(String string, Image image, int n, int n2) {
        try {
            this.fo = new BufferedOutputStream(new FileOutputStream(string));
            this.save(image, n, n2);
            this.fo.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void save(Image image, int n, int n2) {
        try {
            this.convertImage(image, n, n2);
            this.writeBitmapFileHeader();
            this.writeBitmapInfoHeader();
            this.writeBitmap();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean convertImage(Image image, int n, int n2) {
        this.bitmap = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, this.bitmap, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return false;
        }
        int n3 = n * 3 % 4;
        int n4 = n3 == 0 ? 0 : (n3 == 1 ? 3 * n2 : (n3 == 2 ? 2 * n2 : 1 * n2));
        this.biSizeImage = n * n2 * 3 + n4;
        this.bfSize = this.biSizeImage + 14 + 40;
        this.biWidth = n;
        this.biHeight = n2;
        return true;
    }

    private void writeBitmap() {
        int n;
        byte[] byArray = new byte[3];
        int n2 = this.biWidth * this.biHeight;
        int n3 = 4 - this.biWidth * 3 % 4;
        if (n3 == 4) {
            n3 = 0;
        }
        int n4 = 1;
        int n5 = 0;
        int n6 = n = n2 - this.biWidth;
        try {
            for (int i = 0; i < n2 && !this.cancelled; ++i) {
                int n7 = this.bitmap[n];
                byArray[0] = (byte)(n7 & 0xFF);
                byArray[1] = (byte)(n7 >> 8 & 0xFF);
                byArray[2] = (byte)(n7 >> 16 & 0xFF);
                this.fo.write(byArray);
                if (n4 == this.biWidth) {
                    n5 += n3;
                    for (int j = 1; j <= n3; ++j) {
                        this.fo.write(0);
                    }
                    n4 = 1;
                    n6 = n = n6 - this.biWidth;
                } else {
                    ++n4;
                }
                ++n;
                if (this.exporter == null || i % (n2 / 100) != 0) continue;
                this.exporter.setProgress(i / (n2 / 100));
            }
            this.bfSize += n5 - n3;
            this.biSizeImage += n5 - n3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeBitmapFileHeader() {
        try {
            this.fo.write(this.bfType);
            this.fo.write(this.intToDWord(this.bfSize));
            this.fo.write(this.intToWord(this.bfReserved1));
            this.fo.write(this.intToWord(this.bfReserved2));
            this.fo.write(this.intToDWord(this.bfOffBits));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeBitmapInfoHeader() {
        try {
            this.fo.write(this.intToDWord(this.biSize));
            this.fo.write(this.intToDWord(this.biWidth));
            this.fo.write(this.intToDWord(this.biHeight));
            this.fo.write(this.intToWord(this.biPlanes));
            this.fo.write(this.intToWord(this.biBitCount));
            this.fo.write(this.intToDWord(this.biCompression));
            this.fo.write(this.intToDWord(this.biSizeImage));
            this.fo.write(this.intToDWord(this.biXPelsPerMeter));
            this.fo.write(this.intToDWord(this.biYPelsPerMeter));
            this.fo.write(this.intToDWord(this.biClrUsed));
            this.fo.write(this.intToDWord(this.biClrImportant));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private byte[] intToWord(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        return byArray;
    }

    private byte[] intToDWord(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return byArray;
    }

    protected void close() {
        this.cancelled = true;
    }

    public static void main(String[] stringArray) {
        BufferedImage bufferedImage = new BufferedImage(100, 100, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, 100, 100);
        for (int i = 80; i >= 0; i -= 5) {
            graphics.setColor(new Color(255 - i * 2, 100, 255 - i * 2));
            graphics.fillOval(5 + (90 - i) / 5, 5 + (90 - i) / 5, i + 10, i + 10);
        }
        BMPFile bMPFile = new BMPFile("test.bmp", bufferedImage);
        bMPFile.saveBitmap();
        bMPFile.saveBitmapAs("test2.bmp");
    }
}

